/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.channels;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.InsufficientMoneyException;
import org.bitcoinj.core.LegacyAddress;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.SignatureDecodeException;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.crypto.TransactionSignature;
import org.bitcoinj.protocols.channels.IPaymentChannelClient;
import org.bitcoinj.protocols.channels.PaymentChannelClientState;
import org.bitcoinj.protocols.channels.StoredClientChannel;
import org.bitcoinj.protocols.channels.StoredPaymentChannelClientStates;
import org.bitcoinj.protocols.channels.ValueOutOfRangeException;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptBuilder;
import org.bitcoinj.script.ScriptException;
import org.bitcoinj.wallet.AllowUnconfirmedCoinSelector;
import org.bitcoinj.wallet.SendRequest;
import org.bitcoinj.wallet.Wallet;
import org.bouncycastle.crypto.params.KeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentChannelV1ClientState
extends PaymentChannelClientState {
    private static final Logger log = LoggerFactory.getLogger(PaymentChannelV1ClientState.class);
    private final Coin totalValue;
    private final long expiryTime;
    private Transaction refundTx;
    private Coin refundFees;
    private Transaction multisigContract;
    private Script multisigScript;

    PaymentChannelV1ClientState(StoredClientChannel storedClientChannel, Wallet wallet) throws VerificationException {
        super(storedClientChannel, wallet);
        this.multisigContract = (Transaction)Preconditions.checkNotNull((Object)storedClientChannel.contract);
        this.multisigScript = this.multisigContract.getOutput(0L).getScriptPubKey();
        this.refundTx = (Transaction)Preconditions.checkNotNull((Object)storedClientChannel.refund);
        this.refundFees = (Coin)Preconditions.checkNotNull((Object)storedClientChannel.refundFees);
        this.expiryTime = this.refundTx.getLockTime();
        this.totalValue = this.multisigContract.getOutput(0L).getValue();
        this.stateMachine.transition(PaymentChannelClientState.State.READY);
        this.initWalletListeners();
    }

    public PaymentChannelV1ClientState(Wallet wallet, ECKey myKey, ECKey serverMultisigKey, Coin value, long expiryTimeInSeconds) throws VerificationException {
        super(wallet, myKey, serverMultisigKey, value, expiryTimeInSeconds);
        Preconditions.checkArgument((value.signum() > 0 ? 1 : 0) != 0);
        this.initWalletListeners();
        this.totalValue = (Coin)Preconditions.checkNotNull((Object)value);
        this.expiryTime = expiryTimeInSeconds;
        this.stateMachine.transition(PaymentChannelClientState.State.NEW);
    }

    @Override
    protected Multimap<PaymentChannelClientState.State, PaymentChannelClientState.State> getStateTransitions() {
        ListMultimap result = MultimapBuilder.enumKeys(PaymentChannelClientState.State.class).arrayListValues().build();
        result.put((Object)PaymentChannelClientState.State.UNINITIALISED, (Object)PaymentChannelClientState.State.NEW);
        result.put((Object)PaymentChannelClientState.State.UNINITIALISED, (Object)PaymentChannelClientState.State.READY);
        result.put((Object)PaymentChannelClientState.State.NEW, (Object)PaymentChannelClientState.State.INITIATED);
        result.put((Object)PaymentChannelClientState.State.INITIATED, (Object)PaymentChannelClientState.State.WAITING_FOR_SIGNED_REFUND);
        result.put((Object)PaymentChannelClientState.State.WAITING_FOR_SIGNED_REFUND, (Object)PaymentChannelClientState.State.SAVE_STATE_IN_WALLET);
        result.put((Object)PaymentChannelClientState.State.SAVE_STATE_IN_WALLET, (Object)PaymentChannelClientState.State.PROVIDE_MULTISIG_CONTRACT_TO_SERVER);
        result.put((Object)PaymentChannelClientState.State.PROVIDE_MULTISIG_CONTRACT_TO_SERVER, (Object)PaymentChannelClientState.State.READY);
        result.put((Object)PaymentChannelClientState.State.READY, (Object)PaymentChannelClientState.State.EXPIRED);
        result.put((Object)PaymentChannelClientState.State.READY, (Object)PaymentChannelClientState.State.CLOSED);
        return result;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public synchronized void initiate(@Nullable KeyParameter userKey, IPaymentChannelClient.ClientChannelProperties clientChannelProperties) throws ValueOutOfRangeException, InsufficientMoneyException {
        NetworkParameters params = this.wallet.getParams();
        Transaction template = new Transaction(params);
        ArrayList keys = Lists.newArrayList((Object[])new ECKey[]{this.myKey, this.serverKey});
        TransactionOutput multisigOutput = template.addOutput(this.totalValue, ScriptBuilder.createMultiSigOutputScript(2, keys));
        if (multisigOutput.isDust()) {
            throw new ValueOutOfRangeException("totalValue too small to use");
        }
        SendRequest req = SendRequest.forTx(template);
        req.coinSelector = AllowUnconfirmedCoinSelector.get();
        req.shuffleOutputs = false;
        req = clientChannelProperties.modifyContractSendRequest(req);
        if (userKey != null) {
            req.aesKey = userKey;
        }
        this.wallet.completeTx(req);
        Coin multisigFee = req.tx.getFee();
        this.multisigContract = req.tx;
        this.refundTx = new Transaction(params);
        this.refundTx.addInput(multisigOutput).setSequenceNumber(0xFFFFFFFEL);
        this.refundTx.setLockTime(this.expiryTime);
        if (Context.get().isEnsureMinRequiredFee()) {
            Coin valueAfterFee = this.totalValue.subtract(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE);
            if (Transaction.MIN_NONDUST_OUTPUT.compareTo(valueAfterFee) > 0) {
                throw new ValueOutOfRangeException("totalValue too small to use");
            }
            this.refundTx.addOutput(valueAfterFee, LegacyAddress.fromKey(params, this.myKey));
            this.refundFees = multisigFee.add(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE);
        } else {
            this.refundTx.addOutput(this.totalValue, LegacyAddress.fromKey(params, this.myKey));
            this.refundFees = multisigFee;
        }
        this.refundTx.getConfidence().setSource(TransactionConfidence.Source.SELF);
        log.info("initiated channel with multi-sig contract {}, refund {}", (Object)this.multisigContract.getTxId(), (Object)this.refundTx.getTxId());
        this.stateMachine.transition(PaymentChannelClientState.State.INITIATED);
    }

    @Override
    public synchronized Transaction getContract() {
        Preconditions.checkState((this.multisigContract != null ? 1 : 0) != 0);
        if (this.stateMachine.getState() == PaymentChannelClientState.State.PROVIDE_MULTISIG_CONTRACT_TO_SERVER) {
            this.stateMachine.transition(PaymentChannelClientState.State.READY);
        }
        return this.multisigContract;
    }

    @Override
    protected synchronized Transaction getContractInternal() {
        return this.multisigContract;
    }

    @Override
    protected synchronized Script getContractScript() {
        return this.multisigScript;
    }

    @Override
    protected Script getSignedScript() {
        return this.getContractScript();
    }

    public synchronized Transaction getIncompleteRefundTransaction() {
        Preconditions.checkState((this.refundTx != null ? 1 : 0) != 0);
        if (this.stateMachine.getState() == PaymentChannelClientState.State.INITIATED) {
            this.stateMachine.transition(PaymentChannelClientState.State.WAITING_FOR_SIGNED_REFUND);
        }
        return this.refundTx;
    }

    public synchronized void provideRefundSignature(byte[] theirSignature, @Nullable KeyParameter userKey) throws SignatureDecodeException, VerificationException {
        Preconditions.checkNotNull((Object)theirSignature);
        this.stateMachine.checkState(PaymentChannelClientState.State.WAITING_FOR_SIGNED_REFUND);
        TransactionSignature theirSig = TransactionSignature.decodeFromBitcoin(theirSignature, true, false);
        if (theirSig.sigHashMode() != Transaction.SigHash.NONE || !theirSig.anyoneCanPay()) {
            throw new VerificationException("Refund signature was not SIGHASH_NONE|SIGHASH_ANYONECANPAY");
        }
        TransactionOutput multisigContractOutput = this.multisigContract.getOutput(0L);
        try {
            this.multisigScript = multisigContractOutput.getScriptPubKey();
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
        TransactionSignature ourSignature = this.refundTx.calculateSignature(0, this.myKey.maybeDecrypt(userKey), this.multisigScript, Transaction.SigHash.ALL, false);
        Script scriptSig = ScriptBuilder.createMultiSigInputScript(ourSignature, theirSig);
        log.info("Refund scriptSig: {}", (Object)scriptSig);
        log.info("Multi-sig contract scriptPubKey: {}", (Object)this.multisigScript);
        TransactionInput refundInput = this.refundTx.getInput(0L);
        refundInput.setScriptSig(scriptSig);
        refundInput.verify(multisigContractOutput);
        this.stateMachine.transition(PaymentChannelClientState.State.SAVE_STATE_IN_WALLET);
    }

    @Override
    protected synchronized Coin getValueToMe() {
        return this.valueToMe;
    }

    @Override
    protected long getExpiryTime() {
        return this.expiryTime;
    }

    @Override
    @VisibleForTesting
    synchronized void doStoreChannelInWallet(Sha256Hash id) {
        StoredPaymentChannelClientStates channels = (StoredPaymentChannelClientStates)this.wallet.getExtensions().get(StoredPaymentChannelClientStates.EXTENSION_ID);
        Preconditions.checkNotNull((Object)channels, (Object)"You have not added the StoredPaymentChannelClientStates extension to the wallet.");
        Preconditions.checkState((channels.getChannel(id, this.multisigContract.getTxId()) == null ? 1 : 0) != 0);
        this.storedChannel = new StoredClientChannel(this.getMajorVersion(), id, this.multisigContract, this.refundTx, this.myKey, this.serverKey, this.valueToMe, this.refundFees, 0L, true);
        channels.putChannel(this.storedChannel);
    }

    @Override
    public synchronized Coin getRefundTxFees() {
        Preconditions.checkState((this.getState().compareTo(PaymentChannelClientState.State.NEW) > 0 ? 1 : 0) != 0);
        return this.refundFees;
    }

    @Override
    @VisibleForTesting
    Transaction getRefundTransaction() {
        return this.refundTx;
    }

    public synchronized Transaction getCompletedRefundTransaction() {
        Preconditions.checkState((this.getState().compareTo(PaymentChannelClientState.State.WAITING_FOR_SIGNED_REFUND) > 0 ? 1 : 0) != 0);
        return this.refundTx;
    }

    @Override
    public Coin getTotalValue() {
        return this.totalValue;
    }
}

