/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import javax.annotation.Nullable;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.Bech32;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.params.Networks;
import org.bitcoinj.script.Script;

public class SegwitAddress
extends Address {
    public static final int WITNESS_PROGRAM_LENGTH_PKH = 20;
    public static final int WITNESS_PROGRAM_LENGTH_SH = 32;
    public static final int WITNESS_PROGRAM_MIN_LENGTH = 2;
    public static final int WITNESS_PROGRAM_MAX_LENGTH = 40;

    private SegwitAddress(NetworkParameters params, int witnessVersion, byte[] witnessProgram) throws AddressFormatException {
        this(params, SegwitAddress.encode(witnessVersion, witnessProgram));
    }

    private static byte[] encode(int witnessVersion, byte[] witnessProgram) throws AddressFormatException {
        byte[] convertedProgram = SegwitAddress.convertBits(witnessProgram, 0, witnessProgram.length, 8, 5, true);
        byte[] bytes = new byte[1 + convertedProgram.length];
        bytes[0] = (byte)(witnessVersion & 0xFF);
        System.arraycopy(convertedProgram, 0, bytes, 1, convertedProgram.length);
        return bytes;
    }

    private SegwitAddress(NetworkParameters params, byte[] data) throws AddressFormatException {
        super(params, data);
        if (data.length < 1) {
            throw new AddressFormatException.InvalidDataLength("Zero data found");
        }
        int witnessVersion = this.getWitnessVersion();
        if (witnessVersion < 0 || witnessVersion > 16) {
            throw new AddressFormatException("Invalid script version: " + witnessVersion);
        }
        byte[] witnessProgram = this.getWitnessProgram();
        if (witnessProgram.length < 2 || witnessProgram.length > 40) {
            throw new AddressFormatException.InvalidDataLength("Invalid length: " + witnessProgram.length);
        }
        if (witnessVersion == 0 && witnessProgram.length != 20 && witnessProgram.length != 32) {
            throw new AddressFormatException.InvalidDataLength("Invalid length for address version 0: " + witnessProgram.length);
        }
    }

    public int getWitnessVersion() {
        return this.bytes[0] & 0xFF;
    }

    public byte[] getWitnessProgram() {
        return SegwitAddress.convertBits(this.bytes, 1, this.bytes.length - 1, 5, 8, false);
    }

    @Override
    public byte[] getHash() {
        return this.getWitnessProgram();
    }

    @Override
    public Script.ScriptType getOutputScriptType() {
        int version = this.getWitnessVersion();
        Preconditions.checkState((version == 0 ? 1 : 0) != 0);
        int programLength = this.getWitnessProgram().length;
        if (programLength == 20) {
            return Script.ScriptType.P2WPKH;
        }
        if (programLength == 32) {
            return Script.ScriptType.P2WSH;
        }
        throw new IllegalStateException("Cannot happen.");
    }

    public String toString() {
        return this.toBech32();
    }

    public static SegwitAddress fromBech32(@Nullable NetworkParameters params, String bech32) throws AddressFormatException {
        Bech32.Bech32Data bechData = Bech32.decode(bech32);
        if (params == null) {
            for (NetworkParameters networkParameters : Networks.get()) {
                if (!bechData.hrp.equals(networkParameters.getSegwitAddressHrp())) continue;
                return new SegwitAddress(networkParameters, bechData.data);
            }
            throw new AddressFormatException.InvalidPrefix("No network found for " + bech32);
        }
        if (bechData.hrp.equals(params.getSegwitAddressHrp())) {
            return new SegwitAddress(params, bechData.data);
        }
        throw new AddressFormatException.WrongNetwork(bechData.hrp);
    }

    public static SegwitAddress fromHash(NetworkParameters params, byte[] hash) {
        return new SegwitAddress(params, 0, hash);
    }

    public static SegwitAddress fromKey(NetworkParameters params, ECKey key) {
        Preconditions.checkArgument((boolean)key.isCompressed(), (Object)"only compressed keys allowed");
        return SegwitAddress.fromHash(params, key.getPubKeyHash());
    }

    public String toBech32() {
        return Bech32.encode(this.params.getSegwitAddressHrp(), this.bytes);
    }

    private static byte[] convertBits(byte[] in, int inStart, int inLen, int fromBits, int toBits, boolean pad) throws AddressFormatException {
        int acc = 0;
        int bits = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream(64);
        int maxv = (1 << toBits) - 1;
        int max_acc = (1 << fromBits + toBits - 1) - 1;
        for (int i = 0; i < inLen; ++i) {
            int value = in[i + inStart] & 0xFF;
            if (value >>> fromBits != 0) {
                throw new AddressFormatException(String.format("Input value '%X' exceeds '%d' bit size", value, fromBits));
            }
            acc = (acc << fromBits | value) & max_acc;
            bits += fromBits;
            while (bits >= toBits) {
                out.write(acc >>> (bits -= toBits) & maxv);
            }
        }
        if (pad) {
            if (bits > 0) {
                out.write(acc << toBits - bits & maxv);
            }
        } else if (bits >= fromBits || (acc << toBits - bits & maxv) != 0) {
            throw new AddressFormatException("Could not convert bits, invalid padding");
        }
        return out.toByteArray();
    }
}

