/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import javax.annotation.Nullable;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.LegacyAddress;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PrefixedChecksummedBytes;
import org.bitcoinj.core.SegwitAddress;
import org.bitcoinj.script.Script;

public abstract class Address
extends PrefixedChecksummedBytes {
    public Address(NetworkParameters params, byte[] bytes) {
        super(params, bytes);
    }

    public static Address fromString(@Nullable NetworkParameters params, String str) throws AddressFormatException {
        try {
            return LegacyAddress.fromBase58(params, str);
        }
        catch (AddressFormatException.WrongNetwork x) {
            throw x;
        }
        catch (AddressFormatException x) {
            try {
                return SegwitAddress.fromBech32(params, str);
            }
            catch (AddressFormatException.WrongNetwork x2) {
                throw x;
            }
            catch (AddressFormatException x2) {
                throw new AddressFormatException(str);
            }
        }
    }

    public static Address fromKey(NetworkParameters params, ECKey key, Script.ScriptType outputScriptType) {
        if (outputScriptType == Script.ScriptType.P2PKH) {
            return LegacyAddress.fromKey(params, key);
        }
        if (outputScriptType == Script.ScriptType.P2WPKH) {
            return SegwitAddress.fromKey(params, key);
        }
        throw new IllegalArgumentException(outputScriptType.toString());
    }

    public abstract byte[] getHash();

    public abstract Script.ScriptType getOutputScriptType();
}

