/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.wallet.KeyBag;
import org.bitcoinj.wallet.RedeemData;
import org.spongycastle.crypto.params.KeyParameter;

public class DecryptingKeyBag
implements KeyBag {
    protected final KeyBag target;
    protected final KeyParameter aesKey;

    public DecryptingKeyBag(KeyBag target, @Nullable KeyParameter aesKey) {
        this.target = (KeyBag)Preconditions.checkNotNull((Object)target);
        this.aesKey = aesKey;
    }

    @Nullable
    private ECKey maybeDecrypt(ECKey key) {
        if (key == null) {
            return null;
        }
        if (key.isEncrypted()) {
            if (this.aesKey == null) {
                throw new ECKey.KeyIsEncryptedException();
            }
            return key.decrypt(this.aesKey);
        }
        return key;
    }

    private RedeemData maybeDecrypt(RedeemData redeemData) {
        ArrayList<ECKey> decryptedKeys = new ArrayList<ECKey>();
        for (ECKey key : redeemData.keys) {
            decryptedKeys.add(this.maybeDecrypt(key));
        }
        return RedeemData.of(decryptedKeys, redeemData.redeemScript);
    }

    @Override
    @Nullable
    public ECKey findKeyFromPubHash(byte[] pubkeyHash) {
        return this.maybeDecrypt(this.target.findKeyFromPubHash(pubkeyHash));
    }

    @Override
    @Nullable
    public ECKey findKeyFromPubKey(byte[] pubkey) {
        return this.maybeDecrypt(this.target.findKeyFromPubKey(pubkey));
    }

    @Override
    @Nullable
    public RedeemData findRedeemDataFromScriptHash(byte[] scriptHash) {
        return this.maybeDecrypt(this.target.findRedeemDataFromScriptHash(scriptHash));
    }
}

