/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Block stores persist blockchain data downloaded from remote peers. There is an SPV block store which preserves a ring
 * buffer of headers on disk and is suitable for lightweight user wallets, a store that's backed by Postgres and which
 * can calculate a full indexed UTXO set (i.e. it can query address balances), a store that's backed by the embedded H2
 * database, and a memory only store useful for unit tests.
 */
package org.bitcoinj.store;