/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.BloomFilter;
import org.bitcoinj.core.ChildMessage;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.FilteredBlock;
import org.bitcoinj.core.InsufficientMoneyException;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.PeerFilterProvider;
import org.bitcoinj.core.ScriptException;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionBag;
import org.bitcoinj.core.TransactionBroadcast;
import org.bitcoinj.core.TransactionBroadcaster;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.UTXO;
import org.bitcoinj.core.UTXOProvider;
import org.bitcoinj.core.UTXOProviderException;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VarInt;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.core.listeners.NewBestBlockListener;
import org.bitcoinj.core.listeners.ReorganizeListener;
import org.bitcoinj.core.listeners.TransactionConfidenceEventListener;
import org.bitcoinj.core.listeners.TransactionReceivedInBlockListener;
import org.bitcoinj.crypto.ChildNumber;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.KeyCrypter;
import org.bitcoinj.crypto.KeyCrypterScrypt;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptBuilder;
import org.bitcoinj.script.ScriptChunk;
import org.bitcoinj.signers.LocalTransactionSigner;
import org.bitcoinj.signers.MissingSigResolutionSigner;
import org.bitcoinj.signers.TransactionSigner;
import org.bitcoinj.utils.BaseTaggableObject;
import org.bitcoinj.utils.ListenerRegistration;
import org.bitcoinj.utils.Threading;
import org.bitcoinj.wallet.AllRandomKeysRotating;
import org.bitcoinj.wallet.AllowUnconfirmedCoinSelector;
import org.bitcoinj.wallet.CoinSelection;
import org.bitcoinj.wallet.CoinSelector;
import org.bitcoinj.wallet.DecryptingKeyBag;
import org.bitcoinj.wallet.DefaultCoinSelector;
import org.bitcoinj.wallet.DefaultRiskAnalysis;
import org.bitcoinj.wallet.DeterministicKeyChain;
import org.bitcoinj.wallet.DeterministicSeed;
import org.bitcoinj.wallet.DeterministicUpgradeRequiresPassword;
import org.bitcoinj.wallet.FilteringCoinSelector;
import org.bitcoinj.wallet.KeyBag;
import org.bitcoinj.wallet.KeyChain;
import org.bitcoinj.wallet.KeyChainGroup;
import org.bitcoinj.wallet.KeyTimeCoinSelector;
import org.bitcoinj.wallet.Protos;
import org.bitcoinj.wallet.RedeemData;
import org.bitcoinj.wallet.RiskAnalysis;
import org.bitcoinj.wallet.SendRequest;
import org.bitcoinj.wallet.UnreadableWalletException;
import org.bitcoinj.wallet.WalletExtension;
import org.bitcoinj.wallet.WalletFiles;
import org.bitcoinj.wallet.WalletProtobufSerializer;
import org.bitcoinj.wallet.WalletTransaction;
import org.bitcoinj.wallet.listeners.KeyChainEventListener;
import org.bitcoinj.wallet.listeners.ScriptsChangeEventListener;
import org.bitcoinj.wallet.listeners.WalletChangeEventListener;
import org.bitcoinj.wallet.listeners.WalletCoinsReceivedEventListener;
import org.bitcoinj.wallet.listeners.WalletCoinsSentEventListener;
import org.bitcoinj.wallet.listeners.WalletEventListener;
import org.bitcoinj.wallet.listeners.WalletReorganizeEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.crypto.params.KeyParameter;

public class Wallet
extends BaseTaggableObject
implements NewBestBlockListener,
TransactionReceivedInBlockListener,
PeerFilterProvider,
KeyBag,
TransactionBag,
ReorganizeListener {
    private static final Logger log = LoggerFactory.getLogger(Wallet.class);
    private static final int MINIMUM_BLOOM_DATA_LENGTH = 8;
    protected final ReentrantLock lock = Threading.lock("wallet");
    protected final ReentrantLock keyChainGroupLock = Threading.lock("wallet-keychaingroup");
    private final Map<Sha256Hash, Transaction> pending;
    private final Map<Sha256Hash, Transaction> unspent;
    private final Map<Sha256Hash, Transaction> spent;
    private final Map<Sha256Hash, Transaction> dead;
    protected final Map<Sha256Hash, Transaction> transactions;
    protected final HashSet<TransactionOutput> myUnspents = Sets.newHashSet();
    private final LinkedHashMap<Sha256Hash, Transaction> riskDropped = new LinkedHashMap<Sha256Hash, Transaction>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Sha256Hash, Transaction> eldest) {
            return this.size() > 1000;
        }
    };
    @GuardedBy(value="keyChainGroupLock")
    private KeyChainGroup keyChainGroup;
    @GuardedBy(value="keyChainGroupLock")
    private Set<Script> watchedScripts;
    protected final Context context;
    protected final NetworkParameters params;
    @Nullable
    private Sha256Hash lastBlockSeenHash;
    private int lastBlockSeenHeight;
    private long lastBlockSeenTimeSecs;
    private final CopyOnWriteArrayList<ListenerRegistration<WalletChangeEventListener>> changeListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<WalletCoinsReceivedEventListener>> coinsReceivedListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<WalletCoinsSentEventListener>> coinsSentListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<WalletReorganizeEventListener>> reorganizeListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<ScriptsChangeEventListener>> scriptChangeListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<TransactionConfidenceEventListener>> transactionConfidenceListeners = new CopyOnWriteArrayList();
    private TransactionConfidence.Listener txConfidenceListener;
    private HashSet<Sha256Hash> ignoreNextNewBlock;
    private boolean acceptRiskyTransactions;
    private RiskAnalysis.Analyzer riskAnalyzer = DefaultRiskAnalysis.FACTORY;
    private int onWalletChangedSuppressions;
    private boolean insideReorg;
    private Map<Transaction, TransactionConfidence.Listener.ChangeReason> confidenceChanged;
    protected volatile WalletFiles vFileManager;
    protected volatile TransactionBroadcaster vTransactionBroadcaster;
    private volatile long vKeyRotationTimestamp;
    protected CoinSelector coinSelector = new DefaultCoinSelector();
    private int version;
    private String description;
    private final HashMap<String, WalletExtension> extensions;
    @GuardedBy(value="lock")
    private List<TransactionSigner> signers;
    @Nullable
    private volatile UTXOProvider vUTXOProvider;
    private boolean hardSaveOnNextBlock = false;
    @GuardedBy(value="lock")
    private List<BalanceFutureRequest> balanceFutureRequests = Lists.newLinkedList();
    private final ArrayList<TransactionOutPoint> bloomOutPoints = Lists.newArrayList();
    private final AtomicInteger bloomFilterGuard = new AtomicInteger(0);

    public Wallet(NetworkParameters params) {
        this(Context.getOrCreate(params));
    }

    public Wallet(Context context) {
        this(context, new KeyChainGroup(context.getParams()));
    }

    public static Wallet fromSeed(NetworkParameters params, DeterministicSeed seed) {
        return new Wallet(params, new KeyChainGroup(params, seed));
    }

    public static Wallet fromWatchingKey(NetworkParameters params, DeterministicKey watchKey) {
        return new Wallet(params, new KeyChainGroup(params, watchKey));
    }

    public static Wallet fromWatchingKeyB58(NetworkParameters params, String watchKeyB58, long creationTimeSeconds) {
        DeterministicKey watchKey = DeterministicKey.deserializeB58(null, watchKeyB58, params);
        watchKey.setCreationTimeSeconds(creationTimeSeconds);
        return Wallet.fromWatchingKey(params, watchKey);
    }

    public static Wallet fromKeys(NetworkParameters params, List<ECKey> keys) {
        for (ECKey key : keys) {
            Preconditions.checkArgument((!(key instanceof DeterministicKey) ? 1 : 0) != 0);
        }
        KeyChainGroup group = new KeyChainGroup(params);
        group.importKeys(keys);
        return new Wallet(params, group);
    }

    public Wallet(NetworkParameters params, KeyChainGroup keyChainGroup) {
        this(Context.getOrCreate(params), keyChainGroup);
    }

    private Wallet(Context context, KeyChainGroup keyChainGroup) {
        this.context = context;
        this.params = context.getParams();
        this.keyChainGroup = (KeyChainGroup)Preconditions.checkNotNull((Object)keyChainGroup);
        if (this.params.getId().equals("org.bitcoinj.unittest")) {
            this.keyChainGroup.setLookaheadSize(5);
        }
        if (this.keyChainGroup.numKeys() == 0) {
            this.keyChainGroup.createAndActivateNewHDChain();
        }
        this.watchedScripts = Sets.newHashSet();
        this.unspent = new HashMap<Sha256Hash, Transaction>();
        this.spent = new HashMap<Sha256Hash, Transaction>();
        this.pending = new HashMap<Sha256Hash, Transaction>();
        this.dead = new HashMap<Sha256Hash, Transaction>();
        this.transactions = new HashMap<Sha256Hash, Transaction>();
        this.extensions = new HashMap();
        this.confidenceChanged = new LinkedHashMap<Transaction, TransactionConfidence.Listener.ChangeReason>();
        this.signers = new ArrayList<TransactionSigner>();
        this.addTransactionSigner(new LocalTransactionSigner());
        this.createTransientState();
    }

    private void createTransientState() {
        this.ignoreNextNewBlock = new HashSet();
        this.txConfidenceListener = new TransactionConfidence.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConfidenceChanged(TransactionConfidence confidence, TransactionConfidence.Listener.ChangeReason reason) {
                if (reason == TransactionConfidence.Listener.ChangeReason.SEEN_PEERS) {
                    Wallet.this.lock.lock();
                    try {
                        Wallet.this.checkBalanceFuturesLocked(null);
                        Transaction tx = Wallet.this.getTransaction(confidence.getTransactionHash());
                        Wallet.this.queueOnTransactionConfidenceChanged(tx);
                        Wallet.this.maybeQueueOnWalletChanged();
                    }
                    finally {
                        Wallet.this.lock.unlock();
                    }
                }
            }
        };
        this.acceptRiskyTransactions = false;
    }

    public NetworkParameters getNetworkParameters() {
        return this.params;
    }

    public DeterministicKeyChain getActiveKeyChain() {
        return this.keyChainGroup.getActiveKeyChain();
    }

    public final void addTransactionSigner(TransactionSigner signer) {
        block4: {
            this.lock.lock();
            try {
                if (signer.isReady()) {
                    this.signers.add(signer);
                    break block4;
                }
                throw new IllegalStateException("Signer instance is not ready to be added into Wallet: " + signer.getClass());
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public List<TransactionSigner> getTransactionSigners() {
        this.lock.lock();
        try {
            ImmutableList immutableList = ImmutableList.copyOf(this.signers);
            return immutableList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public DeterministicKey currentKey(KeyChain.KeyPurpose purpose) {
        this.keyChainGroupLock.lock();
        try {
            this.maybeUpgradeToHD();
            DeterministicKey deterministicKey = this.keyChainGroup.currentKey(purpose);
            return deterministicKey;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public DeterministicKey currentReceiveKey() {
        return this.currentKey(KeyChain.KeyPurpose.RECEIVE_FUNDS);
    }

    public Address currentAddress(KeyChain.KeyPurpose purpose) {
        this.keyChainGroupLock.lock();
        try {
            this.maybeUpgradeToHD();
            Address address = this.keyChainGroup.currentAddress(purpose);
            return address;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public Address currentReceiveAddress() {
        return this.currentAddress(KeyChain.KeyPurpose.RECEIVE_FUNDS);
    }

    public DeterministicKey freshKey(KeyChain.KeyPurpose purpose) {
        return this.freshKeys(purpose, 1).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeterministicKey> freshKeys(KeyChain.KeyPurpose purpose, int numberOfKeys) {
        List<DeterministicKey> keys;
        this.keyChainGroupLock.lock();
        try {
            this.maybeUpgradeToHD();
            keys = this.keyChainGroup.freshKeys(purpose, numberOfKeys);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
        this.saveNow();
        return keys;
    }

    public DeterministicKey freshReceiveKey() {
        return this.freshKey(KeyChain.KeyPurpose.RECEIVE_FUNDS);
    }

    public Address freshAddress(KeyChain.KeyPurpose purpose) {
        Address key;
        this.keyChainGroupLock.lock();
        try {
            key = this.keyChainGroup.freshAddress(purpose);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
        this.saveNow();
        return key;
    }

    public Address freshReceiveAddress() {
        return this.freshAddress(KeyChain.KeyPurpose.RECEIVE_FUNDS);
    }

    public List<ECKey> getIssuedReceiveKeys() {
        this.keyChainGroupLock.lock();
        try {
            List<ECKey> list = this.keyChainGroup.getActiveKeyChain().getIssuedReceiveKeys();
            return list;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public List<Address> getIssuedReceiveAddresses() {
        List<ECKey> keys = this.getIssuedReceiveKeys();
        ArrayList<Address> addresses = new ArrayList<Address>(keys.size());
        for (ECKey key : keys) {
            addresses.add(key.toAddress(this.getParams()));
        }
        return addresses;
    }

    public void upgradeToDeterministic(@Nullable KeyParameter aesKey) throws DeterministicUpgradeRequiresPassword {
        this.keyChainGroupLock.lock();
        try {
            this.keyChainGroup.upgradeToDeterministic(this.vKeyRotationTimestamp, aesKey);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public boolean isDeterministicUpgradeRequired() {
        this.keyChainGroupLock.lock();
        try {
            boolean bl = this.keyChainGroup.isDeterministicUpgradeRequired();
            return bl;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    private void maybeUpgradeToHD() throws DeterministicUpgradeRequiresPassword {
        this.maybeUpgradeToHD(null);
    }

    @GuardedBy(value="keyChainGroupLock")
    private void maybeUpgradeToHD(@Nullable KeyParameter aesKey) throws DeterministicUpgradeRequiresPassword {
        Preconditions.checkState((boolean)this.keyChainGroupLock.isHeldByCurrentThread());
        if (this.keyChainGroup.isDeterministicUpgradeRequired()) {
            log.info("Upgrade to HD wallets is required, attempting to do so.");
            try {
                this.upgradeToDeterministic(aesKey);
            }
            catch (DeterministicUpgradeRequiresPassword e) {
                log.error("Failed to auto upgrade due to encryption. You should call wallet.upgradeToDeterministic with the users AES key to avoid this error.");
                throw e;
            }
        }
    }

    public List<Script> getWatchedScripts() {
        this.keyChainGroupLock.lock();
        try {
            ArrayList<Script> arrayList = new ArrayList<Script>(this.watchedScripts);
            return arrayList;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public boolean removeKey(ECKey key) {
        this.keyChainGroupLock.lock();
        try {
            boolean bl = this.keyChainGroup.removeImportedKey(key);
            return bl;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public int getKeyChainGroupSize() {
        this.keyChainGroupLock.lock();
        try {
            int n = this.keyChainGroup.numKeys();
            return n;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    @VisibleForTesting
    public int getKeyChainGroupCombinedKeyLookaheadEpochs() {
        this.keyChainGroupLock.lock();
        try {
            int n = this.keyChainGroup.getCombinedKeyLookaheadEpochs();
            return n;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public List<ECKey> getImportedKeys() {
        this.keyChainGroupLock.lock();
        try {
            List<ECKey> list = this.keyChainGroup.getImportedKeys();
            return list;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public Address currentChangeAddress() {
        return this.currentAddress(KeyChain.KeyPurpose.CHANGE);
    }

    public Address getChangeAddress() {
        return this.currentChangeAddress();
    }

    @Deprecated
    public boolean addKey(ECKey key) {
        return this.importKey(key);
    }

    public boolean importKey(ECKey key) {
        return this.importKeys(Lists.newArrayList((Object[])new ECKey[]{key})) == 1;
    }

    @Deprecated
    public int addKeys(List<ECKey> keys) {
        return this.importKeys(keys);
    }

    public int importKeys(List<ECKey> keys) {
        int result;
        this.checkNoDeterministicKeys(keys);
        this.keyChainGroupLock.lock();
        try {
            result = this.keyChainGroup.importKeys(keys);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
        this.saveNow();
        return result;
    }

    private void checkNoDeterministicKeys(List<ECKey> keys) {
        for (ECKey key : keys) {
            if (!(key instanceof DeterministicKey)) continue;
            throw new IllegalArgumentException("Cannot import HD keys back into the wallet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importKeysAndEncrypt(List<ECKey> keys, CharSequence password) {
        this.keyChainGroupLock.lock();
        try {
            Preconditions.checkNotNull((Object)this.getKeyCrypter(), (Object)"Wallet is not encrypted");
            int n = this.importKeysAndEncrypt(keys, this.getKeyCrypter().deriveKey(password));
            return n;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importKeysAndEncrypt(List<ECKey> keys, KeyParameter aesKey) {
        this.keyChainGroupLock.lock();
        try {
            this.checkNoDeterministicKeys(keys);
            int n = this.keyChainGroup.importKeysAndEncrypt(keys, aesKey);
            return n;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public void addAndActivateHDChain(DeterministicKeyChain chain) {
        this.keyChainGroupLock.lock();
        try {
            this.keyChainGroup.addAndActivateHDChain(chain);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public void setKeyChainGroupLookaheadSize(int lookaheadSize) {
        this.keyChainGroupLock.lock();
        try {
            this.keyChainGroup.setLookaheadSize(lookaheadSize);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public int getKeyChainGroupLookaheadSize() {
        this.keyChainGroupLock.lock();
        try {
            int n = this.keyChainGroup.getLookaheadSize();
            return n;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public void setKeyChainGroupLookaheadThreshold(int num) {
        this.keyChainGroupLock.lock();
        try {
            this.maybeUpgradeToHD();
            this.keyChainGroup.setLookaheadThreshold(num);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public int getKeyChainGroupLookaheadThreshold() {
        this.keyChainGroupLock.lock();
        try {
            this.maybeUpgradeToHD();
            int n = this.keyChainGroup.getLookaheadThreshold();
            return n;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public DeterministicKey getWatchingKey() {
        this.keyChainGroupLock.lock();
        try {
            this.maybeUpgradeToHD();
            DeterministicKey deterministicKey = this.keyChainGroup.getActiveKeyChain().getWatchingKey();
            return deterministicKey;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public boolean isWatching() {
        this.keyChainGroupLock.lock();
        try {
            this.maybeUpgradeToHD();
            boolean bl = this.keyChainGroup.isWatching();
            return bl;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public boolean isAddressWatched(Address address) {
        Script script = ScriptBuilder.createOutputScript(address);
        return this.isWatchedScript(script);
    }

    public boolean addWatchedAddress(Address address) {
        long now = Utils.currentTimeMillis() / 1000L;
        return this.addWatchedAddresses(Lists.newArrayList((Object[])new Address[]{address}), now) == 1;
    }

    public boolean addWatchedAddress(Address address, long creationTime) {
        return this.addWatchedAddresses(Lists.newArrayList((Object[])new Address[]{address}), creationTime) == 1;
    }

    public int addWatchedAddresses(List<Address> addresses, long creationTime) {
        ArrayList scripts = Lists.newArrayList();
        for (Address address : addresses) {
            Script script = ScriptBuilder.createOutputScript(address);
            script.setCreationTimeSeconds(creationTime);
            scripts.add(script);
        }
        return this.addWatchedScripts(scripts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addWatchedScripts(List<Script> scripts) {
        int added = 0;
        this.keyChainGroupLock.lock();
        try {
            for (Script script : scripts) {
                if (this.watchedScripts.contains(script)) {
                    this.watchedScripts.remove(script);
                }
                if (script.getCreationTimeSeconds() == 0L) {
                    log.warn("Adding a script to the wallet with a creation time of zero, this will disable the checkpointing optimization!    {}", (Object)script);
                }
                this.watchedScripts.add(script);
                ++added;
            }
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
        if (added > 0) {
            this.queueOnScriptsChanged(scripts, true);
            this.saveNow();
        }
        return added;
    }

    public boolean removeWatchedAddress(Address address) {
        return this.removeWatchedAddresses((List<Address>)ImmutableList.of((Object)address));
    }

    public boolean removeWatchedAddresses(List<Address> addresses) {
        ArrayList scripts = Lists.newArrayList();
        for (Address address : addresses) {
            Script script = ScriptBuilder.createOutputScript(address);
            scripts.add(script);
        }
        return this.removeWatchedScripts(scripts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeWatchedScripts(List<Script> scripts) {
        this.lock.lock();
        try {
            for (Script script : scripts) {
                if (!this.watchedScripts.contains(script)) continue;
                this.watchedScripts.remove(script);
            }
            this.queueOnScriptsChanged(scripts, false);
            this.saveNow();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Address> getWatchedAddresses() {
        this.keyChainGroupLock.lock();
        try {
            LinkedList<Address> addresses = new LinkedList<Address>();
            for (Script script : this.watchedScripts) {
                if (!script.isSentToAddress()) continue;
                addresses.add(script.getToAddress(this.params));
            }
            LinkedList<Address> linkedList = addresses;
            return linkedList;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    @Override
    @Nullable
    public ECKey findKeyFromPubHash(byte[] pubkeyHash) {
        this.keyChainGroupLock.lock();
        try {
            ECKey eCKey = this.keyChainGroup.findKeyFromPubHash(pubkeyHash);
            return eCKey;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public boolean hasKey(ECKey key) {
        this.keyChainGroupLock.lock();
        try {
            boolean bl = this.keyChainGroup.hasKey(key);
            return bl;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    @Override
    public boolean isPubKeyHashMine(byte[] pubkeyHash) {
        return this.findKeyFromPubHash(pubkeyHash) != null;
    }

    @Override
    public boolean isWatchedScript(Script script) {
        this.keyChainGroupLock.lock();
        try {
            boolean bl = this.watchedScripts.contains(script);
            return bl;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    @Override
    @Nullable
    public ECKey findKeyFromPubKey(byte[] pubkey) {
        this.keyChainGroupLock.lock();
        try {
            ECKey eCKey = this.keyChainGroup.findKeyFromPubKey(pubkey);
            return eCKey;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    @Override
    public boolean isPubKeyMine(byte[] pubkey) {
        return this.findKeyFromPubKey(pubkey) != null;
    }

    @Override
    @Nullable
    public RedeemData findRedeemDataFromScriptHash(byte[] payToScriptHash) {
        this.keyChainGroupLock.lock();
        try {
            RedeemData redeemData = this.keyChainGroup.findRedeemDataFromScriptHash(payToScriptHash);
            return redeemData;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    @Override
    public boolean isPayToScriptHashMine(byte[] payToScriptHash) {
        return this.findRedeemDataFromScriptHash(payToScriptHash) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markKeysAsUsed(Transaction tx) {
        this.keyChainGroupLock.lock();
        try {
            for (TransactionOutput o : tx.getOutputs()) {
                try {
                    Script script = o.getScriptPubKey();
                    if (script.isSentToRawPubKey()) {
                        byte[] pubkey = script.getPubKey();
                        this.keyChainGroup.markPubKeyAsUsed(pubkey);
                        continue;
                    }
                    if (script.isSentToAddress()) {
                        byte[] pubkeyHash = script.getPubKeyHash();
                        this.keyChainGroup.markPubKeyHashAsUsed(pubkeyHash);
                        continue;
                    }
                    if (!script.isPayToScriptHash()) continue;
                    Address a = Address.fromP2SHScript(tx.getParams(), script);
                    this.keyChainGroup.markP2SHAddressAsUsed(a);
                }
                catch (ScriptException e) {
                    log.warn("Could not parse tx output script: {}", (Object)e.toString());
                }
            }
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public DeterministicSeed getKeyChainSeed() {
        this.keyChainGroupLock.lock();
        try {
            DeterministicSeed seed = this.keyChainGroup.getActiveKeyChain().getSeed();
            if (seed == null) {
                throw new ECKey.MissingPrivateKeyException();
            }
            DeterministicSeed deterministicSeed = seed;
            return deterministicSeed;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public DeterministicKey getKeyByPath(List<ChildNumber> path) {
        this.keyChainGroupLock.lock();
        try {
            this.maybeUpgradeToHD();
            DeterministicKey deterministicKey = this.keyChainGroup.getActiveKeyChain().getKeyByPath(path, false);
            return deterministicKey;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public void encrypt(CharSequence password) {
        this.keyChainGroupLock.lock();
        try {
            KeyCrypterScrypt scrypt = new KeyCrypterScrypt();
            this.keyChainGroup.encrypt(scrypt, scrypt.deriveKey(password));
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
        this.saveNow();
    }

    public void encrypt(KeyCrypter keyCrypter, KeyParameter aesKey) {
        this.keyChainGroupLock.lock();
        try {
            this.keyChainGroup.encrypt(keyCrypter, aesKey);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
        this.saveNow();
    }

    public void decrypt(CharSequence password) {
        this.keyChainGroupLock.lock();
        try {
            KeyCrypter crypter = this.keyChainGroup.getKeyCrypter();
            Preconditions.checkState((crypter != null ? 1 : 0) != 0, (Object)"Not encrypted");
            this.keyChainGroup.decrypt(crypter.deriveKey(password));
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
        this.saveNow();
    }

    public void decrypt(KeyParameter aesKey) {
        this.keyChainGroupLock.lock();
        try {
            this.keyChainGroup.decrypt(aesKey);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
        this.saveNow();
    }

    public boolean checkPassword(CharSequence password) {
        this.keyChainGroupLock.lock();
        try {
            boolean bl = this.keyChainGroup.checkPassword(password);
            return bl;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public boolean checkAESKey(KeyParameter aesKey) {
        this.keyChainGroupLock.lock();
        try {
            boolean bl = this.keyChainGroup.checkAESKey(aesKey);
            return bl;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    @Nullable
    public KeyCrypter getKeyCrypter() {
        this.keyChainGroupLock.lock();
        try {
            KeyCrypter keyCrypter = this.keyChainGroup.getKeyCrypter();
            return keyCrypter;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public Protos.Wallet.EncryptionType getEncryptionType() {
        this.keyChainGroupLock.lock();
        try {
            KeyCrypter crypter = this.keyChainGroup.getKeyCrypter();
            if (crypter != null) {
                Protos.Wallet.EncryptionType encryptionType = crypter.getUnderstoodEncryptionType();
                return encryptionType;
            }
            Protos.Wallet.EncryptionType encryptionType = Protos.Wallet.EncryptionType.UNENCRYPTED;
            return encryptionType;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public boolean isEncrypted() {
        return this.getEncryptionType() != Protos.Wallet.EncryptionType.UNENCRYPTED;
    }

    public void changeEncryptionPassword(CharSequence currentPassword, CharSequence newPassword) {
        this.keyChainGroupLock.lock();
        try {
            this.decrypt(currentPassword);
            this.encrypt(newPassword);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeEncryptionKey(KeyCrypter keyCrypter, KeyParameter currentAesKey, KeyParameter newAesKey) {
        this.keyChainGroupLock.lock();
        try {
            this.decrypt(currentAesKey);
            this.encrypt(keyCrypter, newAesKey);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public List<Protos.Key> serializeKeyChainGroupToProtobuf() {
        this.keyChainGroupLock.lock();
        try {
            List<Protos.Key> list = this.keyChainGroup.serializeToProtobuf();
            return list;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public void saveToFile(File temp, File destFile) throws IOException {
        FileOutputStream stream = null;
        this.lock.lock();
        try {
            stream = new FileOutputStream(temp);
            this.saveToFileStream(stream);
            stream.flush();
            stream.getFD().sync();
            stream.close();
            stream = null;
            if (Utils.isWindows()) {
                File canonical = destFile.getCanonicalFile();
                if (canonical.exists() && !canonical.delete()) {
                    throw new IOException("Failed to delete canonical wallet file for replacement with autosave");
                }
                if (temp.renameTo(canonical)) {
                    return;
                }
                throw new IOException("Failed to rename " + temp + " to " + canonical);
            }
            if (!temp.renameTo(destFile)) {
                throw new IOException("Failed to rename " + temp + " to " + destFile);
            }
        }
        catch (RuntimeException e) {
            log.error("Failed whilst saving wallet", (Throwable)e);
            throw e;
        }
        finally {
            this.lock.unlock();
            if (stream != null) {
                stream.close();
            }
            if (temp.exists()) {
                log.warn("Temp file still exists after failed save.");
            }
        }
    }

    public void saveToFile(File f) throws IOException {
        File directory = f.getAbsoluteFile().getParentFile();
        File temp = File.createTempFile("wallet", null, directory);
        this.saveToFile(temp, f);
    }

    public void setAcceptRiskyTransactions(boolean acceptRiskyTransactions) {
        this.lock.lock();
        try {
            this.acceptRiskyTransactions = acceptRiskyTransactions;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isAcceptRiskyTransactions() {
        this.lock.lock();
        try {
            boolean bl = this.acceptRiskyTransactions;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setRiskAnalyzer(RiskAnalysis.Analyzer analyzer) {
        this.lock.lock();
        try {
            this.riskAnalyzer = (RiskAnalysis.Analyzer)Preconditions.checkNotNull((Object)analyzer);
        }
        finally {
            this.lock.unlock();
        }
    }

    public RiskAnalysis.Analyzer getRiskAnalyzer() {
        this.lock.lock();
        try {
            RiskAnalysis.Analyzer analyzer = this.riskAnalyzer;
            return analyzer;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WalletFiles autosaveToFile(File f, long delayTime, TimeUnit timeUnit, @Nullable WalletFiles.Listener eventListener) {
        this.lock.lock();
        try {
            Preconditions.checkState((this.vFileManager == null ? 1 : 0) != 0, (Object)"Already auto saving this wallet.");
            WalletFiles manager = new WalletFiles(this, f, delayTime, timeUnit);
            if (eventListener != null) {
                manager.setListener(eventListener);
            }
            this.vFileManager = manager;
            WalletFiles walletFiles = manager;
            return walletFiles;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void shutdownAutosaveAndWait() {
        this.lock.lock();
        try {
            WalletFiles files = this.vFileManager;
            this.vFileManager = null;
            Preconditions.checkState((files != null ? 1 : 0) != 0, (Object)"Auto saving not enabled.");
            files.shutdownAndWait();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void saveLater() {
        WalletFiles files = this.vFileManager;
        if (files != null) {
            files.saveLater();
        }
    }

    protected void saveNow() {
        block3: {
            WalletFiles files = this.vFileManager;
            if (files != null) {
                try {
                    files.saveNow();
                }
                catch (IOException e) {
                    log.error("Failed to save wallet to disk!", (Throwable)e);
                    Thread.UncaughtExceptionHandler handler = Threading.uncaughtExceptionHandler;
                    if (handler == null) break block3;
                    handler.uncaughtException(Thread.currentThread(), e);
                }
            }
        }
    }

    public void saveToFileStream(OutputStream f) throws IOException {
        this.lock.lock();
        try {
            new WalletProtobufSerializer().writeWallet(this, f);
        }
        finally {
            this.lock.unlock();
        }
    }

    public NetworkParameters getParams() {
        return this.params;
    }

    public Context getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Wallet loadFromFile(File file, WalletExtension ... walletExtensions) throws UnreadableWalletException {
        Wallet wallet;
        block6: {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(file);
                wallet = Wallet.loadFromFileStream(stream, walletExtensions);
                if (stream == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UnreadableWalletException("Could not open file", e);
                }
            }
            stream.close();
        }
        return wallet;
    }

    public boolean isConsistent() {
        try {
            this.isConsistentOrThrow();
            return true;
        }
        catch (IllegalStateException x) {
            log.error(x.getMessage());
            try {
                log.error(this.toString());
            }
            catch (RuntimeException x2) {
                log.error("Printing inconsistent wallet failed", (Throwable)x2);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isConsistentOrThrow() throws IllegalStateException {
        this.lock.lock();
        try {
            Set<Transaction> transactions = this.getTransactions(true);
            HashSet<Sha256Hash> hashes = new HashSet<Sha256Hash>();
            for (Transaction tx : transactions) {
                hashes.add(tx.getHash());
            }
            int size1 = transactions.size();
            if (size1 != hashes.size()) {
                throw new IllegalStateException("Two transactions with same hash");
            }
            int size2 = this.unspent.size() + this.spent.size() + this.pending.size() + this.dead.size();
            if (size1 != size2) {
                throw new IllegalStateException("Inconsistent wallet sizes: " + size1 + ", " + size2);
            }
            for (Transaction tx : this.unspent.values()) {
                if (this.isTxConsistent(tx, false)) continue;
                throw new IllegalStateException("Inconsistent unspent tx: " + tx.getHashAsString());
            }
            for (Transaction tx : this.spent.values()) {
                if (this.isTxConsistent(tx, true)) continue;
                throw new IllegalStateException("Inconsistent spent tx: " + tx.getHashAsString());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @VisibleForTesting
    boolean isTxConsistent(Transaction tx, boolean isSpent) {
        boolean isActuallySpent = true;
        for (TransactionOutput o : tx.getOutputs()) {
            if (o.isAvailableForSpending()) {
                if (o.isMineOrWatched(this)) {
                    isActuallySpent = false;
                }
                if (o.getSpentBy() == null) continue;
                log.error("isAvailableForSpending != spentBy");
                return false;
            }
            if (o.getSpentBy() != null) continue;
            log.error("isAvailableForSpending != spentBy");
            return false;
        }
        return isActuallySpent == isSpent;
    }

    public static Wallet loadFromFileStream(InputStream stream, WalletExtension ... walletExtensions) throws UnreadableWalletException {
        Wallet wallet = new WalletProtobufSerializer().readWallet(stream, walletExtensions);
        if (!wallet.isConsistent()) {
            log.error("Loaded an inconsistent wallet");
        }
        return wallet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notifyTransactionIsInBlock(Sha256Hash txHash, StoredBlock block, AbstractBlockChain.NewBlockType blockType, int relativityOffset) throws VerificationException {
        this.lock.lock();
        try {
            Transaction tx = this.transactions.get(txHash);
            if (tx == null) {
                tx = this.riskDropped.get(txHash);
                if (tx != null) {
                    log.info("Risk analysis dropped tx {} but was included in block anyway", (Object)tx.getHash());
                } else {
                    boolean bl = false;
                    return bl;
                }
            }
            this.receive(tx, block, blockType, relativityOffset);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivePending(Transaction tx, @Nullable List<Transaction> dependencies, boolean overrideIsRelevant) throws VerificationException {
        this.lock.lock();
        try {
            tx.verify();
            EnumSet<WalletTransaction.Pool> containingPools = this.getContainingPools(tx);
            if (!containingPools.equals(EnumSet.noneOf(WalletTransaction.Pool.class))) {
                log.debug("Received tx we already saw in a block or created ourselves: " + tx.getHashAsString());
                return;
            }
            if (!overrideIsRelevant && !this.isPendingTransactionRelevant(tx)) {
                return;
            }
            if (this.isTransactionRisky(tx, dependencies) && !this.acceptRiskyTransactions) {
                this.riskDropped.put(tx.getHash(), tx);
                log.warn("There are now {} risk dropped transactions being kept in memory", (Object)this.riskDropped.size());
                return;
            }
            Coin valueSentToMe = tx.getValueSentToMe(this);
            Coin valueSentFromMe = tx.getValueSentFromMe(this);
            if (log.isInfoEnabled()) {
                log.info(String.format(Locale.US, "Received a pending transaction %s that spends %s from our own wallet, and sends us %s", tx.getHashAsString(), valueSentFromMe.toFriendlyString(), valueSentToMe.toFriendlyString()));
            }
            if (tx.getConfidence().getSource().equals((Object)TransactionConfidence.Source.UNKNOWN)) {
                log.warn("Wallet received transaction with an unknown source. Consider tagging it!");
            }
            this.commitTx(tx);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTransactionRisky(Transaction tx, @Nullable List<Transaction> dependencies) {
        this.lock.lock();
        try {
            RiskAnalysis analysis;
            RiskAnalysis.Result result;
            if (dependencies == null) {
                dependencies = ImmutableList.of();
            }
            if ((result = (analysis = this.riskAnalyzer.create(this, tx, (List<Transaction>)dependencies)).analyze()) != RiskAnalysis.Result.OK) {
                log.warn("Pending transaction was considered risky: {}\n{}", (Object)analysis, (Object)tx);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void receivePending(Transaction tx, @Nullable List<Transaction> dependencies) throws VerificationException {
        this.receivePending(tx, dependencies, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPendingTransactionRelevant(Transaction tx) throws ScriptException {
        this.lock.lock();
        try {
            EnumSet<WalletTransaction.Pool> containingPools = this.getContainingPools(tx);
            if (!containingPools.equals(EnumSet.noneOf(WalletTransaction.Pool.class))) {
                log.debug("Received tx we already saw in a block or created ourselves: " + tx.getHashAsString());
                boolean bl = false;
                return bl;
            }
            if (!this.isTransactionRelevant(tx)) {
                log.debug("Received tx that isn't relevant to this wallet, discarding.");
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isTransactionRelevant(Transaction tx) throws ScriptException {
        this.lock.lock();
        try {
            boolean bl = tx.getValueSentFromMe(this).signum() > 0 || tx.getValueSentToMe(this).signum() > 0 || !this.findDoubleSpendsAgainst(tx, this.transactions).isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Set<Transaction> findDoubleSpendsAgainst(Transaction tx, Map<Sha256Hash, Transaction> candidates) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        if (tx.isCoinBase()) {
            return Sets.newHashSet();
        }
        HashSet<TransactionOutPoint> outpoints = new HashSet<TransactionOutPoint>();
        for (TransactionInput input : tx.getInputs()) {
            outpoints.add(input.getOutpoint());
        }
        HashSet doubleSpendTxns = Sets.newHashSet();
        for (Transaction p : candidates.values()) {
            for (TransactionInput input : p.getInputs()) {
                TransactionOutPoint outpoint = input.getOutpoint();
                if (!outpoints.contains(outpoint)) continue;
                doubleSpendTxns.add(p);
            }
        }
        return doubleSpendTxns;
    }

    void addTransactionsDependingOn(Set<Transaction> txSet, Set<Transaction> txPool) {
        LinkedHashMap<Sha256Hash, Transaction> txQueue = new LinkedHashMap<Sha256Hash, Transaction>();
        for (Transaction tx : txSet) {
            txQueue.put(tx.getHash(), tx);
        }
        while (!txQueue.isEmpty()) {
            Transaction tx = (Transaction)txQueue.remove(txQueue.keySet().iterator().next());
            for (Transaction anotherTx : txPool) {
                if (anotherTx.equals(tx)) continue;
                for (TransactionInput input : anotherTx.getInputs()) {
                    if (!input.getOutpoint().getHash().equals(tx.getHash()) || txQueue.get(anotherTx.getHash()) != null) continue;
                    txQueue.put(anotherTx.getHash(), anotherTx);
                    txSet.add(anotherTx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveFromBlock(Transaction tx, StoredBlock block, AbstractBlockChain.NewBlockType blockType, int relativityOffset) throws VerificationException {
        this.lock.lock();
        try {
            if (!this.isTransactionRelevant(tx)) {
                return;
            }
            this.receive(tx, block, blockType, relativityOffset);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void receive(Transaction tx, StoredBlock block, AbstractBlockChain.NewBlockType blockType, int relativityOffset) throws VerificationException {
        boolean wasPending;
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        Coin prevBalance = this.getBalance();
        Sha256Hash txHash = tx.getHash();
        boolean bestChain = blockType == AbstractBlockChain.NewBlockType.BEST_CHAIN;
        boolean sideChain = blockType == AbstractBlockChain.NewBlockType.SIDE_CHAIN;
        Coin valueSentFromMe = tx.getValueSentFromMe(this);
        Coin valueSentToMe = tx.getValueSentToMe(this);
        Coin valueDifference = valueSentToMe.subtract(valueSentFromMe);
        log.info("Received tx{} for {}: {} [{}] in block {}", new Object[]{sideChain ? " on a side chain" : "", valueDifference.toFriendlyString(), tx.getHashAsString(), relativityOffset, block != null ? block.getHeader().getHash() : "(unit test)"});
        this.markKeysAsUsed(tx);
        ++this.onWalletChangedSuppressions;
        Transaction tmp = this.transactions.get(tx.getHash());
        if (tmp != null) {
            tx = tmp;
        }
        boolean bl = wasPending = this.pending.remove(txHash) != null;
        if (wasPending) {
            log.info("  <-pending");
        }
        if (bestChain) {
            boolean wasDead;
            boolean bl2 = wasDead = this.dead.remove(txHash) != null;
            if (wasDead) {
                log.info("  <-dead");
            }
            if (wasPending) {
                for (TransactionOutput output : tx.getOutputs()) {
                    TransactionInput spentBy = output.getSpentBy();
                    if (spentBy == null) continue;
                    Preconditions.checkState((boolean)this.myUnspents.add(output));
                    spentBy.disconnect();
                }
            }
            this.processTxFromBestChain(tx, wasPending || wasDead);
        } else {
            Preconditions.checkState((boolean)sideChain);
            if (wasPending) {
                this.addWalletTransaction(WalletTransaction.Pool.PENDING, tx);
                log.info("  ->pending");
            } else {
                Sha256Hash hash = tx.getHash();
                if (!(this.unspent.containsKey(hash) || this.spent.containsKey(hash) || this.dead.containsKey(hash))) {
                    this.commitTx(tx);
                }
            }
        }
        if (block != null) {
            tx.setBlockAppearance(block, bestChain, relativityOffset);
            if (bestChain) {
                this.ignoreNextNewBlock.add(txHash);
                HashSet currentTxDependencies = Sets.newHashSet((Object[])new Transaction[]{tx});
                this.addTransactionsDependingOn(currentTxDependencies, this.getTransactions(true));
                currentTxDependencies.remove(tx);
                List<Transaction> currentTxDependenciesSorted = this.sortTxnsByDependency(currentTxDependencies);
                for (Transaction txDependency : currentTxDependenciesSorted) {
                    if (!txDependency.getConfidence().getConfidenceType().equals((Object)TransactionConfidence.ConfidenceType.IN_CONFLICT) || !this.isNotSpendingTxnsInConfidenceType(txDependency, TransactionConfidence.ConfidenceType.IN_CONFLICT)) continue;
                    txDependency.getConfidence().setConfidenceType(TransactionConfidence.ConfidenceType.PENDING);
                    this.confidenceChanged.put(txDependency, TransactionConfidence.Listener.ChangeReason.TYPE);
                }
            }
        }
        --this.onWalletChangedSuppressions;
        if (bestChain) {
            this.confidenceChanged.put(tx, TransactionConfidence.Listener.ChangeReason.TYPE);
        } else {
            this.maybeQueueOnWalletChanged();
        }
        if (!this.insideReorg && bestChain) {
            Coin newBalance = this.getBalance();
            log.info("Balance is now: " + newBalance.toFriendlyString());
            if (!wasPending) {
                int diff = valueDifference.signum();
                if (diff > 0) {
                    this.queueOnCoinsReceived(tx, prevBalance, newBalance);
                } else if (diff < 0) {
                    this.queueOnCoinsSent(tx, prevBalance, newBalance);
                }
            }
            this.checkBalanceFuturesLocked(newBalance);
        }
        this.informConfidenceListenersIfNotReorganizing();
        this.isConsistentOrThrow();
        this.saveLater();
        this.hardSaveOnNextBlock = true;
    }

    private boolean isNotSpendingTxnsInConfidenceType(Transaction tx, TransactionConfidence.ConfidenceType confidenceType) {
        for (TransactionInput txInput : tx.getInputs()) {
            Transaction connectedTx = this.getTransaction(txInput.getOutpoint().getHash());
            if (connectedTx == null || !connectedTx.getConfidence().getConfidenceType().equals((Object)confidenceType)) continue;
            return false;
        }
        return true;
    }

    List<Transaction> sortTxnsByDependency(Set<Transaction> inputSet) {
        ArrayList<Transaction> result = new ArrayList<Transaction>(inputSet);
        for (int i = 0; i < result.size() - 1; ++i) {
            boolean txAtISpendsOtherTxInTheList;
            block1: do {
                txAtISpendsOtherTxInTheList = false;
                for (int j = i + 1; j < result.size(); ++j) {
                    if (!this.spends(result.get(i), result.get(j))) continue;
                    Transaction transactionAtI = result.remove(i);
                    result.add(j, transactionAtI);
                    txAtISpendsOtherTxInTheList = true;
                    continue block1;
                }
            } while (txAtISpendsOtherTxInTheList);
        }
        return result;
    }

    boolean spends(Transaction txA, Transaction txB) {
        for (TransactionInput txInput : txA.getInputs()) {
            if (!txInput.getOutpoint().getHash().equals(txB.getHash())) continue;
            return true;
        }
        return false;
    }

    private void informConfidenceListenersIfNotReorganizing() {
        if (this.insideReorg) {
            return;
        }
        for (Map.Entry<Transaction, TransactionConfidence.Listener.ChangeReason> entry : this.confidenceChanged.entrySet()) {
            Transaction tx = entry.getKey();
            tx.getConfidence().queueListeners(entry.getValue());
            this.queueOnTransactionConfidenceChanged(tx);
        }
        this.confidenceChanged.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyNewBestBlock(StoredBlock block) throws VerificationException {
        Sha256Hash newBlockHash = block.getHeader().getHash();
        if (newBlockHash.equals(this.getLastBlockSeenHash())) {
            return;
        }
        this.lock.lock();
        try {
            this.setLastBlockSeenHash(newBlockHash);
            this.setLastBlockSeenHeight(block.getHeight());
            this.setLastBlockSeenTimeSecs(block.getHeader().getTimeSeconds());
            Set<Transaction> transactions = this.getTransactions(true);
            for (Transaction tx : transactions) {
                if (this.ignoreNextNewBlock.contains(tx.getHash())) {
                    this.ignoreNextNewBlock.remove(tx.getHash());
                    continue;
                }
                TransactionConfidence confidence = tx.getConfidence();
                if (confidence.getConfidenceType() != TransactionConfidence.ConfidenceType.BUILDING) continue;
                if (confidence.incrementDepthInBlocks() > this.context.getEventHorizon()) {
                    confidence.clearBroadcastBy();
                }
                this.confidenceChanged.put(tx, TransactionConfidence.Listener.ChangeReason.DEPTH);
            }
            this.informConfidenceListenersIfNotReorganizing();
            this.maybeQueueOnWalletChanged();
            if (this.hardSaveOnNextBlock) {
                this.saveNow();
                this.hardSaveOnNextBlock = false;
            } else {
                this.saveLater();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void processTxFromBestChain(Transaction tx, boolean forceAddToPool) throws VerificationException {
        boolean hasOutputsToMe;
        boolean isDeadCoinbase;
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        Preconditions.checkState((!this.pending.containsKey(tx.getHash()) ? 1 : 0) != 0);
        boolean bl = isDeadCoinbase = tx.isCoinBase() && this.dead.containsKey(tx.getHash());
        if (isDeadCoinbase) {
            log.info("  coinbase tx <-dead: confidence {}", (Object)tx.getHashAsString(), (Object)tx.getConfidence().getConfidenceType().name());
            this.dead.remove(tx.getHash());
        }
        this.updateForSpends(tx, true);
        boolean bl2 = hasOutputsToMe = tx.getValueSentToMe(this).signum() > 0;
        if (hasOutputsToMe) {
            if (tx.isEveryOwnedOutputSpent(this)) {
                log.info("  tx {} ->spent (by pending)", (Object)tx.getHashAsString());
                this.addWalletTransaction(WalletTransaction.Pool.SPENT, tx);
            } else {
                log.info("  tx {} ->unspent", (Object)tx.getHashAsString());
                this.addWalletTransaction(WalletTransaction.Pool.UNSPENT, tx);
            }
        } else if (tx.getValueSentFromMe(this).signum() > 0) {
            log.info("  tx {} ->spent", (Object)tx.getHashAsString());
            this.addWalletTransaction(WalletTransaction.Pool.SPENT, tx);
        } else if (forceAddToPool) {
            log.info("  tx {} ->spent (manually added)", (Object)tx.getHashAsString());
            this.addWalletTransaction(WalletTransaction.Pool.SPENT, tx);
        }
        Set<Transaction> doubleSpendTxns = this.findDoubleSpendsAgainst(tx, this.pending);
        if (!doubleSpendTxns.isEmpty()) {
            this.killTxns(doubleSpendTxns, tx);
        }
    }

    private void updateForSpends(Transaction tx, boolean fromChain) throws VerificationException {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        if (fromChain) {
            Preconditions.checkState((!this.pending.containsKey(tx.getHash()) ? 1 : 0) != 0);
        }
        for (TransactionInput input : tx.getInputs()) {
            TransactionInput.ConnectionResult result = input.connect(this.unspent, TransactionInput.ConnectMode.ABORT_ON_CONFLICT);
            if (result == TransactionInput.ConnectionResult.NO_SUCH_TX && (result = input.connect(this.spent, TransactionInput.ConnectMode.ABORT_ON_CONFLICT)) == TransactionInput.ConnectionResult.NO_SUCH_TX && (result = input.connect(this.pending, TransactionInput.ConnectMode.ABORT_ON_CONFLICT)) == TransactionInput.ConnectionResult.NO_SUCH_TX) continue;
            TransactionOutput output = (TransactionOutput)Preconditions.checkNotNull((Object)input.getConnectedOutput());
            if (result == TransactionInput.ConnectionResult.ALREADY_SPENT) {
                if (fromChain) continue;
                log.warn("Saw two pending transactions double spend each other");
                log.warn("  offending input is input {}", (Object)tx.getInputs().indexOf(input));
                log.warn("{}: {}", (Object)tx.getHash(), (Object)Utils.HEX.encode(tx.unsafeBitcoinSerialize()));
                Transaction other = output.getSpentBy().getParentTransaction();
                log.warn("{}: {}", (Object)other.getHash(), (Object)Utils.HEX.encode(other.unsafeBitcoinSerialize()));
                continue;
            }
            if (result != TransactionInput.ConnectionResult.SUCCESS) continue;
            Transaction connected = (Transaction)Preconditions.checkNotNull((Object)input.getConnectedTransaction());
            log.info("  marked {} as spent by {}", (Object)input.getOutpoint(), (Object)tx.getHashAsString());
            this.maybeMovePool(connected, "prevtx");
            if (!output.isMineOrWatched(this)) continue;
            Preconditions.checkState((boolean)this.myUnspents.remove(output));
        }
        for (Transaction pendingTx : this.pending.values()) {
            for (TransactionInput input : pendingTx.getInputs()) {
                TransactionInput.ConnectionResult result = input.connect(tx, TransactionInput.ConnectMode.ABORT_ON_CONFLICT);
                if (fromChain) {
                    Preconditions.checkState((result != TransactionInput.ConnectionResult.ALREADY_SPENT ? 1 : 0) != 0);
                }
                if (result != TransactionInput.ConnectionResult.SUCCESS) continue;
                log.info("Connected pending tx input {}:{}", (Object)pendingTx.getHashAsString(), (Object)pendingTx.getInputs().indexOf(input));
                if (!this.myUnspents.remove(input.getConnectedOutput())) continue;
                log.info("Removed from UNSPENTS: {}", (Object)input.getConnectedOutput());
            }
        }
        if (!fromChain) {
            this.maybeMovePool(tx, "pendingtx");
        }
    }

    private void killTxns(Set<Transaction> txnsToKill, @Nullable Transaction overridingTx) {
        LinkedList<Transaction> work = new LinkedList<Transaction>(txnsToKill);
        while (!work.isEmpty()) {
            ChildMessage connected;
            Transaction tx = work.poll();
            log.warn("TX {} killed{}", (Object)tx.getHashAsString(), (Object)(overridingTx != null ? " by " + overridingTx.getHashAsString() : ""));
            log.warn("Disconnecting each input and moving connected transactions.");
            this.pending.remove(tx.getHash());
            this.unspent.remove(tx.getHash());
            this.spent.remove(tx.getHash());
            this.addWalletTransaction(WalletTransaction.Pool.DEAD, tx);
            for (TransactionInput deadInput : tx.getInputs()) {
                connected = deadInput.getConnectedTransaction();
                if (connected == null) continue;
                if (((Transaction)connected).getConfidence().getConfidenceType() != TransactionConfidence.ConfidenceType.DEAD && deadInput.getConnectedOutput().getSpentBy() != null && deadInput.getConnectedOutput().getSpentBy().equals(deadInput)) {
                    Preconditions.checkState((boolean)this.myUnspents.add(deadInput.getConnectedOutput()));
                    log.info("Added to UNSPENTS: {} in {}", (Object)deadInput.getConnectedOutput(), (Object)deadInput.getConnectedOutput().getParentTransaction().getHash());
                }
                deadInput.disconnect();
                this.maybeMovePool((Transaction)connected, "kill");
            }
            tx.getConfidence().setOverridingTransaction(overridingTx);
            this.confidenceChanged.put(tx, TransactionConfidence.Listener.ChangeReason.TYPE);
            for (TransactionOutput deadOutput : tx.getOutputs()) {
                if (this.myUnspents.remove(deadOutput)) {
                    log.info("XX Removed from UNSPENTS: {}", (Object)deadOutput);
                }
                if ((connected = deadOutput.getSpentBy()) == null) continue;
                Transaction parentTransaction = ((TransactionInput)connected).getParentTransaction();
                log.info("This death invalidated dependent tx {}", (Object)parentTransaction.getHash());
                work.push(parentTransaction);
            }
        }
        if (overridingTx == null) {
            return;
        }
        log.warn("Now attempting to connect the inputs of the overriding transaction.");
        for (TransactionInput input : overridingTx.getInputs()) {
            TransactionInput.ConnectionResult result = input.connect(this.unspent, TransactionInput.ConnectMode.DISCONNECT_ON_CONFLICT);
            if (result == TransactionInput.ConnectionResult.SUCCESS) {
                this.maybeMovePool(input.getConnectedTransaction(), "kill");
                this.myUnspents.remove(input.getConnectedOutput());
                log.info("Removing from UNSPENTS: {}", (Object)input.getConnectedOutput());
                continue;
            }
            result = input.connect(this.spent, TransactionInput.ConnectMode.DISCONNECT_ON_CONFLICT);
            if (result != TransactionInput.ConnectionResult.SUCCESS) continue;
            this.maybeMovePool(input.getConnectedTransaction(), "kill");
            this.myUnspents.remove(input.getConnectedOutput());
            log.info("Removing from UNSPENTS: {}", (Object)input.getConnectedOutput());
        }
    }

    private void maybeMovePool(Transaction tx, String context) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        if (tx.isEveryOwnedOutputSpent(this)) {
            if (this.unspent.remove(tx.getHash()) != null) {
                if (log.isInfoEnabled()) {
                    log.info("  {} {} <-unspent ->spent", (Object)tx.getHashAsString(), (Object)context);
                }
                this.spent.put(tx.getHash(), tx);
            }
        } else if (this.spent.remove(tx.getHash()) != null) {
            if (log.isInfoEnabled()) {
                log.info("  {} {} <-spent ->unspent", (Object)tx.getHashAsString(), (Object)context);
            }
            this.unspent.put(tx.getHash(), tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean maybeCommitTx(Transaction tx) throws VerificationException {
        tx.verify();
        this.lock.lock();
        try {
            if (this.pending.containsKey(tx.getHash())) {
                boolean bl = false;
                return bl;
            }
            log.info("commitTx of {}", (Object)tx.getHashAsString());
            Coin balance = this.getBalance();
            tx.setUpdateTime(Utils.now());
            Coin valueSentToMe = Coin.ZERO;
            for (TransactionOutput o : tx.getOutputs()) {
                if (!o.isMineOrWatched(this)) continue;
                valueSentToMe = valueSentToMe.add(o.getValue());
            }
            this.updateForSpends(tx, false);
            Set<Transaction> doubleSpendPendingTxns = this.findDoubleSpendsAgainst(tx, this.pending);
            Set<Transaction> doubleSpendUnspentTxns = this.findDoubleSpendsAgainst(tx, this.unspent);
            Set<Transaction> doubleSpendSpentTxns = this.findDoubleSpendsAgainst(tx, this.spent);
            if (!(doubleSpendUnspentTxns.isEmpty() && doubleSpendSpentTxns.isEmpty() && this.isNotSpendingTxnsInConfidenceType(tx, TransactionConfidence.ConfidenceType.DEAD))) {
                log.info("->dead: {}", (Object)tx.getHashAsString());
                tx.getConfidence().setConfidenceType(TransactionConfidence.ConfidenceType.DEAD);
                this.confidenceChanged.put(tx, TransactionConfidence.Listener.ChangeReason.TYPE);
                this.addWalletTransaction(WalletTransaction.Pool.DEAD, tx);
            } else if (!doubleSpendPendingTxns.isEmpty() || !this.isNotSpendingTxnsInConfidenceType(tx, TransactionConfidence.ConfidenceType.IN_CONFLICT)) {
                log.info("->pending (IN_CONFLICT): {}", (Object)tx.getHashAsString());
                this.addWalletTransaction(WalletTransaction.Pool.PENDING, tx);
                doubleSpendPendingTxns.add(tx);
                this.addTransactionsDependingOn(doubleSpendPendingTxns, this.getTransactions(true));
                for (Transaction doubleSpendTx : doubleSpendPendingTxns) {
                    doubleSpendTx.getConfidence().setConfidenceType(TransactionConfidence.ConfidenceType.IN_CONFLICT);
                    this.confidenceChanged.put(doubleSpendTx, TransactionConfidence.Listener.ChangeReason.TYPE);
                }
            } else {
                log.info("->pending: {}", (Object)tx.getHashAsString());
                tx.getConfidence().setConfidenceType(TransactionConfidence.ConfidenceType.PENDING);
                this.confidenceChanged.put(tx, TransactionConfidence.Listener.ChangeReason.TYPE);
                this.addWalletTransaction(WalletTransaction.Pool.PENDING, tx);
            }
            if (log.isInfoEnabled()) {
                log.info("Estimated balance is now: {}", (Object)this.getBalance(BalanceType.ESTIMATED).toFriendlyString());
            }
            this.markKeysAsUsed(tx);
            try {
                Coin valueSentFromMe = tx.getValueSentFromMe(this);
                Coin newBalance = balance.add(valueSentToMe).subtract(valueSentFromMe);
                if (valueSentToMe.signum() > 0) {
                    this.checkBalanceFuturesLocked(null);
                    this.queueOnCoinsReceived(tx, balance, newBalance);
                }
                if (valueSentFromMe.signum() > 0) {
                    this.queueOnCoinsSent(tx, balance, newBalance);
                }
                this.maybeQueueOnWalletChanged();
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
            this.isConsistentOrThrow();
            this.informConfidenceListenersIfNotReorganizing();
            this.saveNow();
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    public void commitTx(Transaction tx) throws VerificationException {
        Preconditions.checkArgument((boolean)this.maybeCommitTx(tx), (Object)"commitTx called on the same transaction twice");
    }

    public void addEventListener(WalletEventListener listener) {
        this.addChangeEventListener(Threading.USER_THREAD, listener);
        this.addCoinsReceivedEventListener(Threading.USER_THREAD, listener);
        this.addCoinsSentEventListener(Threading.USER_THREAD, listener);
        this.addKeyChainEventListener(Threading.USER_THREAD, listener);
        this.addReorganizeEventListener(Threading.USER_THREAD, listener);
        this.addScriptChangeEventListener(Threading.USER_THREAD, listener);
        this.addTransactionConfidenceEventListener(Threading.USER_THREAD, listener);
    }

    @Deprecated
    public void addEventListener(WalletEventListener listener, Executor executor) {
        this.addCoinsReceivedEventListener(executor, listener);
        this.addCoinsSentEventListener(executor, listener);
        this.addChangeEventListener(executor, listener);
        this.addKeyChainEventListener(executor, listener);
        this.addReorganizeEventListener(executor, listener);
        this.addScriptChangeEventListener(executor, listener);
        this.addTransactionConfidenceEventListener(executor, listener);
    }

    public void addChangeEventListener(WalletChangeEventListener listener) {
        this.addChangeEventListener(Threading.USER_THREAD, listener);
    }

    public void addChangeEventListener(Executor executor, WalletChangeEventListener listener) {
        this.changeListeners.add(new ListenerRegistration<WalletChangeEventListener>(listener, executor));
    }

    public void addCoinsReceivedEventListener(WalletCoinsReceivedEventListener listener) {
        this.addCoinsReceivedEventListener(Threading.USER_THREAD, listener);
    }

    public void addCoinsReceivedEventListener(Executor executor, WalletCoinsReceivedEventListener listener) {
        this.coinsReceivedListeners.add(new ListenerRegistration<WalletCoinsReceivedEventListener>(listener, executor));
    }

    public void addCoinsSentEventListener(WalletCoinsSentEventListener listener) {
        this.addCoinsSentEventListener(Threading.USER_THREAD, listener);
    }

    public void addCoinsSentEventListener(Executor executor, WalletCoinsSentEventListener listener) {
        this.coinsSentListeners.add(new ListenerRegistration<WalletCoinsSentEventListener>(listener, executor));
    }

    public void addKeyChainEventListener(KeyChainEventListener listener) {
        this.keyChainGroup.addEventListener(listener, Threading.USER_THREAD);
    }

    public void addKeyChainEventListener(Executor executor, KeyChainEventListener listener) {
        this.keyChainGroup.addEventListener(listener, executor);
    }

    public void addReorganizeEventListener(WalletReorganizeEventListener listener) {
        this.addReorganizeEventListener(Threading.USER_THREAD, listener);
    }

    public void addReorganizeEventListener(Executor executor, WalletReorganizeEventListener listener) {
        this.reorganizeListeners.add(new ListenerRegistration<WalletReorganizeEventListener>(listener, executor));
    }

    public void addScriptsChangeEventListener(ScriptsChangeEventListener listener) {
        this.addScriptChangeEventListener(Threading.USER_THREAD, listener);
    }

    public void addScriptChangeEventListener(Executor executor, ScriptsChangeEventListener listener) {
        this.scriptChangeListeners.add(new ListenerRegistration<ScriptsChangeEventListener>(listener, executor));
    }

    public void addTransactionConfidenceEventListener(TransactionConfidenceEventListener listener) {
        this.addTransactionConfidenceEventListener(Threading.USER_THREAD, listener);
    }

    public void addTransactionConfidenceEventListener(Executor executor, TransactionConfidenceEventListener listener) {
        this.transactionConfidenceListeners.add(new ListenerRegistration<TransactionConfidenceEventListener>(listener, executor));
    }

    @Deprecated
    public boolean removeEventListener(WalletEventListener listener) {
        return this.removeChangeEventListener(listener) || this.removeCoinsReceivedEventListener(listener) || this.removeCoinsSentEventListener(listener) || this.removeKeyChainEventListener(listener) || this.removeReorganizeEventListener(listener) || this.removeTransactionConfidenceEventListener(listener);
    }

    public boolean removeChangeEventListener(WalletChangeEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.changeListeners);
    }

    public boolean removeCoinsReceivedEventListener(WalletCoinsReceivedEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.coinsReceivedListeners);
    }

    public boolean removeCoinsSentEventListener(WalletCoinsSentEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.coinsSentListeners);
    }

    public boolean removeKeyChainEventListener(KeyChainEventListener listener) {
        return this.keyChainGroup.removeEventListener(listener);
    }

    public boolean removeReorganizeEventListener(WalletReorganizeEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.reorganizeListeners);
    }

    public boolean removeScriptChangeEventListener(ScriptsChangeEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.scriptChangeListeners);
    }

    public boolean removeTransactionConfidenceEventListener(TransactionConfidenceEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.transactionConfidenceListeners);
    }

    private void queueOnTransactionConfidenceChanged(final Transaction tx) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        for (final ListenerRegistration<TransactionConfidenceEventListener> registration : this.transactionConfidenceListeners) {
            if (registration.executor == Threading.SAME_THREAD) {
                ((TransactionConfidenceEventListener)registration.listener).onTransactionConfidenceChanged(this, tx);
                continue;
            }
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((TransactionConfidenceEventListener)registration.listener).onTransactionConfidenceChanged(Wallet.this, tx);
                }
            });
        }
    }

    protected void maybeQueueOnWalletChanged() {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        Preconditions.checkState((this.onWalletChangedSuppressions >= 0 ? 1 : 0) != 0);
        if (this.onWalletChangedSuppressions > 0) {
            return;
        }
        for (final ListenerRegistration<WalletChangeEventListener> registration : this.changeListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((WalletChangeEventListener)registration.listener).onWalletChanged(Wallet.this);
                }
            });
        }
    }

    protected void queueOnCoinsReceived(final Transaction tx, final Coin balance, final Coin newBalance) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        for (final ListenerRegistration<WalletCoinsReceivedEventListener> registration : this.coinsReceivedListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((WalletCoinsReceivedEventListener)registration.listener).onCoinsReceived(Wallet.this, tx, balance, newBalance);
                }
            });
        }
    }

    protected void queueOnCoinsSent(final Transaction tx, final Coin prevBalance, final Coin newBalance) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        for (final ListenerRegistration<WalletCoinsSentEventListener> registration : this.coinsSentListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((WalletCoinsSentEventListener)registration.listener).onCoinsSent(Wallet.this, tx, prevBalance, newBalance);
                }
            });
        }
    }

    protected void queueOnReorganize() {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        Preconditions.checkState((boolean)this.insideReorg);
        for (final ListenerRegistration<WalletReorganizeEventListener> registration : this.reorganizeListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((WalletReorganizeEventListener)registration.listener).onReorganize(Wallet.this);
                }
            });
        }
    }

    protected void queueOnScriptsChanged(final List<Script> scripts, final boolean isAddingScripts) {
        for (final ListenerRegistration<ScriptsChangeEventListener> registration : this.scriptChangeListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((ScriptsChangeEventListener)registration.listener).onScriptsChanged(Wallet.this, scripts, isAddingScripts);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Transaction> getTransactions(boolean includeDead) {
        this.lock.lock();
        try {
            HashSet<Transaction> all = new HashSet<Transaction>();
            all.addAll(this.unspent.values());
            all.addAll(this.spent.values());
            all.addAll(this.pending.values());
            if (includeDead) {
                all.addAll(this.dead.values());
            }
            HashSet<Transaction> hashSet = all;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Iterable<WalletTransaction> getWalletTransactions() {
        this.lock.lock();
        try {
            HashSet<WalletTransaction> all = new HashSet<WalletTransaction>();
            Wallet.addWalletTransactionsToSet(all, WalletTransaction.Pool.UNSPENT, this.unspent.values());
            Wallet.addWalletTransactionsToSet(all, WalletTransaction.Pool.SPENT, this.spent.values());
            Wallet.addWalletTransactionsToSet(all, WalletTransaction.Pool.DEAD, this.dead.values());
            Wallet.addWalletTransactionsToSet(all, WalletTransaction.Pool.PENDING, this.pending.values());
            HashSet<WalletTransaction> hashSet = all;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static void addWalletTransactionsToSet(Set<WalletTransaction> txns, WalletTransaction.Pool poolType, Collection<Transaction> pool) {
        for (Transaction tx : pool) {
            txns.add(new WalletTransaction(poolType, tx));
        }
    }

    public void addWalletTransaction(WalletTransaction wtx) {
        this.lock.lock();
        try {
            this.addWalletTransaction(wtx.getPool(), wtx.getTransaction());
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addWalletTransaction(WalletTransaction.Pool pool, Transaction tx) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        this.transactions.put(tx.getHash(), tx);
        switch (pool) {
            case UNSPENT: {
                Preconditions.checkState((this.unspent.put(tx.getHash(), tx) == null ? 1 : 0) != 0);
                break;
            }
            case SPENT: {
                Preconditions.checkState((this.spent.put(tx.getHash(), tx) == null ? 1 : 0) != 0);
                break;
            }
            case PENDING: {
                Preconditions.checkState((this.pending.put(tx.getHash(), tx) == null ? 1 : 0) != 0);
                break;
            }
            case DEAD: {
                Preconditions.checkState((this.dead.put(tx.getHash(), tx) == null ? 1 : 0) != 0);
                break;
            }
            default: {
                throw new RuntimeException("Unknown wallet transaction type " + (Object)((Object)pool));
            }
        }
        if (pool == WalletTransaction.Pool.UNSPENT || pool == WalletTransaction.Pool.PENDING) {
            for (TransactionOutput output : tx.getOutputs()) {
                if (!output.isAvailableForSpending() || !output.isMineOrWatched(this)) continue;
                this.myUnspents.add(output);
            }
        }
        tx.getConfidence().addEventListener(Threading.SAME_THREAD, this.txConfidenceListener);
    }

    public List<Transaction> getTransactionsByTime() {
        return this.getRecentTransactions(0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Transaction> getRecentTransactions(int numTransactions, boolean includeDead) {
        this.lock.lock();
        try {
            Preconditions.checkArgument((numTransactions >= 0 ? 1 : 0) != 0);
            int size = this.unspent.size() + this.spent.size() + this.pending.size();
            if (numTransactions > size || numTransactions == 0) {
                numTransactions = size;
            }
            ArrayList<Transaction> all = new ArrayList<Transaction>(this.getTransactions(includeDead));
            Collections.sort(all, Transaction.SORT_TX_BY_UPDATE_TIME);
            if (numTransactions == all.size()) {
                ArrayList<Transaction> arrayList = all;
                return arrayList;
            }
            all.subList(numTransactions, all.size()).clear();
            ArrayList<Transaction> arrayList = all;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    public Transaction getTransaction(Sha256Hash hash) {
        this.lock.lock();
        try {
            Transaction transaction = this.transactions.get(hash);
            return transaction;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Map<Sha256Hash, Transaction> getTransactionPool(WalletTransaction.Pool pool) {
        this.lock.lock();
        try {
            switch (pool) {
                case UNSPENT: {
                    Map<Sha256Hash, Transaction> map = this.unspent;
                    return map;
                }
                case SPENT: {
                    Map<Sha256Hash, Transaction> map = this.spent;
                    return map;
                }
                case PENDING: {
                    Map<Sha256Hash, Transaction> map = this.pending;
                    return map;
                }
                case DEAD: {
                    Map<Sha256Hash, Transaction> map = this.dead;
                    return map;
                }
            }
            throw new RuntimeException("Unknown wallet transaction type " + (Object)((Object)pool));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void reset() {
        this.lock.lock();
        try {
            this.clearTransactions();
            this.lastBlockSeenHash = null;
            this.lastBlockSeenHeight = -1;
            this.lastBlockSeenTimeSecs = 0L;
            this.saveLater();
            this.maybeQueueOnWalletChanged();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearTransactions(int fromHeight) {
        block4: {
            this.lock.lock();
            try {
                if (fromHeight == 0) {
                    this.clearTransactions();
                    this.saveLater();
                    break block4;
                }
                throw new UnsupportedOperationException();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void clearTransactions() {
        this.unspent.clear();
        this.spent.clear();
        this.pending.clear();
        this.dead.clear();
        this.transactions.clear();
        this.myUnspents.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransactionOutput> getWatchedOutputs(boolean excludeImmatureCoinbases) {
        this.lock.lock();
        this.keyChainGroupLock.lock();
        try {
            LinkedList candidates = Lists.newLinkedList();
            for (Transaction tx : Iterables.concat(this.unspent.values(), this.pending.values())) {
                if (excludeImmatureCoinbases && !tx.isMature()) continue;
                for (TransactionOutput output : tx.getOutputs()) {
                    if (!output.isAvailableForSpending()) continue;
                    try {
                        Script scriptPubKey = output.getScriptPubKey();
                        if (!this.watchedScripts.contains(scriptPubKey)) continue;
                        candidates.add(output);
                    }
                    catch (ScriptException scriptException) {}
                }
            }
            LinkedList linkedList = candidates;
            return linkedList;
        }
        finally {
            this.keyChainGroupLock.unlock();
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        this.lock.lock();
        try {
            boolean dirty = false;
            Iterator<Transaction> i = this.pending.values().iterator();
            while (i.hasNext()) {
                Transaction tx = i.next();
                if (!this.isTransactionRisky(tx, null) || this.acceptRiskyTransactions) continue;
                log.debug("Found risky transaction {} in wallet during cleanup.", (Object)tx.getHashAsString());
                if (!tx.isAnyOutputSpent()) {
                    for (TransactionInput input : tx.getInputs()) {
                        TransactionOutput output = input.getConnectedOutput();
                        if (output == null) continue;
                        if (output.isMineOrWatched(this)) {
                            Preconditions.checkState((boolean)this.myUnspents.add(output));
                        }
                        input.disconnect();
                    }
                    for (TransactionOutput output : tx.getOutputs()) {
                        this.myUnspents.remove(output);
                    }
                    i.remove();
                    this.transactions.remove(tx.getHash());
                    dirty = true;
                    log.info("Removed transaction {} from pending pool during cleanup.", (Object)tx.getHashAsString());
                    continue;
                }
                log.info("Cannot remove transaction {} from pending pool during cleanup, as it's already spent partially.", (Object)tx.getHashAsString());
            }
            if (dirty) {
                this.isConsistentOrThrow();
                this.saveLater();
                if (log.isInfoEnabled()) {
                    log.info("Estimated balance is now: {}", (Object)this.getBalance(BalanceType.ESTIMATED).toFriendlyString());
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EnumSet<WalletTransaction.Pool> getContainingPools(Transaction tx) {
        this.lock.lock();
        try {
            EnumSet<WalletTransaction.Pool> result = EnumSet.noneOf(WalletTransaction.Pool.class);
            Sha256Hash txHash = tx.getHash();
            if (this.unspent.containsKey(txHash)) {
                result.add(WalletTransaction.Pool.UNSPENT);
            }
            if (this.spent.containsKey(txHash)) {
                result.add(WalletTransaction.Pool.SPENT);
            }
            if (this.pending.containsKey(txHash)) {
                result.add(WalletTransaction.Pool.PENDING);
            }
            if (this.dead.containsKey(txHash)) {
                result.add(WalletTransaction.Pool.DEAD);
            }
            EnumSet<WalletTransaction.Pool> enumSet = result;
            return enumSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    @VisibleForTesting
    public int getPoolSize(WalletTransaction.Pool pool) {
        this.lock.lock();
        try {
            switch (pool) {
                case UNSPENT: {
                    int n = this.unspent.size();
                    return n;
                }
                case SPENT: {
                    int n = this.spent.size();
                    return n;
                }
                case PENDING: {
                    int n = this.pending.size();
                    return n;
                }
                case DEAD: {
                    int n = this.dead.size();
                    return n;
                }
            }
            throw new RuntimeException("Unreachable");
        }
        finally {
            this.lock.unlock();
        }
    }

    @VisibleForTesting
    public boolean poolContainsTxHash(WalletTransaction.Pool pool, Sha256Hash txHash) {
        this.lock.lock();
        try {
            switch (pool) {
                case UNSPENT: {
                    boolean bl = this.unspent.containsKey(txHash);
                    return bl;
                }
                case SPENT: {
                    boolean bl = this.spent.containsKey(txHash);
                    return bl;
                }
                case PENDING: {
                    boolean bl = this.pending.containsKey(txHash);
                    return bl;
                }
                case DEAD: {
                    boolean bl = this.dead.containsKey(txHash);
                    return bl;
                }
            }
            throw new RuntimeException("Unreachable");
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<TransactionOutput> getUnspents() {
        this.lock.lock();
        try {
            ArrayList<TransactionOutput> arrayList = new ArrayList<TransactionOutput>(this.myUnspents);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.toString(false, true, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(boolean includePrivateKeys, boolean includeTransactions, boolean includeExtensions, @Nullable AbstractBlockChain chain) {
        this.lock.lock();
        this.keyChainGroupLock.lock();
        try {
            StringBuilder builder = new StringBuilder();
            Coin estimatedBalance = this.getBalance(BalanceType.ESTIMATED);
            Coin availableBalance = this.getBalance(BalanceType.AVAILABLE_SPENDABLE);
            builder.append("Wallet containing ").append(estimatedBalance.toFriendlyString()).append(" (spendable: ").append(availableBalance.toFriendlyString()).append(") in:\n");
            builder.append("  ").append(this.pending.size()).append(" pending transactions\n");
            builder.append("  ").append(this.unspent.size()).append(" unspent transactions\n");
            builder.append("  ").append(this.spent.size()).append(" spent transactions\n");
            builder.append("  ").append(this.dead.size()).append(" dead transactions\n");
            Date lastBlockSeenTime = this.getLastBlockSeenTime();
            builder.append("Last seen best block: ").append(this.getLastBlockSeenHeight()).append(" (").append(lastBlockSeenTime == null ? "time unknown" : Utils.dateTimeFormat(lastBlockSeenTime)).append("): ").append(this.getLastBlockSeenHash()).append('\n');
            KeyCrypter crypter = this.keyChainGroup.getKeyCrypter();
            if (crypter != null) {
                builder.append("Encryption: ").append(crypter).append('\n');
            }
            if (this.isWatching()) {
                builder.append("Wallet is watching.\n");
            }
            builder.append("\nKeys:\n");
            builder.append("Earliest creation time: ").append(Utils.dateTimeFormat(this.getEarliestKeyCreationTime() * 1000L)).append('\n');
            Date keyRotationTime = this.getKeyRotationTime();
            if (keyRotationTime != null) {
                builder.append("Key rotation time:      ").append(Utils.dateTimeFormat(keyRotationTime)).append('\n');
            }
            builder.append(this.keyChainGroup.toString(includePrivateKeys));
            if (!this.watchedScripts.isEmpty()) {
                builder.append("\nWatched scripts:\n");
                for (Script script : this.watchedScripts) {
                    builder.append("  ").append(script).append("\n");
                }
            }
            if (includeTransactions) {
                if (this.pending.size() > 0) {
                    builder.append("\n>>> PENDING:\n");
                    this.toStringHelper(builder, this.pending, chain, Transaction.SORT_TX_BY_UPDATE_TIME);
                }
                if (this.unspent.size() > 0) {
                    builder.append("\n>>> UNSPENT:\n");
                    this.toStringHelper(builder, this.unspent, chain, Transaction.SORT_TX_BY_HEIGHT);
                }
                if (this.spent.size() > 0) {
                    builder.append("\n>>> SPENT:\n");
                    this.toStringHelper(builder, this.spent, chain, Transaction.SORT_TX_BY_HEIGHT);
                }
                if (this.dead.size() > 0) {
                    builder.append("\n>>> DEAD:\n");
                    this.toStringHelper(builder, this.dead, chain, Transaction.SORT_TX_BY_UPDATE_TIME);
                }
            }
            if (includeExtensions && this.extensions.size() > 0) {
                builder.append("\n>>> EXTENSIONS:\n");
                for (WalletExtension extension : this.extensions.values()) {
                    builder.append(extension).append("\n\n");
                }
            }
            Iterator<WalletExtension> iterator = builder.toString();
            return iterator;
        }
        finally {
            this.keyChainGroupLock.unlock();
            this.lock.unlock();
        }
    }

    private void toStringHelper(StringBuilder builder, Map<Sha256Hash, Transaction> transactionMap, @Nullable AbstractBlockChain chain, @Nullable Comparator<Transaction> sortOrder) {
        Collection<Transaction> txns;
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        if (sortOrder != null) {
            txns = new TreeSet<Transaction>(sortOrder);
            txns.addAll(transactionMap.values());
        } else {
            txns = transactionMap.values();
        }
        for (Transaction tx : txns) {
            try {
                builder.append(tx.getValue(this).toFriendlyString());
                builder.append(" total value (sends ");
                builder.append(tx.getValueSentFromMe(this).toFriendlyString());
                builder.append(" and receives ");
                builder.append(tx.getValueSentToMe(this).toFriendlyString());
                builder.append(")\n");
            }
            catch (ScriptException scriptException) {
                // empty catch block
            }
            if (tx.hasConfidence()) {
                builder.append("  confidence: ").append(tx.getConfidence()).append('\n');
            }
            builder.append(tx.toString(chain));
        }
    }

    public Collection<Transaction> getPendingTransactions() {
        this.lock.lock();
        try {
            Collection<Transaction> collection = Collections.unmodifiableCollection(this.pending.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getEarliestKeyCreationTime() {
        this.keyChainGroupLock.lock();
        try {
            long earliestTime = this.keyChainGroup.getEarliestKeyCreationTime();
            for (Script script : this.watchedScripts) {
                earliestTime = Math.min(script.getCreationTimeSeconds(), earliestTime);
            }
            if (earliestTime == Long.MAX_VALUE) {
                long l = Utils.currentTimeSeconds();
                return l;
            }
            long l = earliestTime;
            return l;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    @Nullable
    public Sha256Hash getLastBlockSeenHash() {
        this.lock.lock();
        try {
            Sha256Hash sha256Hash = this.lastBlockSeenHash;
            return sha256Hash;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setLastBlockSeenHash(@Nullable Sha256Hash lastBlockSeenHash) {
        this.lock.lock();
        try {
            this.lastBlockSeenHash = lastBlockSeenHash;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setLastBlockSeenHeight(int lastBlockSeenHeight) {
        this.lock.lock();
        try {
            this.lastBlockSeenHeight = lastBlockSeenHeight;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setLastBlockSeenTimeSecs(long timeSecs) {
        this.lock.lock();
        try {
            this.lastBlockSeenTimeSecs = timeSecs;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getLastBlockSeenTimeSecs() {
        this.lock.lock();
        try {
            long l = this.lastBlockSeenTimeSecs;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    public Date getLastBlockSeenTime() {
        long secs = this.getLastBlockSeenTimeSecs();
        if (secs == 0L) {
            return null;
        }
        return new Date(secs * 1000L);
    }

    public int getLastBlockSeenHeight() {
        this.lock.lock();
        try {
            int n = this.lastBlockSeenHeight;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    @Deprecated
    public Coin getWatchedBalance() {
        return this.getBalance();
    }

    @Deprecated
    public Coin getWatchedBalance(CoinSelector selector) {
        return this.getBalance(selector);
    }

    public Coin getBalance() {
        return this.getBalance(BalanceType.AVAILABLE);
    }

    public Coin getBalance(BalanceType balanceType) {
        this.lock.lock();
        try {
            if (balanceType == BalanceType.AVAILABLE || balanceType == BalanceType.AVAILABLE_SPENDABLE) {
                List<TransactionOutput> candidates = this.calculateAllSpendCandidates(true, balanceType == BalanceType.AVAILABLE_SPENDABLE);
                CoinSelection selection = this.coinSelector.select(NetworkParameters.MAX_MONEY, candidates);
                Coin coin = selection.valueGathered;
                return coin;
            }
            if (balanceType == BalanceType.ESTIMATED || balanceType == BalanceType.ESTIMATED_SPENDABLE) {
                List<TransactionOutput> all = this.calculateAllSpendCandidates(false, balanceType == BalanceType.ESTIMATED_SPENDABLE);
                Coin value = Coin.ZERO;
                for (TransactionOutput out : all) {
                    value = value.add(out.getValue());
                }
                Coin coin = value;
                return coin;
            }
            throw new AssertionError((Object)"Unknown balance type");
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Coin getBalance(CoinSelector selector) {
        this.lock.lock();
        try {
            Preconditions.checkNotNull((Object)selector);
            List<TransactionOutput> candidates = this.calculateAllSpendCandidates(true, false);
            CoinSelection selection = selector.select(this.params.getMaxMoney(), candidates);
            Coin coin = selection.valueGathered;
            return coin;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Coin> getBalanceFuture(Coin value, BalanceType type) {
        this.lock.lock();
        try {
            SettableFuture future = SettableFuture.create();
            Coin current = this.getBalance(type);
            if (current.compareTo(value) >= 0) {
                future.set((Object)current);
            } else {
                BalanceFutureRequest req = new BalanceFutureRequest();
                req.future = future;
                req.value = value;
                req.type = type;
                this.balanceFutureRequests.add(req);
            }
            SettableFuture settableFuture = future;
            return settableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkBalanceFuturesLocked(@Nullable Coin avail) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        ListIterator<BalanceFutureRequest> it = this.balanceFutureRequests.listIterator();
        while (it.hasNext()) {
            final BalanceFutureRequest req = it.next();
            Coin val = this.getBalance(req.type);
            if (val.compareTo(req.value) < 0) continue;
            it.remove();
            final Coin v = val;
            Threading.USER_THREAD.execute(new Runnable(){

                @Override
                public void run() {
                    req.future.set((Object)v);
                }
            });
        }
    }

    public Coin getTotalReceived() {
        Coin total = Coin.ZERO;
        for (Transaction tx : this.transactions.values()) {
            Coin txTotal = Coin.ZERO;
            for (TransactionOutput output : tx.getOutputs()) {
                if (!output.isMine(this)) continue;
                txTotal = txTotal.add(output.getValue());
            }
            for (TransactionInput in : tx.getInputs()) {
                TransactionOutput prevOut = in.getConnectedOutput();
                if (prevOut == null || !prevOut.isMine(this)) continue;
                txTotal = txTotal.subtract(prevOut.getValue());
            }
            if (!txTotal.isPositive()) continue;
            total = total.add(txTotal);
        }
        return total;
    }

    public Coin getTotalSent() {
        Coin total = Coin.ZERO;
        for (Transaction tx : this.transactions.values()) {
            Coin txOutputTotal = Coin.ZERO;
            for (TransactionOutput transactionOutput : tx.getOutputs()) {
                if (transactionOutput.isMine(this)) continue;
                txOutputTotal = txOutputTotal.add(transactionOutput.getValue());
            }
            Coin txOwnedInputsTotal = Coin.ZERO;
            for (TransactionInput in : tx.getInputs()) {
                TransactionOutput prevOut = in.getConnectedOutput();
                if (prevOut == null || !prevOut.isMine(this)) continue;
                txOwnedInputsTotal = txOwnedInputsTotal.add(prevOut.getValue());
            }
            Coin coin = tx.getInputSum();
            if (txOwnedInputsTotal != coin) {
                BigInteger txOutputTotalNum = new BigInteger(txOutputTotal.toString());
                txOutputTotalNum = txOutputTotalNum.multiply(new BigInteger(txOwnedInputsTotal.toString()));
                txOutputTotalNum = txOutputTotalNum.divide(new BigInteger(coin.toString()));
                txOutputTotal = Coin.valueOf(txOutputTotalNum.longValue());
            }
            total = total.add(txOutputTotal);
        }
        return total;
    }

    public Transaction createSend(Address address, Coin value) throws InsufficientMoneyException {
        SendRequest req = SendRequest.to(address, value);
        if (this.params.getId().equals("org.bitcoinj.unittest")) {
            req.shuffleOutputs = false;
        }
        this.completeTx(req);
        return req.tx;
    }

    public Transaction sendCoinsOffline(SendRequest request) throws InsufficientMoneyException {
        this.lock.lock();
        try {
            this.completeTx(request);
            this.commitTx(request.tx);
            Transaction transaction = request.tx;
            return transaction;
        }
        finally {
            this.lock.unlock();
        }
    }

    public SendResult sendCoins(TransactionBroadcaster broadcaster, Address to, Coin value) throws InsufficientMoneyException {
        SendRequest request = SendRequest.to(to, value);
        return this.sendCoins(broadcaster, request);
    }

    public SendResult sendCoins(TransactionBroadcaster broadcaster, SendRequest request) throws InsufficientMoneyException {
        Preconditions.checkState((!this.lock.isHeldByCurrentThread() ? 1 : 0) != 0);
        Transaction tx = this.sendCoinsOffline(request);
        SendResult result = new SendResult();
        result.tx = tx;
        result.broadcast = broadcaster.broadcastTransaction(tx);
        result.broadcastComplete = result.broadcast.future();
        return result;
    }

    public SendResult sendCoins(SendRequest request) throws InsufficientMoneyException {
        TransactionBroadcaster broadcaster = this.vTransactionBroadcaster;
        Preconditions.checkState((broadcaster != null ? 1 : 0) != 0, (Object)"No transaction broadcaster is configured");
        return this.sendCoins(broadcaster, request);
    }

    public Transaction sendCoins(Peer peer, SendRequest request) throws InsufficientMoneyException {
        Transaction tx = this.sendCoinsOffline(request);
        peer.sendMessage(tx);
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeTx(SendRequest req) throws InsufficientMoneyException {
        this.lock.lock();
        try {
            int size;
            CoinSelection bestCoinSelection;
            Preconditions.checkArgument((!req.completed ? 1 : 0) != 0, (Object)"Given SendRequest has already been completed.");
            Coin value = Coin.ZERO;
            for (TransactionOutput transactionOutput : req.tx.getOutputs()) {
                value = value.add(transactionOutput.getValue());
            }
            log.info("Completing send tx with {} outputs totalling {} and a fee of {}/kB", new Object[]{req.tx.getOutputs().size(), value.toFriendlyString(), req.feePerKb.toFriendlyString()});
            Coin totalInput = Coin.ZERO;
            for (TransactionInput input : req.tx.getInputs()) {
                if (input.getConnectedOutput() != null) {
                    totalInput = totalInput.add(input.getConnectedOutput().getValue());
                    continue;
                }
                log.warn("SendRequest transaction already has inputs but we don't know how much they are worth - they will be added to fee.");
            }
            value = value.subtract(totalInput);
            ArrayList<TransactionInput> arrayList = new ArrayList<TransactionInput>(req.tx.getInputs());
            if (req.ensureMinRequiredFee && !req.emptyWallet) {
                int opReturnCount = 0;
                for (TransactionOutput output : req.tx.getOutputs()) {
                    if (output.isDust()) {
                        throw new DustySendRequested();
                    }
                    if (!output.getScriptPubKey().isOpReturn()) continue;
                    ++opReturnCount;
                }
                if (opReturnCount > 1) {
                    throw new MultipleOpReturnRequested();
                }
            }
            List<TransactionOutput> candidates = this.calculateAllSpendCandidates(true, req.missingSigsMode == MissingSigsMode.THROW);
            TransactionOutput bestChangeOutput = null;
            if (!req.emptyWallet) {
                FeeCalculation feeCalculation = this.calculateFee(req, value, arrayList, req.ensureMinRequiredFee, candidates);
                bestCoinSelection = feeCalculation.bestCoinSelection;
                bestChangeOutput = feeCalculation.bestChangeOutput;
            } else {
                Preconditions.checkState((req.tx.getOutputs().size() == 1 ? 1 : 0) != 0, (Object)"Empty wallet TX must have a single output only.");
                CoinSelector selector = req.coinSelector == null ? this.coinSelector : req.coinSelector;
                bestCoinSelection = selector.select(this.params.getMaxMoney(), candidates);
                candidates = null;
                req.tx.getOutput(0L).setValue(bestCoinSelection.valueGathered);
                log.info("  emptying {}", (Object)bestCoinSelection.valueGathered.toFriendlyString());
            }
            for (TransactionOutput output : bestCoinSelection.gathered) {
                req.tx.addInput(output);
            }
            if (req.emptyWallet) {
                Coin feePerKb;
                Coin coin = feePerKb = req.feePerKb == null ? Coin.ZERO : req.feePerKb;
                if (!this.adjustOutputDownwardsForFee(req.tx, bestCoinSelection, feePerKb, req.ensureMinRequiredFee)) {
                    throw new CouldNotAdjustDownwards();
                }
            }
            if (bestChangeOutput != null) {
                req.tx.addOutput(bestChangeOutput);
                log.info("  with {} change", (Object)bestChangeOutput.getValue().toFriendlyString());
            }
            if (req.shuffleOutputs) {
                req.tx.shuffleOutputs();
            }
            if (req.signInputs) {
                this.signTransaction(req);
            }
            if ((size = req.tx.unsafeBitcoinSerialize().length) > 100000) {
                throw new ExceededMaxTransactionSize();
            }
            req.tx.getConfidence().setSource(TransactionConfidence.Source.SELF);
            req.tx.setPurpose(Transaction.Purpose.USER_PAYMENT);
            req.tx.setExchangeRate(req.exchangeRate);
            req.tx.setMemo(req.memo);
            req.completed = true;
            log.info("  completed: {}", (Object)req.tx);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signTransaction(SendRequest req) {
        this.lock.lock();
        try {
            Transaction tx = req.tx;
            List<TransactionInput> inputs = tx.getInputs();
            List<TransactionOutput> outputs = tx.getOutputs();
            Preconditions.checkState((inputs.size() > 0 ? 1 : 0) != 0);
            Preconditions.checkState((outputs.size() > 0 ? 1 : 0) != 0);
            DecryptingKeyBag maybeDecryptingKeyBag = new DecryptingKeyBag(this, req.aesKey);
            int numInputs = tx.getInputs().size();
            for (int i = 0; i < numInputs; ++i) {
                TransactionInput txIn = tx.getInput(i);
                if (txIn.getConnectedOutput() == null) continue;
                try {
                    txIn.getScriptSig().correctlySpends(tx, i, txIn.getConnectedOutput().getScriptPubKey());
                    log.warn("Input {} already correctly spends output, assuming SIGHASH type used will be safe and skipping signing.", (Object)i);
                    continue;
                }
                catch (ScriptException e) {
                    log.debug("Input contained an incorrect signature", (Throwable)e);
                    Script scriptPubKey = txIn.getConnectedOutput().getScriptPubKey();
                    RedeemData redeemData = txIn.getConnectedRedeemData(maybeDecryptingKeyBag);
                    Preconditions.checkNotNull((Object)redeemData, (String)"Transaction exists in wallet that we cannot redeem: %s", (Object[])new Object[]{txIn.getOutpoint().getHash()});
                    txIn.setScriptSig(scriptPubKey.createEmptyInputScript(redeemData.keys.get(0), redeemData.redeemScript));
                }
            }
            TransactionSigner.ProposedTransaction proposal = new TransactionSigner.ProposedTransaction(tx);
            for (TransactionSigner signer : this.signers) {
                if (signer.signInputs(proposal, maybeDecryptingKeyBag)) continue;
                log.info("{} returned false for the tx", (Object)signer.getClass().getName());
            }
            new MissingSigResolutionSigner(req.missingSigsMode).signInputs(proposal, maybeDecryptingKeyBag);
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean adjustOutputDownwardsForFee(Transaction tx, CoinSelection coinSelection, Coin feePerKb, boolean ensureMinRequiredFee) {
        int size = tx.unsafeBitcoinSerialize().length + this.estimateBytesForSigning(coinSelection);
        Coin fee = feePerKb.multiply(size).divide(1000L);
        if (ensureMinRequiredFee && fee.compareTo(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE) < 0) {
            fee = Transaction.REFERENCE_DEFAULT_MIN_TX_FEE;
        }
        TransactionOutput output = tx.getOutput(0L);
        output.setValue(output.getValue().subtract(fee));
        return !output.isDust();
    }

    public List<TransactionOutput> calculateAllSpendCandidates() {
        return this.calculateAllSpendCandidates(true, true);
    }

    @Deprecated
    public List<TransactionOutput> calculateAllSpendCandidates(boolean excludeImmatureCoinbases) {
        return this.calculateAllSpendCandidates(excludeImmatureCoinbases, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransactionOutput> calculateAllSpendCandidates(boolean excludeImmatureCoinbases, boolean excludeUnsignable) {
        this.lock.lock();
        try {
            AbstractList candidates;
            if (this.vUTXOProvider == null) {
                candidates = new ArrayList(this.myUnspents.size());
                for (TransactionOutput output : this.myUnspents) {
                    if (excludeUnsignable && !this.canSignFor(output.getScriptPubKey())) continue;
                    Transaction transaction = (Transaction)Preconditions.checkNotNull((Object)output.getParentTransaction());
                    if (excludeImmatureCoinbases && !transaction.isMature()) continue;
                    candidates.add((TransactionOutput)output);
                }
            } else {
                candidates = this.calculateAllSpendCandidatesFromUTXOProvider(excludeImmatureCoinbases);
            }
            AbstractList abstractList = candidates;
            return abstractList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean canSignFor(Script script) {
        if (script.isSentToRawPubKey()) {
            byte[] pubkey = script.getPubKey();
            ECKey key = this.findKeyFromPubKey(pubkey);
            return key != null && (key.isEncrypted() || key.hasPrivKey());
        }
        if (script.isPayToScriptHash()) {
            RedeemData data = this.findRedeemDataFromScriptHash(script.getPubKeyHash());
            return data != null && this.canSignFor(data.redeemScript);
        }
        if (script.isSentToAddress()) {
            ECKey key = this.findKeyFromPubHash(script.getPubKeyHash());
            return key != null && (key.isEncrypted() || key.hasPrivKey());
        }
        if (script.isSentToMultiSig()) {
            for (ECKey pubkey : script.getPubKeys()) {
                ECKey key = this.findKeyFromPubKey(pubkey.getPubKey());
                if (key == null || !key.isEncrypted() && !key.hasPrivKey()) continue;
                return true;
            }
        } else if (script.isSentToCLTVPaymentChannel()) {
            byte[] sender = script.getCLTVPaymentChannelSenderPubKey();
            ECKey senderKey = this.findKeyFromPubKey(sender);
            if (senderKey != null && (senderKey.isEncrypted() || senderKey.hasPrivKey())) {
                return true;
            }
            byte[] recipient = script.getCLTVPaymentChannelRecipientPubKey();
            ECKey recipientKey = this.findKeyFromPubKey(sender);
            return recipientKey != null && (recipientKey.isEncrypted() || recipientKey.hasPrivKey());
        }
        return false;
    }

    protected LinkedList<TransactionOutput> calculateAllSpendCandidatesFromUTXOProvider(boolean excludeImmatureCoinbases) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        UTXOProvider utxoProvider = (UTXOProvider)Preconditions.checkNotNull((Object)this.vUTXOProvider, (Object)"No UTXO provider has been set");
        LinkedList candidates = Lists.newLinkedList();
        try {
            int chainHeight = utxoProvider.getChainHeadHeight();
            for (UTXO output : this.getStoredOutputsFromUTXOProvider()) {
                boolean coinbase = output.isCoinbase();
                int depth = chainHeight - output.getHeight() + 1;
                if (excludeImmatureCoinbases && coinbase && depth < this.params.getSpendableCoinbaseDepth()) continue;
                candidates.add(new FreeStandingTransactionOutput(this.params, output, chainHeight));
            }
        }
        catch (UTXOProviderException e) {
            throw new RuntimeException("UTXO provider error", e);
        }
        for (Transaction tx : this.pending.values()) {
            for (TransactionInput input : tx.getInputs()) {
                if (!input.getConnectedOutput().isMine(this)) continue;
                candidates.remove(input.getConnectedOutput());
            }
            if (excludeImmatureCoinbases && !tx.isMature()) continue;
            for (TransactionOutput output : tx.getOutputs()) {
                if (!output.isAvailableForSpending() || !output.isMine(this)) continue;
                candidates.add(output);
            }
        }
        return candidates;
    }

    protected List<UTXO> getStoredOutputsFromUTXOProvider() throws UTXOProviderException {
        UTXOProvider utxoProvider = (UTXOProvider)Preconditions.checkNotNull((Object)this.vUTXOProvider, (Object)"No UTXO provider has been set");
        ArrayList<UTXO> candidates = new ArrayList<UTXO>();
        List<ECKey> keys = this.getImportedKeys();
        keys.addAll(this.getActiveKeyChain().getLeafKeys());
        ArrayList<Address> addresses = new ArrayList<Address>();
        for (ECKey key : keys) {
            Address address = new Address(this.params, key.getPubKeyHash());
            addresses.add(address);
        }
        candidates.addAll(utxoProvider.getOpenTransactionOutputs(addresses));
        return candidates;
    }

    public CoinSelector getCoinSelector() {
        this.lock.lock();
        try {
            CoinSelector coinSelector = this.coinSelector;
            return coinSelector;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setCoinSelector(CoinSelector coinSelector) {
        this.lock.lock();
        try {
            this.coinSelector = (CoinSelector)Preconditions.checkNotNull((Object)coinSelector);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void allowSpendingUnconfirmedTransactions() {
        this.setCoinSelector(AllowUnconfirmedCoinSelector.get());
    }

    @Nullable
    public UTXOProvider getUTXOProvider() {
        this.lock.lock();
        try {
            UTXOProvider uTXOProvider = this.vUTXOProvider;
            return uTXOProvider;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUTXOProvider(@Nullable UTXOProvider provider) {
        this.lock.lock();
        try {
            Preconditions.checkArgument((provider == null || provider.getParams().equals(this.params) ? 1 : 0) != 0);
            this.vUTXOProvider = provider;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reorganize(StoredBlock splitPoint, List<StoredBlock> oldBlocks, List<StoredBlock> newBlocks) throws VerificationException {
        this.lock.lock();
        try {
            Preconditions.checkState((this.confidenceChanged.size() == 0 ? 1 : 0) != 0);
            Preconditions.checkState((!this.insideReorg ? 1 : 0) != 0);
            this.insideReorg = true;
            Preconditions.checkState((this.onWalletChangedSuppressions == 0 ? 1 : 0) != 0);
            ++this.onWalletChangedSuppressions;
            ArrayListMultimap mapBlockTx = ArrayListMultimap.create();
            for (Transaction tx : this.getTransactions(true)) {
                Map<Sha256Hash, Integer> map = tx.getAppearsInHashes();
                if (map == null) continue;
                for (Map.Entry<Sha256Hash, Integer> entry : map.entrySet()) {
                    mapBlockTx.put((Object)entry.getKey(), (Object)new TxOffsetPair(tx, entry.getValue()));
                }
            }
            for (Iterator<StoredBlock> blockHash : mapBlockTx.keySet()) {
                Collections.sort(mapBlockTx.get((Object)blockHash));
            }
            ArrayList<Sha256Hash> oldBlockHashes = new ArrayList<Sha256Hash>(oldBlocks.size());
            log.info("Old part of chain (top to bottom):");
            for (StoredBlock storedBlock : oldBlocks) {
                log.info("  {}", (Object)storedBlock.getHeader().getHashAsString());
                oldBlockHashes.add(storedBlock.getHeader().getHash());
            }
            log.info("New part of chain (top to bottom):");
            for (StoredBlock storedBlock : newBlocks) {
                log.info("  {}", (Object)storedBlock.getHeader().getHashAsString());
            }
            Collections.reverse(newBlocks);
            LinkedList oldChainTxns = Lists.newLinkedList();
            for (Sha256Hash blockHash : oldBlockHashes) {
                for (TxOffsetPair pair : mapBlockTx.get((Object)blockHash)) {
                    Transaction tx = pair.tx;
                    Sha256Hash txHash = tx.getHash();
                    if (tx.isCoinBase()) {
                        log.warn("Coinbase killed by re-org: {}", (Object)tx.getHashAsString());
                        this.killTxns((Set<Transaction>)ImmutableSet.of((Object)tx), null);
                        continue;
                    }
                    for (TransactionOutput output : tx.getOutputs()) {
                        TransactionInput input = output.getSpentBy();
                        if (input == null) continue;
                        if (output.isMineOrWatched(this)) {
                            Preconditions.checkState((boolean)this.myUnspents.add(output));
                        }
                        input.disconnect();
                    }
                    oldChainTxns.add(tx);
                    this.unspent.remove(txHash);
                    this.spent.remove(txHash);
                    Preconditions.checkState((!this.pending.containsKey(txHash) ? 1 : 0) != 0);
                    Preconditions.checkState((!this.dead.containsKey(txHash) ? 1 : 0) != 0);
                }
            }
            for (Object tx : oldChainTxns) {
                if (((Transaction)tx).isCoinBase()) continue;
                log.info("  ->pending {}", (Object)((Transaction)tx).getHash());
                ((Transaction)tx).getConfidence().setConfidenceType(TransactionConfidence.ConfidenceType.PENDING);
                this.confidenceChanged.put((Transaction)tx, TransactionConfidence.Listener.ChangeReason.TYPE);
                this.addWalletTransaction(WalletTransaction.Pool.PENDING, (Transaction)tx);
                this.updateForSpends((Transaction)tx, false);
            }
            int n = oldBlocks.size();
            log.info("depthToSubtract = " + n);
            this.subtractDepth(n, this.spent.values());
            this.subtractDepth(n, this.unspent.values());
            this.subtractDepth(n, this.dead.values());
            this.setLastBlockSeenHash(splitPoint.getHeader().getHash());
            for (StoredBlock storedBlock : newBlocks) {
                log.info("Replaying block {}", (Object)storedBlock.getHeader().getHashAsString());
                for (TxOffsetPair pair : mapBlockTx.get((Object)storedBlock.getHeader().getHash())) {
                    log.info("  tx {}", (Object)pair.tx.getHash());
                    try {
                        this.receive(pair.tx, storedBlock, AbstractBlockChain.NewBlockType.BEST_CHAIN, pair.offset);
                    }
                    catch (ScriptException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.notifyNewBestBlock(storedBlock);
            }
            this.isConsistentOrThrow();
            Coin balance = this.getBalance();
            log.info("post-reorg balance is {}", (Object)balance.toFriendlyString());
            this.queueOnReorganize();
            this.insideReorg = false;
            --this.onWalletChangedSuppressions;
            this.maybeQueueOnWalletChanged();
            this.checkBalanceFuturesLocked(balance);
            this.informConfidenceListenersIfNotReorganizing();
            this.saveLater();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void subtractDepth(int depthToSubtract, Collection<Transaction> transactions) {
        for (Transaction tx : transactions) {
            if (tx.getConfidence().getConfidenceType() != TransactionConfidence.ConfidenceType.BUILDING) continue;
            tx.getConfidence().setDepthInBlocks(tx.getConfidence().getDepthInBlocks() - depthToSubtract);
            this.confidenceChanged.put(tx, TransactionConfidence.Listener.ChangeReason.DEPTH);
        }
    }

    @Override
    public void beginBloomFilterCalculation() {
        if (this.bloomFilterGuard.incrementAndGet() > 1) {
            return;
        }
        this.lock.lock();
        this.keyChainGroupLock.lock();
        this.calcBloomOutPointsLocked();
    }

    private void calcBloomOutPointsLocked() {
        this.bloomOutPoints.clear();
        HashSet<Transaction> all = new HashSet<Transaction>();
        all.addAll(this.unspent.values());
        all.addAll(this.spent.values());
        all.addAll(this.pending.values());
        for (Transaction tx : all) {
            for (TransactionOutput out : tx.getOutputs()) {
                try {
                    if (!this.isTxOutputBloomFilterable(out)) continue;
                    this.bloomOutPoints.add(out.getOutPointFor());
                }
                catch (ScriptException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    @GuardedBy(value="keyChainGroupLock")
    public void endBloomFilterCalculation() {
        if (this.bloomFilterGuard.decrementAndGet() > 0) {
            return;
        }
        this.bloomOutPoints.clear();
        this.keyChainGroupLock.unlock();
        this.lock.unlock();
    }

    @Override
    public int getBloomFilterElementCount() {
        this.beginBloomFilterCalculation();
        try {
            int size = this.bloomOutPoints.size();
            size += this.keyChainGroup.getBloomFilterElementCount();
            int n = size += this.watchedScripts.size();
            return n;
        }
        finally {
            this.endBloomFilterCalculation();
        }
    }

    @Override
    public boolean isRequiringUpdateAllBloomFilter() {
        this.keyChainGroupLock.lock();
        try {
            boolean bl = !this.watchedScripts.isEmpty();
            return bl;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BloomFilter getBloomFilter(double falsePositiveRate) {
        this.beginBloomFilterCalculation();
        try {
            BloomFilter bloomFilter = this.getBloomFilter(this.getBloomFilterElementCount(), falsePositiveRate, (long)(Math.random() * 9.223372036854776E18));
            return bloomFilter;
        }
        finally {
            this.endBloomFilterCalculation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="keyChainGroupLock")
    public BloomFilter getBloomFilter(int size, double falsePositiveRate, long nTweak) {
        this.beginBloomFilterCalculation();
        try {
            BloomFilter filter = this.keyChainGroup.getBloomFilter(size, falsePositiveRate, nTweak);
            for (Script script : this.watchedScripts) {
                for (ScriptChunk chunk : script.getChunks()) {
                    if (chunk.isOpCode() || chunk.data.length < 8) continue;
                    filter.insert(chunk.data);
                }
            }
            for (TransactionOutPoint point : this.bloomOutPoints) {
                filter.insert(point.unsafeBitcoinSerialize());
            }
            BloomFilter bloomFilter = filter;
            return bloomFilter;
        }
        finally {
            this.endBloomFilterCalculation();
        }
    }

    private boolean isTxOutputBloomFilterable(TransactionOutput out) {
        Script script = out.getScriptPubKey();
        boolean isScriptTypeSupported = script.isSentToRawPubKey() || script.isPayToScriptHash();
        return isScriptTypeSupported && this.myUnspents.contains(out) || this.watchedScripts.contains(script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForFilterExhaustion(FilteredBlock block) {
        this.keyChainGroupLock.lock();
        try {
            int epoch = this.keyChainGroup.getCombinedKeyLookaheadEpochs();
            for (Transaction tx : block.getAssociatedTransactions().values()) {
                this.markKeysAsUsed(tx);
            }
            int newEpoch = this.keyChainGroup.getCombinedKeyLookaheadEpochs();
            Preconditions.checkState((newEpoch >= epoch ? 1 : 0) != 0);
            boolean bl = newEpoch > epoch;
            return bl;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public void addExtension(WalletExtension extension) {
        String id = ((WalletExtension)Preconditions.checkNotNull((Object)extension)).getWalletExtensionID();
        this.lock.lock();
        try {
            if (this.extensions.containsKey(id)) {
                throw new IllegalStateException("Cannot add two extensions with the same ID: " + id);
            }
            this.extensions.put(id, extension);
            this.saveNow();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WalletExtension addOrGetExistingExtension(WalletExtension extension) {
        String id = ((WalletExtension)Preconditions.checkNotNull((Object)extension)).getWalletExtensionID();
        this.lock.lock();
        try {
            WalletExtension previousExtension = this.extensions.get(id);
            if (previousExtension != null) {
                WalletExtension walletExtension = previousExtension;
                return walletExtension;
            }
            this.extensions.put(id, extension);
            this.saveNow();
            WalletExtension walletExtension = extension;
            return walletExtension;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addOrUpdateExtension(WalletExtension extension) {
        String id = ((WalletExtension)Preconditions.checkNotNull((Object)extension)).getWalletExtensionID();
        this.lock.lock();
        try {
            this.extensions.put(id, extension);
            this.saveNow();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Map<String, WalletExtension> getExtensions() {
        this.lock.lock();
        try {
            ImmutableMap immutableMap = ImmutableMap.copyOf(this.extensions);
            return immutableMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserializeExtension(WalletExtension extension, byte[] data) throws Exception {
        this.lock.lock();
        this.keyChainGroupLock.lock();
        try {
            extension.deserializeWalletExtension(this, data);
            this.extensions.put(extension.getWalletExtensionID(), extension);
        }
        catch (Throwable throwable) {
            log.error("Error during extension deserialization", throwable);
            this.extensions.remove(extension.getWalletExtensionID());
            Throwables.propagate((Throwable)throwable);
        }
        finally {
            this.keyChainGroupLock.unlock();
            this.lock.unlock();
        }
    }

    @Override
    public void setTag(String tag, ByteString value) {
        super.setTag(tag, value);
        this.saveNow();
    }

    public FeeCalculation calculateFee(SendRequest req, Coin value, List<TransactionInput> originalInputs, boolean needAtLeastReferenceFee, List<TransactionOutput> candidates) throws InsufficientMoneyException {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        Coin additionalValueForNextCategory = null;
        CoinSelection selection3 = null;
        CoinSelection selection2 = null;
        TransactionOutput selection2Change = null;
        CoinSelection selection1 = null;
        TransactionOutput selection1Change = null;
        int lastCalculatedSize = 0;
        Coin valueMissing = null;
        while (true) {
            this.resetTxInputs(req, originalInputs);
            Coin fees = req.feePerKb.multiply(lastCalculatedSize).divide(1000L);
            if (needAtLeastReferenceFee && fees.compareTo(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE) < 0) {
                fees = Transaction.REFERENCE_DEFAULT_MIN_TX_FEE;
            }
            Coin valueNeeded = value.add(fees);
            if (additionalValueForNextCategory != null) {
                valueNeeded = valueNeeded.add(additionalValueForNextCategory);
            }
            Coin additionalValueSelected = additionalValueForNextCategory;
            CoinSelector selector = req.coinSelector == null ? this.coinSelector : req.coinSelector;
            CoinSelection selection = selector.select(valueNeeded, new LinkedList<TransactionOutput>(candidates));
            if (selection.valueGathered.compareTo(valueNeeded) < 0) {
                valueMissing = valueNeeded.subtract(selection.valueGathered);
                break;
            }
            Preconditions.checkState((selection.gathered.size() > 0 || originalInputs.size() > 0 ? 1 : 0) != 0);
            boolean eitherCategory2Or3 = false;
            boolean isCategory3 = false;
            Coin change = selection.valueGathered.subtract(valueNeeded);
            if (additionalValueSelected != null) {
                change = change.add(additionalValueSelected);
            }
            if (req.ensureMinRequiredFee && !change.equals(Coin.ZERO) && change.compareTo(Coin.CENT) < 0 && fees.compareTo(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE) < 0) {
                eitherCategory2Or3 = true;
                additionalValueForNextCategory = Coin.CENT;
                change = change.subtract(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE.subtract(fees));
            }
            int size = 0;
            TransactionOutput changeOutput = null;
            if (change.signum() > 0) {
                Address changeAddress = req.changeAddress;
                if (changeAddress == null) {
                    changeAddress = this.currentChangeAddress();
                }
                changeOutput = new TransactionOutput(this.params, req.tx, change, changeAddress);
                if (req.ensureMinRequiredFee && changeOutput.isDust()) {
                    isCategory3 = true;
                    additionalValueForNextCategory = Transaction.REFERENCE_DEFAULT_MIN_TX_FEE.add(changeOutput.getMinNonDustValue().add(Coin.SATOSHI));
                } else {
                    size += changeOutput.unsafeBitcoinSerialize().length + VarInt.sizeOf(req.tx.getOutputs().size()) - VarInt.sizeOf(req.tx.getOutputs().size() - 1);
                    if (!eitherCategory2Or3) {
                        additionalValueForNextCategory = null;
                    }
                }
            } else if (eitherCategory2Or3) {
                isCategory3 = true;
                additionalValueForNextCategory = Transaction.REFERENCE_DEFAULT_MIN_TX_FEE.add(Coin.SATOSHI);
            }
            for (TransactionOutput output : selection.gathered) {
                TransactionInput input = req.tx.addInput(output);
                Preconditions.checkState((input.getScriptBytes().length == 0 ? 1 : 0) != 0);
            }
            size += req.tx.unsafeBitcoinSerialize().length;
            if ((size += this.estimateBytesForSigning(selection)) > lastCalculatedSize && req.feePerKb.signum() > 0) {
                lastCalculatedSize = size;
                additionalValueForNextCategory = additionalValueSelected;
                continue;
            }
            if (isCategory3) {
                if (selection3 == null) {
                    selection3 = selection;
                }
            } else if (eitherCategory2Or3) {
                Preconditions.checkState((selection2 == null ? 1 : 0) != 0);
                Preconditions.checkState((boolean)additionalValueForNextCategory.equals(Coin.CENT));
                selection2 = selection;
                selection2Change = (TransactionOutput)Preconditions.checkNotNull((Object)changeOutput);
            } else {
                Preconditions.checkState((selection1 == null ? 1 : 0) != 0);
                Preconditions.checkState((additionalValueForNextCategory == null ? 1 : 0) != 0);
                selection1 = selection;
                selection1Change = changeOutput;
            }
            if (additionalValueForNextCategory == null) break;
            if (additionalValueSelected == null) continue;
            Preconditions.checkState((additionalValueForNextCategory.compareTo(additionalValueSelected) > 0 ? 1 : 0) != 0);
        }
        this.resetTxInputs(req, originalInputs);
        if (selection3 == null && selection2 == null && selection1 == null) {
            Preconditions.checkNotNull((Object)valueMissing);
            log.warn("Insufficient value in wallet for send: needed {} more", (Object)valueMissing.toFriendlyString());
            throw new InsufficientMoneyException(valueMissing);
        }
        Coin lowestFee = null;
        FeeCalculation result = new FeeCalculation();
        if (selection1 != null) {
            lowestFee = selection1Change != null ? selection1.valueGathered.subtract(selection1Change.getValue()) : selection1.valueGathered;
            result.bestCoinSelection = selection1;
            result.bestChangeOutput = selection1Change;
        }
        if (selection2 != null) {
            Coin fee = selection2.valueGathered.subtract(((TransactionOutput)Preconditions.checkNotNull(selection2Change)).getValue());
            if (lowestFee == null || fee.compareTo(lowestFee) < 0) {
                lowestFee = fee;
                result.bestCoinSelection = selection2;
                result.bestChangeOutput = selection2Change;
            }
        }
        if (selection3 != null && (lowestFee == null || selection3.valueGathered.compareTo(lowestFee) < 0)) {
            result.bestCoinSelection = selection3;
            result.bestChangeOutput = null;
        }
        return result;
    }

    private void resetTxInputs(SendRequest req, List<TransactionInput> originalInputs) {
        req.tx.clearInputs();
        for (TransactionInput input : originalInputs) {
            req.tx.addInput(input);
        }
    }

    private int estimateBytesForSigning(CoinSelection selection) {
        int size = 0;
        for (TransactionOutput output : selection.gathered) {
            try {
                Script script = output.getScriptPubKey();
                ECKey key = null;
                Script redeemScript = null;
                if (script.isSentToAddress()) {
                    key = this.findKeyFromPubHash(script.getPubKeyHash());
                    Preconditions.checkNotNull((Object)key, (Object)"Coin selection includes unspendable outputs");
                } else if (script.isPayToScriptHash()) {
                    redeemScript = this.findRedeemDataFromScriptHash((byte[])script.getPubKeyHash()).redeemScript;
                    Preconditions.checkNotNull((Object)redeemScript, (Object)"Coin selection includes unspendable outputs");
                }
                size += script.getNumberOfBytesRequiredToSpend(key, redeemScript);
            }
            catch (ScriptException e) {
                throw new IllegalStateException(e);
            }
        }
        return size;
    }

    public void setTransactionBroadcaster(@Nullable TransactionBroadcaster broadcaster) {
        Transaction[] toBroadcast = new Transaction[]{};
        this.lock.lock();
        try {
            if (this.vTransactionBroadcaster == broadcaster) {
                return;
            }
            this.vTransactionBroadcaster = broadcaster;
            if (broadcaster == null) {
                return;
            }
            toBroadcast = this.pending.values().toArray(toBroadcast);
        }
        finally {
            this.lock.unlock();
        }
        for (Transaction tx : toBroadcast) {
            TransactionConfidence.ConfidenceType confidenceType = tx.getConfidence().getConfidenceType();
            Preconditions.checkState((confidenceType == TransactionConfidence.ConfidenceType.PENDING || confidenceType == TransactionConfidence.ConfidenceType.IN_CONFLICT ? 1 : 0) != 0, (String)"Expected PENDING or IN_CONFLICT, was %s.", (Object[])new Object[]{confidenceType});
            log.info("New broadcaster so uploading waiting tx {}", (Object)tx.getHash());
            broadcaster.broadcastTransaction(tx);
        }
    }

    public void setKeyRotationTime(Date time) {
        this.setKeyRotationTime(time.getTime() / 1000L);
    }

    @Nullable
    public Date getKeyRotationTime() {
        long keyRotationTimestamp = this.vKeyRotationTimestamp;
        if (keyRotationTimestamp != 0L) {
            return new Date(keyRotationTimestamp * 1000L);
        }
        return null;
    }

    public void setKeyRotationTime(long unixTimeSeconds) {
        Preconditions.checkArgument((unixTimeSeconds <= Utils.currentTimeSeconds() ? 1 : 0) != 0, (String)"Given time (%s) cannot be in the future.", (Object[])new Object[]{Utils.dateTimeFormat(unixTimeSeconds * 1000L)});
        this.vKeyRotationTimestamp = unixTimeSeconds;
        this.saveNow();
    }

    public boolean isKeyRotating(ECKey key) {
        long time = this.vKeyRotationTimestamp;
        return time != 0L && key.getCreationTimeSeconds() < time;
    }

    @Deprecated
    public ListenableFuture<List<Transaction>> maybeDoMaintenance(@Nullable KeyParameter aesKey, boolean andSend) throws DeterministicUpgradeRequiresPassword {
        return this.doMaintenance(aesKey, andSend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<List<Transaction>> doMaintenance(@Nullable KeyParameter aesKey, boolean signAndSend) throws DeterministicUpgradeRequiresPassword {
        List<Transaction> txns;
        this.lock.lock();
        this.keyChainGroupLock.lock();
        try {
            txns = this.maybeRotateKeys(aesKey, signAndSend);
            if (!signAndSend) {
                ListenableFuture listenableFuture = Futures.immediateFuture(txns);
                return listenableFuture;
            }
        }
        finally {
            this.keyChainGroupLock.unlock();
            this.lock.unlock();
        }
        Preconditions.checkState((!this.lock.isHeldByCurrentThread() ? 1 : 0) != 0);
        ArrayList<ListenableFuture<Transaction>> futures = new ArrayList<ListenableFuture<Transaction>>(txns.size());
        TransactionBroadcaster broadcaster = this.vTransactionBroadcaster;
        for (Transaction tx : txns) {
            try {
                ListenableFuture<Transaction> future = broadcaster.broadcastTransaction(tx).future();
                futures.add(future);
                Futures.addCallback(future, (FutureCallback)new FutureCallback<Transaction>(){

                    public void onSuccess(Transaction transaction) {
                        log.info("Successfully broadcast key rotation tx: {}", (Object)transaction);
                    }

                    public void onFailure(Throwable throwable) {
                        log.error("Failed to broadcast key rotation tx", throwable);
                    }
                });
            }
            catch (Exception e) {
                log.error("Failed to broadcast rekey tx", (Throwable)e);
            }
        }
        return Futures.allAsList(futures);
    }

    @GuardedBy(value="keyChainGroupLock")
    private List<Transaction> maybeRotateKeys(@Nullable KeyParameter aesKey, boolean sign) throws DeterministicUpgradeRequiresPassword {
        Transaction tx;
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        Preconditions.checkState((boolean)this.keyChainGroupLock.isHeldByCurrentThread());
        LinkedList results = Lists.newLinkedList();
        long keyRotationTimestamp = this.vKeyRotationTimestamp;
        if (keyRotationTimestamp == 0L) {
            return results;
        }
        boolean allChainsRotating = true;
        for (DeterministicKeyChain chain : this.keyChainGroup.getDeterministicKeyChains()) {
            if (chain.getEarliestKeyCreationTime() < keyRotationTimestamp) continue;
            allChainsRotating = false;
            break;
        }
        if (allChainsRotating) {
            try {
                if (this.keyChainGroup.getImportedKeys().isEmpty()) {
                    log.info("All HD chains are currently rotating and we have no random keys, creating fresh HD chain ...");
                    this.keyChainGroup.createAndActivateNewHDChain();
                } else {
                    log.info("All HD chains are currently rotating, attempting to create a new one from the next oldest non-rotating key material ...");
                    this.keyChainGroup.upgradeToDeterministic(keyRotationTimestamp, aesKey);
                    log.info(" ... upgraded to HD again, based on next best oldest key.");
                }
            }
            catch (AllRandomKeysRotating rotating) {
                log.info(" ... no non-rotating random keys available, generating entirely new HD tree: backup required after this.");
                this.keyChainGroup.createAndActivateNewHDChain();
            }
            this.saveNow();
        }
        do {
            if ((tx = this.rekeyOneBatch(keyRotationTimestamp, aesKey, results, sign)) == null) continue;
            results.add(tx);
        } while (tx != null && tx.getInputs().size() == 600);
        return results;
    }

    @Nullable
    private Transaction rekeyOneBatch(long timeSecs, @Nullable KeyParameter aesKey, List<Transaction> others, boolean sign) {
        this.lock.lock();
        try {
            KeyTimeCoinSelector keyTimeSelector = new KeyTimeCoinSelector(this, timeSecs, true);
            FilteringCoinSelector selector = new FilteringCoinSelector(keyTimeSelector);
            for (Transaction other : others) {
                selector.excludeOutputsSpentBy(other);
            }
            CoinSelection toMove = selector.select(Coin.ZERO, this.calculateAllSpendCandidates());
            if (toMove.valueGathered.equals(Coin.ZERO)) {
                Transaction other;
                other = null;
                return other;
            }
            this.maybeUpgradeToHD(aesKey);
            Transaction rekeyTx = new Transaction(this.params);
            for (TransactionOutput output : toMove.gathered) {
                rekeyTx.addInput(output);
            }
            rekeyTx.addOutput(toMove.valueGathered, sign ? this.freshReceiveAddress() : this.currentReceiveAddress());
            if (!this.adjustOutputDownwardsForFee(rekeyTx, toMove, Transaction.DEFAULT_TX_FEE, true)) {
                log.error("Failed to adjust rekey tx for fees.");
                Iterator<TransactionOutput> iterator = null;
                return iterator;
            }
            rekeyTx.getConfidence().setSource(TransactionConfidence.Source.SELF);
            rekeyTx.setPurpose(Transaction.Purpose.KEY_ROTATION);
            SendRequest req = SendRequest.forTx(rekeyTx);
            req.aesKey = aesKey;
            if (sign) {
                this.signTransaction(req);
            }
            Preconditions.checkState((rekeyTx.unsafeBitcoinSerialize().length < 100000 ? 1 : 0) != 0);
            Transaction transaction = rekeyTx;
            return transaction;
        }
        catch (VerificationException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class FeeCalculation {
        public CoinSelection bestCoinSelection;
        public TransactionOutput bestChangeOutput;

        private FeeCalculation() {
        }
    }

    private static class TxOffsetPair
    implements Comparable<TxOffsetPair> {
        public final Transaction tx;
        public final int offset;

        public TxOffsetPair(Transaction tx, int offset) {
            this.tx = tx;
            this.offset = offset;
        }

        @Override
        public int compareTo(TxOffsetPair o) {
            return Ints.compare((int)this.offset, (int)o.offset);
        }
    }

    private class FreeStandingTransactionOutput
    extends TransactionOutput {
        private UTXO output;
        private int chainHeight;

        public FreeStandingTransactionOutput(NetworkParameters params, UTXO output, int chainHeight) {
            super(params, null, output.getValue(), output.getScript().getProgram());
            this.output = output;
            this.chainHeight = chainHeight;
        }

        public UTXO getUTXO() {
            return this.output;
        }

        @Override
        public int getParentTransactionDepthInBlocks() {
            return this.chainHeight - this.output.getHeight() + 1;
        }

        @Override
        public int getIndex() {
            return (int)this.output.getIndex();
        }

        @Override
        public Sha256Hash getParentTransactionHash() {
            return this.output.getHash();
        }
    }

    public static class ExceededMaxTransactionSize
    extends CompletionException {
    }

    public static class CouldNotAdjustDownwards
    extends CompletionException {
    }

    public static class MultipleOpReturnRequested
    extends CompletionException {
    }

    public static class DustySendRequested
    extends CompletionException {
    }

    public static class CompletionException
    extends RuntimeException {
    }

    public static enum MissingSigsMode {
        USE_OP_ZERO,
        USE_DUMMY_SIG,
        THROW;

    }

    public static class SendResult {
        public Transaction tx;
        public ListenableFuture<Transaction> broadcastComplete;
        public TransactionBroadcast broadcast;
    }

    private static class BalanceFutureRequest {
        public SettableFuture<Coin> future;
        public Coin value;
        public BalanceType type;

        private BalanceFutureRequest() {
        }
    }

    public static enum BalanceType {
        ESTIMATED,
        AVAILABLE,
        ESTIMATED_SPENDABLE,
        AVAILABLE_SPENDABLE;

    }
}

