/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.annotation.Nullable;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PrunedException;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.StoredUndoableBlock;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.TransactionOutputChanges;
import org.bitcoinj.core.UTXO;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.script.Script;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.store.FullPrunedBlockStore;
import org.bitcoinj.utils.ContextPropagatingThreadFactory;
import org.bitcoinj.wallet.Wallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullPrunedBlockChain
extends AbstractBlockChain {
    private static final Logger log = LoggerFactory.getLogger(FullPrunedBlockChain.class);
    protected final FullPrunedBlockStore blockStore;
    private boolean runScripts = true;
    ExecutorService scriptVerificationExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ContextPropagatingThreadFactory("Script verification"));

    public FullPrunedBlockChain(Context context, Wallet wallet, FullPrunedBlockStore blockStore) throws BlockStoreException {
        this(context, new ArrayList<Wallet>(), blockStore);
        this.addWallet(wallet);
    }

    public FullPrunedBlockChain(NetworkParameters params, Wallet wallet, FullPrunedBlockStore blockStore) throws BlockStoreException {
        this(Context.getOrCreate(params), wallet, blockStore);
    }

    public FullPrunedBlockChain(Context context, FullPrunedBlockStore blockStore) throws BlockStoreException {
        this(context, new ArrayList<Wallet>(), blockStore);
    }

    public FullPrunedBlockChain(NetworkParameters params, FullPrunedBlockStore blockStore) throws BlockStoreException {
        this(Context.getOrCreate(params), blockStore);
    }

    public FullPrunedBlockChain(Context context, List<Wallet> listeners, FullPrunedBlockStore blockStore) throws BlockStoreException {
        super(context, listeners, (BlockStore)blockStore);
        this.blockStore = blockStore;
        this.chainHead = blockStore.getVerifiedChainHead();
    }

    public FullPrunedBlockChain(NetworkParameters params, List<Wallet> listeners, FullPrunedBlockStore blockStore) throws BlockStoreException {
        this(Context.getOrCreate(params), listeners, blockStore);
    }

    @Override
    protected StoredBlock addToBlockStore(StoredBlock storedPrev, Block header, TransactionOutputChanges txOutChanges) throws BlockStoreException, VerificationException {
        StoredBlock newBlock = storedPrev.build(header);
        this.blockStore.put(newBlock, new StoredUndoableBlock(newBlock.getHeader().getHash(), txOutChanges));
        return newBlock;
    }

    @Override
    protected StoredBlock addToBlockStore(StoredBlock storedPrev, Block block) throws BlockStoreException, VerificationException {
        StoredBlock newBlock = storedPrev.build(block);
        this.blockStore.put(newBlock, new StoredUndoableBlock(newBlock.getHeader().getHash(), block.transactions));
        return newBlock;
    }

    @Override
    protected void rollbackBlockStore(int height) throws BlockStoreException {
        throw new BlockStoreException("Unsupported");
    }

    @Override
    protected boolean shouldVerifyTransactions() {
        return true;
    }

    public void setRunScripts(boolean value) {
        this.runScripts = value;
    }

    private Script getScript(byte[] scriptBytes) {
        try {
            return new Script(scriptBytes);
        }
        catch (Exception e) {
            return new Script(new byte[0]);
        }
    }

    private String getScriptAddress(@Nullable Script script) {
        String address = "";
        try {
            if (script != null) {
                address = script.getToAddress(this.params, true).toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return address;
    }

    @Override
    protected TransactionOutputChanges connectTransactions(int height, Block block) throws VerificationException, BlockStoreException {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        if (block.transactions == null) {
            throw new RuntimeException("connectTransactions called with Block that didn't have transactions!");
        }
        if (!this.params.passesCheckpoint(height, block.getHash())) {
            throw new VerificationException("Block failed checkpoint lockin at " + height);
        }
        this.blockStore.beginDatabaseBatchWrite();
        LinkedList<UTXO> txOutsSpent = new LinkedList<UTXO>();
        LinkedList<UTXO> txOutsCreated = new LinkedList<UTXO>();
        long sigOps = 0L;
        if (this.scriptVerificationExecutor.isShutdown()) {
            this.scriptVerificationExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        }
        ArrayList<FutureTask<VerificationException>> listScriptVerificationResults = new ArrayList<FutureTask<VerificationException>>(block.transactions.size());
        try {
            if (!this.params.isCheckpoint(height)) {
                for (Transaction tx : block.transactions) {
                    EnumSet<Script.VerifyFlag> verifyFlags = this.params.getTransactionVerificationFlags(block, tx, this.getVersionTally(), height);
                    Sha256Hash sha256Hash = tx.getHash();
                    if (this.blockStore.hasUnspentOutputs(sha256Hash, tx.getOutputs().size())) {
                        throw new VerificationException("Block failed BIP30 test!");
                    }
                    if (!verifyFlags.contains((Object)Script.VerifyFlag.P2SH)) continue;
                    sigOps += (long)tx.getSigOpCount();
                }
            }
            Coin totalFees = Coin.ZERO;
            Coin coinbaseValue = null;
            for (Transaction transaction : block.transactions) {
                boolean isCoinBase = transaction.isCoinBase();
                Coin valueIn = Coin.ZERO;
                Coin valueOut = Coin.ZERO;
                LinkedList<Script> prevOutScripts = new LinkedList<Script>();
                EnumSet<Script.VerifyFlag> verifyFlags = this.params.getTransactionVerificationFlags(block, transaction, this.getVersionTally(), height);
                if (!isCoinBase) {
                    for (int index = 0; index < transaction.getInputs().size(); ++index) {
                        TransactionInput in = transaction.getInputs().get(index);
                        UTXO prevOut = this.blockStore.getTransactionOutput(in.getOutpoint().getHash(), in.getOutpoint().getIndex());
                        if (prevOut == null) {
                            throw new VerificationException("Attempted to spend a non-existent or already spent output!");
                        }
                        if (prevOut.isCoinbase() && height - prevOut.getHeight() < this.params.getSpendableCoinbaseDepth()) {
                            throw new VerificationException("Tried to spend coinbase at depth " + (height - prevOut.getHeight()));
                        }
                        valueIn = valueIn.add(prevOut.getValue());
                        if (verifyFlags.contains((Object)Script.VerifyFlag.P2SH)) {
                            if (prevOut.getScript().isPayToScriptHash()) {
                                sigOps += Script.getP2SHSigOpCount(in.getScriptBytes());
                            }
                            if (sigOps > 20000L) {
                                throw new VerificationException("Too many P2SH SigOps in block");
                            }
                        }
                        prevOutScripts.add(prevOut.getScript());
                        this.blockStore.removeUnspentTransactionOutput(prevOut);
                        txOutsSpent.add(prevOut);
                    }
                }
                Sha256Hash hash = transaction.getHash();
                for (TransactionOutput out : transaction.getOutputs()) {
                    valueOut = valueOut.add(out.getValue());
                    Script script = this.getScript(out.getScriptBytes());
                    UTXO newOut = new UTXO(hash, out.getIndex(), out.getValue(), height, isCoinBase, script, this.getScriptAddress(script));
                    this.blockStore.addUnspentTransactionOutput(newOut);
                    txOutsCreated.add(newOut);
                }
                if (valueOut.signum() < 0 || valueOut.compareTo(this.params.getMaxMoney()) > 0) {
                    throw new VerificationException("Transaction output value out of range");
                }
                if (isCoinBase) {
                    coinbaseValue = valueOut;
                } else {
                    if (valueIn.compareTo(valueOut) < 0 || valueIn.compareTo(this.params.getMaxMoney()) > 0) {
                        throw new VerificationException("Transaction input value out of range");
                    }
                    totalFees = totalFees.add(valueIn.subtract(valueOut));
                }
                if (isCoinBase || !this.runScripts) continue;
                FutureTask<VerificationException> future = new FutureTask<VerificationException>(new Verifier(transaction, prevOutScripts, verifyFlags));
                this.scriptVerificationExecutor.execute(future);
                listScriptVerificationResults.add(future);
            }
            if (totalFees.compareTo(this.params.getMaxMoney()) > 0 || block.getBlockInflation(height).add(totalFees).compareTo(coinbaseValue) < 0) {
                throw new VerificationException("Transaction fees out of range");
            }
            for (Future future : listScriptVerificationResults) {
                VerificationException e;
                try {
                    e = (VerificationException)future.get();
                }
                catch (InterruptedException thrownE) {
                    throw new RuntimeException(thrownE);
                }
                catch (ExecutionException thrownE) {
                    log.error("Script.correctlySpends threw a non-normal exception: " + thrownE.getCause());
                    throw new VerificationException("Bug in Script.correctlySpends, likely script malformed in some new and interesting way.", thrownE);
                }
                if (e == null) continue;
                throw e;
            }
        }
        catch (VerificationException e) {
            this.scriptVerificationExecutor.shutdownNow();
            this.blockStore.abortDatabaseBatchWrite();
            throw e;
        }
        catch (BlockStoreException e) {
            this.scriptVerificationExecutor.shutdownNow();
            this.blockStore.abortDatabaseBatchWrite();
            throw e;
        }
        return new TransactionOutputChanges(txOutsCreated, txOutsSpent);
    }

    @Override
    protected synchronized TransactionOutputChanges connectTransactions(StoredBlock newBlock) throws VerificationException, BlockStoreException, PrunedException {
        TransactionOutputChanges txOutChanges;
        block31: {
            Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
            if (!this.params.passesCheckpoint(newBlock.getHeight(), newBlock.getHeader().getHash())) {
                throw new VerificationException("Block failed checkpoint lockin at " + newBlock.getHeight());
            }
            this.blockStore.beginDatabaseBatchWrite();
            StoredUndoableBlock block = this.blockStore.getUndoBlock(newBlock.getHeader().getHash());
            if (block == null) {
                this.blockStore.abortDatabaseBatchWrite();
                throw new PrunedException(newBlock.getHeader().getHash());
            }
            try {
                List<Transaction> transactions = block.getTransactions();
                if (transactions != null) {
                    LinkedList<UTXO> txOutsSpent = new LinkedList<UTXO>();
                    LinkedList<UTXO> txOutsCreated = new LinkedList<UTXO>();
                    long sigOps = 0L;
                    if (!this.params.isCheckpoint(newBlock.getHeight())) {
                        for (Transaction tx : transactions) {
                            Sha256Hash hash = tx.getHash();
                            if (!this.blockStore.hasUnspentOutputs(hash, tx.getOutputs().size())) continue;
                            throw new VerificationException("Block failed BIP30 test!");
                        }
                    }
                    Coin totalFees = Coin.ZERO;
                    Coin coinbaseValue = null;
                    if (this.scriptVerificationExecutor.isShutdown()) {
                        this.scriptVerificationExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                    }
                    ArrayList<FutureTask<VerificationException>> listScriptVerificationResults = new ArrayList<FutureTask<VerificationException>>(transactions.size());
                    for (Transaction transaction : transactions) {
                        EnumSet<Script.VerifyFlag> verifyFlags = this.params.getTransactionVerificationFlags(newBlock.getHeader(), transaction, this.getVersionTally(), 32);
                        boolean isCoinBase = transaction.isCoinBase();
                        Coin valueIn = Coin.ZERO;
                        Coin valueOut = Coin.ZERO;
                        LinkedList<Script> prevOutScripts = new LinkedList<Script>();
                        if (!isCoinBase) {
                            for (int index = 0; index < transaction.getInputs().size(); ++index) {
                                TransactionInput in = transaction.getInputs().get(index);
                                UTXO prevOut = this.blockStore.getTransactionOutput(in.getOutpoint().getHash(), in.getOutpoint().getIndex());
                                if (prevOut == null) {
                                    throw new VerificationException("Attempted spend of a non-existent or already spent output!");
                                }
                                if (prevOut.isCoinbase() && newBlock.getHeight() - prevOut.getHeight() < this.params.getSpendableCoinbaseDepth()) {
                                    throw new VerificationException("Tried to spend coinbase at depth " + (newBlock.getHeight() - prevOut.getHeight()));
                                }
                                valueIn = valueIn.add(prevOut.getValue());
                                if (verifyFlags.contains((Object)Script.VerifyFlag.P2SH)) {
                                    if (prevOut.getScript().isPayToScriptHash()) {
                                        sigOps += Script.getP2SHSigOpCount(in.getScriptBytes());
                                    }
                                    if (sigOps > 20000L) {
                                        throw new VerificationException("Too many P2SH SigOps in block");
                                    }
                                }
                                prevOutScripts.add(prevOut.getScript());
                                this.blockStore.removeUnspentTransactionOutput(prevOut);
                                txOutsSpent.add(prevOut);
                            }
                        }
                        Sha256Hash hash = transaction.getHash();
                        for (TransactionOutput out : transaction.getOutputs()) {
                            valueOut = valueOut.add(out.getValue());
                            Script script = this.getScript(out.getScriptBytes());
                            UTXO newOut = new UTXO(hash, out.getIndex(), out.getValue(), newBlock.getHeight(), isCoinBase, script, this.getScriptAddress(script));
                            this.blockStore.addUnspentTransactionOutput(newOut);
                            txOutsCreated.add(newOut);
                        }
                        if (valueOut.signum() < 0 || valueOut.compareTo(this.params.getMaxMoney()) > 0) {
                            throw new VerificationException("Transaction output value out of range");
                        }
                        if (isCoinBase) {
                            coinbaseValue = valueOut;
                        } else {
                            if (valueIn.compareTo(valueOut) < 0 || valueIn.compareTo(this.params.getMaxMoney()) > 0) {
                                throw new VerificationException("Transaction input value out of range");
                            }
                            totalFees = totalFees.add(valueIn.subtract(valueOut));
                        }
                        if (isCoinBase) continue;
                        FutureTask<VerificationException> future = new FutureTask<VerificationException>(new Verifier(transaction, prevOutScripts, verifyFlags));
                        this.scriptVerificationExecutor.execute(future);
                        listScriptVerificationResults.add(future);
                    }
                    if (totalFees.compareTo(this.params.getMaxMoney()) > 0 || newBlock.getHeader().getBlockInflation(newBlock.getHeight()).add(totalFees).compareTo(coinbaseValue) < 0) {
                        throw new VerificationException("Transaction fees out of range");
                    }
                    txOutChanges = new TransactionOutputChanges(txOutsCreated, txOutsSpent);
                    for (Future future : listScriptVerificationResults) {
                        VerificationException e;
                        try {
                            e = (VerificationException)future.get();
                        }
                        catch (InterruptedException thrownE) {
                            throw new RuntimeException(thrownE);
                        }
                        catch (ExecutionException thrownE) {
                            log.error("Script.correctlySpends threw a non-normal exception: " + thrownE.getCause());
                            throw new VerificationException("Bug in Script.correctlySpends, likely script malformed in some new and interesting way.", thrownE);
                        }
                        if (e == null) continue;
                        throw e;
                    }
                    break block31;
                }
                txOutChanges = block.getTxOutChanges();
                if (!this.params.isCheckpoint(newBlock.getHeight())) {
                    for (UTXO out : txOutChanges.txOutsCreated) {
                        Sha256Hash hash = out.getHash();
                        if (this.blockStore.getTransactionOutput(hash, out.getIndex()) == null) continue;
                        throw new VerificationException("Block failed BIP30 test!");
                    }
                }
                for (UTXO out : txOutChanges.txOutsCreated) {
                    this.blockStore.addUnspentTransactionOutput(out);
                }
                for (UTXO out : txOutChanges.txOutsSpent) {
                    this.blockStore.removeUnspentTransactionOutput(out);
                }
            }
            catch (VerificationException e) {
                this.scriptVerificationExecutor.shutdownNow();
                this.blockStore.abortDatabaseBatchWrite();
                throw e;
            }
            catch (BlockStoreException e) {
                this.scriptVerificationExecutor.shutdownNow();
                this.blockStore.abortDatabaseBatchWrite();
                throw e;
            }
        }
        return txOutChanges;
    }

    @Override
    protected void disconnectTransactions(StoredBlock oldBlock) throws PrunedException, BlockStoreException {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        this.blockStore.beginDatabaseBatchWrite();
        try {
            StoredUndoableBlock undoBlock = this.blockStore.getUndoBlock(oldBlock.getHeader().getHash());
            if (undoBlock == null) {
                throw new PrunedException(oldBlock.getHeader().getHash());
            }
            TransactionOutputChanges txOutChanges = undoBlock.getTxOutChanges();
            for (UTXO out : txOutChanges.txOutsSpent) {
                this.blockStore.addUnspentTransactionOutput(out);
            }
            for (UTXO out : txOutChanges.txOutsCreated) {
                this.blockStore.removeUnspentTransactionOutput(out);
            }
        }
        catch (PrunedException e) {
            this.blockStore.abortDatabaseBatchWrite();
            throw e;
        }
        catch (BlockStoreException e) {
            this.blockStore.abortDatabaseBatchWrite();
            throw e;
        }
    }

    @Override
    protected void doSetChainHead(StoredBlock chainHead) throws BlockStoreException {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        this.blockStore.setVerifiedChainHead(chainHead);
        this.blockStore.commitDatabaseBatchWrite();
    }

    @Override
    protected void notSettingChainHead() throws BlockStoreException {
        this.blockStore.abortDatabaseBatchWrite();
    }

    @Override
    protected StoredBlock getStoredBlockInCurrentScope(Sha256Hash hash) throws BlockStoreException {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        return this.blockStore.getOnceUndoableStoredBlock(hash);
    }

    private static class Verifier
    implements Callable<VerificationException> {
        final Transaction tx;
        final List<Script> prevOutScripts;
        final Set<Script.VerifyFlag> verifyFlags;

        public Verifier(Transaction tx, List<Script> prevOutScripts, Set<Script.VerifyFlag> verifyFlags) {
            this.tx = tx;
            this.prevOutScripts = prevOutScripts;
            this.verifyFlags = verifyFlags;
        }

        @Override
        @Nullable
        public VerificationException call() throws Exception {
            try {
                ListIterator<Script> prevOutIt = this.prevOutScripts.listIterator();
                for (int index = 0; index < this.tx.getInputs().size(); ++index) {
                    this.tx.getInputs().get(index).getScriptSig().correctlySpends(this.tx, index, prevOutIt.next(), this.verifyFlags);
                }
            }
            catch (VerificationException e) {
                return e;
            }
            return null;
        }
    }
}

