/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.channels;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.Locale;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.InsufficientMoneyException;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionBroadcaster;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.crypto.TransactionSignature;
import org.bitcoinj.protocols.channels.PaymentChannelServerState;
import org.bitcoinj.protocols.channels.StoredPaymentChannelServerStates;
import org.bitcoinj.protocols.channels.StoredServerChannel;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptBuilder;
import org.bitcoinj.wallet.SendRequest;
import org.bitcoinj.wallet.Wallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentChannelV1ServerState
extends PaymentChannelServerState {
    private static final Logger log = LoggerFactory.getLogger(PaymentChannelV1ServerState.class);
    private Coin feePaidForPayment;
    protected ECKey clientKey;
    private TransactionOutput clientOutput;
    private long refundTransactionUnlockTimeSecs;
    final SettableFuture<Transaction> closedFuture = SettableFuture.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PaymentChannelV1ServerState(StoredServerChannel storedServerChannel, Wallet wallet, TransactionBroadcaster broadcaster) throws VerificationException {
        super(storedServerChannel, wallet, broadcaster);
        StoredServerChannel storedServerChannel2 = storedServerChannel;
        synchronized (storedServerChannel2) {
            this.clientKey = ECKey.fromPublicOnly(this.getContractScript().getChunks().get((int)1).data);
            this.clientOutput = (TransactionOutput)Preconditions.checkNotNull((Object)storedServerChannel.clientOutput);
            this.refundTransactionUnlockTimeSecs = storedServerChannel.refundTransactionUnlockTimeSecs;
            this.stateMachine.transition(PaymentChannelServerState.State.READY);
        }
    }

    public PaymentChannelV1ServerState(TransactionBroadcaster broadcaster, Wallet wallet, ECKey serverKey, long minExpireTime) {
        super(broadcaster, wallet, serverKey, minExpireTime);
        this.stateMachine.transition(PaymentChannelServerState.State.WAITING_FOR_REFUND_TRANSACTION);
    }

    @Override
    public Multimap<PaymentChannelServerState.State, PaymentChannelServerState.State> getStateTransitions() {
        ListMultimap result = MultimapBuilder.enumKeys(PaymentChannelServerState.State.class).arrayListValues().build();
        result.put((Object)PaymentChannelServerState.State.UNINITIALISED, (Object)PaymentChannelServerState.State.READY);
        result.put((Object)PaymentChannelServerState.State.UNINITIALISED, (Object)PaymentChannelServerState.State.WAITING_FOR_REFUND_TRANSACTION);
        result.put((Object)PaymentChannelServerState.State.WAITING_FOR_REFUND_TRANSACTION, (Object)PaymentChannelServerState.State.WAITING_FOR_MULTISIG_CONTRACT);
        result.put((Object)PaymentChannelServerState.State.WAITING_FOR_MULTISIG_CONTRACT, (Object)PaymentChannelServerState.State.WAITING_FOR_MULTISIG_ACCEPTANCE);
        result.put((Object)PaymentChannelServerState.State.WAITING_FOR_MULTISIG_ACCEPTANCE, (Object)PaymentChannelServerState.State.READY);
        result.put((Object)PaymentChannelServerState.State.READY, (Object)PaymentChannelServerState.State.CLOSING);
        result.put((Object)PaymentChannelServerState.State.CLOSING, (Object)PaymentChannelServerState.State.CLOSED);
        for (PaymentChannelServerState.State state : PaymentChannelServerState.State.values()) {
            result.put((Object)state, (Object)PaymentChannelServerState.State.ERROR);
        }
        return result;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public TransactionOutput getClientOutput() {
        return this.clientOutput;
    }

    @Override
    protected Script getSignedScript() {
        return this.getContractScript();
    }

    public synchronized byte[] provideRefundTransaction(Transaction refundTx, byte[] clientMultiSigPubKey) throws VerificationException {
        Preconditions.checkNotNull((Object)refundTx);
        Preconditions.checkNotNull((Object)clientMultiSigPubKey);
        this.stateMachine.checkState(PaymentChannelServerState.State.WAITING_FOR_REFUND_TRANSACTION);
        log.info("Provided with refund transaction: {}", (Object)refundTx);
        refundTx.verify();
        if (refundTx.getInputs().size() != 1) {
            throw new VerificationException("Refund transaction does not have exactly one input");
        }
        if (refundTx.getInput(0L).getSequenceNumber() == 0xFFFFFFFFL) {
            throw new VerificationException("Refund transaction's input's sequence number disables lock time");
        }
        if (refundTx.getLockTime() < this.minExpireTime) {
            throw new VerificationException("Refund transaction has a lock time too soon");
        }
        if (refundTx.getOutputs().size() != 1) {
            throw new VerificationException("Refund transaction does not have exactly one output");
        }
        this.refundTransactionUnlockTimeSecs = refundTx.getLockTime();
        this.clientKey = ECKey.fromPublicOnly(clientMultiSigPubKey);
        Script multisigPubKey = ScriptBuilder.createMultiSigOutputScript(2, (List<ECKey>)ImmutableList.of((Object)this.clientKey, (Object)this.serverKey));
        TransactionSignature sig = refundTx.calculateSignature(0, this.serverKey, multisigPubKey, Transaction.SigHash.NONE, true);
        log.info("Signed refund transaction.");
        this.clientOutput = refundTx.getOutput(0L);
        this.stateMachine.transition(PaymentChannelServerState.State.WAITING_FOR_MULTISIG_CONTRACT);
        return sig.encodeToBitcoin();
    }

    @Override
    protected Script createOutputScript() {
        return ScriptBuilder.createMultiSigOutputScript(2, (List<ECKey>)ImmutableList.of((Object)this.clientKey, (Object)this.serverKey));
    }

    @Override
    protected ECKey getClientKey() {
        return this.clientKey;
    }

    private void signMultisigInput(Transaction tx, Transaction.SigHash hashType, boolean anyoneCanPay) {
        TransactionSignature signature = tx.calculateSignature(0, this.serverKey, this.getContractScript(), hashType, anyoneCanPay);
        byte[] mySig = signature.encodeToBitcoin();
        Script scriptSig = ScriptBuilder.createMultiSigInputScriptBytes((List<byte[]>)ImmutableList.of((Object)this.bestValueSignature, (Object)mySig));
        tx.getInput(0L).setScriptSig(scriptSig);
    }

    @Override
    public synchronized ListenableFuture<Transaction> close() throws InsufficientMoneyException {
        if (this.storedServerChannel != null) {
            StoredServerChannel temp = this.storedServerChannel;
            this.storedServerChannel = null;
            StoredPaymentChannelServerStates channels = (StoredPaymentChannelServerStates)this.wallet.getExtensions().get(StoredPaymentChannelServerStates.EXTENSION_ID);
            channels.closeChannel(temp);
            if (this.getState().compareTo(PaymentChannelServerState.State.CLOSING) >= 0) {
                return this.closedFuture;
            }
        }
        if (this.getState().ordinal() < PaymentChannelServerState.State.READY.ordinal()) {
            log.error("Attempt to settle channel in state " + (Object)((Object)this.getState()));
            this.stateMachine.transition(PaymentChannelServerState.State.CLOSED);
            this.closedFuture.set(null);
            return this.closedFuture;
        }
        if (this.getState() != PaymentChannelServerState.State.READY) {
            log.warn("Failed attempt to settle a channel in state " + (Object)((Object)this.getState()));
            return this.closedFuture;
        }
        Transaction tx = null;
        try {
            SendRequest req = this.makeUnsignedChannelContract(this.bestValueToMe);
            tx = req.tx;
            this.signMultisigInput(tx, Transaction.SigHash.NONE, true);
            req.shuffleOutputs = false;
            req.missingSigsMode = Wallet.MissingSigsMode.USE_DUMMY_SIG;
            this.wallet.completeTx(req);
            this.feePaidForPayment = req.tx.getFee();
            log.info("Calculated fee is {}", (Object)this.feePaidForPayment);
            if (this.feePaidForPayment.compareTo(this.bestValueToMe) > 0) {
                String msg = String.format(Locale.US, "Had to pay more in fees (%s) than the channel was worth (%s)", this.feePaidForPayment, this.bestValueToMe);
                throw new InsufficientMoneyException(this.feePaidForPayment.subtract(this.bestValueToMe), msg);
            }
            this.signMultisigInput(tx, Transaction.SigHash.ALL, false);
            tx.verify();
            for (TransactionInput input : tx.getInputs()) {
                input.verify();
            }
        }
        catch (InsufficientMoneyException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Could not verify self-built tx\nMULTISIG {}\nCLOSE {}", (Object)this.contract, tx != null ? tx : "");
            throw new RuntimeException(e);
        }
        this.stateMachine.transition(PaymentChannelServerState.State.CLOSING);
        log.info("Closing channel, broadcasting tx {}", (Object)tx);
        ListenableFuture<Transaction> future = this.broadcaster.broadcastTransaction(tx).future();
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Transaction>(){

            public void onSuccess(Transaction transaction) {
                log.info("TX {} propagated, channel successfully closed.", (Object)transaction.getHash());
                PaymentChannelV1ServerState.this.stateMachine.transition(PaymentChannelServerState.State.CLOSED);
                PaymentChannelV1ServerState.this.closedFuture.set((Object)transaction);
            }

            public void onFailure(Throwable throwable) {
                log.error("Failed to settle channel, could not broadcast: {}", throwable);
                PaymentChannelV1ServerState.this.stateMachine.transition(PaymentChannelServerState.State.ERROR);
                PaymentChannelV1ServerState.this.closedFuture.setException(throwable);
            }
        });
        return this.closedFuture;
    }

    @Override
    public synchronized Coin getFeePaid() {
        this.stateMachine.checkState(new PaymentChannelServerState.State[]{PaymentChannelServerState.State.CLOSED, PaymentChannelServerState.State.CLOSING});
        return this.feePaidForPayment;
    }

    public synchronized long getRefundTransactionUnlockTime() {
        Preconditions.checkState((this.getState().compareTo(PaymentChannelServerState.State.WAITING_FOR_MULTISIG_CONTRACT) > 0 && this.getState() != PaymentChannelServerState.State.ERROR ? 1 : 0) != 0);
        return this.refundTransactionUnlockTimeSecs;
    }
}

