/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.testing;

import com.google.common.util.concurrent.SettableFuture;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.bitcoinj.core.BloomFilter;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.PeerSocketHandler;
import org.bitcoinj.core.Ping;

public abstract class InboundMessageQueuer
extends PeerSocketHandler {
    public final BlockingQueue<Message> inboundMessages = new ArrayBlockingQueue<Message>(1000);
    public final Map<Long, SettableFuture<Void>> mapPingFutures = new HashMap<Long, SettableFuture<Void>>();
    public Peer peer;
    public BloomFilter lastReceivedFilter;

    protected InboundMessageQueuer(NetworkParameters params) {
        super(params, new InetSocketAddress("127.0.0.1", 2000));
    }

    public Message nextMessage() {
        return (Message)this.inboundMessages.poll();
    }

    public Message nextMessageBlocking() throws InterruptedException {
        return this.inboundMessages.take();
    }

    @Override
    protected void processMessage(Message m) throws Exception {
        SettableFuture<Void> future;
        if (m instanceof Ping && (future = this.mapPingFutures.get(((Ping)m).getNonce())) != null) {
            future.set(null);
            return;
        }
        if (m instanceof BloomFilter) {
            this.lastReceivedFilter = (BloomFilter)m;
        }
        this.inboundMessages.offer(m);
    }
}

