/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.channels;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Locale;
import javax.annotation.Nullable;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionBroadcaster;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.core.Wallet;
import org.bitcoinj.protocols.channels.PaymentChannelServer;
import org.bitcoinj.protocols.channels.PaymentChannelServerState;

public class StoredServerChannel {
    Coin bestValueToMe;
    byte[] bestValueSignature;
    long refundTransactionUnlockTimeSecs;
    Transaction contract;
    TransactionOutput clientOutput;
    ECKey myKey;
    private PaymentChannelServer connectedHandler = null;
    PaymentChannelServerState state = null;

    StoredServerChannel(@Nullable PaymentChannelServerState state, Transaction contract, TransactionOutput clientOutput, long refundTransactionUnlockTimeSecs, ECKey myKey, Coin bestValueToMe, @Nullable byte[] bestValueSignature) {
        this.contract = contract;
        this.clientOutput = clientOutput;
        this.refundTransactionUnlockTimeSecs = refundTransactionUnlockTimeSecs;
        this.myKey = myKey;
        this.bestValueToMe = bestValueToMe;
        this.bestValueSignature = bestValueSignature;
        this.state = state;
    }

    synchronized void updateValueToMe(Coin newValue, byte[] newSignature) {
        this.bestValueToMe = newValue;
        this.bestValueSignature = newSignature;
    }

    synchronized PaymentChannelServer setConnectedHandler(PaymentChannelServer connectedHandler, boolean override) {
        if (this.connectedHandler != null && !override) {
            return this.connectedHandler;
        }
        this.connectedHandler = connectedHandler;
        return connectedHandler;
    }

    synchronized void clearConnectedHandler() {
        this.connectedHandler = null;
    }

    synchronized void closeConnectedHandler() {
        if (this.connectedHandler != null) {
            this.connectedHandler.close();
        }
    }

    public synchronized PaymentChannelServerState getOrCreateState(Wallet wallet, TransactionBroadcaster broadcaster) throws VerificationException {
        if (this.state == null) {
            this.state = new PaymentChannelServerState(this, wallet, broadcaster);
        }
        Preconditions.checkArgument((wallet == this.state.wallet ? 1 : 0) != 0);
        return this.state;
    }

    public synchronized String toString() {
        String newline = String.format(Locale.US, "%n", new Object[0]);
        return String.format(Locale.US, "Stored server channel (%s)%n    Key:           %s%n    Value to me:   %s%n    Client output: %s%n    Refund unlock: %s (%d unix time)%n    Contract:    %s%n", this.connectedHandler != null ? "connected" : "disconnected", this.myKey, this.bestValueToMe, this.clientOutput, new Date(this.refundTransactionUnlockTimeSecs * 1000L), this.refundTransactionUnlockTimeSecs, this.contract.toString().replaceAll(newline, newline + "    "));
    }
}

