/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.channels;

import java.util.Locale;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;

class StoredClientChannel {
    Sha256Hash id;
    Transaction contract;
    Transaction refund;
    Transaction close;
    ECKey myKey;
    Coin valueToMe;
    Coin refundFees;
    boolean active = false;

    StoredClientChannel(Sha256Hash id, Transaction contract, Transaction refund, ECKey myKey, Coin valueToMe, Coin refundFees, boolean active) {
        this.id = id;
        this.contract = contract;
        this.refund = refund;
        this.myKey = myKey;
        this.valueToMe = valueToMe;
        this.refundFees = refundFees;
        this.active = active;
    }

    long expiryTimeSeconds() {
        return this.refund.getLockTime() + 300L;
    }

    public String toString() {
        String newline = String.format(Locale.US, "%n", new Object[0]);
        String closeStr = this.close == null ? "still open" : this.close.toString().replaceAll(newline, newline + "   ");
        return String.format(Locale.US, "Stored client channel for server ID %s (%s)%n    Key:         %s%n    Value left:  %s%n    Refund fees: %s%n    Contract:  %sRefund:    %sClose:     %s", this.id, this.active ? "active" : "inactive", this.myKey, this.valueToMe, this.refundFees, this.contract.toString().replaceAll(newline, newline + "    "), this.refund.toString().replaceAll(newline, newline + "    "), closeStr);
    }
}

