/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.channels;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.bitcoin.paymentchannel.Protos;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.InsufficientMoneyException;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionBroadcaster;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.core.Wallet;
import org.bitcoinj.protocols.channels.PaymentChannelCloseException;
import org.bitcoinj.protocols.channels.PaymentChannelServerState;
import org.bitcoinj.protocols.channels.StoredPaymentChannelServerStates;
import org.bitcoinj.protocols.channels.StoredServerChannel;
import org.bitcoinj.protocols.channels.ValueOutOfRangeException;
import org.bitcoinj.utils.Threading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentChannelServer {
    private static final Logger log = LoggerFactory.getLogger(PaymentChannelServer.class);
    protected final ReentrantLock lock = Threading.lock("channelserver");
    public final int SERVER_MAJOR_VERSION = 1;
    public final int SERVER_MINOR_VERSION = 0;
    @GuardedBy(value="lock")
    private InitStep step = InitStep.WAITING_ON_CLIENT_VERSION;
    private final ServerConnection conn;
    @GuardedBy(value="lock")
    private boolean connectionOpen = false;
    @GuardedBy(value="lock")
    private boolean channelSettling = false;
    private final Wallet wallet;
    private final TransactionBroadcaster broadcaster;
    @GuardedBy(value="lock")
    private ECKey myKey;
    private final Coin minAcceptedChannelSize;
    @GuardedBy(value="lock")
    private PaymentChannelServerState state;
    @GuardedBy(value="lock")
    private long expireTime;
    public static final long DEFAULT_MAX_TIME_WINDOW = 604800L;
    protected final long maxTimeWindow;
    public static final long DEFAULT_MIN_TIME_WINDOW = 14400L;
    public static final long HARD_MIN_TIME_WINDOW = 7200L;
    protected final long minTimeWindow;

    public PaymentChannelServer(TransactionBroadcaster broadcaster, Wallet wallet, Coin minAcceptedChannelSize, ServerConnection conn) {
        this(broadcaster, wallet, minAcceptedChannelSize, 14400L, 604800L, conn);
    }

    public PaymentChannelServer(TransactionBroadcaster broadcaster, Wallet wallet, Coin minAcceptedChannelSize, long minTimeWindow, long maxTimeWindow, ServerConnection conn) {
        if (minTimeWindow > maxTimeWindow) {
            throw new IllegalArgumentException("minTimeWindow must be less or equal to maxTimeWindow");
        }
        if (minTimeWindow < 7200L) {
            throw new IllegalArgumentException("minTimeWindow must be larger than7200 seconds");
        }
        this.broadcaster = (TransactionBroadcaster)Preconditions.checkNotNull((Object)broadcaster);
        this.wallet = (Wallet)Preconditions.checkNotNull((Object)wallet);
        this.minAcceptedChannelSize = (Coin)Preconditions.checkNotNull((Object)minAcceptedChannelSize);
        this.conn = (ServerConnection)Preconditions.checkNotNull((Object)conn);
        this.minTimeWindow = minTimeWindow;
        this.maxTimeWindow = maxTimeWindow;
    }

    @Nullable
    public PaymentChannelServerState state() {
        return this.state;
    }

    @GuardedBy(value="lock")
    private void receiveVersionMessage(Protos.TwoWayChannelMessage msg) throws VerificationException {
        Preconditions.checkState((this.step == InitStep.WAITING_ON_CLIENT_VERSION && msg.hasClientVersion() ? 1 : 0) != 0);
        Protos.ClientVersion clientVersion = msg.getClientVersion();
        int major = clientVersion.getMajor();
        if (major != 1) {
            this.error("This server needs protocol version 1 , client offered " + major, Protos.Error.ErrorCode.NO_ACCEPTABLE_VERSION, PaymentChannelCloseException.CloseReason.NO_ACCEPTABLE_VERSION);
            return;
        }
        Protos.ServerVersion.Builder versionNegotiationBuilder = Protos.ServerVersion.newBuilder().setMajor(1).setMinor(0);
        this.conn.sendToClient(Protos.TwoWayChannelMessage.newBuilder().setType(Protos.TwoWayChannelMessage.MessageType.SERVER_VERSION).setServerVersion(versionNegotiationBuilder).build());
        ByteString reopenChannelContractHash = clientVersion.getPreviousChannelContractHash();
        if (reopenChannelContractHash != null && reopenChannelContractHash.size() == 32) {
            Sha256Hash contractHash = Sha256Hash.wrap(reopenChannelContractHash.toByteArray());
            log.info("New client that wants to resume {}", (Object)contractHash);
            StoredPaymentChannelServerStates channels = (StoredPaymentChannelServerStates)this.wallet.getExtensions().get(StoredPaymentChannelServerStates.EXTENSION_ID);
            if (channels != null) {
                StoredServerChannel storedServerChannel = channels.getChannel(contractHash);
                if (storedServerChannel != null) {
                    PaymentChannelServer existingHandler = storedServerChannel.setConnectedHandler(this, false);
                    if (existingHandler != this) {
                        log.warn("  ... and that channel is already in use, disconnecting other user.");
                        existingHandler.close();
                        storedServerChannel.setConnectedHandler(this, true);
                    }
                    log.info("Got resume version message, responding with VERSIONS and CHANNEL_OPEN");
                    this.state = storedServerChannel.getOrCreateState(this.wallet, this.broadcaster);
                    this.step = InitStep.CHANNEL_OPEN;
                    this.conn.sendToClient(Protos.TwoWayChannelMessage.newBuilder().setType(Protos.TwoWayChannelMessage.MessageType.CHANNEL_OPEN).build());
                    this.conn.channelOpen(contractHash);
                    return;
                }
                log.error(" ... but we do not have any record of that contract! Resume failed.");
            } else {
                log.error(" ... but we do not have any stored channels! Resume failed.");
            }
        }
        log.info("Got initial version message, responding with VERSIONS and INITIATE: min value={}", (Object)this.minAcceptedChannelSize.value);
        this.myKey = new ECKey();
        this.wallet.freshReceiveKey();
        this.expireTime = Utils.currentTimeSeconds() + this.truncateTimeWindow(clientVersion.getTimeWindowSecs());
        this.step = InitStep.WAITING_ON_UNSIGNED_REFUND;
        Protos.Initiate.Builder initiateBuilder = Protos.Initiate.newBuilder().setMultisigKey(ByteString.copyFrom((byte[])this.myKey.getPubKey())).setExpireTimeSecs(this.expireTime).setMinAcceptedChannelSize(this.minAcceptedChannelSize.value).setMinPayment(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE.value);
        this.conn.sendToClient(Protos.TwoWayChannelMessage.newBuilder().setInitiate(initiateBuilder).setType(Protos.TwoWayChannelMessage.MessageType.INITIATE).build());
    }

    private long truncateTimeWindow(long timeWindow) {
        if (timeWindow < this.minTimeWindow) {
            log.info("client requested time window {} s to short, offering {} s", (Object)timeWindow, (Object)this.minTimeWindow);
            return this.minTimeWindow;
        }
        if (timeWindow > this.maxTimeWindow) {
            log.info("client requested time window {} s to long, offering {} s", (Object)timeWindow, (Object)this.minTimeWindow);
            return this.maxTimeWindow;
        }
        return timeWindow;
    }

    @GuardedBy(value="lock")
    private void receiveRefundMessage(Protos.TwoWayChannelMessage msg) throws VerificationException {
        Preconditions.checkState((this.step == InitStep.WAITING_ON_UNSIGNED_REFUND && msg.hasProvideRefund() ? 1 : 0) != 0);
        log.info("Got refund transaction, returning signature");
        Protos.ProvideRefund providedRefund = msg.getProvideRefund();
        this.state = new PaymentChannelServerState(this.broadcaster, this.wallet, this.myKey, this.expireTime);
        byte[] signature = this.state.provideRefundTransaction(new Transaction(this.wallet.getParams(), providedRefund.getTx().toByteArray()), providedRefund.getMultisigKey().toByteArray());
        this.step = InitStep.WAITING_ON_CONTRACT;
        Protos.ReturnRefund.Builder returnRefundBuilder = Protos.ReturnRefund.newBuilder().setSignature(ByteString.copyFrom((byte[])signature));
        this.conn.sendToClient(Protos.TwoWayChannelMessage.newBuilder().setReturnRefund(returnRefundBuilder).setType(Protos.TwoWayChannelMessage.MessageType.RETURN_REFUND).build());
    }

    /*
     * Exception decompiling
     */
    private void multisigContractPropogated(Protos.ProvideContract providedContract, Sha256Hash contractHash) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @GuardedBy(value="lock")
    private void receiveContractMessage(Protos.TwoWayChannelMessage msg) throws VerificationException {
        Preconditions.checkState((this.step == InitStep.WAITING_ON_CONTRACT && msg.hasProvideContract() ? 1 : 0) != 0);
        log.info("Got contract, broadcasting and responding with CHANNEL_OPEN");
        final Protos.ProvideContract providedContract = msg.getProvideContract();
        final Transaction multisigContract = new Transaction(this.wallet.getParams(), providedContract.getTx().toByteArray());
        this.step = InitStep.WAITING_ON_MULTISIG_ACCEPTANCE;
        this.state.provideMultiSigContract(multisigContract).addListener(new Runnable(){

            @Override
            public void run() {
                PaymentChannelServer.this.multisigContractPropogated(providedContract, multisigContract.getHash());
            }
        }, Threading.SAME_THREAD);
    }

    @GuardedBy(value="lock")
    private void receiveUpdatePaymentMessage(Protos.UpdatePayment msg, boolean sendAck) throws VerificationException, ValueOutOfRangeException, InsufficientMoneyException {
        log.info("Got a payment update");
        Coin lastBestPayment = this.state.getBestValueToMe();
        Coin refundSize = Coin.valueOf(msg.getClientChangeValue());
        boolean stillUsable = this.state.incrementPayment(refundSize, msg.getSignature().toByteArray());
        Coin bestPaymentChange = this.state.getBestValueToMe().subtract(lastBestPayment);
        ListenableFuture<ByteString> ackInfoFuture = null;
        if (bestPaymentChange.signum() > 0) {
            ByteString info = msg.hasInfo() ? msg.getInfo() : null;
            ackInfoFuture = this.conn.paymentIncrease(bestPaymentChange, this.state.getBestValueToMe(), info);
        }
        if (sendAck) {
            final Protos.TwoWayChannelMessage.Builder ack = Protos.TwoWayChannelMessage.newBuilder();
            ack.setType(Protos.TwoWayChannelMessage.MessageType.PAYMENT_ACK);
            if (ackInfoFuture == null) {
                this.conn.sendToClient(ack.build());
            } else {
                Futures.addCallback(ackInfoFuture, (FutureCallback)new FutureCallback<ByteString>(){

                    public void onSuccess(@Nullable ByteString result) {
                        if (result != null) {
                            ack.setPaymentAck(ack.getPaymentAckBuilder().setInfo(result));
                        }
                        PaymentChannelServer.this.conn.sendToClient(ack.build());
                    }

                    public void onFailure(Throwable t) {
                        log.info("Failed retrieving paymentIncrease info future");
                        PaymentChannelServer.this.error("Failed processing payment update", Protos.Error.ErrorCode.OTHER, PaymentChannelCloseException.CloseReason.UPDATE_PAYMENT_FAILED);
                    }
                });
            }
        }
        if (!stillUsable) {
            log.info("Channel is now fully exhausted, closing/initiating settlement");
            this.settlePayment(PaymentChannelCloseException.CloseReason.CHANNEL_EXHAUSTED);
        }
    }

    /*
     * Exception decompiling
     */
    public void receiveMessage(Protos.TwoWayChannelMessage msg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 10[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void error(String message, Protos.Error.ErrorCode errorCode, PaymentChannelCloseException.CloseReason closeReason) {
        log.error(message);
        Protos.Error.Builder errorBuilder = Protos.Error.newBuilder().setCode(errorCode).setExplanation(message);
        this.conn.sendToClient(Protos.TwoWayChannelMessage.newBuilder().setError(errorBuilder).setType(Protos.TwoWayChannelMessage.MessageType.ERROR).build());
        this.conn.destroyConnection(closeReason);
    }

    @GuardedBy(value="lock")
    private void receiveCloseMessage() throws InsufficientMoneyException {
        log.info("Got CLOSE message, closing channel");
        if (this.state != null) {
            this.settlePayment(PaymentChannelCloseException.CloseReason.CLIENT_REQUESTED_CLOSE);
        } else {
            this.conn.destroyConnection(PaymentChannelCloseException.CloseReason.CLIENT_REQUESTED_CLOSE);
        }
    }

    @GuardedBy(value="lock")
    private void settlePayment(final PaymentChannelCloseException.CloseReason clientRequestedClose) throws InsufficientMoneyException {
        this.channelSettling = true;
        Futures.addCallback(this.state.close(), (FutureCallback)new FutureCallback<Transaction>(){

            public void onSuccess(Transaction result) {
                Protos.TwoWayChannelMessage.Builder msg = Protos.TwoWayChannelMessage.newBuilder();
                msg.setType(Protos.TwoWayChannelMessage.MessageType.CLOSE);
                if (result != null) {
                    msg.getSettlementBuilder().setTx(ByteString.copyFrom((byte[])result.bitcoinSerialize()));
                    log.info("Sending CLOSE back with broadcast settlement tx.");
                } else {
                    log.info("Sending CLOSE back without broadcast settlement tx.");
                }
                PaymentChannelServer.this.conn.sendToClient(msg.build());
                PaymentChannelServer.this.conn.destroyConnection(clientRequestedClose);
            }

            public void onFailure(Throwable t) {
                log.error("Failed to broadcast settlement tx", t);
                PaymentChannelServer.this.conn.destroyConnection(clientRequestedClose);
            }
        });
    }

    public void connectionClosed() {
        this.lock.lock();
        try {
            log.info("Server channel closed.");
            this.connectionOpen = false;
            try {
                StoredServerChannel storedServerChannel;
                StoredPaymentChannelServerStates channels;
                if (this.state != null && this.state.getMultisigContract() != null && (channels = (StoredPaymentChannelServerStates)this.wallet.getExtensions().get(StoredPaymentChannelServerStates.EXTENSION_ID)) != null && (storedServerChannel = channels.getChannel(this.state.getMultisigContract().getHash())) != null) {
                    storedServerChannel.clearConnectedHandler();
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void connectionOpen() {
        this.lock.lock();
        try {
            log.info("New server channel active.");
            this.connectionOpen = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() {
        this.lock.lock();
        try {
            if (this.connectionOpen && !this.channelSettling) {
                Protos.TwoWayChannelMessage.Builder msg = Protos.TwoWayChannelMessage.newBuilder();
                msg.setType(Protos.TwoWayChannelMessage.MessageType.CLOSE);
                this.conn.sendToClient(msg.build());
                this.conn.destroyConnection(PaymentChannelCloseException.CloseReason.SERVER_REQUESTED_CLOSE);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public static interface ServerConnection {
        public void sendToClient(Protos.TwoWayChannelMessage var1);

        public void destroyConnection(PaymentChannelCloseException.CloseReason var1);

        public void channelOpen(Sha256Hash var1);

        @Nullable
        public ListenableFuture<ByteString> paymentIncrease(Coin var1, Coin var2, @Nullable ByteString var3);
    }

    private static enum InitStep {
        WAITING_ON_CLIENT_VERSION,
        WAITING_ON_UNSIGNED_REFUND,
        WAITING_ON_CONTRACT,
        WAITING_ON_MULTISIG_ACCEPTANCE,
        CHANNEL_OPEN;

    }
}

