/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net.discovery;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.net.discovery.PeerDiscoveryException;

public class SeedPeers
implements PeerDiscovery {
    private NetworkParameters params;
    private int[] seedAddrs;
    private int pnseedIndex;

    public SeedPeers(NetworkParameters params) {
        this(params.getAddrSeeds(), params);
    }

    public SeedPeers(int[] seedAddrs, NetworkParameters params) {
        this.seedAddrs = seedAddrs;
        this.params = params;
    }

    @Nullable
    public InetSocketAddress getPeer() throws PeerDiscoveryException {
        try {
            return this.nextPeer();
        }
        catch (UnknownHostException e) {
            throw new PeerDiscoveryException(e);
        }
    }

    @Nullable
    private InetSocketAddress nextPeer() throws UnknownHostException, PeerDiscoveryException {
        if (this.seedAddrs == null || this.seedAddrs.length == 0) {
            throw new PeerDiscoveryException("No IP address seeds configured; unable to find any peers");
        }
        if (this.pnseedIndex >= this.seedAddrs.length) {
            return null;
        }
        return new InetSocketAddress(this.convertAddress(this.seedAddrs[this.pnseedIndex++]), this.params.getPort());
    }

    @Override
    public InetSocketAddress[] getPeers(long timeoutValue, TimeUnit timeoutUnit) throws PeerDiscoveryException {
        try {
            return this.allPeers();
        }
        catch (UnknownHostException e) {
            throw new PeerDiscoveryException(e);
        }
    }

    private InetSocketAddress[] allPeers() throws UnknownHostException {
        InetSocketAddress[] addresses = new InetSocketAddress[this.seedAddrs.length];
        for (int i = 0; i < this.seedAddrs.length; ++i) {
            addresses[i] = new InetSocketAddress(this.convertAddress(this.seedAddrs[i]), this.params.getPort());
        }
        return addresses;
    }

    private InetAddress convertAddress(int seed) throws UnknownHostException {
        byte[] v4addr = new byte[]{(byte)(0xFF & seed), (byte)(0xFF & seed >> 8), (byte)(0xFF & seed >> 16), (byte)(0xFF & seed >> 24)};
        return InetAddress.getByAddress(v4addr);
    }

    @Override
    public void shutdown() {
    }
}

