/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.Preconditions;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.InventoryItem;
import org.bitcoinj.core.ListMessage;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Transaction;

public class InventoryMessage
extends ListMessage {
    private static final long serialVersionUID = -7050246551646107066L;
    public static final int MAX_INV_SIZE = 50000;

    public InventoryMessage(NetworkParameters params, byte[] bytes) throws ProtocolException {
        super(params, bytes);
    }

    public InventoryMessage(NetworkParameters params, byte[] payload, boolean parseLazy, boolean parseRetain, int length) throws ProtocolException {
        super(params, payload, parseLazy, parseRetain, length);
    }

    public InventoryMessage(NetworkParameters params) {
        super(params);
    }

    public void addBlock(Block block) {
        this.addItem(new InventoryItem(InventoryItem.Type.Block, block.getHash()));
    }

    public void addTransaction(Transaction tx) {
        this.addItem(new InventoryItem(InventoryItem.Type.Transaction, tx.getHash()));
    }

    public static InventoryMessage with(Transaction ... txns) {
        Preconditions.checkArgument((txns.length > 0 ? 1 : 0) != 0);
        InventoryMessage result = new InventoryMessage(txns[0].getParams());
        for (Transaction tx : txns) {
            result.addTransaction(tx);
        }
        return result;
    }
}

