/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.core.VarInt;

public class GetUTXOsMessage
extends Message {
    public static final int MIN_PROTOCOL_VERSION = 70002;
    public static final int SERVICE_FLAGS_REQUIRED = 3;
    private boolean includeMempool;
    private ImmutableList<TransactionOutPoint> outPoints;

    public GetUTXOsMessage(NetworkParameters params, List<TransactionOutPoint> outPoints, boolean includeMempool) {
        super(params);
        this.outPoints = ImmutableList.copyOf(outPoints);
        this.includeMempool = includeMempool;
    }

    public GetUTXOsMessage(NetworkParameters params, byte[] payloadBytes) {
        super(params, payloadBytes, 0);
    }

    @Override
    protected void parse() throws ProtocolException {
        this.includeMempool = this.readBytes(1)[0] == 1;
        long numOutpoints = this.readVarInt();
        ImmutableList.Builder list = ImmutableList.builder();
        int i = 0;
        while ((long)i < numOutpoints) {
            TransactionOutPoint outPoint = new TransactionOutPoint(this.params, this.payload, this.cursor);
            list.add((Object)outPoint);
            this.cursor += outPoint.getMessageSize();
            ++i;
        }
        this.outPoints = list.build();
        this.length = this.cursor;
    }

    public boolean getIncludeMempool() {
        return this.includeMempool;
    }

    public ImmutableList<TransactionOutPoint> getOutPoints() {
        return this.outPoints;
    }

    @Override
    protected void parseLite() throws ProtocolException {
    }

    @Override
    void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        stream.write(new byte[]{1});
        stream.write(new VarInt(this.outPoints.size()).encode());
        for (TransactionOutPoint outPoint : this.outPoints) {
            outPoint.bitcoinSerializeToStream(stream);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetUTXOsMessage that = (GetUTXOsMessage)o;
        if (this.includeMempool != that.includeMempool) {
            return false;
        }
        return this.outPoints.equals(that.outPoints);
    }

    public int hashCode() {
        int result = this.includeMempool ? 1 : 0;
        result = 31 * result + this.outPoints.hashCode();
        return result;
    }
}

