/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.stefanodp91.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.util.Log;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bitbucket.stefanodp91.R;

public class ImageUtils {
    private static final String TAG = ImageUtils.class.getName();
    private Context context;

    public ImageUtils(Context context) {
        this.context = context;
    }

    public void loadBitmap(Intent data, File file) {
        Uri imageUri = data.getData();
        Bitmap bitmap = this.getBitmapFromUri(imageUri);
        if (bitmap != null) {
            this.saveBitmapToFile(bitmap, file);
        } else {
            Log.e((String)TAG, (String)"loadBitmap(...) ==> bitmap is null");
        }
    }

    public void display(ImageView imageView, Uri imageUri) {
        imageView.setVisibility(0);
        Log.d((String)TAG, (String)("display(...) ==> imageUri == " + imageUri));
        if (imageUri.toString().contains("file://")) {
            String convertedUrl = String.valueOf(imageUri);
            Glide.with((Context)this.context).load(convertedUrl).into(imageView);
        } else {
            Glide.with((Context)this.context).load(new File(String.valueOf(imageUri))).into(imageView);
        }
    }

    public boolean isPhotoFile(String string2) {
        boolean isUri = false;
        if (string2.contains("content://") || string2.contains("file://") || string2.contains("/storage/")) {
            isUri = true;
        }
        return isUri;
    }

    public File createImageFile() {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_";
        File storageDir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), this.context.getString(R.string.image_dir_name));
        if (!storageDir.mkdirs()) {
            Log.d((String)TAG, (String)"createImageFile() ==> directory already exists");
        }
        File image = null;
        try {
            image = File.createTempFile(imageFileName, ".jpg", storageDir);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("createImageFile(...) failed with IOException " + e.getMessage()));
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBitmapToFile(Bitmap bitmap, File file) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("saveBitmapToFile(...) failed with IOException " + e.getMessage()));
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("saveBitmapToFile(...) failed with IOException " + e.getMessage()));
            }
        }
    }

    private Bitmap getBitmapFromUri(Uri imageUri) {
        Bitmap bitmap = null;
        try {
            bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)imageUri);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("getBitmapFromUri(...) failed with IOException " + e.getMessage()));
        }
        return bitmap;
    }
}

