/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.stefanodp91.ui;

import android.app.Activity;
import android.os.Bundle;
import android.support.design.widget.TextInputLayout;
import android.support.v4.app.Fragment;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import org.bitbucket.stefanodp91.R;
import org.bitbucket.stefanodp91.model.Page;
import org.bitbucket.stefanodp91.ui.PageFragmentCallbacks;

public class TextFragment
extends Fragment {
    protected static final String ARG_KEY = "key";
    private PageFragmentCallbacks mCallbacks;
    private String mKey;
    private Page mPage;
    protected EditText mEditTextInput;
    private TextInputLayout mEditTextInputWrapper;

    public static TextFragment create(String key) {
        Bundle args = new Bundle();
        args.putString(ARG_KEY, key);
        TextFragment f = new TextFragment();
        f.setArguments(args);
        return f;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        this.mKey = args.getString(ARG_KEY);
        this.mPage = this.mCallbacks.onGetPage(this.mKey);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_page_text, container, false);
        ((TextView)rootView.findViewById(16908310)).setText((CharSequence)this.mPage.getTitle());
        this.mEditTextInput = (EditText)rootView.findViewById(R.id.editTextInput);
        this.mEditTextInputWrapper = (TextInputLayout)rootView.findViewById(R.id.editTextInputWrapper);
        this.mEditTextInput.setText((CharSequence)this.mPage.getData().getString("_"));
        return rootView;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (!(activity instanceof PageFragmentCallbacks)) {
            throw new ClassCastException("Activity must implement PageFragmentCallbacks");
        }
        this.mCallbacks = (PageFragmentCallbacks)activity;
    }

    public void onDetach() {
        super.onDetach();
        this.mCallbacks = null;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.setInputType();
        this.mEditTextInput.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable editable) {
                TextFragment.this.mPage.getData().putString("_", editable != null ? editable.toString() : null);
                TextFragment.this.mPage.notifyDataChanged();
            }
        });
    }

    protected void setInputType() {
        this.mEditTextInput.setInputType(1);
    }

    public void setMenuVisibility(boolean menuVisible) {
        super.setMenuVisibility(menuVisible);
        if (this.mEditTextInput != null) {
            InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
            if (!menuVisible) {
                imm.hideSoftInputFromWindow(this.getView().getWindowToken(), 0);
            }
        }
    }

    public TextInputLayout getEditTextInputWrapper() {
        return this.mEditTextInputWrapper;
    }

    protected void setHint(String hint) {
        Log.d((String)((Object)((Object)this)).getClass().getName(), (String)hint);
        this.mEditTextInput.setHint((CharSequence)hint);
    }
}

