/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.stefanodp91.ui;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import org.bitbucket.stefanodp91.R;

public class StepPagerStrip
extends View {
    private static final int[] ATTRS = new int[]{16842927};
    private int mPageCount;
    private int mCurrentPage;
    private int mGravity = 51;
    private float mTabWidth;
    private float mTabHeight;
    private float mTabSpacing;
    private Paint mPrevTabPaint;
    private Paint mSelectedTabPaint;
    private Paint mSelectedLastTabPaint;
    private Paint mNextTabPaint;
    private RectF mTempRectF = new RectF();
    private OnPageSelectedListener mOnPageSelectedListener;

    public StepPagerStrip(Context context) {
        this(context, null, 0);
    }

    public StepPagerStrip(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StepPagerStrip(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, ATTRS);
        this.mGravity = a.getInteger(0, this.mGravity);
        a.recycle();
        Resources res = this.getResources();
        this.mTabWidth = res.getDimensionPixelSize(R.dimen.step_pager_tab_width);
        this.mTabHeight = res.getDimensionPixelSize(R.dimen.step_pager_tab_height);
        this.mTabSpacing = res.getDimensionPixelSize(R.dimen.step_pager_tab_spacing);
        this.mPrevTabPaint = new Paint();
        this.mPrevTabPaint.setColor(res.getColor(R.color.step_pager_previous_tab_color));
        this.mSelectedTabPaint = new Paint();
        this.mSelectedTabPaint.setColor(res.getColor(R.color.step_pager_selected_tab_color));
        this.mSelectedLastTabPaint = new Paint();
        this.mSelectedLastTabPaint.setColor(res.getColor(R.color.step_pager_selected_last_tab_color));
        this.mNextTabPaint = new Paint();
        this.mNextTabPaint.setColor(res.getColor(R.color.step_pager_next_tab_color));
    }

    public void setOnPageSelectedListener(OnPageSelectedListener onPageSelectedListener) {
        this.mOnPageSelectedListener = onPageSelectedListener;
    }

    protected void onDraw(Canvas canvas) {
        float totalLeft;
        super.onDraw(canvas);
        if (this.mPageCount == 0) {
            return;
        }
        float totalWidth = (float)this.mPageCount * (this.mTabWidth + this.mTabSpacing) - this.mTabSpacing;
        boolean fillHorizontal = false;
        switch (this.mGravity & 7) {
            case 1: {
                totalLeft = ((float)this.getWidth() - totalWidth) / 2.0f;
                break;
            }
            case 5: {
                totalLeft = (float)(this.getWidth() - this.getPaddingRight()) - totalWidth;
                break;
            }
            case 7: {
                totalLeft = this.getPaddingLeft();
                fillHorizontal = true;
                break;
            }
            default: {
                totalLeft = this.getPaddingLeft();
            }
        }
        switch (this.mGravity & 0x70) {
            case 16: {
                this.mTempRectF.top = (int)((float)this.getHeight() - this.mTabHeight) / 2;
                break;
            }
            case 80: {
                this.mTempRectF.top = (float)(this.getHeight() - this.getPaddingBottom()) - this.mTabHeight;
                break;
            }
            default: {
                this.mTempRectF.top = this.getPaddingTop();
            }
        }
        this.mTempRectF.bottom = this.mTempRectF.top + this.mTabHeight;
        float tabWidth = this.mTabWidth;
        if (fillHorizontal) {
            tabWidth = ((float)(this.getWidth() - this.getPaddingRight() - this.getPaddingLeft()) - (float)(this.mPageCount - 1) * this.mTabSpacing) / (float)this.mPageCount;
        }
        for (int i = 0; i < this.mPageCount; ++i) {
            this.mTempRectF.left = totalLeft + (float)i * (tabWidth + this.mTabSpacing);
            this.mTempRectF.right = this.mTempRectF.left + tabWidth;
            canvas.drawRect(this.mTempRectF, i < this.mCurrentPage ? this.mPrevTabPaint : (i > this.mCurrentPage ? this.mNextTabPaint : (i == this.mPageCount - 1 ? this.mSelectedLastTabPaint : this.mSelectedTabPaint)));
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.resolveSize((int)((int)((float)this.mPageCount * (this.mTabWidth + this.mTabSpacing) - this.mTabSpacing) + this.getPaddingLeft() + this.getPaddingRight()), (int)widthMeasureSpec), View.resolveSize((int)((int)this.mTabHeight + this.getPaddingTop() + this.getPaddingBottom()), (int)heightMeasureSpec));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.scrollCurrentPageIntoView();
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mOnPageSelectedListener != null) {
            switch (event.getActionMasked()) {
                case 0: 
                case 2: {
                    int position = this.hitTest(event.getX());
                    if (position >= 0) {
                        this.mOnPageSelectedListener.onPageStripSelected(position);
                    }
                    return true;
                }
            }
        }
        return super.onTouchEvent(event);
    }

    private int hitTest(float x) {
        float totalLeft;
        if (this.mPageCount == 0) {
            return -1;
        }
        float totalWidth = (float)this.mPageCount * (this.mTabWidth + this.mTabSpacing) - this.mTabSpacing;
        boolean fillHorizontal = false;
        switch (this.mGravity & 7) {
            case 1: {
                totalLeft = ((float)this.getWidth() - totalWidth) / 2.0f;
                break;
            }
            case 5: {
                totalLeft = (float)(this.getWidth() - this.getPaddingRight()) - totalWidth;
                break;
            }
            case 7: {
                totalLeft = this.getPaddingLeft();
                fillHorizontal = true;
                break;
            }
            default: {
                totalLeft = this.getPaddingLeft();
            }
        }
        float tabWidth = this.mTabWidth;
        if (fillHorizontal) {
            tabWidth = ((float)(this.getWidth() - this.getPaddingRight() - this.getPaddingLeft()) - (float)(this.mPageCount - 1) * this.mTabSpacing) / (float)this.mPageCount;
        }
        float totalRight = totalLeft + (float)this.mPageCount * (tabWidth + this.mTabSpacing);
        if (x >= totalLeft && x <= totalRight && totalRight > totalLeft) {
            return (int)((x - totalLeft) / (totalRight - totalLeft) * (float)this.mPageCount);
        }
        return -1;
    }

    public void setCurrentPage(int currentPage) {
        this.mCurrentPage = currentPage;
        this.invalidate();
        this.scrollCurrentPageIntoView();
    }

    private void scrollCurrentPageIntoView() {
    }

    public void setPageCount(int count) {
        this.mPageCount = count;
        this.invalidate();
    }

    public static interface OnPageSelectedListener {
        public void onPageStripSelected(int var1);
    }
}

