/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.stefanodp91.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.ListFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import org.bitbucket.stefanodp91.R;
import org.bitbucket.stefanodp91.model.Page;
import org.bitbucket.stefanodp91.model.SingleFixedChoicePage;
import org.bitbucket.stefanodp91.ui.PageFragmentCallbacks;

public class SingleChoiceFragment
extends ListFragment {
    private static final String ARG_KEY = "key";
    private PageFragmentCallbacks mCallbacks;
    private List<String> mChoices;
    private String mKey;
    private Page mPage;

    public static SingleChoiceFragment create(String key) {
        Bundle args = new Bundle();
        args.putString(ARG_KEY, key);
        SingleChoiceFragment fragment = new SingleChoiceFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        this.mKey = args.getString(ARG_KEY);
        this.mPage = this.mCallbacks.onGetPage(this.mKey);
        SingleFixedChoicePage fixedChoicePage = (SingleFixedChoicePage)this.mPage;
        this.mChoices = new ArrayList<String>();
        for (int i = 0; i < fixedChoicePage.getOptionCount(); ++i) {
            this.mChoices.add(fixedChoicePage.getOptionAt(i));
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_page, container, false);
        ((TextView)rootView.findViewById(16908310)).setText((CharSequence)this.mPage.getTitle());
        final ListView listView = (ListView)rootView.findViewById(16908298);
        this.setListAdapter((ListAdapter)new ArrayAdapter((Context)this.getActivity(), 17367055, 16908308, this.mChoices));
        listView.setChoiceMode(1);
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                String selection = SingleChoiceFragment.this.mPage.getData().getString("_");
                for (int i = 0; i < SingleChoiceFragment.this.mChoices.size(); ++i) {
                    if (!((String)SingleChoiceFragment.this.mChoices.get(i)).equals(selection)) continue;
                    listView.setItemChecked(i, true);
                    break;
                }
            }
        });
        return rootView;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (!(activity instanceof PageFragmentCallbacks)) {
            throw new ClassCastException("Activity must implement PageFragmentCallbacks");
        }
        this.mCallbacks = (PageFragmentCallbacks)activity;
    }

    public void onDetach() {
        super.onDetach();
        this.mCallbacks = null;
    }

    public void onListItemClick(ListView l, View v, int position, long id2) {
        this.mPage.getData().putString("_", this.getListAdapter().getItem(position).toString());
        this.mPage.notifyDataChanged();
    }
}

