/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.stefanodp91.ui;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.ListFragment;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.bitbucket.stefanodp91.R;
import org.bitbucket.stefanodp91.model.AbstractWizardModel;
import org.bitbucket.stefanodp91.model.ModelCallbacks;
import org.bitbucket.stefanodp91.model.Page;
import org.bitbucket.stefanodp91.model.ReviewItem;
import org.bitbucket.stefanodp91.utils.ImageUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ReviewFragment
extends ListFragment
implements ModelCallbacks {
    private static final String TAG = ReviewFragment.class.getName();
    private Callbacks mCallbacks;
    private AbstractWizardModel mWizardModel;
    private List<ReviewItem> mCurrentReviewItems;
    private ReviewAdapter mReviewAdapter;
    private ImageUtils imageUtils;
    private ImageView imageView;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mReviewAdapter = new ReviewAdapter();
        this.imageUtils = new ImageUtils(this.getContext());
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_page, container, false);
        TextView titleView = (TextView)rootView.findViewById(16908310);
        titleView.setText(R.string.review);
        titleView.setTextColor(this.getResources().getColor(R.color.color_review));
        ListView listView = (ListView)rootView.findViewById(16908298);
        this.setListAdapter((ListAdapter)this.mReviewAdapter);
        listView.setChoiceMode(1);
        return rootView;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (!(activity instanceof Callbacks)) {
            throw new ClassCastException("Activity must implement fragment's callbacks");
        }
        this.imageUtils = new ImageUtils(this.getContext());
        this.mCallbacks = (Callbacks)activity;
        this.mWizardModel = this.mCallbacks.onGetModel();
        this.mWizardModel.registerListener(this);
        this.onPageTreeChanged();
    }

    @Override
    public void onPageTreeChanged() {
        this.onPageDataChanged(null);
    }

    public void onDetach() {
        super.onDetach();
        this.mCallbacks = null;
        this.imageUtils = null;
        this.mWizardModel.unregisterListener(this);
    }

    @Override
    public void onPageDataChanged(Page changedPage) {
        ArrayList<ReviewItem> reviewItems = new ArrayList<ReviewItem>();
        for (Page page : this.mWizardModel.getCurrentPageSequence()) {
            page.getReviewItems(reviewItems);
        }
        Collections.sort(reviewItems, new Comparator<ReviewItem>(){

            @Override
            public int compare(ReviewItem a, ReviewItem b) {
                return a.getWeight() > b.getWeight() ? 1 : (a.getWeight() < b.getWeight() ? -1 : 0);
            }
        });
        this.mCurrentReviewItems = reviewItems;
        if (this.mReviewAdapter != null) {
            this.mReviewAdapter.notifyDataSetInvalidated();
        }
    }

    public void onListItemClick(ListView l, View v, int position, long id2) {
        this.mCallbacks.onEditScreenAfterReview(this.mCurrentReviewItems.get(position).getPageKey());
    }

    private class ReviewAdapter
    extends BaseAdapter {
        private ReviewAdapter() {
        }

        public boolean hasStableIds() {
            return true;
        }

        public int getItemViewType(int position) {
            return 0;
        }

        public int getViewTypeCount() {
            return 1;
        }

        public boolean areAllItemsEnabled() {
            return true;
        }

        public Object getItem(int position) {
            return ReviewFragment.this.mCurrentReviewItems.get(position);
        }

        public long getItemId(int position) {
            return ((ReviewItem)ReviewFragment.this.mCurrentReviewItems.get(position)).hashCode();
        }

        public View getView(int position, View view, ViewGroup container) {
            LayoutInflater inflater = LayoutInflater.from((Context)ReviewFragment.this.getActivity());
            View rootView = inflater.inflate(R.layout.list_item_review, container, false);
            ReviewItem reviewItem = (ReviewItem)ReviewFragment.this.mCurrentReviewItems.get(position);
            String value = reviewItem.getDisplayValue();
            Log.i((String)TAG, (String)("value ======= " + value));
            if (org.bitbucket.stefanodp91.utils.TextUtils.isValis(value)) {
                try {
                    JSONObject jsonObject = new JSONObject(value);
                    String jsonType = jsonObject.getString("JSON_TYPE");
                    if (jsonType.compareTo("JSON_TYPE_MAP") == 0) {
                        String nearCity;
                        value = nearCity = jsonObject.getString("JSON_NEAR_CITY");
                        Bundle bundle = new Bundle();
                        bundle.putString("JSON_BUNDLE_MAP", jsonObject.toString());
                        reviewItem.setExtra(bundle);
                    }
                }
                catch (JSONException e) {
                    Log.e((String)TAG, (String)("setReviewButtonAction() ==> failed with JSONException. " + e.getMessage()));
                }
            }
            if (TextUtils.isEmpty((CharSequence)value)) {
                value = ReviewFragment.this.getString(R.string.no_item_selected);
            }
            ((TextView)rootView.findViewById(16908308)).setText((CharSequence)reviewItem.getTitle());
            if (ReviewFragment.this.imageUtils.isPhotoFile(value)) {
                ((TextView)rootView.findViewById(16908309)).setVisibility(8);
                ReviewFragment.this.imageView = (ImageView)rootView.findViewById(R.id.image1);
                ReviewFragment.this.imageUtils.display(ReviewFragment.this.imageView, Uri.parse((String)value));
            } else {
                ((TextView)rootView.findViewById(16908309)).setText((CharSequence)value);
            }
            return rootView;
        }

        public int getCount() {
            return ReviewFragment.this.mCurrentReviewItems.size();
        }
    }

    public static interface Callbacks {
        public AbstractWizardModel onGetModel();

        public void onEditScreenAfterReview(String var1);
    }
}

