/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.stefanodp91.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.ListFragment;
import android.util.SparseBooleanArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bitbucket.stefanodp91.R;
import org.bitbucket.stefanodp91.model.MultipleFixedChoicePage;
import org.bitbucket.stefanodp91.model.Page;
import org.bitbucket.stefanodp91.ui.PageFragmentCallbacks;

public class MultipleChoiceFragment
extends ListFragment {
    private static final String ARG_KEY = "key";
    private PageFragmentCallbacks mCallbacks;
    private String mKey;
    private List<String> mChoices;
    private Page mPage;

    public static MultipleChoiceFragment create(String key) {
        Bundle args = new Bundle();
        args.putString(ARG_KEY, key);
        MultipleChoiceFragment fragment = new MultipleChoiceFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        this.mKey = args.getString(ARG_KEY);
        this.mPage = this.mCallbacks.onGetPage(this.mKey);
        MultipleFixedChoicePage fixedChoicePage = (MultipleFixedChoicePage)this.mPage;
        this.mChoices = new ArrayList<String>();
        for (int i = 0; i < fixedChoicePage.getOptionCount(); ++i) {
            this.mChoices.add(fixedChoicePage.getOptionAt(i));
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_page, container, false);
        ((TextView)rootView.findViewById(16908310)).setText((CharSequence)this.mPage.getTitle());
        final ListView listView = (ListView)rootView.findViewById(16908298);
        this.setListAdapter((ListAdapter)new ArrayAdapter((Context)this.getActivity(), 0x1090010, 16908308, this.mChoices));
        listView.setChoiceMode(2);
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                ArrayList selectedItems = MultipleChoiceFragment.this.mPage.getData().getStringArrayList("_");
                if (selectedItems == null || selectedItems.size() == 0) {
                    return;
                }
                HashSet selectedSet = new HashSet(selectedItems);
                for (int i = 0; i < MultipleChoiceFragment.this.mChoices.size(); ++i) {
                    if (!selectedSet.contains(MultipleChoiceFragment.this.mChoices.get(i))) continue;
                    listView.setItemChecked(i, true);
                }
            }
        });
        return rootView;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (!(activity instanceof PageFragmentCallbacks)) {
            throw new ClassCastException("Activity must implement PageFragmentCallbacks");
        }
        this.mCallbacks = (PageFragmentCallbacks)activity;
    }

    public void onDetach() {
        super.onDetach();
        this.mCallbacks = null;
    }

    public void onListItemClick(ListView l, View v, int position, long id2) {
        SparseBooleanArray checkedPositions = this.getListView().getCheckedItemPositions();
        ArrayList<String> selections = new ArrayList<String>();
        for (int i = 0; i < checkedPositions.size(); ++i) {
            if (!checkedPositions.valueAt(i)) continue;
            selections.add(this.getListAdapter().getItem(checkedPositions.keyAt(i)).toString());
        }
        this.mPage.getData().putStringArrayList("_", selections);
        this.mPage.notifyDataChanged();
    }
}

