/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.stefanodp91.ui;

import android.app.Activity;
import android.content.Context;
import android.location.Address;
import android.location.Criteria;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationManager;
import android.os.Bundle;
import android.support.design.widget.Snackbar;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.places.AutocompleteFilter;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.ui.PlaceAutocompleteFragment;
import com.google.android.gms.location.places.ui.PlaceSelectionListener;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.MarkerOptions;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.bitbucket.stefanodp91.R;
import org.bitbucket.stefanodp91.model.Page;
import org.bitbucket.stefanodp91.ui.PageFragmentCallbacks;
import org.bitbucket.stefanodp91.utils.MyMapFragment;
import org.json.JSONException;
import org.json.JSONObject;

public class MapFragment
extends Fragment
implements PlaceSelectionListener,
OnMapReadyCallback {
    private static final String TAG = MapFragment.class.getName();
    protected static final String ARG_KEY = "key";
    private PageFragmentCallbacks mCallbacks;
    private String mKey;
    private Page mPage;
    private static final int MAX_RESULTS_NUMBER = 1;
    private static final String LAT = "LAT";
    private static final String LNG = "LNG";
    private static final int MAP_ANIMATION_DURATION = 1000;
    private static final int MAP_ZOOM = 10;
    private PlaceAutocompleteFragment autocompleteFragment;
    private MyMapFragment mapFragment;
    private MapHelper mapHelper;
    private static View rootView;

    public static MapFragment create(String key) {
        Bundle args = new Bundle();
        args.putString(ARG_KEY, key);
        MapFragment f = new MapFragment();
        f.setArguments(args);
        return f;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        this.mKey = args.getString(ARG_KEY);
        this.mPage = this.mCallbacks.onGetPage(this.mKey);
        this.mapHelper = new MapHelper(this.getContext());
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        ViewGroup parent;
        if (rootView != null && (parent = (ViewGroup)rootView.getParent()) != null) {
            parent.removeView(rootView);
        }
        try {
            rootView = inflater.inflate(R.layout.fragment_page_map, container, false);
        }
        catch (InflateException e) {
            Log.e((String)TAG, (String)("onCreateView() ==> failed with InflateException. " + e.getMessage()));
        }
        return rootView;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        ((TextView)view.findViewById(16908310)).setText((CharSequence)this.mPage.getTitle());
        this.mapFragment = (MyMapFragment)this.getActivity().getFragmentManager().findFragmentById(R.id.map);
        this.mapFragment.getMapAsync(this);
        this.autocompleteFragment = (PlaceAutocompleteFragment)this.getActivity().getFragmentManager().findFragmentById(R.id.place_autocomplete_fragment);
        AutocompleteFilter typeFilter = new AutocompleteFilter.Builder().setTypeFilter(5).build();
        this.autocompleteFragment.setFilter(typeFilter);
        this.autocompleteFragment.setOnPlaceSelectedListener((PlaceSelectionListener)this);
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (!(activity instanceof PageFragmentCallbacks)) {
            throw new ClassCastException("Activity must implement PageFragmentCallbacks");
        }
        this.mCallbacks = (PageFragmentCallbacks)activity;
    }

    public void onDetach() {
        super.onDetach();
        this.mCallbacks = null;
    }

    public void onMapReady(GoogleMap map) {
        if (map != null) {
            map.clear();
            Bundle arguments = this.mapFragment.getDatas();
            String nearCity = "";
            if (arguments != null) {
                double lat = arguments.getDouble(LAT);
                double lng = arguments.getDouble(LNG);
                try {
                    nearCity = this.mapHelper.getNearCity(lat, lng);
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("updateButtonsStatus(...) ==> failed with IOException." + e.getMessage()));
                }
                LatLng placePosition = new LatLng(lat, lng);
                CameraPosition position = this.mapHelper.setCameraPosition(placePosition, 10);
                map.addMarker(new MarkerOptions().position(placePosition).title(nearCity));
                map.animateCamera(CameraUpdateFactory.newCameraPosition((CameraPosition)position), 1000, null);
                this.updateLocation(placePosition, nearCity);
            } else {
                Log.i((String)TAG, (String)"onMapReady(...) ==> arguments is null");
                map.setMyLocationEnabled(true);
                LocationManager locationManager = (LocationManager)this.getActivity().getSystemService("location");
                Criteria criteria = new Criteria();
                String provider = locationManager.getBestProvider(criteria, true);
                Location location = locationManager.getLastKnownLocation(provider);
                if (location != null) {
                    double lat = location.getLatitude();
                    double lng = location.getLongitude();
                    LatLng placePosition = new LatLng(lat, lng);
                    CameraPosition position = this.mapHelper.setCameraPosition(placePosition, 10);
                    try {
                        nearCity = this.mapHelper.getNearCity(lat, lng);
                    }
                    catch (IOException e) {
                        Log.e((String)TAG, (String)("updateButtonsStatus(...) ==> failed with IOException." + e.getMessage()));
                    }
                    map.addMarker(new MarkerOptions().position(placePosition).title(nearCity));
                    map.animateCamera(CameraUpdateFactory.newCameraPosition((CameraPosition)position), 1000, null);
                    this.updateSuggestion(nearCity);
                    this.updateLocation(placePosition, nearCity);
                }
            }
        } else {
            Log.e((String)TAG, (String)"onMapReady(...) ==> map is null");
        }
    }

    public void onPlaceSelected(Place place) {
        if (place.isDataValid()) {
            Log.i((String)TAG, (String)("onPlaceSelected(...) ==> placeName ==  " + place.getName()));
            try {
                this.showMap(place);
            }
            catch (GooglePlayServicesRepairableException e) {
                Log.e((String)TAG, (String)("onPlaceSelected(...) ==> failed with GooglePlayServicesRepairableException. " + e.getMessage()));
            }
            catch (GooglePlayServicesNotAvailableException e) {
                Log.e((String)TAG, (String)("onPlaceSelected(...) ==> failed with GooglePlayServicesNotAvailableException. " + e.getMessage()));
            }
        } else {
            Log.e((String)TAG, (String)"onPlaceSelected(...) ==> place is null");
        }
    }

    public void onError(Status status) {
        Log.e((String)TAG, (String)("onError(...) ==> status == " + status.toString()));
        Snackbar.make((View)this.getActivity().findViewById(0x1020002), (CharSequence)("Place selection failed: " + status.getStatusMessage()), (int)-1).show();
    }

    private void showMap(Place place) throws GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        LatLng latLng = place.getLatLng();
        double lat = latLng.latitude;
        double lng = latLng.longitude;
        Bundle arguments = new Bundle();
        arguments.putDouble(LAT, lat);
        arguments.putDouble(LNG, lng);
        this.mapFragment.setDatas(arguments);
        this.mapFragment.getMapAsync(this);
    }

    private void updateSuggestion(String suggestion) {
        this.autocompleteFragment.setText((CharSequence)suggestion);
    }

    private void updateLocation(LatLng latLng, String nearCity) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("JSON_TYPE", (Object)"JSON_TYPE_MAP");
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("updateLocation() ==> JSON_TYPE failed with JSONException. " + e.getMessage()));
        }
        try {
            jsonObject.put("JSON_NEAR_CITY", (Object)nearCity);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("updateLocation() ==> NEAR_CITY failed with JSONException. " + e.getMessage()));
        }
        try {
            jsonObject.put("JSON_LAT", latLng.latitude);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("updateLocation() ==> JSON_LAT failed with JSONException. " + e.getMessage()));
        }
        try {
            jsonObject.put("JSON_LNG", latLng.longitude);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("updateLocation() ==> JSON_LNG failed with JSONException. " + e.getMessage()));
        }
        this.mPage.getData().putString("_", jsonObject.toString());
        this.mPage.notifyDataChanged();
    }

    private static class MapHelper {
        private Context context;

        public MapHelper(Context context) {
            this.context = context;
        }

        public String getNearCity(double lat, double lng) throws IOException {
            String nearCity = "";
            Geocoder geocoder = new Geocoder(this.context, Locale.getDefault());
            List addresses = geocoder.getFromLocation(lat, lng, 1);
            if (addresses.size() > 0) {
                nearCity = ((Address)addresses.get(0)).getLocality();
                Log.i((String)TAG, (String)("getNearCity(...) ==> nearCity == " + ((Address)addresses.get(0)).getLocality()));
            }
            return nearCity;
        }

        public CameraPosition setCameraPosition(LatLng position, int zoom) {
            return CameraPosition.builder().target(position).zoom((float)zoom).bearing(0.0f).tilt(45.0f).build();
        }
    }
}

