/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.stefanodp91.ui;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.io.File;
import org.bitbucket.stefanodp91.R;
import org.bitbucket.stefanodp91.model.Page;
import org.bitbucket.stefanodp91.ui.PageFragmentCallbacks;
import org.bitbucket.stefanodp91.utils.ImageUtils;

public class ImageFragment
extends Fragment
implements View.OnClickListener {
    private static final String TAG = ImageFragment.class.getName();
    private static final String NEW_IMAGE_URI = "new_image_uri";
    private static final int GALLERY_REQUEST_CODE = 0;
    private static final int CAMERA_REQUEST_CODE = 1;
    protected static final String ARG_KEY = "key";
    private File photoFile = null;
    private PageFragmentCallbacks mCallbacks;
    private String mKey;
    private Page mPage;
    private ImageView imageView;
    private LinearLayout boxImagePreview;
    private Button cameraBtn;
    private Button galleryBtn;
    private Uri mNewImageUri;
    private ImageUtils imageUtils;

    public static ImageFragment create(String key) {
        Bundle args = new Bundle();
        args.putString(ARG_KEY, key);
        ImageFragment f = new ImageFragment();
        f.setArguments(args);
        return f;
    }

    public void onCreate(Bundle savedInstanceState) {
        String uriString;
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        this.mKey = args.getString(ARG_KEY);
        this.mPage = this.mCallbacks.onGetPage(this.mKey);
        if (savedInstanceState != null && !TextUtils.isEmpty((CharSequence)(uriString = savedInstanceState.getString(NEW_IMAGE_URI)))) {
            this.mNewImageUri = Uri.parse((String)uriString);
        }
        this.imageUtils = new ImageUtils(this.getContext());
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mNewImageUri != null) {
            outState.putString(NEW_IMAGE_URI, this.mNewImageUri.toString());
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_page_image, container, false);
        ((TextView)rootView.findViewById(16908310)).setText((CharSequence)this.mPage.getTitle());
        this.cameraBtn = (Button)rootView.findViewById(R.id.camera_btn);
        this.cameraBtn.setOnClickListener((View.OnClickListener)this);
        this.galleryBtn = (Button)rootView.findViewById(R.id.gallery_btn);
        this.galleryBtn.setOnClickListener((View.OnClickListener)this);
        this.boxImagePreview = (LinearLayout)rootView.findViewById(R.id.box_image_preview);
        this.imageView = (ImageView)rootView.findViewById(R.id.imageView);
        String imageData = this.mPage.getData().getString("_");
        if (!TextUtils.isEmpty((CharSequence)imageData)) {
            Uri imageUri = Uri.parse((String)imageData);
            this.boxImagePreview.setVisibility(0);
            this.imageUtils.display(this.imageView, imageUri);
        } else {
            this.imageView.setImageResource(R.drawable.ic_person);
        }
        return rootView;
    }

    private void dispatchTakePictureFromGalleryIntent() {
        Intent intent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        this.photoFile = this.imageUtils.createImageFile();
        this.mNewImageUri = Uri.fromFile((File)this.photoFile);
        if (this.photoFile != null) {
            this.startActivityForResult(intent, 0);
        }
    }

    private void dispatchTakePictureIntent() {
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(this.getActivity().getPackageManager()) != null) {
            File photoFile = this.imageUtils.createImageFile();
            this.mNewImageUri = Uri.fromFile((File)photoFile);
            if (photoFile != null) {
                takePictureIntent.putExtra("output", (Parcelable)Uri.fromFile((File)photoFile));
                this.startActivityForResult(takePictureIntent, 1);
            }
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (!(activity instanceof PageFragmentCallbacks)) {
            throw new ClassCastException("Activity must implement PageFragmentCallbacks");
        }
        this.mCallbacks = (PageFragmentCallbacks)activity;
        this.imageUtils = new ImageUtils(this.getContext());
    }

    public void onDetach() {
        super.onDetach();
        this.mCallbacks = null;
        this.imageUtils = null;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            this.boxImagePreview.setVisibility(0);
            if (requestCode == 1) {
                Log.d((String)TAG, (String)"onActivityResult() ==> photo has been taken with success");
            } else if (requestCode == 0) {
                Log.d((String)TAG, (String)"onActivityResult() ==> photo has been picked from gallery with success");
                this.imageUtils.loadBitmap(data, this.photoFile);
                this.mNewImageUri = Uri.parse((String)this.photoFile.getAbsolutePath());
            }
            this.imageUtils.display(this.imageView, this.mNewImageUri);
            this.writeResult();
        } else {
            Log.e((String)TAG, (String)"onActivityResult(...) ==> resultCode != Activity.RESULT_OK");
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    private void writeResult() {
        this.mPage.getData().putString("_", this.mNewImageUri != null ? this.mNewImageUri.toString() : null);
        this.mPage.notifyDataChanged();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == this.cameraBtn.getId()) {
            this.dispatchTakePictureIntent();
        } else if (id2 == this.galleryBtn.getId()) {
            this.dispatchTakePictureFromGalleryIntent();
        } else {
            Log.e((String)TAG, (String)"onClick(...) default action");
        }
    }
}

