/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.stefanodp91.ui;

import android.app.Activity;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import org.bitbucket.stefanodp91.R;
import org.bitbucket.stefanodp91.model.CustomerInfoPage;
import org.bitbucket.stefanodp91.ui.PageFragmentCallbacks;

public class CustomerInfoFragment
extends Fragment {
    private static final String ARG_KEY = "key";
    private PageFragmentCallbacks mCallbacks;
    private String mKey;
    private CustomerInfoPage mPage;
    private TextView mNameView;
    private TextView mEmailView;

    public static CustomerInfoFragment create(String key) {
        Bundle args = new Bundle();
        args.putString(ARG_KEY, key);
        CustomerInfoFragment fragment = new CustomerInfoFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        this.mKey = args.getString(ARG_KEY);
        this.mPage = (CustomerInfoPage)this.mCallbacks.onGetPage(this.mKey);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_page_customer_info, container, false);
        ((TextView)rootView.findViewById(16908310)).setText((CharSequence)this.mPage.getTitle());
        this.mNameView = (TextView)rootView.findViewById(R.id.your_name);
        this.mNameView.setText((CharSequence)this.mPage.getData().getString("name"));
        this.mEmailView = (TextView)rootView.findViewById(R.id.your_email);
        this.mEmailView.setText((CharSequence)this.mPage.getData().getString("email"));
        return rootView;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (!(activity instanceof PageFragmentCallbacks)) {
            throw new ClassCastException("Activity must implement PageFragmentCallbacks");
        }
        this.mCallbacks = (PageFragmentCallbacks)activity;
    }

    public void onDetach() {
        super.onDetach();
        this.mCallbacks = null;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mNameView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                CustomerInfoFragment.this.mPage.getData().putString("name", editable != null ? editable.toString() : null);
                CustomerInfoFragment.this.mPage.notifyDataChanged();
            }
        });
        this.mEmailView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                CustomerInfoFragment.this.mPage.getData().putString("email", editable != null ? editable.toString() : null);
                CustomerInfoFragment.this.mPage.notifyDataChanged();
            }
        });
    }

    public void setMenuVisibility(boolean menuVisible) {
        super.setMenuVisibility(menuVisible);
        if (this.mNameView != null) {
            InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
            if (!menuVisible) {
                imm.hideSoftInputFromWindow(this.getView().getWindowToken(), 0);
            }
        }
    }
}

