/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.stefanodp91.model;

import android.support.v4.app.Fragment;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.bitbucket.stefanodp91.model.ModelCallbacks;
import org.bitbucket.stefanodp91.model.Page;
import org.bitbucket.stefanodp91.model.ReviewItem;
import org.bitbucket.stefanodp91.ui.SingleChoiceFragment;

public class SingleFixedChoicePage
extends Page {
    protected ArrayList<String> mChoices = new ArrayList();

    public SingleFixedChoicePage(ModelCallbacks callbacks, String title) {
        super(callbacks, title);
    }

    @Override
    public Fragment createFragment() {
        return SingleChoiceFragment.create(this.getKey());
    }

    public String getOptionAt(int position) {
        return this.mChoices.get(position);
    }

    public int getOptionCount() {
        return this.mChoices.size();
    }

    @Override
    public void getReviewItems(ArrayList<ReviewItem> dest) {
        dest.add(new ReviewItem(this.getTitle(), this.mData.getString("_"), this.getKey()));
    }

    @Override
    public boolean isCompleted() {
        return !TextUtils.isEmpty((CharSequence)this.mData.getString("_"));
    }

    public SingleFixedChoicePage setChoices(String ... choices) {
        this.mChoices.addAll(Arrays.asList(choices));
        return this;
    }

    public SingleFixedChoicePage setValue(String value) {
        this.mData.putString("_", value);
        return this;
    }
}

