/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.stefanodp91.model;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import java.util.ArrayList;
import org.bitbucket.stefanodp91.model.ModelCallbacks;
import org.bitbucket.stefanodp91.model.PageTreeNode;
import org.bitbucket.stefanodp91.model.ReviewItem;

public abstract class Page
implements PageTreeNode {
    public static final String SIMPLE_DATA_KEY = "_";
    protected ModelCallbacks mCallbacks;
    protected Bundle mData = new Bundle();
    protected String mTitle;
    protected boolean mRequired = false;
    protected String mParentKey;

    protected Page(ModelCallbacks callbacks, String title) {
        this.mCallbacks = callbacks;
        this.mTitle = title;
    }

    public Bundle getData() {
        return this.mData;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public boolean isRequired() {
        return this.mRequired;
    }

    void setParentKey(String parentKey) {
        this.mParentKey = parentKey;
    }

    @Override
    public Page findByKey(String key) {
        return this.getKey().equals(key) ? this : null;
    }

    @Override
    public void flattenCurrentPageSequence(ArrayList<Page> dest) {
        dest.add(this);
    }

    public abstract Fragment createFragment();

    public String getKey() {
        return this.mParentKey != null ? this.mParentKey + ":" + this.mTitle : this.mTitle;
    }

    public abstract void getReviewItems(ArrayList<ReviewItem> var1);

    public boolean isCompleted() {
        return true;
    }

    public void resetData(Bundle data) {
        this.mData = data;
        this.notifyDataChanged();
    }

    public void notifyDataChanged() {
        this.mCallbacks.onPageDataChanged(this);
    }

    public Page setRequired(boolean required) {
        this.mRequired = required;
        return this;
    }
}

