/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.stefanodp91.model;

import android.support.v4.app.Fragment;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.bitbucket.stefanodp91.model.ModelCallbacks;
import org.bitbucket.stefanodp91.model.Page;
import org.bitbucket.stefanodp91.model.PageList;
import org.bitbucket.stefanodp91.model.ReviewItem;
import org.bitbucket.stefanodp91.model.SingleFixedChoicePage;
import org.bitbucket.stefanodp91.ui.SingleChoiceFragment;

public class BranchPage
extends SingleFixedChoicePage {
    private List<Branch> mBranches = new ArrayList<Branch>();

    public BranchPage(ModelCallbacks callbacks, String title) {
        super(callbacks, title);
    }

    @Override
    public Page findByKey(String key) {
        if (this.getKey().equals(key)) {
            return this;
        }
        for (Branch branch : this.mBranches) {
            Page found = branch.childPageList.findByKey(key);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public void flattenCurrentPageSequence(ArrayList<Page> destination) {
        super.flattenCurrentPageSequence(destination);
        for (Branch branch : this.mBranches) {
            if (!branch.choice.equals(this.mData.getString("_"))) continue;
            branch.childPageList.flattenCurrentPageSequence(destination);
            break;
        }
    }

    public BranchPage addBranch(String choice, Page ... childPages) {
        PageList childPageList = new PageList(childPages);
        for (Page page : childPageList) {
            page.setParentKey(choice);
        }
        this.mBranches.add(new Branch(choice, childPageList));
        return this;
    }

    @Override
    public Fragment createFragment() {
        return SingleChoiceFragment.create(this.getKey());
    }

    @Override
    public String getOptionAt(int position) {
        return this.mBranches.get((int)position).choice;
    }

    @Override
    public int getOptionCount() {
        return this.mBranches.size();
    }

    @Override
    public void getReviewItems(ArrayList<ReviewItem> dest) {
        dest.add(new ReviewItem(this.getTitle(), this.mData.getString("_"), this.getKey()));
    }

    @Override
    public boolean isCompleted() {
        return !TextUtils.isEmpty((CharSequence)this.mData.getString("_"));
    }

    @Override
    public void notifyDataChanged() {
        this.mCallbacks.onPageTreeChanged();
        super.notifyDataChanged();
    }

    @Override
    public BranchPage setValue(String value) {
        this.mData.putString("_", value);
        return this;
    }

    private static class Branch {
        public String choice;
        public PageList childPageList;

        private Branch(String choice, PageList childPageList) {
            this.choice = choice;
            this.childPageList = childPageList;
        }
    }
}

