/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.stefanodp91.model;

import android.content.Context;
import android.os.Bundle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.bitbucket.stefanodp91.model.ModelCallbacks;
import org.bitbucket.stefanodp91.model.Page;
import org.bitbucket.stefanodp91.model.PageList;

public abstract class AbstractWizardModel
implements ModelCallbacks,
Serializable {
    protected Context mContext;
    private List<ModelCallbacks> mListeners = new ArrayList<ModelCallbacks>();
    private PageList mRootPageList;

    public AbstractWizardModel(Context context) {
        this.mContext = context;
        this.mRootPageList = this.onNewRootPageList();
    }

    protected abstract PageList onNewRootPageList();

    @Override
    public void onPageDataChanged(Page page) {
        for (int i = 0; i < this.mListeners.size(); ++i) {
            this.mListeners.get(i).onPageDataChanged(page);
        }
    }

    @Override
    public void onPageTreeChanged() {
        for (int i = 0; i < this.mListeners.size(); ++i) {
            this.mListeners.get(i).onPageTreeChanged();
        }
    }

    public Page findByKey(String key) {
        return this.mRootPageList.findByKey(key);
    }

    public void load(Bundle savedValues) {
        for (String key : savedValues.keySet()) {
            this.mRootPageList.findByKey(key).resetData(savedValues.getBundle(key));
        }
    }

    public void registerListener(ModelCallbacks listener) {
        this.mListeners.add(listener);
    }

    public Bundle save() {
        Bundle bundle = new Bundle();
        for (Page page : this.getCurrentPageSequence()) {
            bundle.putBundle(page.getKey(), page.getData());
        }
        return bundle;
    }

    public List<Page> getCurrentPageSequence() {
        ArrayList<Page> flattened = new ArrayList<Page>();
        this.mRootPageList.flattenCurrentPageSequence(flattened);
        return flattened;
    }

    public void unregisterListener(ModelCallbacks listener) {
        this.mListeners.remove(listener);
    }
}

