/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.stefanodp91;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import java.util.ArrayList;
import java.util.List;
import org.bitbucket.stefanodp91.R;
import org.bitbucket.stefanodp91.model.AbstractWizardModel;
import org.bitbucket.stefanodp91.model.ModelCallbacks;
import org.bitbucket.stefanodp91.model.Page;
import org.bitbucket.stefanodp91.model.ReviewItem;
import org.bitbucket.stefanodp91.ui.PageFragmentCallbacks;
import org.bitbucket.stefanodp91.ui.ReviewFragment;
import org.bitbucket.stefanodp91.ui.StepPagerStrip;

public abstract class WizardActivity
extends FragmentActivity
implements PageFragmentCallbacks,
ReviewFragment.Callbacks,
ModelCallbacks,
View.OnClickListener {
    private static final String TAG = WizardActivity.class.getName();
    private ViewPager mPager;
    private MyPagerAdapter mPagerAdapter;
    private boolean mEditingAfterReview;
    private AbstractWizardModel mWizardModel;
    private boolean mConsumePageSelectedEvent;
    private Button mNextButton;
    private Button mPrevButton;
    private List<Page> mCurrentPageSequence;
    private StepPagerStrip mStepPagerStrip;

    protected void initWizard(AbstractWizardModel mWizardModel) {
        this.mWizardModel = mWizardModel;
        mWizardModel.registerListener(this);
        this.mPagerAdapter = new MyPagerAdapter(this.getSupportFragmentManager());
        this.mPager = (ViewPager)this.findViewById(R.id.pager);
        this.mPager.setAdapter((PagerAdapter)this.mPagerAdapter);
        this.mStepPagerStrip = (StepPagerStrip)this.findViewById(R.id.strip);
        this.mStepPagerStrip.setOnPageSelectedListener(new StepPagerStrip.OnPageSelectedListener(){

            @Override
            public void onPageStripSelected(int position) {
                position = Math.min(WizardActivity.this.mPagerAdapter.getCount() - 1, position);
                if (WizardActivity.this.mPager.getCurrentItem() != position) {
                    WizardActivity.this.mPager.setCurrentItem(position);
                }
            }
        });
        this.mNextButton = (Button)this.findViewById(R.id.next_button);
        this.mPrevButton = (Button)this.findViewById(R.id.prev_button);
        this.mPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int position) {
                WizardActivity.this.mStepPagerStrip.setCurrentPage(position);
                if (WizardActivity.this.mConsumePageSelectedEvent) {
                    WizardActivity.this.mConsumePageSelectedEvent = false;
                    return;
                }
                WizardActivity.this.mEditingAfterReview = false;
                WizardActivity.this.updateBottomBar();
            }
        });
        this.mNextButton.setOnClickListener((View.OnClickListener)this);
        this.mPrevButton.setOnClickListener((View.OnClickListener)this);
        this.onPageTreeChanged();
        this.updateBottomBar();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == this.mNextButton.getId()) {
            this.nextButtonAction();
        } else if (id2 == this.mPrevButton.getId()) {
            this.prevButtonAction();
        } else {
            Log.e((String)TAG, (String)"default action click");
        }
    }

    private void prevButtonAction() {
        this.mPager.setCurrentItem(this.mPager.getCurrentItem() - 1);
    }

    private void nextButtonAction() {
        if (this.mPager.getCurrentItem() == this.mCurrentPageSequence.size()) {
            this.setReviewButtonAction();
        } else if (this.mEditingAfterReview) {
            this.mPager.setCurrentItem(this.mPagerAdapter.getCount() - 1);
        } else {
            this.mPager.setCurrentItem(this.mPager.getCurrentItem() + 1);
        }
    }

    protected void setReviewButtonAction() {
        DialogFragment dg = new DialogFragment(){

            public Dialog onCreateDialog(Bundle savedInstanceState) {
                return new AlertDialog.Builder((Context)this.getActivity()).setMessage(R.string.submit_confirm_message).setPositiveButton(R.string.submit_confirm_button, null).setNegativeButton(0x1040000, null).create();
            }
        };
        dg.show(this.getSupportFragmentManager(), "place_order_dialog");
    }

    protected List<ReviewItem> getReviewItems() {
        ArrayList<ReviewItem> mList = new ArrayList<ReviewItem>();
        for (Page page : this.mCurrentPageSequence) {
            page.getReviewItems(mList);
        }
        return mList;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_main);
        if (savedInstanceState != null) {
            this.mWizardModel.load(savedInstanceState.getBundle("model"));
            this.initWizard(this.mWizardModel);
        }
    }

    @Override
    public void onPageTreeChanged() {
        this.mCurrentPageSequence = this.mWizardModel.getCurrentPageSequence();
        this.recalculateCutOffPage();
        this.mStepPagerStrip.setPageCount(this.mCurrentPageSequence.size() + 1);
        this.mPagerAdapter.notifyDataSetChanged();
        this.updateBottomBar();
    }

    private void updateBottomBar() {
        int position = this.mPager.getCurrentItem();
        if (position == this.mCurrentPageSequence.size()) {
            this.mNextButton.setText(R.string.finish);
            this.mNextButton.setBackgroundResource(R.drawable.footer_button_save_selector);
            this.mNextButton.setTextAppearance((Context)this, R.style.TextAppearanceFinish);
        } else {
            this.mNextButton.setTextAppearance((Context)this, R.style.TextAppearanceNext);
            this.mNextButton.setText(this.mEditingAfterReview ? R.string.review : R.string.next);
            if (this.mNextButton.getText().toString().compareToIgnoreCase(this.getString(R.string.review)) == 0) {
                this.mNextButton.setBackgroundResource(R.drawable.footer_button_save_selector);
                this.mNextButton.setTextAppearance((Context)this, R.style.TextAppearanceFinish);
            } else {
                this.mNextButton.setBackgroundResource(R.drawable.footer_button_next_selector);
            }
            this.mNextButton.setEnabled(position != this.mPagerAdapter.getCutOffPage());
        }
        this.mPrevButton.setVisibility(position <= 0 ? 4 : 0);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mWizardModel.unregisterListener(this);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBundle("model", this.mWizardModel.save());
    }

    @Override
    public AbstractWizardModel onGetModel() {
        return this.mWizardModel;
    }

    @Override
    public void onEditScreenAfterReview(String key) {
        for (int i = this.mCurrentPageSequence.size() - 1; i >= 0; --i) {
            if (!this.mCurrentPageSequence.get(i).getKey().equals(key)) continue;
            this.mConsumePageSelectedEvent = true;
            this.mEditingAfterReview = true;
            this.mPager.setCurrentItem(i);
            this.updateBottomBar();
            break;
        }
    }

    @Override
    public void onPageDataChanged(Page page) {
        if (page.isRequired() && this.recalculateCutOffPage()) {
            this.mPagerAdapter.notifyDataSetChanged();
            this.updateBottomBar();
        }
    }

    @Override
    public Page onGetPage(String key) {
        return this.mWizardModel.findByKey(key);
    }

    private boolean recalculateCutOffPage() {
        int cutOffPage = this.mCurrentPageSequence.size() + 1;
        for (int i = 0; i < this.mCurrentPageSequence.size(); ++i) {
            Page page = this.mCurrentPageSequence.get(i);
            if (!page.isRequired() || page.isCompleted()) continue;
            cutOffPage = i;
            break;
        }
        if (this.mPagerAdapter.getCutOffPage() != cutOffPage) {
            this.mPagerAdapter.setCutOffPage(cutOffPage);
            return true;
        }
        return false;
    }

    public class MyPagerAdapter
    extends FragmentStatePagerAdapter {
        private int mCutOffPage;
        private Fragment mPrimaryItem;

        public MyPagerAdapter(FragmentManager fm) {
            super(fm);
        }

        public Fragment getItem(int i) {
            if (i >= WizardActivity.this.mCurrentPageSequence.size()) {
                return new ReviewFragment();
            }
            return ((Page)WizardActivity.this.mCurrentPageSequence.get(i)).createFragment();
        }

        public int getItemPosition(Object object) {
            if (object == this.mPrimaryItem) {
                return -1;
            }
            return -2;
        }

        public void setPrimaryItem(ViewGroup container, int position, Object object) {
            super.setPrimaryItem(container, position, object);
            this.mPrimaryItem = (Fragment)object;
        }

        public int getCount() {
            return Math.min(this.mCutOffPage + 1, WizardActivity.this.mCurrentPageSequence == null ? 1 : WizardActivity.this.mCurrentPageSequence.size() + 1);
        }

        public void setCutOffPage(int cutOffPage) {
            if (cutOffPage < 0) {
                cutOffPage = Integer.MAX_VALUE;
            }
            this.mCutOffPage = cutOffPage;
        }

        public int getCutOffPage() {
            return this.mCutOffPage;
        }
    }
}

