/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.gt_tech.spring.data.querydsl.value.operators.experimental;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.ExpressionProviderFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.web.querydsl.QuerydslPredicateArgumentResolver;

public class QuerydslPredicateArgumentResolverBeanPostProcessor
implements BeanPostProcessor {
    private final QuerydslBindingsFactory querydslBindingsFactory;
    private final ConversionService conversionServiceDelegate;
    private final Class[] delegatedConversions;
    private final ConversionService delegationAwareConversionService = new ConversionService(){

        public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
            if (this.isDelegatedConversion(sourceType) || this.isDelegatedConversion(targetType)) {
                return QuerydslPredicateArgumentResolverBeanPostProcessor.this.conversionServiceDelegate.canConvert(sourceType, targetType);
            }
            return false;
        }

        public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (this.isDelegatedConversion(sourceType.getType()) || this.isDelegatedConversion(targetType.getType())) {
                return QuerydslPredicateArgumentResolverBeanPostProcessor.this.conversionServiceDelegate.canConvert(sourceType, targetType);
            }
            return false;
        }

        public <T> T convert(Object source, Class<T> targetType) {
            if (this.isDelegatedConversion(source.getClass()) || this.isDelegatedConversion(targetType)) {
                return (T)QuerydslPredicateArgumentResolverBeanPostProcessor.this.conversionServiceDelegate.convert(source, targetType);
            }
            throw new UnsupportedOperationException("Overridden ConversionService in QuerydslPredicateArgumentResolver does not support conversion");
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (this.isDelegatedConversion(sourceType.getType()) || this.isDelegatedConversion(targetType.getType())) {
                return QuerydslPredicateArgumentResolverBeanPostProcessor.this.conversionServiceDelegate.convert(source, sourceType, targetType);
            }
            throw new UnsupportedOperationException("Overridden ConversionService in QuerydslPredicateArgumentResolver does not support conversion");
        }

        private boolean isDelegatedConversion(Class<?> type) {
            boolean result = false;
            if (QuerydslPredicateArgumentResolverBeanPostProcessor.this.conversionServiceDelegate != null && type != null && QuerydslPredicateArgumentResolverBeanPostProcessor.this.delegatedConversions != null) {
                for (Class c : QuerydslPredicateArgumentResolverBeanPostProcessor.this.delegatedConversions) {
                    if (!c.equals(type)) continue;
                    result = true;
                    break;
                }
            }
            return result;
        }
    };

    public QuerydslPredicateArgumentResolverBeanPostProcessor(QuerydslBindingsFactory querydslBindingsFactory) {
        this(querydslBindingsFactory, null, new Class[0]);
    }

    public QuerydslPredicateArgumentResolverBeanPostProcessor(QuerydslBindingsFactory querydslBindingsFactory, ConversionService conversionServiceDelegate) {
        this(querydslBindingsFactory, conversionServiceDelegate, new Class[]{Date.class, LocalDate.class, Timestamp.class});
    }

    public QuerydslPredicateArgumentResolverBeanPostProcessor(QuerydslBindingsFactory querydslBindingsFactory, ConversionService conversionServiceDelegate, Class[] delegatedConversions) {
        Validate.notNull((Object)querydslBindingsFactory, (String)"QuerydslBindingsFactory must not be null", (Object[])new Object[0]);
        this.querydslBindingsFactory = querydslBindingsFactory;
        this.conversionServiceDelegate = conversionServiceDelegate;
        this.delegatedConversions = delegatedConversions;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Object target = bean;
        if (target != null && QuerydslPredicateArgumentResolver.class.isAssignableFrom(target.getClass())) {
            ExpressionProviderFactory.setSupportsUnTypedValues(true);
            try {
                try {
                    return ConstructorUtils.invokeConstructor(QuerydslPredicateArgumentResolver.class, (Object[])new Object[]{this.querydslBindingsFactory, Optional.of(this.delegationAwareConversionService)});
                }
                catch (NoSuchMethodError | NoSuchMethodException e) {
                    return ConstructorUtils.invokeConstructor(QuerydslPredicateArgumentResolver.class, (Object[])new Object[]{this.querydslBindingsFactory, this.delegationAwareConversionService});
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to post-process QuerydslPredicateArgumentResolver", t);
            }
        }
        return target;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

