/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.gt_tech.spring.data.querydsl.value.operators.experimental;

import java.lang.reflect.Constructor;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.experimental.QuerydslHttpRequestContext;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.experimental.QuerydslHttpRequestContextHolderStrategy;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.experimental.ThreadLocalQuerydslHttpRequestContextHolderStrategy;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public final class QuerydslHttpRequestContextHolder {
    public static final String MODE_THREADLOCAL = "MODE_THREADLOCAL";
    public static final String MODE_INHERITABLETHREADLOCAL = "MODE_INHERITABLETHREADLOCAL";
    public static final String SYSTEM_PROPERTY = "querydsl.experimental.operator.web.context.strategy";
    private static String strategyName = System.getProperty("querydsl.experimental.operator.web.context.strategy");
    private static QuerydslHttpRequestContextHolderStrategy strategy;

    public static void clearContext() {
        strategy.clearContext();
    }

    public static QuerydslHttpRequestContext getContext() {
        return strategy.getContext();
    }

    private static void initialize() {
        if (!StringUtils.hasText((String)strategyName)) {
            strategyName = MODE_THREADLOCAL;
        }
        if (strategyName.equals(MODE_THREADLOCAL)) {
            strategy = new ThreadLocalQuerydslHttpRequestContextHolderStrategy(false);
        } else if (strategyName.equals(MODE_INHERITABLETHREADLOCAL)) {
            strategy = new ThreadLocalQuerydslHttpRequestContextHolderStrategy(true);
        } else {
            try {
                Class<?> clazz = Class.forName(strategyName);
                Constructor<?> customStrategy = clazz.getConstructor(new Class[0]);
                strategy = (QuerydslHttpRequestContextHolderStrategy)customStrategy.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
        }
    }

    public static void setContext(QuerydslHttpRequestContext context) {
        strategy.setContext(context);
    }

    public static void setStrategyName(String strategyName) {
        QuerydslHttpRequestContextHolder.strategyName = strategyName;
        QuerydslHttpRequestContextHolder.initialize();
    }

    public static QuerydslHttpRequestContextHolderStrategy getContextHolderStrategy() {
        return strategy;
    }

    static {
        QuerydslHttpRequestContextHolder.initialize();
    }
}

