/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.gt_tech.spring.data.querydsl.value.operators.experimental;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.querydsl.core.types.EntityPath;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.experimental.QuerydslHttpRequestContext;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.experimental.QuerydslHttpRequestContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.SimpleEntityPathResolver;

public class QuerydslHttpRequestContextAwareServletFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(QuerydslHttpRequestContextAwareServletFilter.class);
    private static final EntityPathResolver entityPathResolver = SimpleEntityPathResolver.INSTANCE;
    Map<String, Class<?>> URI_SEARCH_RESOURCE_TYPE_MAPPINGS = new TreeMap(new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            if (s1.length() > s2.length()) {
                return -1;
            }
            if (s1.length() < s2.length()) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    });
    static LoadingCache<Class<?>, EntityPath<?>> loadingCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, EntityPath<?>>(){

        public EntityPath<?> load(Class<?> domainClass) throws Exception {
            return entityPathResolver.createPath(domainClass);
        }
    });

    public QuerydslHttpRequestContextAwareServletFilter(Map<String, Class<?>> URI_SEARCH_RESOURCE_TYPE_MAPPINGS) {
        if (URI_SEARCH_RESOURCE_TYPE_MAPPINGS != null) {
            this.URI_SEARCH_RESOURCE_TYPE_MAPPINGS.putAll(URI_SEARCH_RESOURCE_TYPE_MAPPINGS);
        }
        try {
            loadingCache.getAll(this.URI_SEARCH_RESOURCE_TYPE_MAPPINGS.values());
        }
        catch (ExecutionException ex) {
            throw new RuntimeException("Failed to instantiate filter, possible mis-configurations?", ex);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)request;
            String request_uri = req.getRequestURI();
            Optional<EntityPath> optionalPath = this.URI_SEARCH_RESOURCE_TYPE_MAPPINGS.keySet().stream().filter(k -> k.equalsIgnoreCase(request_uri)).findFirst().map(k -> this.URI_SEARCH_RESOURCE_TYPE_MAPPINGS.get(k)).map(k -> {
                try {
                    return (EntityPath)loadingCache.get(k);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Failed to load Path for request uri: " + request_uri);
                }
            });
            if (optionalPath.isPresent()) {
                logger.debug("Processing {} on URI: {} for EntityPath: {}", new Object[]{QuerydslHttpRequestContext.class, request_uri, optionalPath.get().getClass().getCanonicalName()});
                QuerydslHttpRequestContext context = new QuerydslHttpRequestContext(optionalPath.get(), req);
                QuerydslHttpRequestContextHolder.setContext(context);
                chain.doFilter((ServletRequest)context.getWrappedHttpServletRequest(), response);
            } else {
                logger.error("No EntityPath found on request_uri: {}, bad filter configurations (check filter url pattern and also the injected mappings), filter is turning into a no-op for this request", (Object)request_uri);
                chain.doFilter((ServletRequest)req, response);
            }
        }
        finally {
            QuerydslHttpRequestContextHolder.clearContext();
        }
    }

    public void destroy() {
    }
}

