/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.gt_tech.spring.data.querydsl.value.operators.experimental;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.ExpressionProvider;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.ExpressionProviderFactory;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.Operator;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.OperatorAndValue;

public final class QuerydslHttpRequestContext {
    private final EntityPath<?> root;
    private final HttpServletRequest servletRequest;
    private final Map<String, Collection<String>> original_parameters = new LinkedHashMap<String, Collection<String>>();
    private final Map<String, Collection<String>> transformed_parameters;

    public QuerydslHttpRequestContext(EntityPath<?> root, HttpServletRequest servletRequest) {
        Validate.notNull(root, (String)"EntityPath must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)servletRequest, (String)"HttpServletRequest must not be null", (Object[])new Object[0]);
        this.root = root;
        this.servletRequest = servletRequest;
        this.servletRequest.getParameterMap().keySet().stream().forEach(k -> {
            Collection cfr_ignored_0 = this.original_parameters.put(String.valueOf(k), Arrays.asList(this.servletRequest.getParameterValues(String.valueOf(k))));
        });
        this.transformed_parameters = this.original_parameters.keySet().stream().collect(Collectors.toMap(key -> key, key -> this.original_parameters.get(key).stream().map(s -> this.extractTrueValue((String)s)).collect(Collectors.toList()), (e1, e2) -> e1, LinkedHashMap::new));
    }

    HttpServletRequest getWrappedHttpServletRequest() {
        if (this.transformed_parameters == null || this.transformed_parameters.size() <= 0) {
            return this.getOriginalHttpServletRequest();
        }
        return new HttpServletRequestWrapper(this.servletRequest){

            public String getParameter(String name) {
                Collection<String> values = this.getParameterValuesAsList(name);
                if (CollectionUtils.isNotEmpty(values)) {
                    return values.iterator().next();
                }
                return super.getParameter(name);
            }

            public Map<String, String[]> getParameterMap() {
                return QuerydslHttpRequestContext.this.transformed_parameters.keySet().stream().collect(Collectors.toMap(key -> key, key -> ((Collection)QuerydslHttpRequestContext.this.transformed_parameters.get(key)).toArray(new String[((Collection)QuerydslHttpRequestContext.this.transformed_parameters.get(key)).size()]), (e1, e2) -> e1, LinkedHashMap::new));
            }

            public Enumeration<String> getParameterNames() {
                return super.getParameterNames();
            }

            public String[] getParameterValues(String name) {
                Collection<String> values = this.getParameterValuesAsList(name);
                return values.toArray(new String[values.size()]);
            }

            private Collection<String> getParameterValuesAsList(String name) {
                Validate.notNull((Object)name, (String)"Parameter name must not be blank", (Object[])new Object[0]);
                Collection result = (Collection)QuerydslHttpRequestContext.this.transformed_parameters.get(name);
                return result != null ? result : new ArrayList(0);
            }
        };
    }

    HttpServletRequest getOriginalHttpServletRequest() {
        return this.servletRequest;
    }

    public String getSingleValue(Path inPath) {
        return Optional.ofNullable(Optional.ofNullable(inPath).map(p -> this.servletRequest.getParameter(this.findRequestParameterNameFromPath(inPath))).orElseGet(() -> this.servletRequest.getParameter(inPath.toString()))).orElseGet(() -> ExpressionProviderFactory.findAlias(inPath).map(s -> this.servletRequest.getParameter(s)).orElseGet(() -> null));
    }

    public String[] getAllValues(Path inPath) {
        return Optional.ofNullable(Optional.ofNullable(inPath).map(p -> this.servletRequest.getParameterValues(this.findRequestParameterNameFromPath(inPath))).orElseGet(() -> this.servletRequest.getParameterValues(inPath.toString()))).orElseGet(() -> ExpressionProviderFactory.findAlias(inPath).map(s -> this.servletRequest.getParameterValues(s)).orElseGet(() -> null));
    }

    private String findRequestParameterNameFromPath(Path inPath) {
        Validate.notNull((Object)inPath, (String)"Input path must not be null to lookup original request parameter value", (Object[])new Object[0]);
        Object name = null;
        Validate.isTrue((boolean)inPath.getRoot().getType().equals(this.root.getType()), (String)"Mismatch in type root in path and current context", (Object[])new Object[0]);
        return StringUtils.replace((String)inPath.toString(), (String)(this.root + "."), (String)"", (int)1);
    }

    private String extractTrueValue(String input) {
        if (StringUtils.isNotBlank((CharSequence)input)) {
            if (ExpressionProvider.isOperator(input).isPresent()) {
                return this.extractTrueValue(new OperatorAndValue(input, Arrays.asList(Operator.values()), null).getValue());
            }
            return input;
        }
        return "";
    }
}

