/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.gt_tech.spring.data.querydsl.value.operators;

import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.ExpressionProvider;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.Operator;

public class OperatorAndValue {
    private Operator operator;
    private String value;

    public OperatorAndValue(String input, Collection<Operator> in_operators, Operator defaultOperator) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)input), (String)"Input string cannot be blank", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(in_operators), (String)"Input operators must not be empty", (Object[])new Object[0]);
        this.operator = null;
        this.value = StringUtils.trim((String)input);
        for (Operator op : in_operators) {
            if (!ExpressionProvider.isOperator(op, input)) continue;
            this.operator = op;
            this.value = StringUtils.substringBeforeLast((String)StringUtils.substringAfter((String)input, (String)(op.toString() + "(")), (String)")");
            break;
        }
        if (this.operator == null) {
            this.operator = defaultOperator;
        }
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("operator", (Object)this.operator).append("value", (Object)this.value).toString();
    }
}

