/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.gt_tech.spring.data.querydsl.value.operators;

import com.querydsl.core.Tuple;
import com.querydsl.core.support.NumberConversions;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.NumberPath;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.BaseExpressionProvider;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.Operator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NumberPathExpressionProviderImpl
extends BaseExpressionProvider<NumberPath> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NumberPathExpressionProviderImpl.class);

    public NumberPathExpressionProviderImpl() {
        super(Arrays.asList(Operator.EQUAL, Operator.NOT_EQUAL, Operator.GREATER_THAN, Operator.GREATER_THAN_OR_EQUAL, Operator.LESS_THAN, Operator.NOT, Operator.LESS_THAN_OR_EQUAL));
    }

    @Override
    protected <S extends String> S getStringValue(NumberPath path, Object value) {
        return (S)String.valueOf(value);
    }

    @Override
    protected BooleanExpression eq(NumberPath path, String value, boolean ignoreCase) {
        Validate.isTrue((boolean)StringUtils.isNumeric((CharSequence)value), (String)"Invalid numeric value", (Object[])new Object[0]);
        return path.eq(((Tuple)new NumberConversions((FactoryExpression)Projections.tuple((Expression[])new Expression[]{path})).newInstance(new Object[]{NumberUtils.createNumber((String)StringUtils.trim((String)value))})).get((Expression)path));
    }

    @Override
    protected BooleanExpression ne(NumberPath path, String value, boolean ignoreCase) {
        Validate.isTrue((boolean)StringUtils.isNumeric((CharSequence)value), (String)"Invalid numeric value", (Object[])new Object[0]);
        return path.ne(((Tuple)new NumberConversions((FactoryExpression)Projections.tuple((Expression[])new Expression[]{path})).newInstance(new Object[]{NumberUtils.createNumber((String)StringUtils.trim((String)value))})).get((Expression)path));
    }

    @Override
    protected BooleanExpression contains(NumberPath path, String value, boolean ignoreCase) {
        throw new UnsupportedOperationException("Number can't be searched using contains operator");
    }

    @Override
    protected BooleanExpression startsWith(NumberPath path, String value, boolean ignoreCase) {
        throw new UnsupportedOperationException("Number can't be searched using startsWith operator");
    }

    @Override
    protected BooleanExpression endsWith(NumberPath path, String value, boolean ignoreCase) {
        throw new UnsupportedOperationException("Number can't be searched using endsWith operator");
    }

    @Override
    protected BooleanExpression matches(NumberPath path, String value) {
        throw new UnsupportedOperationException("Number can't be searched using matches operator");
    }

    @Override
    protected BooleanExpression gt(NumberPath path, String value) {
        Validate.isTrue((boolean)StringUtils.isNumeric((CharSequence)value), (String)"Invalid numeric value", (Object[])new Object[0]);
        return path.gt((Number)((Tuple)new NumberConversions((FactoryExpression)Projections.tuple((Expression[])new Expression[]{path})).newInstance(new Object[]{NumberUtils.createNumber((String)StringUtils.trim((String)value))})).get((Expression)path));
    }

    @Override
    protected BooleanExpression gte(NumberPath path, String value) {
        Validate.isTrue((boolean)StringUtils.isNumeric((CharSequence)value), (String)"Invalid numeric value", (Object[])new Object[0]);
        return path.goe((Number)((Tuple)new NumberConversions((FactoryExpression)Projections.tuple((Expression[])new Expression[]{path})).newInstance(new Object[]{NumberUtils.createNumber((String)StringUtils.trim((String)value))})).get((Expression)path));
    }

    @Override
    protected BooleanExpression lt(NumberPath path, String value) {
        Validate.isTrue((boolean)StringUtils.isNumeric((CharSequence)value), (String)"Invalid numeric value", (Object[])new Object[0]);
        return path.lt((Number)((Tuple)new NumberConversions((FactoryExpression)Projections.tuple((Expression[])new Expression[]{path})).newInstance(new Object[]{NumberUtils.createNumber((String)StringUtils.trim((String)value))})).get((Expression)path));
    }

    @Override
    protected BooleanExpression lte(NumberPath path, String value) {
        Validate.isTrue((boolean)StringUtils.isNumeric((CharSequence)value), (String)"Invalid numeric value", (Object[])new Object[0]);
        return path.loe((Number)((Tuple)new NumberConversions((FactoryExpression)Projections.tuple((Expression[])new Expression[]{path})).newInstance(new Object[]{NumberUtils.createNumber((String)StringUtils.trim((String)value))})).get((Expression)path));
    }
}

