/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.gt_tech.spring.data.querydsl.value.operators;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.DateTimePath;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.StringPath;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.DateTimePathExpressionProviderImpl;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.EnumPathExpressionProviderImpl;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.ExpressionProvider;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.NumberPathExpressionProviderImpl;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.StringPathExpressionProviderImpl;

public final class ExpressionProviderFactory {
    static LoadingCache<Path, ExpressionProvider> loadingCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Path, ExpressionProvider>(){

        public ExpressionProvider load(Path key) throws Exception {
            if (StringPath.class.isAssignableFrom(key.getClass())) {
                return new StringPathExpressionProviderImpl();
            }
            if (EnumPath.class.isAssignableFrom(key.getClass())) {
                return new EnumPathExpressionProviderImpl();
            }
            if (NumberPath.class.isAssignableFrom(key.getClass())) {
                return new NumberPathExpressionProviderImpl();
            }
            if (DateTimePath.class.isAssignableFrom(key.getClass())) {
                return new DateTimePathExpressionProviderImpl();
            }
            return null;
        }
    });
    private static boolean supportsUnTypedValues = false;
    private static Map<Path, String> path_alias_registry = new HashMap<Path, String>();

    public static Optional<ExpressionProvider> getProvider(Path path) {
        return Optional.ofNullable(loadingCache.getUnchecked((Object)path));
    }

    public static Optional<Predicate> getPredicate(Path path, Object value) {
        return Optional.ofNullable(loadingCache.getUnchecked((Object)path)).flatMap(p -> p.getPredicate(path, value));
    }

    public static void registerAlias(Path path, String alias) {
        if (path != null && StringUtils.isNotBlank((CharSequence)alias)) {
            path_alias_registry.put(path, alias);
        }
    }

    public static Optional<String> findAlias(Path path) {
        return Optional.ofNullable(path).map(p -> path_alias_registry.get(p));
    }

    public static boolean isSupportsUnTypedValues() {
        return supportsUnTypedValues;
    }

    public static void setSupportsUnTypedValues(boolean supportsUnTypedValues) {
        ExpressionProviderFactory.supportsUnTypedValues = supportsUnTypedValues;
    }
}

