/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.gt_tech.spring.data.querydsl.value.operators;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.Operator;

public interface ExpressionProvider<P extends Path, V> {
    public static final String OPERATOR_VALUE_DELIMITER_PREFIX = "(";
    public static final String OPERATOR_VALUE_DELIMITER_SUFFIX = ")";

    default public Optional<Predicate> getPredicate(P path, V value) {
        return this.getExpression(path, value).map(Predicate.class::cast);
    }

    default public Optional<BooleanExpression> getExpression(P path, V value) {
        return Optional.empty();
    }

    public static <S extends String> Optional<Operator> isOperator(S value) {
        return ExpressionProvider.isOperator(Operator.values(), value);
    }

    public static <S extends String> Optional<Operator> isOperator(Operator[] operators, S value) {
        if (operators != null && StringUtils.isNotBlank(value)) {
            for (Operator operator : operators) {
                if (!ExpressionProvider.isOperator(operator, value)) continue;
                return Optional.of(operator);
            }
        }
        return Optional.empty();
    }

    public static boolean isOperator(Operator operator, String value) {
        return value.startsWith(operator.toString() + OPERATOR_VALUE_DELIMITER_PREFIX) && value.endsWith(OPERATOR_VALUE_DELIMITER_SUFFIX);
    }

    public static void validateComposition(String value) {
        if (StringUtils.isNotBlank((CharSequence)value) && ExpressionProvider.isOperator(value).isPresent()) {
            int count = 0;
            char opening_bracket = OPERATOR_VALUE_DELIMITER_PREFIX.charAt(0);
            char closing_bracket = OPERATOR_VALUE_DELIMITER_SUFFIX.charAt(0);
            for (char c : value.toCharArray()) {
                if (c == opening_bracket) {
                    ++count;
                    continue;
                }
                if (c != closing_bracket) continue;
                if (count <= 0) {
                    throw new IllegalArgumentException("Malformed (bad-ordering) value: " + value);
                }
                --count;
            }
            if (count != 0) {
                throw new IllegalArgumentException("Malformed (Incompletely closed) value: " + value);
            }
        }
    }
}

