/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.gt_tech.spring.data.querydsl.value.operators;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EnumPath;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.BaseExpressionProvider;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.ExpressionProviderFactory;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.Operator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EnumPathExpressionProviderImpl
extends BaseExpressionProvider<EnumPath> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnumPathExpressionProviderImpl.class);
    final LoadingCache<String, Pattern> regex_pattern_cache = CacheBuilder.newBuilder().maximumSize(500L).build((CacheLoader)new CacheLoader<String, Pattern>(){

        public Pattern load(String key) {
            return Pattern.compile(key, 2);
        }
    });

    EnumPathExpressionProviderImpl() {
        super(ExpressionProviderFactory.isSupportsUnTypedValues() ? Arrays.asList(Operator.EQUAL, Operator.NOT_EQUAL, Operator.CONTAINS, Operator.STARTS_WITH, Operator.STARTSWITH, Operator.ENDS_WITH, Operator.ENDSWITH, Operator.NOT, Operator.MATCHES, Operator.CASE_IGNORE) : Arrays.asList(Operator.EQUAL, Operator.NOT_EQUAL, Operator.NOT));
    }

    @Override
    protected <S extends String> S getStringValue(EnumPath path, Object value) {
        if (Enum.class.isAssignableFrom(value.getClass())) {
            return (S)((Enum)value).name();
        }
        return (S)value.toString();
    }

    @Override
    protected BooleanExpression eq(EnumPath path, String value, boolean ignoreCase) {
        return path.eq((Object)value);
    }

    @Override
    protected BooleanExpression ne(EnumPath path, String value, boolean ignoreCase) {
        return path.ne((Object)value);
    }

    @Override
    protected BooleanExpression contains(EnumPath path, String value, boolean ignoreCase) {
        if (ExpressionProviderFactory.isSupportsUnTypedValues()) {
            return path.in(EnumUtils.getEnumList((Class)path.getType()).stream().filter(v -> ignoreCase ? StringUtils.containsIgnoreCase((CharSequence)v.toString(), (CharSequence)value) : StringUtils.contains((CharSequence)v.toString(), (CharSequence)value)).collect(Collectors.toList()));
        }
        throw new UnsupportedOperationException(MessageFormat.format("Operator: {0} not supported with Enum values", new Object[]{Operator.CONTAINS}));
    }

    @Override
    protected BooleanExpression startsWith(EnumPath path, String value, boolean ignoreCase) {
        if (ExpressionProviderFactory.isSupportsUnTypedValues()) {
            return path.in(EnumUtils.getEnumList((Class)path.getType()).stream().filter(v -> ignoreCase ? StringUtils.startsWithIgnoreCase((CharSequence)v.toString(), (CharSequence)value) : StringUtils.startsWith((CharSequence)v.toString(), (CharSequence)value)).collect(Collectors.toList()));
        }
        throw new UnsupportedOperationException(MessageFormat.format("Operator: {0} not supported with Enum values", new Object[]{Operator.STARTS_WITH}));
    }

    @Override
    protected BooleanExpression endsWith(EnumPath path, String value, boolean ignoreCase) {
        if (ExpressionProviderFactory.isSupportsUnTypedValues()) {
            return path.in(EnumUtils.getEnumList((Class)path.getType()).stream().filter(v -> ignoreCase ? StringUtils.endsWithIgnoreCase((CharSequence)v.toString(), (CharSequence)value) : StringUtils.endsWith((CharSequence)v.toString(), (CharSequence)value)).collect(Collectors.toList()));
        }
        throw new UnsupportedOperationException(MessageFormat.format("Operator: {0} not supported with Enum values", new Object[]{Operator.ENDS_WITH}));
    }

    @Override
    protected BooleanExpression matches(EnumPath path, String value) {
        if (ExpressionProviderFactory.isSupportsUnTypedValues()) {
            return path.in(EnumUtils.getEnumList((Class)path.getType()).stream().filter(v -> ((Pattern)this.regex_pattern_cache.getUnchecked((Object)value)).matcher(v.toString()).matches()).collect(Collectors.toList()));
        }
        throw new UnsupportedOperationException(MessageFormat.format("Operator: {0} not supported with Enum values", new Object[]{Operator.MATCHES}));
    }

    @Override
    protected BooleanExpression gt(EnumPath path, String value) {
        throw new UnsupportedOperationException("Enum value can't be searched using gt operator");
    }

    @Override
    protected BooleanExpression gte(EnumPath path, String value) {
        throw new UnsupportedOperationException("Enum value can't be searched using gte operator");
    }

    @Override
    protected BooleanExpression lt(EnumPath path, String value) {
        throw new UnsupportedOperationException("Enum value can't be searched using lt operator");
    }

    @Override
    protected BooleanExpression lte(EnumPath path, String value) {
        throw new UnsupportedOperationException("Enum value can't be searched using lte operator");
    }
}

