/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.gt_tech.spring.data.querydsl.value.operators;

import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.DateTimePath;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang3.Validate;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.BaseExpressionProvider;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.Operator;

class DateTimePathExpressionProviderImpl
extends BaseExpressionProvider<DateTimePath> {
    public DateTimePathExpressionProviderImpl() {
        super(Arrays.asList(Operator.EQUAL, Operator.NOT_EQUAL, Operator.GREATER_THAN, Operator.GREATER_THAN_OR_EQUAL, Operator.LESS_THAN, Operator.LESS_THAN_OR_EQUAL));
    }

    @Override
    protected String getStringValue(DateTimePath path, Object value) {
        return value.toString();
    }

    @Override
    protected BooleanExpression eq(DateTimePath path, String value, boolean ignoreCase) {
        Validate.isTrue((boolean)this.isDate(value), (String)"Invalid date value", (Object[])new Object[0]);
        return path.eq((Object)this.convertToDate(value));
    }

    @Override
    protected BooleanExpression ne(DateTimePath path, String value, boolean ignoreCase) {
        Validate.isTrue((boolean)this.isDate(value), (String)"Invalid date value", (Object[])new Object[0]);
        return path.ne((Object)this.convertToDate(value));
    }

    @Override
    protected BooleanExpression contains(DateTimePath path, String value, boolean ignoreCase) {
        throw new UnsupportedOperationException("Datetime can't be searched using contains operator");
    }

    @Override
    protected BooleanExpression startsWith(DateTimePath path, String value, boolean ignoreCase) {
        throw new UnsupportedOperationException("Datetime can't be searched using startsWith operator");
    }

    @Override
    protected BooleanExpression endsWith(DateTimePath path, String value, boolean ignoreCase) {
        throw new UnsupportedOperationException("Datetime can't be searched using endsWith operator");
    }

    @Override
    protected BooleanExpression matches(DateTimePath path, String value) {
        throw new UnsupportedOperationException("Datetime can't be searched using matches operator");
    }

    @Override
    protected BooleanExpression gt(DateTimePath path, String value) {
        Validate.isTrue((boolean)this.isDate(value), (String)"Invalid date value", (Object[])new Object[0]);
        return path.gt((Comparable)this.convertToDate(value));
    }

    @Override
    protected BooleanExpression gte(DateTimePath path, String value) {
        Validate.isTrue((boolean)this.isDate(value), (String)"Invalid date value", (Object[])new Object[0]);
        return path.goe((Comparable)this.convertToDate(value));
    }

    @Override
    protected BooleanExpression lt(DateTimePath path, String value) {
        Validate.isTrue((boolean)this.isDate(value), (String)"Invalid date value", (Object[])new Object[0]);
        return path.lt((Comparable)this.convertToDate(value));
    }

    @Override
    protected BooleanExpression lte(DateTimePath path, String value) {
        Validate.isTrue((boolean)this.isDate(value), (String)"Invalid date value", (Object[])new Object[0]);
        return path.loe((Comparable)this.convertToDate(value));
    }

    private boolean isDate(String dateString) {
        try {
            new Date(dateString);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private Date convertToDate(String dateString) {
        return new Date(dateString);
    }
}

