/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.gt_tech.spring.data.querydsl.value.operators;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.ExpressionProvider;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.Operator;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.OperatorAndValue;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.experimental.QuerydslHttpRequestContext;
import org.bitbucket.gt_tech.spring.data.querydsl.value.operators.experimental.QuerydslHttpRequestContextHolder;

abstract class BaseExpressionProvider<P extends Path>
implements ExpressionProvider<P, Object> {
    private final List<Operator> SUPPORTED_SINGLE_VALUED_COMPARISON_OPERATORS;

    public BaseExpressionProvider(List<Operator> supportedSingleValueComparisonOperators) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(supportedSingleValueComparisonOperators), (String)"Supported Single value operators must be > 1", (Object[])new Object[0]);
        this.SUPPORTED_SINGLE_VALUED_COMPARISON_OPERATORS = supportedSingleValueComparisonOperators;
    }

    @Override
    public Optional<BooleanExpression> getExpression(P path, Object value) {
        return Optional.ofNullable(path).map(p -> value).map(v -> {
            if (Collection.class.isAssignableFrom(v.getClass())) {
                return new MultiValueExpressionBuilder(this, path, (Collection)v).getExpression();
            }
            return new MultiValueExpressionBuilder(this, path, Arrays.asList(this.getStringValue(path, v))).getExpression();
        });
    }

    protected abstract <S extends String> S getStringValue(P var1, Object var2);

    protected abstract BooleanExpression eq(P var1, String var2, boolean var3);

    protected abstract BooleanExpression ne(P var1, String var2, boolean var3);

    protected abstract BooleanExpression contains(P var1, String var2, boolean var3);

    protected abstract BooleanExpression startsWith(P var1, String var2, boolean var3);

    protected abstract BooleanExpression endsWith(P var1, String var2, boolean var3);

    protected abstract BooleanExpression matches(P var1, String var2);

    protected abstract BooleanExpression gt(P var1, String var2);

    protected abstract BooleanExpression gte(P var1, String var2);

    protected abstract BooleanExpression lt(P var1, String var2);

    protected abstract BooleanExpression lte(P var1, String var2);

    protected final BooleanExpression not(BooleanExpression expression) {
        Validate.notNull((Object)expression);
        return expression.not();
    }

    protected final BooleanExpression and(BooleanExpression left, BooleanExpression right) {
        Validate.notNull((Object)left);
        Validate.notNull((Object)right);
        return left.and((Predicate)right);
    }

    protected final BooleanExpression or(BooleanExpression left, BooleanExpression right) {
        Validate.notNull((Object)left);
        Validate.notNull((Object)right);
        return left.or((Predicate)right);
    }

    private String checkIfOriginalRequestValueAvailable(Path path, String defaultValue) {
        QuerydslHttpRequestContext ctx = QuerydslHttpRequestContextHolder.getContext();
        String result = null;
        if (ctx != null) {
            result = ctx.getSingleValue(path);
        }
        if (StringUtils.isBlank(result)) {
            result = defaultValue;
        }
        return result;
    }

    private Collection<Object> checkIfOriginalRequestValuesAvailable(Path path, Collection<Object> defaultValues) {
        QuerydslHttpRequestContext ctx = QuerydslHttpRequestContextHolder.getContext();
        Collection result = null;
        if (ctx != null) {
            result = Arrays.stream((Object[])Optional.ofNullable(ctx.getAllValues(path)).orElseGet(() -> new String[0])).map(val -> val).collect(Collectors.toCollection(LinkedList::new));
        }
        if (CollectionUtils.isEmpty(result)) {
            result = defaultValues;
        }
        return result;
    }

    private static class SingleValueExpressionBuilder {
        private P path;
        private String value;
        private Operator operator;
        private SingleValueExpressionBuilder parent;
        private SingleValueExpressionBuilder next;
        private boolean ignoreCase = false;
        final /* synthetic */ BaseExpressionProvider this$0;

        public SingleValueExpressionBuilder(P path, String value) {
            this.this$0 = var1_1;
            this.init(path, value);
        }

        private SingleValueExpressionBuilder(P path, String value, SingleValueExpressionBuilder parent) {
            this.this$0 = var1_1;
            this.parent = parent;
            this.init(path, value);
        }

        public boolean isIgnoreCase() {
            return this.ignoreCase;
        }

        public void setIgnoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
        }

        private void init(P path, String value) {
            this.path = path;
            OperatorAndValue ov = new OperatorAndValue(value, this.this$0.SUPPORTED_SINGLE_VALUED_COMPARISON_OPERATORS, Operator.EQUAL);
            this.operator = ov.getOperator();
            this.value = ov.getValue();
            Validate.notNull((Object)((Object)this.operator), (String)"Operator must not be null", (Object[])new Object[0]);
            if (Operator.NOT.equals((Object)this.operator)) {
                Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.value), (String)"Sub-operation must be available with NOT operator", (Object[])new Object[0]);
                this.next = new SingleValueExpressionBuilder(this.this$0, path, ov.getValue(), this);
            } else if (Operator.CASE_IGNORE.equals((Object)this.operator)) {
                Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.value), (String)"Sub-operation must be available with CASE_IGNORE operator", (Object[])new Object[0]);
                this.next = new SingleValueExpressionBuilder(this.this$0, path, ov.getValue(), this);
                this.next.setIgnoreCase(true);
            } else if (ExpressionProvider.isOperator(this.this$0.SUPPORTED_SINGLE_VALUED_COMPARISON_OPERATORS.toArray(new Operator[this.this$0.SUPPORTED_SINGLE_VALUED_COMPARISON_OPERATORS.size()]), this.value).isPresent()) {
                this.next = new SingleValueExpressionBuilder(this.this$0, path, ov.getValue(), this);
            }
            if (this.parent != null) {
                Validate.isTrue((!Operator.AND.equals((Object)this.operator) && !Operator.OR.equals((Object)this.operator) && (!Operator.NOT.equals((Object)this.operator) || Operator.NOT.equals((Object)this.parent.operator)) ? 1 : 0) != 0, (String)"Boolean operators cannot be composed within other operators", (Object[])new Object[0]);
            }
        }

        public BooleanExpression getExpression() {
            BooleanExpression result;
            switch (this.operator) {
                case CASE_IGNORE: {
                    result = this.next.getExpression();
                    break;
                }
                case EQUAL: {
                    result = this.this$0.eq(this.path, this.value, this.isIgnoreCase());
                    break;
                }
                case NOT_EQUAL: {
                    result = this.this$0.ne(this.path, this.value, this.isIgnoreCase());
                    break;
                }
                case CONTAINS: {
                    result = this.this$0.contains(this.path, this.value, this.isIgnoreCase());
                    break;
                }
                case STARTS_WITH: 
                case STARTSWITH: {
                    result = this.this$0.startsWith(this.path, this.value, this.isIgnoreCase());
                    break;
                }
                case ENDS_WITH: 
                case ENDSWITH: {
                    result = this.this$0.endsWith(this.path, this.value, this.isIgnoreCase());
                    break;
                }
                case MATCHES: {
                    result = this.this$0.matches(this.path, this.value);
                    break;
                }
                case NOT: {
                    result = this.next.getExpression();
                    if (result == null) break;
                    result = result.not();
                    break;
                }
                case LESS_THAN: {
                    result = this.this$0.lt(this.path, this.value);
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    result = this.this$0.lte(this.path, this.value);
                    break;
                }
                case GREATER_THAN: {
                    result = this.this$0.gt(this.path, this.value);
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    result = this.this$0.gte(this.path, this.value);
                    break;
                }
                default: {
                    result = null;
                }
            }
            return result;
        }
    }

    private static class MultiValueExpressionBuilder {
        private final P path;
        private final Collection<Object> values;
        private BooleanExpression expression;
        private final Collection<Operator> MULTI_VALUE_LOGICAL_OPERATORS = Collections.unmodifiableCollection(Arrays.asList(Operator.AND, Operator.OR));
        final /* synthetic */ BaseExpressionProvider this$0;

        public MultiValueExpressionBuilder(P path, Collection<Object> values) {
            this.this$0 = var1_1;
            this.path = path;
            this.values = values;
            this.values.forEach(v -> ExpressionProvider.validateComposition(this.this$0.getStringValue(path, v)));
        }

        public BooleanExpression getExpression() {
            Operator default_operator = null;
            if (CollectionUtils.isNotEmpty(this.values)) {
                if (this.values.size() == 1) {
                    String value = this.this$0.checkIfOriginalRequestValueAvailable(this.path, this.this$0.getStringValue(this.path, this.values.iterator().next()));
                    while (ExpressionProvider.isOperator(this.MULTI_VALUE_LOGICAL_OPERATORS.toArray(new Operator[this.MULTI_VALUE_LOGICAL_OPERATORS.size()]), value).isPresent()) {
                        value = new OperatorAndValue(value, this.MULTI_VALUE_LOGICAL_OPERATORS, Operator.OR).getValue();
                    }
                    return new SingleValueExpressionBuilder(this.this$0, this.path, value).getExpression();
                }
                block5: for (Object o : this.this$0.checkIfOriginalRequestValuesAvailable(this.path, this.values).stream().filter(Objects::nonNull).collect(Collectors.toList())) {
                    SingleValueExpressionBuilder e;
                    BooleanExpression current;
                    Object v = this.this$0.getStringValue(this.path, o);
                    OperatorAndValue ov = new OperatorAndValue((String)v, this.MULTI_VALUE_LOGICAL_OPERATORS, default_operator != null ? default_operator : Operator.OR);
                    if (default_operator == null && !Operator.NOT.equals((Object)ov.getOperator())) {
                        default_operator = ov.getOperator();
                    }
                    if ((current = (e = new SingleValueExpressionBuilder(this.this$0, this.path, Operator.NOT.equals((Object)ov.getOperator()) ? v : ov.getValue())).getExpression()) == null) continue;
                    if (this.expression == null) {
                        this.expression = current;
                        continue;
                    }
                    switch (ov.getOperator()) {
                        case AND: {
                            this.expression = this.this$0.and(this.expression, current);
                            continue block5;
                        }
                        case OR: 
                        case NOT: {
                            this.expression = this.this$0.or(this.expression, current);
                            continue block5;
                        }
                    }
                    String msg = MessageFormat.format("Illegal operator: {0}, Search Parameter: {1}, Value: {2}", ov.getOperator().toString(), this.path.toString(), v);
                    throw new IllegalArgumentException(msg);
                }
            }
            return this.expression;
        }
    }
}

