/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.beryx.textio.KeyCombination;

public class TextTerminalData {
    private final List<MessageGroup> messageGroups = new ArrayList<MessageGroup>();
    private Action action = Action.NONE;
    private String actionData = null;
    private boolean resetRequired = true;
    private boolean lineResetRequired = false;
    private boolean moveToLineStartRequired = false;
    private String bookmark = null;
    private String resetToBookmark = null;
    private final List<Key> handlerKeys = new ArrayList<Key>();

    public TextTerminalData getCopy() {
        TextTerminalData data = new TextTerminalData();
        this.messageGroups.forEach(group -> {
            MessageGroup copyGroup = new MessageGroup();
            copyGroup.settings.addAll(group.settings);
            copyGroup.messages.addAll(group.messages);
            data.messageGroups.add(copyGroup);
        });
        data.action = this.action;
        data.actionData = this.actionData;
        data.resetRequired = this.resetRequired;
        data.lineResetRequired = this.lineResetRequired;
        data.moveToLineStartRequired = this.moveToLineStartRequired;
        data.bookmark = this.bookmark;
        data.resetToBookmark = this.resetToBookmark;
        data.handlerKeys.addAll(this.handlerKeys);
        return data;
    }

    public List<MessageGroup> getMessageGroups() {
        return this.messageGroups;
    }

    public MessageGroup newMessageGroup() {
        MessageGroup group = new MessageGroup();
        this.messageGroups.add(group);
        return group;
    }

    public boolean isNewGroupRequiredForSetting() {
        if (this.messageGroups.isEmpty()) {
            return true;
        }
        return !this.messageGroups.get((int)(this.messageGroups.size() - 1)).messages.isEmpty();
    }

    public void addSetting(String key, Object value) {
        this.addSetting(new KeyValue(key, value));
    }

    public void addSetting(KeyValue keyVal) {
        MessageGroup group = this.isNewGroupRequiredForSetting() ? this.newMessageGroup() : this.messageGroups.get(this.messageGroups.size() - 1);
        int size = group.settings.size();
        for (int i = 0; i < size; ++i) {
            if (!group.settings.get((int)i).key.equals(keyVal.key)) continue;
            group.settings.set(i, keyVal);
            return;
        }
        group.settings.add(keyVal);
    }

    public void addRawMessage(String message) {
        MessageGroup group = this.messageGroups.isEmpty() ? this.newMessageGroup() : this.messageGroups.get(this.messageGroups.size() - 1);
        group.messages.add(message);
    }

    public String addMessage(String message) {
        String escapedMessage = StringEscapeUtils.escapeHtml4((String)message);
        escapedMessage = Arrays.stream(escapedMessage.split("\\R", -1)).map(line -> line.replaceAll("\t", "    ")).map(line -> {
            int count;
            for (count = 0; count < line.length() && line.charAt(count) == ' '; ++count) {
            }
            if (count == 0) {
                return line;
            }
            StringBuilder sb = new StringBuilder(line.length() + 5 * count);
            for (int i = 0; i < count; ++i) {
                sb.append("&nbsp;");
            }
            sb.append(line.substring(count));
            return sb.toString();
        }).collect(Collectors.joining("<br>"));
        this.addRawMessage(escapedMessage);
        return escapedMessage;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public String getActionData() {
        return this.actionData;
    }

    public void setActionData(String actionData) {
        this.actionData = actionData;
    }

    public boolean isResetRequired() {
        return this.resetRequired;
    }

    public void setResetRequired(boolean resetRequired) {
        this.resetRequired = resetRequired;
    }

    public boolean isLineResetRequired() {
        return this.lineResetRequired;
    }

    public void setLineResetRequired(boolean lineResetRequired) {
        this.lineResetRequired = lineResetRequired;
    }

    public boolean isMoveToLineStartRequired() {
        return this.moveToLineStartRequired;
    }

    public void setMoveToLineStartRequired(boolean moveToLineStartRequired) {
        this.moveToLineStartRequired = moveToLineStartRequired;
    }

    public String getBookmark() {
        return this.bookmark;
    }

    public void setBookmark(String bookmark) {
        this.bookmark = bookmark;
    }

    public String getResetToBookmark() {
        return this.resetToBookmark;
    }

    public void setResetToBookmark(String resetToBookmark) {
        this.resetToBookmark = resetToBookmark;
    }

    public boolean isEmpty() {
        return this.messageGroups.isEmpty() && this.action == Action.NONE;
    }

    public boolean hasAction() {
        return this.action != Action.NONE;
    }

    public List<Key> getHandlerKeys() {
        return this.handlerKeys;
    }

    public void addKey(Key key) {
        for (int i = 0; i < this.handlerKeys.size(); ++i) {
            Key k = this.handlerKeys.get(i);
            if (!k.id.equals(key.id)) continue;
            this.handlerKeys.set(i, key);
            return;
        }
        this.handlerKeys.add(key);
    }

    public String addKey(String keyStroke) {
        Key key = Key.of(keyStroke);
        if (key == null) {
            return null;
        }
        this.addKey(key);
        return key.id;
    }

    public void clear() {
        this.messageGroups.clear();
        this.action = Action.NONE;
        this.actionData = null;
        this.resetRequired = false;
        this.lineResetRequired = false;
        this.moveToLineStartRequired = false;
        this.bookmark = null;
        this.resetToBookmark = null;
        this.handlerKeys.clear();
    }

    public String toString() {
        return "resetRequired: " + this.resetRequired + ", lineResetRequired: " + this.lineResetRequired + ", moveToLineStartRequired: " + this.moveToLineStartRequired + ", bookmark: " + this.bookmark + ", resetToBookmark: " + this.resetToBookmark + ", handlerKeys: " + this.handlerKeys + ", action: " + (Object)((Object)this.action) + ", actionData: " + this.actionData + ", messageGroups: " + this.messageGroups;
    }

    public static class Key {
        public final String id;
        public final String key;
        public final int keyCode;
        public final boolean ctrlKey;
        public final boolean shiftKey;
        public final boolean altKey;

        public Key(String id, String key, int keyCode, boolean ctrlKey, boolean shiftKey, boolean altKey) {
            this.id = id;
            this.key = key;
            this.keyCode = keyCode;
            this.ctrlKey = ctrlKey;
            this.shiftKey = shiftKey;
            this.altKey = altKey;
        }

        public static Key of(String s) {
            KeyCombination kc = KeyCombination.of((String)s);
            if (kc == null) {
                return null;
            }
            String id = s.replaceAll("\\s", "-");
            String key = String.valueOf((char)kc.getCharOrCode()).toLowerCase();
            return new Key(id, key, kc.getCode(), kc.isCtrlDown(), kc.isShiftDown(), kc.isAltDown());
        }
    }

    public static class MessageGroup {
        public final List<KeyValue> settings = new ArrayList<KeyValue>();
        public final List<String> messages = new ArrayList<String>();

        public String toString() {
            return "settings: " + this.settings + ", messages: " + this.messages;
        }
    }

    public static class KeyValue {
        public final String key;
        public final Object value;

        public KeyValue(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + ": " + this.value;
        }
    }

    public static enum Action {
        NONE,
        VIRTUAL,
        FLUSH,
        READ,
        READ_MASKED,
        CONTINUE_READ,
        CLEAR_OLD_INPUT,
        DISPOSE,
        ABORT;

    }
}

