/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio.web;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.activation.MimetypesFileTypeMap;
import org.beryx.textio.web.AbstractDataServer;
import org.beryx.textio.web.DataApi;
import org.beryx.textio.web.DataApiProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.func.Action;
import ratpack.guice.BindingsSpec;
import ratpack.guice.Guice;
import ratpack.handling.Chain;
import ratpack.handling.Context;
import ratpack.http.Request;
import ratpack.server.BaseDir;
import ratpack.server.RatpackServer;
import ratpack.server.ServerConfigBuilder;
import ratpack.session.Session;
import ratpack.session.SessionModule;

public class RatpackDataServer
extends AbstractDataServer<Context> {
    private static final Logger logger = LoggerFactory.getLogger(RatpackDataServer.class);
    private int port;
    private String baseDir;
    private final BiFunction<ContextHolder, String, DataApi> dataApiCreator;
    private final Function<ContextHolder, DataApi> dataApiGetter;
    private final DataApiProvider<Context> dataApiProvider = new DataApiProvider<Context>(){

        @Override
        public DataApi create(Context context, String initData) {
            return (DataApi)RatpackDataServer.this.dataApiCreator.apply(RatpackDataServer.getContextHolder(context), initData);
        }

        @Override
        public DataApi get(Context context) {
            return (DataApi)RatpackDataServer.this.dataApiGetter.apply(RatpackDataServer.getContextHolder(context));
        }
    };
    protected final Action<Chain> handlerPostInit = chain -> chain.post(this.getPathForPostInit(), ctx -> {
        logger.trace("Received INIT");
        Request request = ctx.getRequest();
        request.getBody().then(req -> {
            String initData = req.getText(StandardCharsets.UTF_8);
            this.sendResponseData(ctx, this.handleInit(ctx, initData));
        });
    });
    protected final Action<Chain> handlerGetData = chain -> chain.get(this.getPathForGetData(), ctx -> {
        logger.trace("Received GET");
        this.sendResponseData(ctx, this.handleGetData(ctx));
    });
    protected final Action<Chain> handlerPostInput = chain -> chain.post(this.getPathForPostInput(), ctx -> {
        logger.trace("Received POST");
        Request request = ctx.getRequest();
        boolean userInterrupt = Boolean.parseBoolean(request.getHeaders().get("textio-user-interrupt"));
        String handlerId = request.getHeaders().get("textio-handler-id");
        request.getBody().then(req -> {
            String text = req.getText(StandardCharsets.UTF_8);
            this.sendResponseData(ctx, this.handlePostInput(ctx, text, userInterrupt, handlerId));
        });
    });
    protected final Action<Chain> handlerTexttermAssets = chain -> chain.get("textterm/:name", ctx -> {
        String resName = "/public-html/textterm/" + (String)ctx.getPathTokens().get((Object)"name");
        String content = this.getResourceContent(resName).orElse(null);
        if (content == null) {
            ctx.next();
        } else {
            String contentType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(resName);
            if (contentType != null) {
                ctx.getResponse().contentType((CharSequence)contentType);
            }
            ctx.getResponse().send(content);
        }
    });
    protected final Action<Chain> handlerStaticAssets = chain -> chain.files(files -> {
        if (this.baseDir != null) {
            files.dir(this.baseDir);
        }
    });
    private final List<Action<Chain>> handlers = new ArrayList<Action>(Arrays.asList(this.handlerPostInit, this.handlerGetData, this.handlerPostInput, this.handlerTexttermAssets, this.handlerStaticAssets));
    private final List<Action<BindingsSpec>> bindings = new ArrayList<Action>(Collections.singletonList(b -> b.module(SessionModule.class)));
    protected final Action<ServerConfigBuilder> portConfigurator = c -> {
        if (this.port > 0) {
            c.port(this.port);
        }
    };
    protected final Action<ServerConfigBuilder> baseDirConfigurator = c -> {
        if (this.baseDir != null) {
            c.baseDir(BaseDir.find((String)this.baseDir));
        }
    };
    private final List<Action<ServerConfigBuilder>> configurators = new ArrayList<Action>(Arrays.asList(this.portConfigurator, this.baseDirConfigurator));

    private static ContextHolder getContextHolder(Context ctx) {
        return new ContextHolder(RatpackDataServer.getId(ctx), ctx);
    }

    @Override
    public DataApiProvider<Context> getDataApiProvider() {
        return this.dataApiProvider;
    }

    public RatpackDataServer(BiFunction<ContextHolder, String, DataApi> dataApiCreator, Function<ContextHolder, DataApi> dataApiGetter) {
        this.dataApiCreator = dataApiCreator;
        this.dataApiGetter = dataApiGetter;
    }

    public List<Action<Chain>> getHandlers() {
        return this.handlers;
    }

    public List<Action<BindingsSpec>> getBindings() {
        return this.bindings;
    }

    public List<Action<ServerConfigBuilder>> getConfigurators() {
        return this.configurators;
    }

    public RatpackDataServer withBaseDir(String baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    @Override
    public RatpackDataServer withPort(int portNumber) {
        this.port = portNumber;
        return this;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void init() {
        try {
            RatpackServer.start(server -> {
                server.serverConfig(c -> {
                    for (Action<ServerConfigBuilder> cfg : this.getConfigurators()) {
                        c = (ServerConfigBuilder)cfg.with(c);
                    }
                });
                server.registry(Guice.registry(b -> {
                    for (Action<BindingsSpec> binding : this.getBindings()) {
                        b = (BindingsSpec)binding.with(b);
                    }
                }));
                server.handlers(chain -> {
                    for (Action<Chain> handler : this.getHandlers()) {
                        chain = (Chain)handler.with(chain);
                    }
                });
            });
        }
        catch (Exception e) {
            logger.error("Ratpack failure", (Throwable)e);
        }
    }

    protected void sendResponseData(Context ctx, AbstractDataServer.ResponseData r) {
        ctx.getResponse().status(r.status).contentType((CharSequence)r.contentType).send(r.text);
    }

    protected Optional<String> getResourceContent(String resourceName) {
        URL url = this.getClass().getResource(resourceName);
        if (url == null) {
            return Optional.empty();
        }
        return this.getUrlContent(url);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Optional<String> getUrlContent(URL url) {
        try (Scanner scanner = new Scanner(url.openStream(), StandardCharsets.UTF_8.name());){
            Optional<String> optional = Optional.of(scanner.useDelimiter("\\A").next());
            return optional;
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    protected static String getId(Context ctx) {
        String id = ((Session)ctx.get(Session.class)).getId();
        String uuid = ctx.getRequest().getHeaders().get("uuid");
        if (uuid != null) {
            id = id + "-" + uuid;
        }
        logger.trace("id: {}", (Object)id);
        return id;
    }

    public static class ContextHolder {
        public final String contextId;
        public final Context context;

        public ContextHolder(String contextId, Context context) {
            this.contextId = contextId;
            this.context = context;
        }
    }
}

