/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio.web;

import com.google.gson.Gson;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.beryx.textio.web.DataApi;
import org.beryx.textio.web.DataApiProvider;
import org.beryx.textio.web.DataApiProviderException;
import org.beryx.textio.web.DataServer;
import org.beryx.textio.web.TextTerminalData;
import org.beryx.textio.web.WebTextTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataServer<CTX>
implements DataServer {
    private static final Logger logger = LoggerFactory.getLogger(WebTextTerminal.class);
    public static final String DEFAULT_PATH_FOR_INIT_DATA = "textTerminalInit";
    public static final String DEFAULT_PATH_FOR_GET_DATA = "textTerminalData";
    public static final String DEFAULT_PATH_FOR_POST_INPUT = "textTerminalInput";
    private String pathForInitData = "textTerminalInit";
    private String pathForGetData = "textTerminalData";
    private String pathForPostInput = "textTerminalInput";
    private final Gson gson = new Gson();

    public abstract DataApiProvider<CTX> getDataApiProvider();

    @Override
    public AbstractDataServer<CTX> withPathForInitData(String pathForInitData) {
        this.pathForInitData = pathForInitData;
        return this;
    }

    public String getPathForPostInit() {
        return this.pathForInitData;
    }

    @Override
    public AbstractDataServer<CTX> withPathForGetData(String pathForGetData) {
        this.pathForGetData = pathForGetData;
        return this;
    }

    public String getPathForGetData() {
        return this.pathForGetData;
    }

    @Override
    public AbstractDataServer<CTX> withPathForPostInput(String pathForPostInput) {
        this.pathForPostInput = pathForPostInput;
        return this;
    }

    public String getPathForPostInput() {
        return this.pathForPostInput;
    }

    protected ResponseData handle(Supplier<String> textSupplier) {
        try {
            return new ResponseData(200, "application/json", textSupplier.get());
        }
        catch (DataApiProviderException e) {
            logger.warn("Session expired", (Throwable)e);
            return new ResponseData(403, "text/plain", e.getMessage());
        }
        catch (Exception e) {
            logger.warn("Failed to handle getData", (Throwable)e);
            return new ResponseData(500, "text/plain", "An error occurred");
        }
    }

    protected ResponseData handleInit(CTX ctx, String initData) {
        logger.trace("Initializing terminal...");
        return this.handle(() -> {
            DataApi dataApi = this.getDataApiProvider().create(ctx, initData);
            TextTerminalData data = dataApi.getTextTerminalData();
            logger.trace("Retrieved terminal data: {}", (Object)data);
            return this.gson.toJson((Object)data);
        });
    }

    protected ResponseData handleGetData(CTX ctx) {
        logger.trace("Retrieving terminal data...");
        return this.handle(() -> {
            DataApi dataApi = this.getDataApiProvider().get(ctx);
            TextTerminalData data = dataApi.getTextTerminalData();
            logger.trace("Retrieved terminal data: {}", (Object)data);
            return this.gson.toJson((Object)data);
        });
    }

    protected ResponseData handlePostInput(CTX ctx, String input, boolean userInterrupt, String handlerId) {
        return this.handle(() -> {
            DataApi dataApi = this.getDataApiProvider().get(ctx);
            if (userInterrupt) {
                logger.trace("Posting user interrupted input...");
                dataApi.postUserInterrupt(input);
            } else if (StringUtils.isNotEmpty((CharSequence)handlerId)) {
                logger.trace("Posting handler call(" + handlerId + ")");
                dataApi.postHandlerCall(handlerId, input);
            } else {
                logger.trace("Posting input...");
                dataApi.postUserInput(input);
            }
            return this.gson.toJson((Object)"OK");
        });
    }

    public static class ResponseData {
        public final int status;
        public final String contentType;
        public final String text;

        public ResponseData(int status, String contentType, String text) {
            this.status = status;
            this.contentType = contentType;
            this.text = text;
        }
    }
}

