/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.jlink;

import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import java.io.File;
import java.util.List;
import org.beryx.jlink.BaseTask;
import org.beryx.jlink.JlinkPlugin;
import org.beryx.jlink.data.CreateMergedModuleTaskData;
import org.beryx.jlink.data.JdepsUsage;
import org.beryx.jlink.data.ModuleInfo;
import org.beryx.jlink.impl.CreateMergedModuleTaskImpl;
import org.beryx.jlink.util.PathUtil;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class CreateMergedModuleTask
extends BaseTask {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public CreateMergedModuleTask() {
        this.dependsOn(new Object[]{JlinkPlugin.getTASK_NAME_PREPARE_MERGED_JARS_DIR()});
        String string = "Unpacks all non-modularized jars into a single directory";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, CreateMergedModuleTask.class, (GroovyObject)this, (String)"description");
    }

    @Input
    public List<String> getForceMergedJarPrefixes() {
        return (List)ScriptBytecodeAdapter.castToType((Object)this.getExtension().getForceMergedJarPrefixes().get(), List.class);
    }

    @Input
    public List<String> getExtraDependenciesPrefixes() {
        return (List)ScriptBytecodeAdapter.castToType((Object)this.getExtension().getExtraDependenciesPrefixes().get(), List.class);
    }

    @Input
    public String getMergedModuleName() {
        return ShortTypeHandling.castToString((Object)this.getExtension().getMergedModuleName().get());
    }

    @Input
    public String getMergedModuleJarName() {
        String jarName = ShortTypeHandling.castToString((Object)this.getExtension().getMergedModuleJarName().get());
        if (jarName.endsWith(".jar")) {
            String string;
            jarName = string = StringGroovyMethods.getAt((String)jarName, (IntRange)new IntRange(true, 0, Integer.valueOf(-5).intValue()));
        }
        return jarName;
    }

    @Input
    public String getMergedModuleJarVersion() {
        return ShortTypeHandling.castToString((Object)this.getExtension().getMergedModuleJarVersion().get());
    }

    @InputDirectory
    public Directory getMergedJarsDir() {
        return ((ProjectInternal)this.getProject()).getLayout().getProjectDirectory().dir(PathUtil.getMergedJarsDirPath(this.getJlinkBasePath()));
    }

    @Input
    public ModuleInfo getMergedModuleInfo() {
        return (ModuleInfo)ScriptBytecodeAdapter.castToType((Object)this.getExtension().getMergedModuleInfo().get(), ModuleInfo.class);
    }

    @Input
    public JdepsUsage getUseJdeps() {
        return (JdepsUsage)ShortTypeHandling.castToEnum((Object)this.getExtension().getUseJdeps().get(), JdepsUsage.class);
    }

    @Input
    public String getJavaHome() {
        return ShortTypeHandling.castToString((Object)this.getExtension().getJavaHome().get());
    }

    @Input
    public String getConfiguration() {
        return ShortTypeHandling.castToString((Object)this.getExtension().getConfiguration().get());
    }

    @OutputFile
    public File getMergedModuleJar() {
        String string;
        String jarFileName = this.getMergedModuleJarName();
        if (DefaultTypeTransformation.booleanUnbox((Object)this.getMergedModuleJarVersion()) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getMergedModuleJarVersion(), (Object)Project.DEFAULT_VERSION)) {
            String string2;
            jarFileName = string2 = StringGroovyMethods.plus((String)jarFileName, (CharSequence)new GStringImpl(new Object[]{this.getMergedModuleJarVersion()}, new String[]{"-", ""}));
        }
        jarFileName = string = StringGroovyMethods.plus((String)jarFileName, (CharSequence)".jar");
        return new File(PathUtil.getJlinkJarsDirPath(this.getJlinkBasePath()), jarFileName);
    }

    @TaskAction
    public void createMergedModuleAction() {
        CreateMergedModuleTaskData taskData = new CreateMergedModuleTaskData();
        String string = this.getJlinkBasePath();
        taskData.setJlinkBasePath(string);
        List<String> list = this.getForceMergedJarPrefixes();
        taskData.setForceMergedJarPrefixes(list);
        List<String> list2 = this.getExtraDependenciesPrefixes();
        taskData.setExtraDependenciesPrefixes(list2);
        String string2 = this.getMergedModuleName();
        taskData.setMergedModuleName(string2);
        ModuleInfo moduleInfo = this.getMergedModuleInfo();
        taskData.setMergedModuleInfo(moduleInfo);
        JdepsUsage jdepsUsage = this.getUseJdeps();
        taskData.setUseJdeps(jdepsUsage);
        File file = this.getMergedModuleJar();
        taskData.setMergedModuleJar(file);
        File file2 = this.getMergedJarsDir().getAsFile();
        taskData.setMergedJarsDir(file2);
        String string3 = this.getJavaHome();
        taskData.setJavaHome(string3);
        Configuration configuration = ((ProjectInternal)this.getProject()).getConfigurations().getByName(this.getConfiguration());
        taskData.setConfiguration(configuration);
        String string4 = PathUtil.getJlinkJarsDirPath(taskData.getJlinkBasePath());
        taskData.setJlinkJarsDirPath(string4);
        String string5 = PathUtil.getTmpMergedModuleDirPath(taskData.getJlinkBasePath());
        taskData.setTmpMergedModuleDirPath(string5);
        String string6 = PathUtil.getTmpModuleInfoDirPath(taskData.getJlinkBasePath());
        taskData.setTmpModuleInfoDirPath(string6);
        String string7 = PathUtil.getTmpJarsDirPath(taskData.getJlinkBasePath());
        taskData.setTmpJarsDirPath(string7);
        CreateMergedModuleTaskImpl taskImpl = new CreateMergedModuleTaskImpl(this.getProject(), taskData);
        taskImpl.execute();
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != CreateMergedModuleTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }
}

