/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.jlink.util;

import groovy.io.FileType;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.SimpleType;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.tools.Utilities;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.util.GradleVersion;

public class Util
implements GroovyObject {
    private static final Logger LOGGER;
    private static String EXEC_EXTENSION;
    private static final String WS = "[ \t\r\n\\u000C]";
    private static final String LINE_COMMENT = "//[^\r\n]*";
    private static final String MULTILINE_COMMENT = "/\\*.*?\\*/";
    private static final String IGNORE;
    private static final String INNER_IGNORE;
    private static final String LETTER = "[a-zA-Z$_]|[^\\u0000-\\u007F\\uD800-\\uDBFF]|[\\uD800-\\uDBFF]|[\\uDC00-\\uDFFF]";
    private static final String LETTER_OR_DIGIT;
    private static final String IDENTIFIER;
    private static final String QUALIFIED_NAME;
    private static final String IMPORT_DECLARATION;
    private static final String IMPORT_DECLARATIONS;
    private static final String MODULE_DECLARATION;
    private static final Pattern PATTERN;
    private static final Set<String> KEYWORDS;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public Util() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String getModuleNameFrom(String moduleInfoText, String fileName) {
        CallSite[] callSiteArray = Util.$getCallSiteArray();
        Object matcher = callSiteArray[0].call((Object)PATTERN, (Object)moduleInfoText);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call(matcher))) {
            throw (Throwable)callSiteArray[2].callConstructor(GradleException.class, (Object)new GStringImpl(new Object[]{fileName, moduleInfoText}, new String[]{"Cannot retrieve module name from ", " with content: ", ""}));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[3].call(matcher, (Object)"MODULE"));
    }

    public static String getDefaultMergedModuleName(Project project) {
        Object object = project.getGroup();
        String name = (String)ScriptBytecodeAdapter.asType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : project.getName()), String.class);
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Util.toModuleName(name)}, new String[]{"", ".merged.module"}));
    }

    /*
     * Loose catch block
     */
    public static String getDefaultModuleName(Project project) {
        CallSite[] callSiteArray = Util.$getCallSiteArray();
        Set srcDirs = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].callGetPropertySafe(callSiteArray[5].callGetPropertySafe(callSiteArray[6].callGetProperty(callSiteArray[7].callGetProperty((Object)project)))), Set.class);
        public class _getDefaultModuleName_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getDefaultModuleName_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getDefaultModuleName_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getDefaultModuleName_closure1.$getCallSiteArray();
                return callSiteArray[0].callSafe(callSiteArray[1].call(it), (Object)"module-info.java");
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getDefaultModuleName_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getDefaultModuleName_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "contains";
                stringArray[1] = "list";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _getDefaultModuleName_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getDefaultModuleName_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getDefaultModuleName_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        File moduleInfoDir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[8].callSafe((Object)srcDirs, (Object)new _getDefaultModuleName_closure1(Util.class, Util.class)), File.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)moduleInfoDir)) {
            throw (Throwable)callSiteArray[9].callConstructor(GradleException.class, (Object)new GStringImpl(new Object[]{srcDirs}, new String[]{"Cannot find module-info.java in ", ""}));
        }
        Object moduleInfoFile = callSiteArray[10].callConstructor(File.class, (Object)moduleInfoDir, (Object)"module-info.java");
        String string = ShortTypeHandling.castToString((Object)callSiteArray[11].callStatic(Util.class, callSiteArray[12].callGetProperty(moduleInfoFile), callSiteArray[13].callGetProperty(moduleInfoFile)));
        try {
            return string;
        }
        catch (GradleException ge) {
            throw (Throwable)ge;
        }
        catch (Exception e) {
            throw (Throwable)callSiteArray[14].callConstructor(GradleException.class, (Object)new GStringImpl(new Object[]{moduleInfoDir}, new String[]{"Cannot retrieve module name from ", "/module-info.java"}), (Object)e);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public static String getPackage(String entryName) {
        if (!entryName.endsWith(".class")) {
            return ShortTypeHandling.castToString(null);
        }
        int pos = entryName.lastIndexOf("/");
        if (pos <= 0) {
            return ShortTypeHandling.castToString(null);
        }
        int dotPos = entryName.lastIndexOf(".");
        if (!Utilities.isJavaIdentifier((String)entryName.substring(pos + 1, dotPos))) {
            return ShortTypeHandling.castToString(null);
        }
        String pkgName = entryName.substring(0, pos).replace("/", ".");
        public class _getPackage_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getPackage_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String s) {
                return Utilities.isJavaIdentifier((String)s);
            }

            public Object call(String s) {
                return this.doCall(s);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getPackage_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        boolean valid = DefaultGroovyMethods.every((Object)pkgName.split("\\."), (Closure)new _getPackage_closure2(Util.class, Util.class));
        return ShortTypeHandling.castToString((Object)(valid ? pkgName : null));
    }

    public static String getModuleName(File f) {
        CallSite[] callSiteArray = Util.$getCallSiteArray();
        String string = ShortTypeHandling.castToString((Object)callSiteArray[15].call(callSiteArray[16].call(callSiteArray[17].call(callSiteArray[18].call(callSiteArray[19].call(ModuleFinder.class, callSiteArray[20].call((Object)f)))))));
        try {
            return string;
        }
        catch (Exception e) {
            Object modName = callSiteArray[21].callStatic(Util.class, (Object)f);
            callSiteArray[22].call((Object)LOGGER, (Object)new GStringImpl(new Object[]{f, modName}, new String[]{"Cannot retrieve the module name of ", ". Using fallback value: ", "."}));
            String string2 = ShortTypeHandling.castToString((Object)modName);
            return string2;
        }
    }

    public static String getFallbackModuleNameFromJarFile(File f) {
        Manifest manifest = new JarFile(f).getManifest();
        Attributes attributes = manifest != null ? manifest.getMainAttributes() : null;
        String modName = attributes != null ? attributes.getValue("Automatic-Module-Name") : null;
        if (DefaultTypeTransformation.booleanUnbox((Object)modName)) {
            return modName;
        }
        return Util.getFallbackModuleNameFromJarName(f.getName());
    }

    public static String getFallbackModuleNameFromJarName(String s) {
        Object[] tokens = s.split("[_.0-9]*-[0-9]");
        String modName = tokens.length < 2 ? StringGroovyMethods.minus((CharSequence)s, (Object)".jar") : ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])tokens, (int)0));
        return Util.toModuleName(modName);
    }

    public static String toModuleName(String s) {
        String string;
        String name = s.replaceAll("[^0-9A-Za-z_.]", ".");
        int start = 0;
        while (ScriptBytecodeAdapter.compareEqual((Object)StringGroovyMethods.getAt((String)name, (int)start), (Object)Character.valueOf('.'))) {
            int n = start;
            int cfr_ignored_0 = n + 1;
        }
        int end = name.length() - 1;
        while (ScriptBytecodeAdapter.compareEqual((Object)StringGroovyMethods.getAt((String)name, (int)end), (Object)Character.valueOf('.'))) {
            int n = end;
            int cfr_ignored_1 = n - 1;
        }
        name = string = name.substring(start, end + 1);
        name.replaceAll("\\.[.]+", ".");
        public class _toModuleName_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _toModuleName_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return it;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _toModuleName_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public class _toModuleName_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _toModuleName_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String it) {
                return Util.getKEYWORDS().contains(it) ? new GStringImpl(new Object[]{it}, new String[]{"", "_"}) : (DefaultGroovyMethods.isDigit((Character)Character.valueOf(DefaultTypeTransformation.charUnbox((Object)ScriptBytecodeAdapter.asType((Object)StringGroovyMethods.getAt((String)it, (int)0), Character.TYPE)))) ? new GStringImpl(new Object[]{it}, new String[]{"_", ""}) : it);
            }

            public Object call(String it) {
                return this.doCall(it);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _toModuleName_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List items = DefaultGroovyMethods.collect((Collection)DefaultGroovyMethods.findAll((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)name.split("\\."), Object[].class)), (Closure)new _toModuleName_closure3(Util.class, Util.class)), (Closure)new _toModuleName_closure4(Util.class, Util.class));
        return DefaultGroovyMethods.join((Iterable)items, (String)".");
    }

    public static void createManifest(Object targetDir, boolean multiRelease) {
        CallSite[] callSiteArray = Util.$getCallSiteArray();
        Object mfdir = callSiteArray[23].callConstructor(File.class, targetDir, (Object)"META-INF");
        callSiteArray[24].call(mfdir);
        Object mf = callSiteArray[25].callConstructor(File.class, mfdir, (Object)"MANIFEST.MF");
        callSiteArray[26].call(mf);
        callSiteArray[27].call(mf, callSiteArray[28].call((Object)"Manifest-Version: 1.0\n            Created-By: Badass-JLink Plugin\n            Built-By: gradle\n        "));
        if (multiRelease) {
            callSiteArray[29].call(mf, (Object)"Multi-Release: true\n");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void createJar(Project project, String javaHome, String jarFilePath, Object contentDir) {
        void var3_3;
        void var2_2;
        Reference javaHome2 = new Reference((Object)javaHome);
        Reference jarFilePath2 = new Reference((Object)var2_2);
        Reference contentDir2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = Util.$getCallSiteArray();
        callSiteArray[30].call(callSiteArray[31].callGetProperty(callSiteArray[32].call((Object)project, (Object)((String)jarFilePath2.get()))));
        public class _createJar_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference javaHome;
            private /* synthetic */ Reference jarFilePath;
            private /* synthetic */ Reference contentDir;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createJar_closure5(Object _outerInstance, Object _thisObject, Reference javaHome, Reference jarFilePath, Reference contentDir) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _createJar_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.javaHome = reference3 = javaHome;
                this.jarFilePath = reference2 = jarFilePath;
                this.contentDir = reference = contentDir;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createJar_closure5.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)new GStringImpl(new Object[]{this.javaHome.get()}, new String[]{"", "/bin/jar"}), (Object)"--create", (Object)"--file", (Object)this.jarFilePath.get(), (Object)"--no-manifest", (Object)"-C", (Object)this.contentDir.get(), (Object)"."));
            }

            public String getJavaHome() {
                CallSite[] callSiteArray = _createJar_closure5.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.javaHome.get());
            }

            public String getJarFilePath() {
                CallSite[] callSiteArray = _createJar_closure5.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.jarFilePath.get());
            }

            public Object getContentDir() {
                CallSite[] callSiteArray = _createJar_closure5.$getCallSiteArray();
                return this.contentDir.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createJar_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createJar_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "commandLine";
                return new CallSiteArray(_createJar_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createJar_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[33].call((Object)project, (Object)new _createJar_closure5(Util.class, Util.class, javaHome2, jarFilePath2, contentDir2));
    }

    public static boolean isValidClassFileReference(String name) {
        String string;
        if (!name.endsWith(".class")) {
            return false;
        }
        name = string = StringGroovyMethods.minus((CharSequence)name, (Object)".class");
        Object[] tokens = name.split("[./\\\\]");
        Object object = BytecodeInterface8.objectArrayGet((Object[])tokens, (int)(tokens.length - 1));
        name = ShortTypeHandling.castToString((Object)object);
        return Utilities.isJavaIdentifier((String)name);
    }

    public static void scan(File file, @ClosureParams(value=SimpleType.class, options={"java.lang.String,java.lang.String,java.io.InputStream"}) Closure<Void> action) {
        if (!file.exists()) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file}, new String[]{"File or directory not found: ", ""})));
        }
        if (file.isDirectory()) {
            Util.scanDir(file, action);
        } else {
            Util.scanJar(file, action);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void scanDir(File dir, @ClosureParams(value=SimpleType.class, options={"java.lang.String,java.lang.String,java.io.InputStream"}) Closure<Void> action) {
        void var1_1;
        Reference dir2 = new Reference((Object)dir);
        Reference action2 = new Reference((Object)var1_1);
        if (!((File)dir2.get()).isDirectory()) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{(File)dir2.get()}, new String[]{"Not a directory: ", ""})));
        }
        public class _scanDir_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference dir;
            private /* synthetic */ Reference action;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _scanDir_closure6(Object _outerInstance, Object _thisObject, Reference dir, Reference action) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.dir = reference2 = dir;
                this.action = reference = action;
            }

            public Object doCall(Object file) {
                Reference basePath = new Reference((Object)((File)this.dir.get()).getAbsolutePath().replace("\\", "/"));
                Reference relPath = new Reference((Object)((File)this.dir.get()).toPath().relativize(((File)file).toPath()).toString().replace("\\", "/"));
                public class _closure17
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference action;
                    private /* synthetic */ Reference basePath;
                    private /* synthetic */ Reference relPath;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure17(Object _outerInstance, Object _thisObject, Reference action, Reference basePath, Reference relPath) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        this.action = reference3 = action;
                        this.basePath = reference2 = basePath;
                        this.relPath = reference = relPath;
                    }

                    public Object doCall(Object it) {
                        return ((Closure)ScriptBytecodeAdapter.castToType((Object)this.action.get(), Closure.class)).call(new Object[]{this.basePath.get(), this.relPath.get(), it});
                    }

                    public Closure getAction() {
                        return (Closure)ScriptBytecodeAdapter.castToType((Object)this.action.get(), Closure.class);
                    }

                    public Object getBasePath() {
                        return this.basePath.get();
                    }

                    public Object getRelPath() {
                        return this.relPath.get();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure17.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return IOGroovyMethods.withCloseable((Closeable)ResourceGroovyMethods.newInputStream((File)((File)ScriptBytecodeAdapter.castToType((Object)file, File.class))), (Closure)new _closure17((Object)this, this.getThisObject(), this.action, basePath, relPath));
            }

            public File getDir() {
                return (File)ScriptBytecodeAdapter.castToType((Object)this.dir.get(), File.class);
            }

            public Closure getAction() {
                return (Closure)ScriptBytecodeAdapter.castToType((Object)this.action.get(), Closure.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _scanDir_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ResourceGroovyMethods.eachFileRecurse((File)((File)dir2.get()), (FileType)FileType.FILES, (Closure)new _scanDir_closure6(Util.class, Util.class, dir2, action2));
    }

    private static void scanJar(File jarFile, @ClosureParams(value=SimpleType.class, options={"java.lang.String,java.lang.String,java.io.InputStream"}) Closure<Void> action) {
        Reference action2 = new Reference(action);
        Reference zipFile = new Reference((Object)new ZipFile(jarFile));
        public class _scanJar_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference zipFile;
            private /* synthetic */ Reference action;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _scanJar_closure7(Object _outerInstance, Object _thisObject, Reference zipFile, Reference action) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.zipFile = reference2 = zipFile;
                this.action = reference = action;
            }

            public Object doCall(ZipEntry entry) {
                Reference entry2 = new Reference((Object)entry);
                public class _closure18
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference action;
                    private /* synthetic */ Reference entry;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure18(Object _outerInstance, Object _thisObject, Reference action, Reference entry) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.action = reference2 = action;
                        this.entry = reference = entry;
                    }

                    public Object doCall(Object it) {
                        return ((Closure)ScriptBytecodeAdapter.castToType((Object)this.action.get(), Closure.class)).call(new Object[]{"", ((ZipEntry)this.entry.get()).getName(), it});
                    }

                    public Closure getAction() {
                        return (Closure)ScriptBytecodeAdapter.castToType((Object)this.action.get(), Closure.class);
                    }

                    public ZipEntry getEntry() {
                        return (ZipEntry)ScriptBytecodeAdapter.castToType((Object)this.entry.get(), ZipEntry.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure18.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return IOGroovyMethods.withCloseable((Closeable)((ZipFile)this.zipFile.get()).getInputStream((ZipEntry)entry2.get()), (Closure)new _closure18((Object)this, this.getThisObject(), this.action, entry2));
            }

            public Object call(ZipEntry entry) {
                Reference entry2 = new Reference((Object)entry);
                return this.doCall((ZipEntry)entry2.get());
            }

            public Object getZipFile() {
                return this.zipFile.get();
            }

            public Closure getAction() {
                return (Closure)ScriptBytecodeAdapter.castToType((Object)this.action.get(), Closure.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _scanJar_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(((ZipFile)zipFile.get()).entries(), (Closure)new _scanJar_closure7(Util.class, Util.class, zipFile, action2));
    }

    public static File getVersionedDir(File baseDir, int javaVersion) {
        Reference javaVersion2 = new Reference((Object)javaVersion);
        File versionsDir = new File(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{baseDir.getAbsolutePath()}, new String[]{"", "/META-INF/versions"})));
        if (!versionsDir.isDirectory()) {
            return (File)ScriptBytecodeAdapter.castToType(null, File.class);
        }
        public class _getVersionedDir_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getVersionedDir_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(File f) {
                return f.isDirectory() && StringGroovyMethods.isNumber((CharSequence)f.getName());
            }

            public Object call(File f) {
                return this.doCall(f);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getVersionedDir_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public class _getVersionedDir_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getVersionedDir_closure9(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(File f) {
                return DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)f.getName(), Integer.TYPE));
            }

            public Object call(File f) {
                return this.doCall(f);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getVersionedDir_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public class _getVersionedDir_closure10
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference javaVersion;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getVersionedDir_closure10(Object _outerInstance, Object _thisObject, Reference javaVersion) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.javaVersion = reference = javaVersion;
            }

            public Object doCall(int v) {
                return ScriptBytecodeAdapter.compareLessThanEqual((Object)v, (Object)this.javaVersion.get());
            }

            public Object call(int v) {
                return this.doCall(v);
            }

            public int getJavaVersion() {
                return DefaultTypeTransformation.intUnbox((Object)this.javaVersion.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getVersionedDir_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Integer version = (Integer)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.max((Iterable)DefaultGroovyMethods.findAll((List)DefaultGroovyMethods.collect((Object)versionsDir.listFiles((FileFilter)ScriptBytecodeAdapter.asType((Object)((Object)new _getVersionedDir_closure8(Util.class, Util.class)), FileFilter.class)), (Closure)new _getVersionedDir_closure9(Util.class, Util.class)), (Closure)new _getVersionedDir_closure10(Util.class, Util.class, javaVersion2))), Integer.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)version)) {
            return (File)ScriptBytecodeAdapter.castToType(null, File.class);
        }
        return new File(versionsDir, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{version}, new String[]{"", ""})));
    }

    public static Set<File> getArtifacts(Set<ResolvedDependency> deps) {
        public class _getArtifacts_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getArtifacts_closure11(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.getPropertySpreadSafe(_getArtifacts_closure11.class, (Object)((ResolvedDependency)it).getModuleArtifacts(), (String)"file");
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getArtifacts_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (Set)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.flatten((List)DefaultGroovyMethods.collect(deps, (Closure)new _getArtifacts_closure11(Util.class, Util.class))), Set.class);
    }

    public static File getArtifact(ResolvedDependency dep) {
        public class _getArtifact_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getArtifact_closure12(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((ResolvedArtifact)it).getClassifier();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getArtifact_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Object object = DefaultGroovyMethods.find((Collection)dep.getModuleArtifacts(), (Closure)new _getArtifact_closure12(Util.class, Util.class));
        ResolvedArtifact resolvedArtifact = (ResolvedArtifact)ScriptBytecodeAdapter.castToType((Object)object, ResolvedArtifact.class);
        ResolvedArtifact artifact = DefaultTypeTransformation.booleanUnbox((Object)object) ? resolvedArtifact : (ResolvedArtifact)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Iterable)dep.getModuleArtifacts(), (int)0), ResolvedArtifact.class);
        return artifact.getFile();
    }

    public static boolean isEmptyJar(File jarFile) {
        ZipFile zipFile = new ZipFile(jarFile);
        public class _isEmptyJar_closure13
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isEmptyJar_closure13(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(ZipEntry entry) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{"META-INF/", "META-INF/MANIFEST.MF"}) == null ? Boolean.valueOf(entry.getName() == null) : Boolean.valueOf(DefaultGroovyMethods.isCase((Collection)ScriptBytecodeAdapter.createList((Object[])new Object[]{"META-INF/", "META-INF/MANIFEST.MF"}), (Object)entry.getName()));
            }

            public Object call(ZipEntry entry) {
                return this.doCall(entry);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isEmptyJar_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.every(zipFile.entries(), (Closure)new _isEmptyJar_closure13(Util.class, Util.class));
    }

    public static DirectoryProperty createDirectoryProperty(Project project) {
        CallSite[] callSiteArray = Util.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[34].call(GradleVersion.class), (Object)callSiteArray[35].call(GradleVersion.class, (Object)"5.0-milestone-1"))) {
            return (DirectoryProperty)ScriptBytecodeAdapter.castToType((Object)callSiteArray[36].call(callSiteArray[37].callGetProperty((Object)project)), DirectoryProperty.class);
        }
        return (DirectoryProperty)ScriptBytecodeAdapter.castToType((Object)callSiteArray[38].call(callSiteArray[39].callGetProperty((Object)project)), DirectoryProperty.class);
    }

    public static RegularFileProperty createRegularFileProperty(Project project) {
        CallSite[] callSiteArray = Util.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[40].call(GradleVersion.class), (Object)callSiteArray[41].call(GradleVersion.class, (Object)"5.0-milestone-1"))) {
            return (RegularFileProperty)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].call(callSiteArray[43].callGetProperty((Object)project)), RegularFileProperty.class);
        }
        return (RegularFileProperty)ScriptBytecodeAdapter.castToType((Object)callSiteArray[44].call(callSiteArray[45].callGetProperty((Object)project)), RegularFileProperty.class);
    }

    public static <T> void addToListProperty(ListProperty<T> listProp, T ... values) {
        CallSite[] callSiteArray = Util.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[46].call(GradleVersion.class), (Object)callSiteArray[47].call(GradleVersion.class, (Object)"5.0-milestone-1"))) {
            Object list = callSiteArray[48].callConstructor(ArrayList.class, callSiteArray[49].call(listProp));
            callSiteArray[50].call(list, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((List)ScriptBytecodeAdapter.asType(values, List.class)), List.class));
            callSiteArray[51].call(listProp, list);
        } else {
            callSiteArray[52].call(listProp, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((List)ScriptBytecodeAdapter.asType(values, List.class)), List.class));
        }
    }

    public static <K, V> Provider<Map<K, V>> createMapProperty(Project project, Class<K> keyType, Class<V> valueType) {
        CallSite[] callSiteArray = Util.$getCallSiteArray();
        Property provider = null;
        if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[53].call(GradleVersion.class), (Object)callSiteArray[54].call(GradleVersion.class, (Object)"5.1"))) {
            Property property;
            provider = property = (Property)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].call(callSiteArray[56].callGetProperty((Object)project), Map.class), Property.class);
        } else {
            Object object = callSiteArray[57].call(callSiteArray[58].callGetProperty((Object)project), keyType, valueType);
            provider = (Provider)ScriptBytecodeAdapter.castToType((Object)object, Provider.class);
        }
        callSiteArray[59].call((Object)provider, callSiteArray[60].callConstructor(TreeMap.class));
        return provider;
    }

    public static <K, V> void putToMapProvider(Provider<Map<K, V>> mapProvider, K key, V value) {
        CallSite[] callSiteArray = Util.$getCallSiteArray();
        Object map = callSiteArray[61].callConstructor(TreeMap.class, callSiteArray[62].call(mapProvider));
        V v = value;
        callSiteArray[63].call(map, key, v);
        callSiteArray[64].call(mapProvider, map);
    }

    public static String getArchiveBaseName(Project project) {
        String name;
        block5: {
            CallSite[] callSiteArray = Util.$getCallSiteArray();
            name = "";
            try {
                if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[65].call(GradleVersion.class), (Object)callSiteArray[66].call(GradleVersion.class, (Object)"5.1"))) {
                    Object object = callSiteArray[67].callGetProperty(callSiteArray[68].callGetProperty((Object)project));
                    name = ShortTypeHandling.castToString((Object)object);
                    break block5;
                }
                Object object = callSiteArray[69].call(callSiteArray[70].callGetProperty(callSiteArray[71].callGetProperty((Object)project)));
                name = ShortTypeHandling.castToString((Object)object);
            }
            catch (Exception e) {
                callSiteArray[72].call((Object)LOGGER, (Object)new GStringImpl(new Object[]{e}, new String[]{"Cannot get archiveBaseName: ", ""}));
            }
        }
        return name;
    }

    public static void checkExecutable(String filePath) {
        Util.checkExecutable(new File(filePath));
    }

    public static void checkExecutable(File f) {
        if (!f.isFile()) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{f.getAbsolutePath()}, new String[]{"", " does not exist."})));
        }
        if (!f.canExecute()) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{f.getAbsolutePath()}, new String[]{"", " is not executable."})));
        }
    }

    public static List<File> getJarsAndMods(Object ... modulePath) {
        Reference allFiles = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public class _getJarsAndMods_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference allFiles;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getJarsAndMods_closure14(Object _outerInstance, Object _thisObject, Reference allFiles) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.allFiles = reference = allFiles;
            }

            public Object doCall(Object entry) {
                File f = entry instanceof File ? (File)ScriptBytecodeAdapter.castToType((Object)entry, File.class) : new File(DefaultGroovyMethods.toString((Object)entry));
                if (f.isFile()) {
                    ((List)this.allFiles.get()).add(f);
                }
                if (f.isDirectory()) {
                    public class _closure19
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure19(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(File ff) {
                            return ff.isFile();
                        }

                        public Object call(File ff) {
                            return this.doCall(ff);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure19.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    return DefaultGroovyMethods.addAll((Collection)((Collection)ScriptBytecodeAdapter.castToType((Object)this.allFiles.get(), Collection.class)), (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)f.listFiles((FileFilter)ScriptBytecodeAdapter.asType((Object)((Object)new _closure19((Object)this, this.getThisObject())), FileFilter.class)), Object[].class)));
                }
                return null;
            }

            public List getAllFiles() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.allFiles.get(), List.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getJarsAndMods_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Object)modulePath, (Closure)new _getJarsAndMods_closure14(Util.class, Util.class, allFiles));
        public class _getJarsAndMods_closure15
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getJarsAndMods_closure15(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((File)it).getName().endsWith(".jar") || ((File)it).getName().endsWith(".jmod");
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getJarsAndMods_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.findAll((List)((List)allFiles.get()), (Closure)new _getJarsAndMods_closure15(Util.class, Util.class));
    }

    public static ModuleDescriptor getModuleDescriptor(File f) {
        if (!f.isFile()) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{f}, new String[]{"", " is not a file"})));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)f.getName(), (Object)"module-info.class")) {
            return ModuleDescriptor.read(ResourceGroovyMethods.newInputStream((File)f));
        }
        if (!f.getName().endsWith(".jar") && !f.getName().endsWith(".jmod")) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{f}, new String[]{"Unsupported file type: ", ""})));
        }
        String prefix = f.getName().endsWith(".jmod") ? "classes/" : "";
        ZipFile zipFile = new ZipFile(f);
        ZipEntry entry = null;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            entry = enumeration.nextElement();
            ZipEntry zipEntry = (ZipEntry)ScriptBytecodeAdapter.castToType((Object)entry, ZipEntry.class);
            if (!ScriptBytecodeAdapter.compareEqual((Object)zipEntry.getName(), (Object)((String)ScriptBytecodeAdapter.asType((Object)new GStringImpl(new Object[]{prefix}, new String[]{"", "module-info.class"}), String.class)))) continue;
            InputStream entryStream = zipFile.getInputStream(zipEntry);
            return ModuleDescriptor.read(entryStream);
        }
        return (ModuleDescriptor)ScriptBytecodeAdapter.castToType(null, ModuleDescriptor.class);
    }

    public static List<Project> getAllDependentProjects(Project project) {
        ArrayList<DomainObjectSet> arrayList = new ArrayList<DomainObjectSet>();
        Object object = ScriptBytecodeAdapter.getPropertySpreadSafe(Util.class, (Object)project.getConfigurations(), (String)"dependencies");
        if (object != null) {
            Object for$it$3 = null;
            Iterator iterator = DefaultGroovyMethods.iterator((Object)object);
            while (iterator.hasNext()) {
                for$it$3 = iterator.next();
                Object var5_5 = for$it$3;
                arrayList.add(var5_5 != null ? ((DomainObjectSet)var5_5).withType(ProjectDependency.class) : null);
            }
        }
        Set projectDependencies = (Set)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.flatten(arrayList), Set.class);
        Reference dependentProjects = new Reference((Object)((List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getPropertySpreadSafe(Util.class, (Object)projectDependencies, (String)"dependencyProject"), List.class)));
        public class _getAllDependentProjects_closure16
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference dependentProjects;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAllDependentProjects_closure16(Object _outerInstance, Object _thisObject, Reference dependentProjects) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.dependentProjects = reference = dependentProjects;
            }

            public Object doCall(Object it) {
                List list = DefaultGroovyMethods.plus((List)((List)ScriptBytecodeAdapter.castToType((Object)this.dependentProjects.get(), List.class)), Util.getAllDependentProjects((Project)ScriptBytecodeAdapter.castToType((Object)it, Project.class)));
                this.dependentProjects.set((Object)list);
                return list;
            }

            public List getDependentProjects() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.dependentProjects.get(), List.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAllDependentProjects_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((List)((List)dependentProjects.get()), (Closure)new _getAllDependentProjects_closure16(Util.class, Util.class, dependentProjects));
        return DefaultGroovyMethods.unique((List)((List)dependentProjects.get()));
    }

    public static /* synthetic */ Set<String> pfaccess$0(Util $that) {
        return KEYWORDS;
    }

    public static String getModuleNameFrom(String moduleInfoText) {
        return Util.getModuleNameFrom(moduleInfoText, "module-info.java");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Util.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        HashSet hashSet;
        Pattern pattern;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        Logger logger;
        LOGGER = logger = Logging.getLogger(Util.class);
        EXEC_EXTENSION = string9 = System.getProperty("os.name", "").toLowerCase().contains("win") ? ".exe" : "";
        IGNORE = string8 = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"(", (CharSequence)WS), (CharSequence)"|"), (CharSequence)LINE_COMMENT), (CharSequence)"|"), (CharSequence)MULTILINE_COMMENT), (CharSequence)")*");
        INNER_IGNORE = string7 = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"(", (CharSequence)MULTILINE_COMMENT), (CharSequence)")*");
        LETTER_OR_DIGIT = string6 = StringGroovyMethods.plus((String)LETTER, (CharSequence)"|[0-9]");
        IDENTIFIER = string5 = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"((", (CharSequence)LETTER), (CharSequence)INNER_IGNORE), (CharSequence)")("), (CharSequence)LETTER_OR_DIGIT), (CharSequence)INNER_IGNORE), (CharSequence)")*)");
        QUALIFIED_NAME = string4 = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)IDENTIFIER, (CharSequence)INNER_IGNORE), (CharSequence)"(\\."), (CharSequence)INNER_IGNORE), (CharSequence)IDENTIFIER), (CharSequence)INNER_IGNORE), (CharSequence)")*");
        IMPORT_DECLARATION = string3 = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"import", (CharSequence)IGNORE), (CharSequence)"(static"), (CharSequence)IGNORE), (CharSequence)")?"), (CharSequence)QUALIFIED_NAME), (CharSequence)"(\\.\\*"), (CharSequence)")?"), (CharSequence)IGNORE), (CharSequence)";");
        IMPORT_DECLARATIONS = string2 = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"(", (CharSequence)IMPORT_DECLARATION), (CharSequence)IGNORE), (CharSequence)")*");
        MODULE_DECLARATION = string = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"(?s)", (CharSequence)IGNORE), (CharSequence)IMPORT_DECLARATIONS), (CharSequence)"(open"), (CharSequence)IGNORE), (CharSequence)")?"), (CharSequence)"module"), (CharSequence)IGNORE), (CharSequence)"(?<MODULE>"), (CharSequence)QUALIFIED_NAME), (CharSequence)").*?");
        PATTERN = pattern = Pattern.compile(MODULE_DECLARATION);
        KEYWORDS = hashSet = (HashSet)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"}), HashSet.class);
    }

    public static String getEXEC_EXTENSION() {
        return EXEC_EXTENSION;
    }

    public static void setEXEC_EXTENSION(String string) {
        EXEC_EXTENSION = string;
    }

    public static Set<String> getKEYWORDS() {
        return KEYWORDS;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "matcher";
        stringArray[1] = "matches";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "group";
        stringArray[4] = "srcDirs";
        stringArray[5] = "java";
        stringArray[6] = "main";
        stringArray[7] = "sourceSets";
        stringArray[8] = "find";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "getModuleNameFrom";
        stringArray[12] = "text";
        stringArray[13] = "path";
        stringArray[14] = "<$constructor$>";
        stringArray[15] = "name";
        stringArray[16] = "descriptor";
        stringArray[17] = "first";
        stringArray[18] = "findAll";
        stringArray[19] = "of";
        stringArray[20] = "toPath";
        stringArray[21] = "getFallbackModuleNameFromJarFile";
        stringArray[22] = "warn";
        stringArray[23] = "<$constructor$>";
        stringArray[24] = "mkdirs";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "delete";
        stringArray[27] = "leftShift";
        stringArray[28] = "stripIndent";
        stringArray[29] = "leftShift";
        stringArray[30] = "mkdirs";
        stringArray[31] = "parentFile";
        stringArray[32] = "file";
        stringArray[33] = "exec";
        stringArray[34] = "current";
        stringArray[35] = "version";
        stringArray[36] = "directoryProperty";
        stringArray[37] = "layout";
        stringArray[38] = "directoryProperty";
        stringArray[39] = "objects";
        stringArray[40] = "current";
        stringArray[41] = "version";
        stringArray[42] = "fileProperty";
        stringArray[43] = "layout";
        stringArray[44] = "fileProperty";
        stringArray[45] = "objects";
        stringArray[46] = "current";
        stringArray[47] = "version";
        stringArray[48] = "<$constructor$>";
        stringArray[49] = "get";
        stringArray[50] = "addAll";
        stringArray[51] = "set";
        stringArray[52] = "addAll";
        stringArray[53] = "current";
        stringArray[54] = "version";
        stringArray[55] = "property";
        stringArray[56] = "objects";
        stringArray[57] = "mapProperty";
        stringArray[58] = "objects";
        stringArray[59] = "set";
        stringArray[60] = "<$constructor$>";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "get";
        stringArray[63] = "putAt";
        stringArray[64] = "set";
        stringArray[65] = "current";
        stringArray[66] = "version";
        stringArray[67] = "baseName";
        stringArray[68] = "jar";
        stringArray[69] = "get";
        stringArray[70] = "archiveBaseName";
        stringArray[71] = "jar";
        stringArray[72] = "warn";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[73];
        Util.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(Util.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Util.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

