/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.benf.cfr.reader.bytecode.analysis.opgraph.InstrIndex;
import org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Cleaner;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.TypeFilter;
import org.benf.cfr.reader.bytecode.analysis.parse.Expression;
import org.benf.cfr.reader.bytecode.analysis.parse.Statement;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.Literal;
import org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.CaseStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.JumpingStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.Nop;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.RawSwitchStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.SwitchStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.BlockIdentifier;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.BlockIdentifierFactory;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.BlockType;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.JumpType;
import org.benf.cfr.reader.bytecode.analysis.types.discovery.InferredJavaType;
import org.benf.cfr.reader.bytecode.opcode.DecodedSwitch;
import org.benf.cfr.reader.bytecode.opcode.DecodedSwitchEntry;
import org.benf.cfr.reader.entities.Method;
import org.benf.cfr.reader.util.CannotPerformDecode;
import org.benf.cfr.reader.util.ConfusedCFRException;
import org.benf.cfr.reader.util.Troolean;
import org.benf.cfr.reader.util.collections.Functional;
import org.benf.cfr.reader.util.collections.ListFactory;
import org.benf.cfr.reader.util.collections.MapFactory;
import org.benf.cfr.reader.util.collections.SetFactory;
import org.benf.cfr.reader.util.collections.SetUtil;
import org.benf.cfr.reader.util.functors.BinaryProcedure;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.benf.cfr.reader.util.graph.GraphVisitor;
import org.benf.cfr.reader.util.graph.GraphVisitorDFS;

public class SwitchReplacer {
    public static void replaceRawSwitches(Method method, List<Op03SimpleStatement> in, BlockIdentifierFactory blockIdentifierFactory, Options options) {
        List<Op03SimpleStatement> switchStatements = Functional.filter(in, new TypeFilter<RawSwitchStatement>(RawSwitchStatement.class));
        List<Op03SimpleStatement> switches = ListFactory.newList();
        for (Op03SimpleStatement switchStatement : switchStatements) {
            Op03SimpleStatement switchToProcess = SwitchReplacer.replaceRawSwitch(method, switchStatement, in, blockIdentifierFactory, options);
            if (switchToProcess == null) continue;
            switches.add(switchToProcess);
        }
        Collections.sort(in, new CompareByIndex());
        boolean pullCodeIntoCase = (Boolean)options.getOption(OptionsImpl.PULL_CODE_CASE);
        for (Op03SimpleStatement switchStatement : switches) {
            SwitchReplacer.examineSwitchContiguity(switchStatement, in, pullCodeIntoCase);
            SwitchReplacer.moveJumpsToCaseStatements(switchStatement);
            SwitchReplacer.moveJumpsToTerminalIfEmpty(switchStatement, in);
        }
    }

    private static Op03SimpleStatement replaceRawSwitch(Method method, Op03SimpleStatement swatch, List<Op03SimpleStatement> in, BlockIdentifierFactory blockIdentifierFactory, Options options) {
        List<Op03SimpleStatement> targets = swatch.getTargets();
        RawSwitchStatement switchStatement = (RawSwitchStatement)swatch.getStatement();
        DecodedSwitch switchData = switchStatement.getSwitchData();
        BlockIdentifier switchBlockIdentifier = blockIdentifierFactory.getNextBlockIdentifier(BlockType.SWITCH);
        Op03SimpleStatement oneTarget = targets.get(0);
        boolean mismatch = false;
        for (int x = 1; x < targets.size(); ++x) {
            Op03SimpleStatement target = targets.get(x);
            if (target == oneTarget) continue;
            mismatch = true;
            break;
        }
        if (!mismatch) {
            int idx = in.indexOf(swatch);
            if (idx + 1 >= in.size() || oneTarget != in.get(idx + 1)) {
                swatch.replaceStatement(new GotoStatement());
                return null;
            }
            swatch.replaceStatement(switchStatement.getSwitchStatement(switchBlockIdentifier));
            BlockIdentifier defBlock = blockIdentifierFactory.getNextBlockIdentifier(BlockType.CASE);
            Op03SimpleStatement defStm = new Op03SimpleStatement(swatch.getBlockIdentifiers(), new CaseStatement(ListFactory.<Expression>newList(), switchStatement.getSwitchOn().getInferredJavaType(), switchBlockIdentifier, defBlock), swatch.getIndex().justAfter());
            swatch.replaceTarget(oneTarget, defStm);
            oneTarget.replaceSource(swatch, defStm);
            defStm.addSource(swatch);
            defStm.addTarget(oneTarget);
            defStm.getBlockIdentifiers().add(switchBlockIdentifier);
            in.add(defStm);
            return null;
        }
        if (options.getOption(OptionsImpl.FORCE_TOPSORT_EXTRA) == Troolean.TRUE) {
            SwitchReplacer.tryInlineRawSwitchContent(swatch, in);
        }
        List<DecodedSwitchEntry> entries = switchData.getJumpTargets();
        InferredJavaType caseType = switchStatement.getSwitchOn().getInferredJavaType();
        Map firstPrev = MapFactory.newMap();
        InstrIndex nextIntermed = swatch.getIndex().justAfter();
        int len = targets.size();
        for (int x = 0; x < len; ++x) {
            Op03SimpleStatement target = targets.get(x);
            InstrIndex tindex = target.getIndex();
            if (firstPrev.containsKey(tindex)) {
                target = (Op03SimpleStatement)firstPrev.get(tindex);
            }
            List<Expression> expression = ListFactory.newList();
            List<Integer> vals = entries.get(x).getValue();
            for (Integer val : vals) {
                if (val == null) continue;
                expression.add(new Literal(TypedLiteral.getInt(val)));
            }
            Set<BlockIdentifier> blocks = SetFactory.newSet(target.getBlockIdentifiers());
            blocks.add(switchBlockIdentifier);
            BlockIdentifier caseIdentifier = blockIdentifierFactory.getNextBlockIdentifier(BlockType.CASE);
            Op03SimpleStatement caseStatement = new Op03SimpleStatement(blocks, new CaseStatement(expression, caseType, switchBlockIdentifier, caseIdentifier), target.getIndex().justBefore());
            Iterator<Op03SimpleStatement> iterator = target.getSources().iterator();
            while (iterator.hasNext()) {
                Op03SimpleStatement source = iterator.next();
                if (swatch.getIndex().isBackJumpTo(source) || source.getIndex().isBackJumpTo(target)) continue;
                source.replaceTarget(target, caseStatement);
                caseStatement.addSource(source);
                iterator.remove();
            }
            if (caseStatement.getSources().isEmpty()) {
                caseStatement.setIndex(nextIntermed);
                nextIntermed = nextIntermed.justAfter();
                Op03SimpleStatement intermediateGoto = new Op03SimpleStatement(blocks, new GotoStatement(), nextIntermed);
                nextIntermed = nextIntermed.justAfter();
                intermediateGoto.addSource(caseStatement);
                intermediateGoto.addTarget(target);
                caseStatement.addTarget(intermediateGoto);
                target.replaceSource(swatch, intermediateGoto);
                swatch.replaceTarget(target, caseStatement);
                caseStatement.addSource(swatch);
                in.add(caseStatement);
                in.add(intermediateGoto);
                continue;
            }
            target.addSource(caseStatement);
            caseStatement.addTarget(target);
            in.add(caseStatement);
            firstPrev.put(tindex, caseStatement);
        }
        Cleaner.sortAndRenumberInPlace(in);
        SwitchReplacer.buildSwitchCases(swatch, targets, switchBlockIdentifier, in);
        swatch.replaceStatement(switchStatement.getSwitchStatement(switchBlockIdentifier));
        Collections.sort(swatch.getTargets(), new CompareByIndex());
        return swatch;
    }

    private static void buildSwitchCases(Op03SimpleStatement swatch, List<Op03SimpleStatement> targets, BlockIdentifier switchBlockIdentifier, List<Op03SimpleStatement> in) {
        Set caseIdentifiers = SetFactory.newSet();
        Set<Op03SimpleStatement> caseTargets = SetFactory.newSet(targets);
        Map lastStatementBefore = MapFactory.newMap();
        for (Op03SimpleStatement target : targets) {
            CaseStatement caseStatement = (CaseStatement)target.getStatement();
            BlockIdentifier caseBlock = caseStatement.getCaseBlock();
            if (!caseStatement.isDefault()) {
                target.markBlock(switchBlockIdentifier);
            }
            NodeReachable nodeReachable = new NodeReachable(caseTargets, target, swatch);
            GraphVisitorDFS<Op03SimpleStatement> gv = new GraphVisitorDFS<Op03SimpleStatement>(target, nodeReachable);
            gv.process();
            List<Op03SimpleStatement> backReachable = Functional.filter(nodeReachable.reaches, new Misc.IsForwardJumpTo(target.getIndex()));
            if (backReachable.isEmpty() || backReachable.size() != 1) continue;
            Op03SimpleStatement backTarget = backReachable.get(0);
            boolean contiguous = SwitchReplacer.blockIsContiguous(in, target, nodeReachable.inBlock);
            if (target.getSources().size() != 1) {
                if (!contiguous) continue;
                for (Op03SimpleStatement reachable : nodeReachable.inBlock) {
                    reachable.markBlock(switchBlockIdentifier);
                    if (caseTargets.contains(reachable) || SetUtil.hasIntersection(reachable.getBlockIdentifiers(), caseIdentifiers)) continue;
                    reachable.markBlock(caseBlock);
                }
                continue;
            }
            if (!contiguous) continue;
            InstrIndex prev = (InstrIndex)lastStatementBefore.get(backTarget);
            if (prev == null) {
                prev = backTarget.getIndex().justBefore();
            }
            int idx = in.indexOf(target) + nodeReachable.inBlock.size() - 1;
            int i = 0;
            int len = nodeReachable.inBlock.size();
            while (i < len) {
                in.get(idx).setIndex(prev);
                prev = prev.justBefore();
                ++i;
                --idx;
            }
            lastStatementBefore.put(backTarget, prev);
        }
    }

    public static void rebuildSwitches(List<Op03SimpleStatement> statements, Options options) {
        SwitchStatement switchStatementInr;
        List<Op03SimpleStatement> switchStatements = Functional.filter(statements, new TypeFilter<SwitchStatement>(SwitchStatement.class));
        for (Op03SimpleStatement switchStatement : switchStatements) {
            switchStatementInr = (SwitchStatement)switchStatement.getStatement();
            Set allBlocks = SetFactory.newSet();
            allBlocks.add(switchStatementInr.getSwitchBlock());
            for (Op03SimpleStatement target : switchStatement.getTargets()) {
                Statement stmTgt = target.getStatement();
                if (!(stmTgt instanceof CaseStatement)) continue;
                allBlocks.add(((CaseStatement)stmTgt).getCaseBlock());
            }
            for (Op03SimpleStatement stm : statements) {
                stm.getBlockIdentifiers().removeAll(allBlocks);
            }
        }
        for (Op03SimpleStatement switchStatement : switchStatements) {
            switchStatementInr = (SwitchStatement)switchStatement.getStatement();
            SwitchReplacer.buildSwitchCases(switchStatement, switchStatement.getTargets(), switchStatementInr.getSwitchBlock(), statements);
        }
        boolean pullCodeIntoCase = (Boolean)options.getOption(OptionsImpl.PULL_CODE_CASE);
        for (Op03SimpleStatement switchStatement : switchStatements) {
            SwitchReplacer.examineSwitchContiguity(switchStatement, statements, pullCodeIntoCase);
            SwitchReplacer.moveJumpsToTerminalIfEmpty(switchStatement, statements);
        }
    }

    private static boolean blockIsContiguous(List<Op03SimpleStatement> in, Op03SimpleStatement start, Set<Op03SimpleStatement> blockContent) {
        int idx = in.indexOf(start);
        int len = blockContent.size();
        if (idx + blockContent.size() > in.size()) {
            return false;
        }
        int found = 1;
        while (found < len) {
            Op03SimpleStatement next = in.get(idx);
            if (!blockContent.contains(next)) {
                return false;
            }
            ++found;
            ++idx;
        }
        return true;
    }

    private static void examineSwitchContiguity(Op03SimpleStatement switchStatement, List<Op03SimpleStatement> statements, boolean pullCodeIntoCase) {
        Op03SimpleStatement lastInThis;
        int breakTarget;
        Set forwardTargets = SetFactory.newSet();
        List<Op03SimpleStatement> targets = ListFactory.newList(switchStatement.getTargets());
        Collections.sort(targets, new CompareByIndex());
        int idxFirstCase = statements.indexOf(targets.get(0));
        if (idxFirstCase != statements.indexOf(switchStatement) + 1) {
            throw new ConfusedCFRException("First case is not immediately after switch.");
        }
        BlockIdentifier switchBlock = ((SwitchStatement)switchStatement.getStatement()).getSwitchBlock();
        int indexLastInLastBlock = 0;
        for (int x = 0; x < targets.size() - 1; ++x) {
            Op03SimpleStatement lastStatement;
            int indexLastInThis;
            Op03SimpleStatement thisCase = targets.get(x);
            Op03SimpleStatement nextCase = targets.get(x + 1);
            int indexThisCase = statements.indexOf(thisCase);
            int indexNextCase = statements.indexOf(nextCase);
            InstrIndex nextCaseIndex = nextCase.getIndex();
            Statement maybeCaseStatement = thisCase.getStatement();
            if (!(maybeCaseStatement instanceof CaseStatement)) continue;
            CaseStatement caseStatement = (CaseStatement)maybeCaseStatement;
            BlockIdentifier caseBlock = caseStatement.getCaseBlock();
            indexLastInLastBlock = indexLastInThis = Misc.getFarthestReachableInRange(statements, indexThisCase, indexNextCase);
            for (int y = indexThisCase + 1; y <= indexLastInThis; ++y) {
                Op03SimpleStatement statement = statements.get(y);
                statement.markBlock(caseBlock);
                statement.markBlock(switchBlock);
                if (!statement.getJumpType().isUnknown()) continue;
                for (Op03SimpleStatement innerTarget : statement.getTargets()) {
                    if (!nextCaseIndex.isBackJumpFrom(innerTarget = Misc.followNopGoto(innerTarget, false, false)) || innerTarget.getBlockIdentifiers().contains(switchBlock)) continue;
                    forwardTargets.add(innerTarget);
                }
            }
            if (!pullCodeIntoCase || (lastStatement = statements.get(indexLastInThis)).getStatement().getClass() != GotoStatement.class) continue;
            Set<BlockIdentifier> others = SetFactory.newSet(caseBlock, switchBlock);
            Op03SimpleStatement last = lastStatement;
            Op03SimpleStatement tgt = last.getTargets().get(0);
            InstrIndex moveTo = last.getIndex().justAfter();
            while (tgt.getSources().size() == 1 && tgt.getTargets().size() == 1 && SetUtil.difference(lastStatement.getBlockIdentifiers(), tgt.getBlockIdentifiers()).equals(others)) {
                tgt.setIndex(moveTo);
                moveTo = moveTo.justAfter();
                tgt.getBlockIdentifiers().addAll(others);
                last = tgt;
                tgt = last.getTargets().get(0);
            }
            if (last == lastStatement || last.getStatement().getClass() == GotoStatement.class) continue;
            Op03SimpleStatement newGoto = new Op03SimpleStatement(last.getBlockIdentifiers(), new GotoStatement(), moveTo);
            Op03SimpleStatement originalTgt = last.getTargets().get(0);
            last.replaceTarget(originalTgt, newGoto);
            originalTgt.replaceSource(last, newGoto);
            newGoto.addTarget(originalTgt);
            newGoto.addSource(last);
            statements.add(newGoto);
        }
        Op03SimpleStatement lastCase = targets.get(targets.size() - 1);
        int indexLastCase = statements.indexOf(lastCase);
        BlockIdentifier caseBlock = null;
        int indexLastInThis = 0;
        boolean retieEnd = false;
        if (!forwardTargets.isEmpty()) {
            List lstFwdTargets = ListFactory.newList(forwardTargets);
            Collections.sort(lstFwdTargets, new CompareByIndex());
            Op03SimpleStatement afterCaseGuess = (Op03SimpleStatement)lstFwdTargets.get(0);
            int indexAfterCase = statements.indexOf(afterCaseGuess);
            CaseStatement caseStatement = (CaseStatement)lastCase.getStatement();
            caseBlock = caseStatement.getCaseBlock();
            try {
                indexLastInThis = Misc.getFarthestReachableInRange(statements, indexLastCase, indexAfterCase);
            }
            catch (CannotPerformDecode e) {
                forwardTargets.clear();
            }
            if (indexLastInThis != indexAfterCase - 1) {
                retieEnd = true;
            }
        }
        if (forwardTargets.isEmpty()) {
            for (int y = idxFirstCase; y <= indexLastInLastBlock; ++y) {
                Op03SimpleStatement statement = statements.get(y);
                statement.markBlock(switchBlock);
            }
            if (indexLastCase != indexLastInLastBlock + 1) {
                Op03SimpleStatement t2;
                Op03SimpleStatement lastInBlock = statements.get(indexLastInLastBlock);
                Op03SimpleStatement target = statements.get(indexLastCase);
                boolean handled = false;
                if (target.getStatement() instanceof CaseStatement && (t2 = target.getTargets().get(0)).getStatement() instanceof ReturnStatement) {
                    Op03SimpleStatement dupCase = new Op03SimpleStatement(switchStatement.getBlockIdentifiers(), target.getStatement(), lastInBlock.getIndex().justAfter());
                    indexLastCase = indexLastInLastBlock + 1;
                    statements.add(indexLastCase, dupCase);
                    target.removeSource(switchStatement);
                    target.nopOut();
                    switchStatement.replaceTarget(target, dupCase);
                    dupCase.addSource(switchStatement);
                    Op03SimpleStatement dupReturn = new Op03SimpleStatement(dupCase.getBlockIdentifiers(), t2.getStatement(), dupCase.getIndex().justAfter());
                    statements.add(indexLastCase + 1, dupReturn);
                    dupCase.addTarget(dupReturn);
                    dupReturn.addSource(dupCase);
                    handled = true;
                }
                if (!handled) {
                    throw new ConfusedCFRException("Extractable last case doesn't follow previous, and can't clone.");
                }
            }
            lastCase.markBlock(switchBlock);
            breakTarget = indexLastCase + 1;
        } else {
            int y;
            for (y = indexLastCase + 1; y <= indexLastInThis; ++y) {
                Op03SimpleStatement statement = statements.get(y);
                statement.markBlock(caseBlock);
            }
            for (y = idxFirstCase; y <= indexLastInThis; ++y) {
                Op03SimpleStatement statement = statements.get(y);
                statement.markBlock(switchBlock);
            }
            breakTarget = indexLastInThis + 1;
        }
        Op03SimpleStatement breakStatementTarget = statements.get(breakTarget);
        if (retieEnd && (lastInThis = statements.get(indexLastInThis)).getStatement().getClass() == GotoStatement.class) {
            Set<BlockIdentifier> blockIdentifiers = SetFactory.newSet(lastInThis.getBlockIdentifiers());
            blockIdentifiers.remove(caseBlock);
            blockIdentifiers.remove(switchBlock);
            Op03SimpleStatement retie = new Op03SimpleStatement(blockIdentifiers, new GotoStatement(), lastInThis.getIndex().justAfter());
            Op03SimpleStatement target = lastInThis.getTargets().get(0);
            Iterator<Op03SimpleStatement> iterator = target.getSources().iterator();
            while (iterator.hasNext()) {
                Op03SimpleStatement source = iterator.next();
                if (!source.getBlockIdentifiers().contains(switchBlock)) continue;
                iterator.remove();
                retie.addSource(source);
                source.replaceTarget(target, retie);
            }
            if (!retie.getSources().isEmpty()) {
                retie.addTarget(target);
                target.addSource(retie);
                statements.add(breakTarget, retie);
                breakStatementTarget = retie;
            }
        }
        if (breakStatementTarget.getBlockIdentifiers().contains(switchBlock)) {
            return;
        }
        Set<Op03SimpleStatement> sources = Misc.followNopGotoBackwards(breakStatementTarget);
        for (Op03SimpleStatement breakSource : sources) {
            Op03SimpleStatement originalTarget;
            if (!breakSource.getBlockIdentifiers().contains(switchBlock) || !breakSource.getJumpType().isUnknown()) continue;
            JumpingStatement jumpingStatement = (JumpingStatement)breakSource.getStatement();
            if (jumpingStatement.getClass() == IfStatement.class) {
                if (breakSource.getTargets().size() != 2) continue;
                originalTarget = breakSource.getTargets().get(1);
            } else {
                if (breakSource.getTargets().size() != 1) continue;
                originalTarget = breakSource.getTargets().get(0);
            }
            if (originalTarget != breakStatementTarget) {
                if (originalTarget == breakSource.getLinearlyNext() && originalTarget.getStatement() instanceof CaseStatement && !((CaseStatement)originalTarget.getStatement()).isDefault() && originalTarget.getSources().contains(switchStatement)) {
                    breakSource.replaceStatement(new Nop());
                    continue;
                }
                breakSource.replaceTarget(originalTarget, breakStatementTarget);
                originalTarget.removeSource(breakSource);
                breakStatementTarget.addSource(breakSource);
            }
            ((JumpingStatement)breakSource.getStatement()).setJumpType(JumpType.BREAK);
        }
    }

    private static void moveJumpsToCaseStatements(Op03SimpleStatement switchStatement) {
        SwitchStatement switchStmt = (SwitchStatement)switchStatement.getStatement();
        BlockIdentifier switchBlock = switchStmt.getSwitchBlock();
        for (Op03SimpleStatement caseStatement : switchStatement.getTargets()) {
            CaseStatement caseStmt;
            if (!(caseStatement.getStatement() instanceof CaseStatement) || switchBlock != (caseStmt = (CaseStatement)caseStatement.getStatement()).getSwitchBlock()) continue;
            BlockIdentifier caseBlock = caseStmt.getCaseBlock();
            Op03SimpleStatement target = caseStatement.getTargets().get(0);
            Iterator<Op03SimpleStatement> targetSourceIt = target.getSources().iterator();
            while (targetSourceIt.hasNext()) {
                Set<BlockIdentifier> blockIdentifiers;
                Op03SimpleStatement src = targetSourceIt.next();
                if (src == caseStatement || (blockIdentifiers = src.getBlockIdentifiers()).contains(caseBlock) || !blockIdentifiers.contains(switchBlock)) continue;
                targetSourceIt.remove();
                src.replaceTarget(target, caseStatement);
                caseStatement.addSource(src);
            }
        }
    }

    private static void moveJumpsToTerminalIfEmpty(Op03SimpleStatement switchStatement, List<Op03SimpleStatement> statements) {
        SwitchStatement swatch = (SwitchStatement)switchStatement.getStatement();
        Op03SimpleStatement lastTgt = switchStatement.getTargets().get(switchStatement.getTargets().size() - 1);
        BlockIdentifier switchBlock = swatch.getSwitchBlock();
        if (!lastTgt.getBlockIdentifiers().contains(switchBlock)) {
            return;
        }
        if (lastTgt.getTargets().size() != 1) {
            return;
        }
        if (lastTgt.getSources().size() == 1) {
            return;
        }
        Op03SimpleStatement following = lastTgt.getTargets().get(0);
        if (following.getBlockIdentifiers().contains(switchBlock)) {
            return;
        }
        List<Op03SimpleStatement> forwardJumpSources = Functional.filter(lastTgt.getSources(), new Misc.IsForwardJumpTo(lastTgt.getIndex()));
        if (forwardJumpSources.size() <= 1) {
            return;
        }
        int idx = statements.indexOf(lastTgt);
        if (idx == 0) {
            return;
        }
        if (idx >= statements.size() - 1) {
            return;
        }
        if (statements.get(idx + 1) != following) {
            return;
        }
        for (Op03SimpleStatement forwardJumpSource : forwardJumpSources) {
            JumpingStatement jumpingStatement;
            JumpType jumpType;
            if (forwardJumpSource == switchStatement) continue;
            forwardJumpSource.replaceTarget(lastTgt, following);
            lastTgt.removeSource(forwardJumpSource);
            following.addSource(forwardJumpSource);
            Statement forwardJump = forwardJumpSource.getStatement();
            if (!(forwardJump instanceof JumpingStatement) || !(jumpType = (jumpingStatement = (JumpingStatement)forwardJump).getJumpType()).isUnknown()) continue;
            jumpingStatement.setJumpType(JumpType.BREAK);
        }
    }

    private static int getDefault(DecodedSwitch decodedSwitch) {
        List<DecodedSwitchEntry> jumpTargets = decodedSwitch.getJumpTargets();
        for (int idx = 0; idx < jumpTargets.size(); ++idx) {
            DecodedSwitchEntry entry = jumpTargets.get(idx);
            if (!entry.hasDefault()) continue;
            return idx;
        }
        return -1;
    }

    private static void tryInlineRawSwitchContent(Op03SimpleStatement switchStatement, List<Op03SimpleStatement> statements) {
        RawSwitchStatement rawSwitch = (RawSwitchStatement)switchStatement.getStatement();
        int defaultIdx = SwitchReplacer.getDefault(rawSwitch.getSwitchData());
        if (defaultIdx < 0) {
            return;
        }
        Op03SimpleStatement defaultTarget = switchStatement.getTargets().get(defaultIdx);
        Op03SimpleStatement ultTarget = Misc.followNopGotoChain(defaultTarget, true, false);
        Set<Op03SimpleStatement> seen = SetFactory.newSet(switchStatement);
        List<NodesReachedUntil> reachedUntils = ListFactory.newList();
        for (Op03SimpleStatement target : switchStatement.getTargets()) {
            NodesReachedUntil nodesReachedUntil = new NodesReachedUntil(target, ultTarget, seen);
            reachedUntils.add(nodesReachedUntil);
            GraphVisitorDFS<Op03SimpleStatement> gv = new GraphVisitorDFS<Op03SimpleStatement>(target, nodesReachedUntil);
            gv.process();
            if (!nodesReachedUntil.found) {
                return;
            }
            if (nodesReachedUntil.hitBanned) {
                return;
            }
            Set reachedNodes = nodesReachedUntil.reaches;
            for (Op03SimpleStatement reached : reachedNodes) {
                for (Op03SimpleStatement source : reached.getSources()) {
                    if (reachedNodes.contains(source) || source == switchStatement) continue;
                    return;
                }
            }
            if (!SwitchReplacer.blockIsContiguous(statements, target, reachedNodes)) {
                return;
            }
            seen.addAll(reachedNodes);
        }
        InstrIndex targetIndex = switchStatement.getIndex();
        Op03SimpleStatement lastStatement = null;
        Op03SimpleStatement firstStatement = null;
        for (NodesReachedUntil reached : reachedUntils) {
            Op03SimpleStatement start = reached.start;
            int idx = statements.indexOf(start);
            int max = idx + reached.reaches.size();
            for (int x = idx; x < max; ++x) {
                targetIndex = targetIndex.justAfter();
                lastStatement = statements.get(x);
                if (firstStatement == null) {
                    firstStatement = lastStatement;
                }
                lastStatement.setIndex(targetIndex);
            }
        }
        if (lastStatement == null) {
            return;
        }
        if (ultTarget.getIndex().isBackJumpFrom(switchStatement)) {
            targetIndex = targetIndex.justAfter();
            Op03SimpleStatement ultTargetNew = new Op03SimpleStatement(lastStatement.getBlockIdentifiers(), new GotoStatement(), targetIndex);
            statements.add(ultTargetNew);
            ultTargetNew.addTarget(ultTarget);
            ultTarget.addSource(ultTargetNew);
            List<Op03SimpleStatement> ultSources = ListFactory.newList(ultTarget.getSources());
            seen.add(switchStatement);
            for (Op03SimpleStatement source : ultSources) {
                if (!seen.contains(source)) continue;
                ultTarget.removeSource(source);
                source.replaceTarget(ultTarget, ultTargetNew);
                ultTargetNew.addSource(source);
            }
        }
        Set<BlockIdentifier> firstBlocks = firstStatement.getBlockIdentifiers();
        List<BlockIdentifier> newInFirst = SetUtil.differenceAtakeBtoList(firstBlocks, switchStatement.getBlockIdentifiers());
        Cleaner.sortAndRenumberInPlace(statements);
        switchStatement.getBlockIdentifiers().addAll(newInFirst);
    }

    private static class NodesReachedUntil
    implements BinaryProcedure<Op03SimpleStatement, GraphVisitor<Op03SimpleStatement>> {
        private final Op03SimpleStatement start;
        private final Op03SimpleStatement target;
        private final Set<Op03SimpleStatement> banned;
        private boolean found = false;
        private boolean hitBanned = false;
        private final Set<Op03SimpleStatement> reaches = SetFactory.newSet();

        private NodesReachedUntil(Op03SimpleStatement start, Op03SimpleStatement target, Set<Op03SimpleStatement> banned) {
            this.start = start;
            this.target = target;
            this.banned = banned;
        }

        @Override
        public void call(Op03SimpleStatement arg1, GraphVisitor<Op03SimpleStatement> arg2) {
            if (arg1 == this.target) {
                this.found = true;
                return;
            }
            if (this.banned.contains(arg1)) {
                this.hitBanned = true;
                return;
            }
            if (this.reaches.add(arg1)) {
                arg2.enqueue(arg1.getTargets());
            }
        }
    }

    private static class NodeReachable
    implements BinaryProcedure<Op03SimpleStatement, GraphVisitor<Op03SimpleStatement>> {
        private final Set<Op03SimpleStatement> otherCases;
        private final Op03SimpleStatement switchStatement;
        private final Op03SimpleStatement start;
        private final List<Op03SimpleStatement> reaches = ListFactory.newList();
        private final Set<Op03SimpleStatement> inBlock = SetFactory.newSet();

        private NodeReachable(Set<Op03SimpleStatement> otherCases, Op03SimpleStatement start, Op03SimpleStatement switchStatement) {
            this.otherCases = otherCases;
            this.switchStatement = switchStatement;
            this.start = start;
        }

        @Override
        public void call(Op03SimpleStatement arg1, GraphVisitor<Op03SimpleStatement> arg2) {
            if (arg1 == this.switchStatement) {
                return;
            }
            if (arg1.getIndex().isBackJumpFrom(this.start) && arg1.getIndex().isBackJumpFrom(this.switchStatement)) {
                return;
            }
            if (arg1 != this.start && this.otherCases.contains(arg1)) {
                this.reaches.add(arg1);
                return;
            }
            this.inBlock.add(arg1);
            arg2.enqueue(arg1.getTargets());
        }
    }
}

