/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.entities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral;
import org.benf.cfr.reader.bytecode.analysis.types.ClassNameUtils;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.RawJavaType;
import org.benf.cfr.reader.entities.AccessFlag;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.entities.attributes.Attribute;
import org.benf.cfr.reader.entities.attributes.AttributeConstantValue;
import org.benf.cfr.reader.entities.attributes.AttributeRuntimeInvisibleAnnotations;
import org.benf.cfr.reader.entities.attributes.AttributeRuntimeVisibleAnnotations;
import org.benf.cfr.reader.entities.attributes.AttributeSignature;
import org.benf.cfr.reader.entities.constantpool.ConstantPool;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryUTF8;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolUtils;
import org.benf.cfr.reader.entityfactories.AttributeFactory;
import org.benf.cfr.reader.entityfactories.ContiguousEntityFactory;
import org.benf.cfr.reader.state.TypeUsageCollector;
import org.benf.cfr.reader.util.ClassFileVersion;
import org.benf.cfr.reader.util.KnowsRawSize;
import org.benf.cfr.reader.util.TypeUsageCollectable;
import org.benf.cfr.reader.util.bytestream.ByteData;
import org.benf.cfr.reader.util.collections.CollectionUtils;
import org.benf.cfr.reader.util.output.Dumper;

public class Field
implements KnowsRawSize,
TypeUsageCollectable {
    private static final long OFFSET_OF_ACCESS_FLAGS = 0L;
    private static final long OFFSET_OF_NAME_INDEX = 2L;
    private static final long OFFSET_OF_DESCRIPTOR_INDEX = 4L;
    private static final long OFFSET_OF_ATTRIBUTES_COUNT = 6L;
    private static final long OFFSET_OF_ATTRIBUTES = 8L;
    private final ConstantPool cp;
    private final long length;
    private final int descriptorIndex;
    private final Set<AccessFlag> accessFlags;
    private final Map<String, Attribute> attributes;
    private final TypedLiteral constantValue;
    private final String fieldName;
    private boolean disambiguate;
    private transient JavaTypeInstance cachedDecodedType;

    public Field(ByteData raw, ConstantPool cp, ClassFileVersion classFileVersion) {
        JavaTypeInstance thisType;
        this.cp = cp;
        this.accessFlags = AccessFlag.build(raw.getU2At(0L));
        int attributes_count = raw.getU2At(6L);
        ArrayList tmpAttributes = new ArrayList();
        tmpAttributes.ensureCapacity(attributes_count);
        long attributesLength = ContiguousEntityFactory.build(raw.getOffsetData(8L), attributes_count, tmpAttributes, AttributeFactory.getBuilder(cp, classFileVersion));
        this.attributes = ContiguousEntityFactory.addToMap(new HashMap(), tmpAttributes);
        AccessFlag.applyAttributes(this.attributes, this.accessFlags);
        this.descriptorIndex = raw.getU2At(4L);
        int nameIndex = raw.getU2At(2L);
        this.length = 8L + attributesLength;
        Attribute cvAttribute = this.attributes.get("ConstantValue");
        this.fieldName = cp.getUTF8Entry(nameIndex).getValue();
        this.disambiguate = false;
        TypedLiteral constValue = null;
        if (cvAttribute != null && (constValue = TypedLiteral.getConstantPoolEntry(cp, ((AttributeConstantValue)cvAttribute).getValue())).getType() == TypedLiteral.LiteralType.Integer && (thisType = this.getJavaTypeInstance()) instanceof RawJavaType) {
            constValue = TypedLiteral.shrinkTo(constValue, (RawJavaType)thisType);
        }
        this.constantValue = constValue;
    }

    @Override
    public long getRawByteLength() {
        return this.length;
    }

    private AttributeSignature getSignatureAttribute() {
        Attribute attribute = this.attributes.get("Signature");
        if (attribute == null) {
            return null;
        }
        return (AttributeSignature)attribute;
    }

    public JavaTypeInstance getJavaTypeInstance() {
        if (this.cachedDecodedType == null) {
            AttributeSignature sig = this.getSignatureAttribute();
            ConstantPoolEntryUTF8 signature = sig == null ? null : sig.getSignature();
            ConstantPoolEntryUTF8 descriptor = this.cp.getUTF8Entry(this.descriptorIndex);
            ConstantPoolEntryUTF8 prototype = signature == null ? descriptor : signature;
            this.cachedDecodedType = ConstantPoolUtils.decodeTypeTok(prototype.getValue(), this.cp);
        }
        return this.cachedDecodedType;
    }

    void setDisambiguate() {
        this.disambiguate = true;
    }

    public String getFieldName() {
        if (this.disambiguate) {
            return "var_" + ClassNameUtils.getTypeFixPrefix(this.getJavaTypeInstance()) + this.fieldName;
        }
        return this.fieldName;
    }

    public boolean testAccessFlag(AccessFlag accessFlag) {
        return this.accessFlags.contains((Object)accessFlag);
    }

    public TypedLiteral getConstantValue() {
        return this.constantValue;
    }

    private <T extends Attribute> T getAttributeByName(String name) {
        Attribute attribute = this.attributes.get(name);
        if (attribute == null) {
            return null;
        }
        Attribute tmp = attribute;
        return (T)tmp;
    }

    @Override
    public void collectTypeUsages(TypeUsageCollector collector) {
        collector.collect(this.getJavaTypeInstance());
        collector.collectFrom((TypeUsageCollectable)this.getAttributeByName("RuntimeVisibleAnnotations"));
        collector.collectFrom((TypeUsageCollectable)this.getAttributeByName("RuntimeInvisibleAnnotations"));
    }

    public void dump(Dumper d, String name, ClassFile owner) {
        String prefix;
        AttributeRuntimeVisibleAnnotations runtimeVisibleAnnotations = (AttributeRuntimeVisibleAnnotations)this.getAttributeByName("RuntimeVisibleAnnotations");
        AttributeRuntimeInvisibleAnnotations runtimeInvisibleAnnotations = (AttributeRuntimeInvisibleAnnotations)this.getAttributeByName("RuntimeInvisibleAnnotations");
        if (runtimeVisibleAnnotations != null) {
            runtimeVisibleAnnotations.dump(d);
        }
        if (runtimeInvisibleAnnotations != null) {
            runtimeInvisibleAnnotations.dump(d);
        }
        if (!(prefix = CollectionUtils.join(this.accessFlags, " ")).isEmpty()) {
            d.print(prefix).print(' ');
        }
        JavaTypeInstance type = this.getJavaTypeInstance();
        d.dump(type).print(' ').fieldName(name, owner.getClassType(), false, false, true);
    }
}

