/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.benf.cfr.reader.bytecode.AnalysisResult;
import org.benf.cfr.reader.bytecode.AnalysisResultFromException;
import org.benf.cfr.reader.bytecode.AnalysisResultSuccessful;
import org.benf.cfr.reader.bytecode.AnonymousClassUsage;
import org.benf.cfr.reader.bytecode.BytecodeMeta;
import org.benf.cfr.reader.bytecode.RecoveryOption;
import org.benf.cfr.reader.bytecode.RecoveryOptions;
import org.benf.cfr.reader.bytecode.analysis.opgraph.Op01WithProcessedDataAndByteJumps;
import org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs;
import org.benf.cfr.reader.bytecode.analysis.opgraph.Op03Blocks;
import org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement;
import org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op2rewriters.GetClassTestInnerConstructor;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op2rewriters.GetClassTestLambda;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op2rewriters.Op02GetClassRewriter;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op2rewriters.Op02RedundantStoreRewriter;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op2rewriters.TypeHintRecovery;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op2rewriters.TypeHintRecoveryImpl;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op2rewriters.TypeHintRecoveryNone;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.AnonymousArray;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.BadNarrowingArgRewriter;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Cleaner;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.FinallyRewriter;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.InlineDeAssigner;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.IterLoopRewriter;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.KotlinSwitchHandler;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LValueProp;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LValuePropSimple;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopIdentifier;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.NullTypedLValueRewriter;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.RemoveDeterministicJumps;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.StaticInitReturnRewriter;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SynchronizedBlocks;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.checker.LooseCatchChecker;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.StringBuilderRewriter;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.XorRewriter;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.BlockIdentifierFactory;
import org.benf.cfr.reader.bytecode.analysis.variables.VariableFactory;
import org.benf.cfr.reader.bytecode.opcode.JVMInstr;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.entities.Method;
import org.benf.cfr.reader.entities.attributes.AttributeCode;
import org.benf.cfr.reader.entities.constantpool.ConstantPool;
import org.benf.cfr.reader.entities.exceptions.ExceptionAggregator;
import org.benf.cfr.reader.entities.exceptions.ExceptionTableEntry;
import org.benf.cfr.reader.state.DCCommonState;
import org.benf.cfr.reader.util.ClassFileVersion;
import org.benf.cfr.reader.util.DecompilerComment;
import org.benf.cfr.reader.util.DecompilerComments;
import org.benf.cfr.reader.util.Troolean;
import org.benf.cfr.reader.util.bytestream.ByteData;
import org.benf.cfr.reader.util.bytestream.OffsettingByteData;
import org.benf.cfr.reader.util.collections.ListFactory;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.benf.cfr.reader.util.output.Dumper;
import org.benf.cfr.reader.util.output.LoggerFactory;

public class CodeAnalyser {
    private static final Logger logger = LoggerFactory.create(CodeAnalyser.class);
    private final AttributeCode originalCodeAttribute;
    private final ConstantPool cp;
    private Method method;
    private Op04StructuredStatement analysed;
    private static final RecoveryOptions recover0 = new RecoveryOptions(new RecoveryOption.TrooleanRO(OptionsImpl.RECOVER_TYPECLASHES, Troolean.TRUE, BytecodeMeta.hasAnyFlag(BytecodeMeta.CodeInfoFlag.LIVENESS_CLASH)), new RecoveryOption.TrooleanRO(OptionsImpl.USE_RECOVERED_ITERATOR_TYPE_HINTS, Troolean.TRUE, BytecodeMeta.hasAnyFlag(BytecodeMeta.CodeInfoFlag.ITERATED_TYPE_HINTS)), new RecoveryOption.BooleanRO(OptionsImpl.STATIC_INIT_RETURN, Boolean.FALSE));
    private static final RecoveryOptions recoverExAgg = new RecoveryOptions(new RecoveryOption.TrooleanRO(OptionsImpl.RECOVER_TYPECLASHES, Troolean.TRUE, BytecodeMeta.hasAnyFlag(BytecodeMeta.CodeInfoFlag.LIVENESS_CLASH)), new RecoveryOption.TrooleanRO(OptionsImpl.USE_RECOVERED_ITERATOR_TYPE_HINTS, Troolean.TRUE, BytecodeMeta.hasAnyFlag(BytecodeMeta.CodeInfoFlag.ITERATED_TYPE_HINTS)), new RecoveryOption.TrooleanRO(OptionsImpl.FORCE_AGGRESSIVE_EXCEPTION_AGG, Troolean.TRUE, BytecodeMeta.hasAnyFlag(BytecodeMeta.CodeInfoFlag.USES_EXCEPTIONS), DecompilerComment.AGGRESSIVE_EXCEPTION_AGG));
    private static final RecoveryOptions recover0a = new RecoveryOptions(recover0, new RecoveryOption.TrooleanRO(OptionsImpl.FORCE_COND_PROPAGATE, Troolean.TRUE, DecompilerComment.COND_PROPAGATE), new RecoveryOption.TrooleanRO(OptionsImpl.FORCE_RETURNING_IFS, Troolean.TRUE, DecompilerComment.RETURNING_IFS));
    private static final RecoveryOptions recover1 = new RecoveryOptions(recover0, new RecoveryOption.TrooleanRO(OptionsImpl.FORCE_TOPSORT, Troolean.TRUE, DecompilerComment.AGGRESSIVE_TOPOLOGICAL_SORT), new RecoveryOption.TrooleanRO(OptionsImpl.FOR_LOOP_CAPTURE, Troolean.TRUE), new RecoveryOption.BooleanRO(OptionsImpl.LENIENT, Boolean.TRUE), new RecoveryOption.TrooleanRO(OptionsImpl.FORCE_COND_PROPAGATE, Troolean.TRUE), new RecoveryOption.TrooleanRO(OptionsImpl.FORCE_PRUNE_EXCEPTIONS, Troolean.TRUE, BytecodeMeta.hasAnyFlag(BytecodeMeta.CodeInfoFlag.USES_EXCEPTIONS), DecompilerComment.PRUNE_EXCEPTIONS), new RecoveryOption.TrooleanRO(OptionsImpl.FORCE_AGGRESSIVE_EXCEPTION_AGG, Troolean.TRUE, BytecodeMeta.hasAnyFlag(BytecodeMeta.CodeInfoFlag.USES_EXCEPTIONS), DecompilerComment.AGGRESSIVE_EXCEPTION_AGG));
    private static final RecoveryOptions recover2 = new RecoveryOptions(recover1, new RecoveryOption.TrooleanRO(OptionsImpl.FORCE_TOPSORT_EXTRA, Troolean.TRUE));
    private static final RecoveryOptions recover3 = new RecoveryOptions(recover1, new RecoveryOption.BooleanRO(OptionsImpl.COMMENT_MONITORS, Boolean.TRUE, BytecodeMeta.hasAnyFlag(BytecodeMeta.CodeInfoFlag.USES_MONITORS), DecompilerComment.COMMENT_MONITORS), new RecoveryOption.TrooleanRO(OptionsImpl.FORCE_RETURNING_IFS, Troolean.TRUE, DecompilerComment.RETURNING_IFS));
    private static final RecoveryOptions recoverLast = new RecoveryOptions(recover3, new RecoveryOption.BooleanRO(OptionsImpl.IGNORE_EXCEPTIONS_ALWAYS, true, BytecodeMeta.checkParam(OptionsImpl.IGNORE_EXCEPTIONS), DecompilerComment.DROP_EXCEPTIONS));
    private static final RecoveryOptions[] recoveryOptionsArr = new RecoveryOptions[]{recover0, recover0a, recover1, recover2, recoverExAgg, recover3, recoverLast};

    public CodeAnalyser(AttributeCode attributeCode) {
        this.originalCodeAttribute = attributeCode;
        this.cp = attributeCode.getConstantPool();
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Op04StructuredStatement getAnalysis(DCCommonState dcCommonState) {
        AnalysisResult res;
        if (this.analysed != null) {
            return this.analysed;
        }
        Options options = dcCommonState.getOptions();
        List<Op01WithProcessedDataAndByteJumps> instrs = this.getInstrs();
        BytecodeMeta bytecodeMeta = new BytecodeMeta(instrs, this.originalCodeAttribute, options);
        if (options.optionIsSet(OptionsImpl.FORCE_PASS)) {
            int pass = (Integer)options.getOption(OptionsImpl.FORCE_PASS);
            if (pass < 0 || pass >= recoveryOptionsArr.length) {
                throw new IllegalArgumentException("Illegal recovery pass idx");
            }
            RecoveryOptions.Applied applied = recoveryOptionsArr[pass].apply(dcCommonState, options, bytecodeMeta);
            res = this.getAnalysisOrWrapFail(pass, instrs, dcCommonState, applied.options, applied.comments, bytecodeMeta);
        } else {
            res = this.getAnalysisOrWrapFail(0, instrs, dcCommonState, options, null, bytecodeMeta);
            if (res.isFailed() && ((Boolean)options.getOption(OptionsImpl.RECOVER)).booleanValue()) {
                int passIdx = 1;
                for (RecoveryOptions recoveryOptions : recoveryOptionsArr) {
                    AnalysisResult nextRes;
                    RecoveryOptions.Applied applied = recoveryOptions.apply(dcCommonState, options, bytecodeMeta);
                    if (!applied.valid) continue;
                    if ((nextRes = this.getAnalysisOrWrapFail(passIdx++, instrs, dcCommonState, applied.options, applied.comments, bytecodeMeta)) != null) {
                        if (res.isFailed() && nextRes.isFailed()) {
                            if (res.isThrown() || !nextRes.isThrown()) {
                                res = nextRes;
                            }
                        } else {
                            res = nextRes;
                        }
                    }
                    if (!res.isFailed()) break;
                }
            }
        }
        if (res.getComments() != null) {
            this.method.setComments(res.getComments());
        }
        res.getAnonymousClassUsage().useNotes();
        this.analysed = res.getCode();
        return this.analysed;
    }

    private List<Op01WithProcessedDataAndByteJumps> getInstrs() {
        int length;
        ByteData rawCode = this.originalCodeAttribute.getRawData();
        long codeLength = this.originalCodeAttribute.getCodeLength();
        ArrayList<Op01WithProcessedDataAndByteJumps> instrs = new ArrayList<Op01WithProcessedDataAndByteJumps>();
        OffsettingByteData bdCode = rawCode.getOffsettingOffsetData(0L);
        int offset = 0;
        instrs.add(JVMInstr.NOP.createOperation(null, this.cp, -1));
        do {
            JVMInstr instr = JVMInstr.find(bdCode.getS1At(0L));
            Op01WithProcessedDataAndByteJumps oc = instr.createOperation(bdCode, this.cp, offset);
            length = oc.getInstructionLength();
            instrs.add(oc);
            bdCode.advance(length);
        } while ((long)(offset += length) < codeLength);
        return instrs;
    }

    private AnalysisResult getAnalysisOrWrapFail(int passIdx, List<Op01WithProcessedDataAndByteJumps> instrs, DCCommonState commonState, Options options, List<DecompilerComment> extraComments, BytecodeMeta bytecodeMeta) {
        try {
            AnalysisResult res = this.getAnalysisInner(instrs, commonState, options, bytecodeMeta, passIdx);
            if (extraComments != null) {
                res.getComments().addComments(extraComments);
            }
            return res;
        }
        catch (RuntimeException e) {
            return new AnalysisResultFromException(e);
        }
    }

    private AnalysisResult getAnalysisInner(List<Op01WithProcessedDataAndByteJumps> instrs, DCCommonState dcCommonState, Options options, BytecodeMeta bytecodeMeta, int passIdx) {
        boolean reloop;
        ExceptionAggregator exceptions;
        int x;
        boolean aggressiveSizeReductions;
        boolean willSort = options.getOption(OptionsImpl.FORCE_TOPSORT) == Troolean.TRUE;
        ClassFile classFile = this.method.getClassFile();
        ClassFileVersion classFileVersion = classFile.getClassFileVersion();
        DecompilerComments comments = new DecompilerComments();
        boolean bl = aggressiveSizeReductions = (Integer)options.getOption(OptionsImpl.AGGRESSIVE_SIZE_REDUCTION_THRESHOLD) < instrs.size();
        if (aggressiveSizeReductions) {
            comments.addComment("Opcode count of " + instrs.size() + " triggered aggressive code reduction.  Override with --" + OptionsImpl.AGGRESSIVE_SIZE_REDUCTION_THRESHOLD.getName() + ".");
        }
        TreeMap<Integer, Integer> lutByOffset = new TreeMap<Integer, Integer>();
        HashMap<Integer, Integer> lutByIdx = new HashMap<Integer, Integer>();
        int idx2 = 0;
        int offset2 = -1;
        for (Op01WithProcessedDataAndByteJumps op : instrs) {
            lutByOffset.put(offset2, idx2);
            lutByIdx.put(idx2, offset2);
            offset2 += op.getInstructionLength();
            ++idx2;
        }
        lutByIdx.put(0, -1);
        lutByOffset.put(-1, 0);
        List op1list = ListFactory.newList();
        List<Op02WithProcessedDataAndRefs> op2list = ListFactory.newList();
        for (x = 0; x < instrs.size(); ++x) {
            Op01WithProcessedDataAndByteJumps op1 = instrs.get(x);
            op1list.add(op1);
            Op02WithProcessedDataAndRefs op2 = op1.createOp2(this.cp, x);
            op2list.add(op2);
        }
        int len = instrs.size();
        for (x = 0; x < len; ++x) {
            int offsetOfThisInstruction = (Integer)lutByIdx.get(x);
            int[] targetIdxs = ((Op01WithProcessedDataAndByteJumps)op1list.get(x)).getAbsoluteIndexJumps(offsetOfThisInstruction, lutByOffset);
            Op02WithProcessedDataAndRefs source = (Op02WithProcessedDataAndRefs)op2list.get(x);
            for (int targetIdx : targetIdxs) {
                if (targetIdx >= len) continue;
                Op02WithProcessedDataAndRefs target = (Op02WithProcessedDataAndRefs)op2list.get(targetIdx);
                source.addTarget(target);
                target.addSource(source);
            }
        }
        BlockIdentifierFactory blockIdentifierFactory = new BlockIdentifierFactory();
        List<ExceptionTableEntry> exceptionTableEntries = this.originalCodeAttribute.getExceptionTableEntries();
        if (((Boolean)options.getOption(OptionsImpl.IGNORE_EXCEPTIONS_ALWAYS)).booleanValue()) {
            exceptionTableEntries = ListFactory.newList();
        }
        if ((exceptions = new ExceptionAggregator(exceptionTableEntries, blockIdentifierFactory, lutByOffset, instrs, options, this.cp)).RemovedLoopingExceptions()) {
            comments.addComment(DecompilerComment.LOOPING_EXCEPTIONS);
        }
        if (options.getOption(OptionsImpl.FORCE_PRUNE_EXCEPTIONS) == Troolean.TRUE) {
            exceptions.aggressivePruning(lutByOffset, lutByIdx, instrs);
            exceptions.removeSynchronisedHandlers(lutByOffset, lutByIdx, instrs);
        }
        if (options.getOption(OptionsImpl.REWRITE_LAMBDAS, classFileVersion).booleanValue() && bytecodeMeta.has(BytecodeMeta.CodeInfoFlag.USES_INVOKEDYNAMIC)) {
            Op02GetClassRewriter.removeInvokeGetClass(classFile, op2list, GetClassTestLambda.INSTANCE);
        }
        Op02GetClassRewriter.removeInvokeGetClass(classFile, op2list, GetClassTestInnerConstructor.INSTANCE);
        long codeLength = this.originalCodeAttribute.getCodeLength();
        op2list = Op02WithProcessedDataAndRefs.insertExceptionBlocks(op2list, exceptions, lutByOffset, this.cp, codeLength, options);
        if (aggressiveSizeReductions) {
            Op02RedundantStoreRewriter.rewrite(op2list, this.originalCodeAttribute.getMaxLocals());
        }
        Op02WithProcessedDataAndRefs.populateStackInfo(op2list, this.method);
        if (Op02WithProcessedDataAndRefs.processJSR(op2list)) {
            Op02WithProcessedDataAndRefs.populateStackInfo(op2list, this.method);
        }
        Op02WithProcessedDataAndRefs.unlinkUnreachable(op2list);
        Op02WithProcessedDataAndRefs.discoverStorageLiveness(this.method, comments, op2list, bytecodeMeta);
        VariableFactory variableFactory = new VariableFactory(this.method);
        TypeHintRecovery typeHintRecovery = options.optionIsSet(OptionsImpl.USE_RECOVERED_ITERATOR_TYPE_HINTS) ? new TypeHintRecoveryImpl(bytecodeMeta) : TypeHintRecoveryNone.INSTANCE;
        List<Op03SimpleStatement> op03SimpleParseNodes = Op02WithProcessedDataAndRefs.convertToOp03List(op2list, this.method, variableFactory, blockIdentifierFactory, dcCommonState, typeHintRecovery);
        op03SimpleParseNodes = Cleaner.sortAndRenumber(op03SimpleParseNodes);
        Misc.flattenCompoundStatements(op03SimpleParseNodes);
        Op03SimpleStatement.rewriteWith(op03SimpleParseNodes, new NullTypedLValueRewriter());
        GenericInferer.inferGenericObjectInfoFromCalls(op03SimpleParseNodes);
        op03SimpleParseNodes = Cleaner.sortAndRenumber(op03SimpleParseNodes);
        if (aggressiveSizeReductions) {
            op03SimpleParseNodes = LValuePropSimple.condenseSimpleLValues(op03SimpleParseNodes);
        }
        Op03SimpleStatement.assignSSAIdentifiers(this.method, op03SimpleParseNodes);
        LValueProp.condenseLValues(op03SimpleParseNodes);
        op03SimpleParseNodes = Cleaner.sortAndRenumber(op03SimpleParseNodes);
        op03SimpleParseNodes = KotlinSwitchHandler.extractStringSwitches(op03SimpleParseNodes, bytecodeMeta);
        SwitchReplacer.replaceRawSwitches(this.method, op03SimpleParseNodes, blockIdentifierFactory, options);
        op03SimpleParseNodes = Cleaner.sortAndRenumber(op03SimpleParseNodes);
        Op03SimpleStatement.removePointlessJumps(op03SimpleParseNodes);
        op03SimpleParseNodes = Op03SimpleStatement.eliminateCatchTemporaries(op03SimpleParseNodes);
        logger.info("identifyCatchBlocks");
        Op03SimpleStatement.identifyCatchBlocks(op03SimpleParseNodes, blockIdentifierFactory);
        Op03SimpleStatement.combineTryCatchBlocks(op03SimpleParseNodes);
        if (((Boolean)options.getOption(OptionsImpl.COMMENT_MONITORS)).booleanValue()) {
            Op03SimpleStatement.commentMonitors(op03SimpleParseNodes);
        }
        AnonymousClassUsage anonymousClassUsage = new AnonymousClassUsage();
        Op03SimpleStatement.condenseConstruction(dcCommonState, this.method, op03SimpleParseNodes, anonymousClassUsage);
        LValueProp.condenseLValues(op03SimpleParseNodes);
        Op03SimpleStatement.condenseLValueChain1(op03SimpleParseNodes);
        StaticInitReturnRewriter.rewrite(options, this.method, op03SimpleParseNodes);
        op03SimpleParseNodes = Op03SimpleStatement.removeRedundantTries(op03SimpleParseNodes);
        FinallyRewriter.identifyFinally(options, this.method, op03SimpleParseNodes, blockIdentifierFactory);
        op03SimpleParseNodes = Cleaner.removeUnreachableCode(op03SimpleParseNodes, !willSort);
        op03SimpleParseNodes = Cleaner.sortAndRenumber(op03SimpleParseNodes);
        Op03SimpleStatement.extendTryBlocks(dcCommonState, op03SimpleParseNodes);
        Op03SimpleStatement.combineTryCatchEnds(op03SimpleParseNodes);
        Op03SimpleStatement.removePointlessExpressionStatements(op03SimpleParseNodes);
        op03SimpleParseNodes = Cleaner.removeUnreachableCode(op03SimpleParseNodes, !willSort);
        Op03SimpleStatement.replacePrePostChangeAssignments(op03SimpleParseNodes);
        Op03SimpleStatement.pushPreChangeBack(op03SimpleParseNodes);
        Op03SimpleStatement.condenseLValueChain2(op03SimpleParseNodes);
        Op03SimpleStatement.collapseAssignmentsIntoConditionals(op03SimpleParseNodes, options);
        LValueProp.condenseLValues(op03SimpleParseNodes);
        op03SimpleParseNodes = Cleaner.sortAndRenumber(op03SimpleParseNodes);
        if (options.getOption(OptionsImpl.FORCE_COND_PROPAGATE) == Troolean.TRUE) {
            op03SimpleParseNodes = RemoveDeterministicJumps.apply(this.method, op03SimpleParseNodes);
        }
        if (options.getOption(OptionsImpl.FORCE_TOPSORT) == Troolean.TRUE) {
            if (options.getOption(OptionsImpl.FORCE_RETURNING_IFS) == Troolean.TRUE) {
                Op03SimpleStatement.replaceReturningIfs(op03SimpleParseNodes, true);
            }
            if (options.getOption(OptionsImpl.FORCE_COND_PROPAGATE) == Troolean.TRUE) {
                Op03SimpleStatement.propagateToReturn2(op03SimpleParseNodes);
            }
            op03SimpleParseNodes = Cleaner.removeUnreachableCode(op03SimpleParseNodes, false);
            op03SimpleParseNodes = Op03Blocks.topologicalSort(op03SimpleParseNodes, comments, options);
            Op03SimpleStatement.removePointlessJumps(op03SimpleParseNodes);
            SwitchReplacer.rebuildSwitches(op03SimpleParseNodes, options);
            Op03SimpleStatement.rejoinBlocks(op03SimpleParseNodes);
            Op03SimpleStatement.extendTryBlocks(dcCommonState, op03SimpleParseNodes);
            op03SimpleParseNodes = Op03Blocks.combineTryBlocks(op03SimpleParseNodes);
            Op03SimpleStatement.combineTryCatchEnds(op03SimpleParseNodes);
            Op03SimpleStatement.rewriteTryBackJumps(op03SimpleParseNodes);
            FinallyRewriter.identifyFinally(options, this.method, op03SimpleParseNodes, blockIdentifierFactory);
            if (options.getOption(OptionsImpl.FORCE_RETURNING_IFS) == Troolean.TRUE) {
                Op03SimpleStatement.replaceReturningIfs(op03SimpleParseNodes, true);
            }
        }
        if (options.getOption(OptionsImpl.FORCE_COND_PROPAGATE) == Troolean.TRUE) {
            RemoveDeterministicJumps.propagateToReturn(this.method, op03SimpleParseNodes);
        }
        logger.info("sugarAnyonymousArrays");
        AnonymousArray.resugarAnonymousArrays(op03SimpleParseNodes);
        do {
            Op03SimpleStatement.rewriteNegativeJumps(op03SimpleParseNodes, true);
            logger.info("collapseAssignmentsIntoConditionals");
            Op03SimpleStatement.collapseAssignmentsIntoConditionals(op03SimpleParseNodes, options);
            logger.info("condenseConditionals");
            reloop = Op03SimpleStatement.condenseConditionals(op03SimpleParseNodes);
            reloop |= Op03SimpleStatement.condenseConditionals2(op03SimpleParseNodes);
            if (reloop |= Op03SimpleStatement.normalizeDupAssigns(op03SimpleParseNodes)) {
                LValueProp.condenseLValues(op03SimpleParseNodes);
            }
            op03SimpleParseNodes = Cleaner.removeUnreachableCode(op03SimpleParseNodes, true);
        } while (reloop);
        logger.info("simplifyConditionals");
        Op03SimpleStatement.simplifyConditionals(op03SimpleParseNodes, false);
        op03SimpleParseNodes = Cleaner.sortAndRenumber(op03SimpleParseNodes);
        logger.info("rewriteNegativeJumps");
        Op03SimpleStatement.rewriteNegativeJumps(op03SimpleParseNodes, false);
        Op03SimpleStatement.optimiseForTypes(op03SimpleParseNodes);
        if (((Boolean)options.getOption(OptionsImpl.ECLIPSE)).booleanValue()) {
            Op03SimpleStatement.eclipseLoopPass(op03SimpleParseNodes);
        }
        logger.info("identifyLoops1");
        op03SimpleParseNodes = Cleaner.removeUnreachableCode(op03SimpleParseNodes, true);
        LoopIdentifier.identifyLoops1(this.method, op03SimpleParseNodes, blockIdentifierFactory);
        op03SimpleParseNodes = Op03SimpleStatement.pushThroughGoto(op03SimpleParseNodes);
        if (options.getOption(OptionsImpl.FORCE_RETURNING_IFS) == Troolean.TRUE) {
            Op03SimpleStatement.replaceReturningIfs(op03SimpleParseNodes, false);
        }
        op03SimpleParseNodes = Cleaner.sortAndRenumber(op03SimpleParseNodes);
        op03SimpleParseNodes = Cleaner.removeUnreachableCode(op03SimpleParseNodes, true);
        logger.info("rewriteBreakStatements");
        Op03SimpleStatement.rewriteBreakStatements(op03SimpleParseNodes);
        logger.info("rewriteWhilesAsFors");
        Op03SimpleStatement.rewriteDoWhileTruePredAsWhile(op03SimpleParseNodes);
        Op03SimpleStatement.rewriteWhilesAsFors(options, op03SimpleParseNodes);
        logger.info("removeSynchronizedCatchBlocks");
        Op03SimpleStatement.removeSynchronizedCatchBlocks(options, op03SimpleParseNodes);
        logger.info("identifyNonjumpingConditionals");
        op03SimpleParseNodes = Op03SimpleStatement.removeUselessNops(op03SimpleParseNodes);
        Op03SimpleStatement.removePointlessJumps(op03SimpleParseNodes);
        Op03SimpleStatement.extractExceptionJumps(op03SimpleParseNodes);
        Op03SimpleStatement.extractAssertionJumps(op03SimpleParseNodes);
        op03SimpleParseNodes = Cleaner.removeUnreachableCode(op03SimpleParseNodes, true);
        ConditionalRewriter.identifyNonjumpingConditionals(op03SimpleParseNodes, blockIdentifierFactory);
        LValueProp.condenseLValues(op03SimpleParseNodes);
        if (options.getOption(OptionsImpl.FORCE_COND_PROPAGATE) == Troolean.TRUE) {
            Op03SimpleStatement.propagateToReturn2(op03SimpleParseNodes);
        }
        logger.info("removeUselessNops");
        op03SimpleParseNodes = Op03SimpleStatement.removeUselessNops(op03SimpleParseNodes);
        logger.info("removePointlessJumps");
        Op03SimpleStatement.removePointlessJumps(op03SimpleParseNodes);
        logger.info("rewriteBreakStatements");
        Op03SimpleStatement.rewriteBreakStatements(op03SimpleParseNodes);
        Op03SimpleStatement.classifyGotos(op03SimpleParseNodes);
        if (((Boolean)options.getOption(OptionsImpl.LABELLED_BLOCKS)).booleanValue()) {
            Op03SimpleStatement.classifyAnonymousBlockGotos(op03SimpleParseNodes, false);
        }
        ConditionalRewriter.identifyNonjumpingConditionals(op03SimpleParseNodes, blockIdentifierFactory);
        InlineDeAssigner.extractAssignments(op03SimpleParseNodes);
        logger.info("rewriteArrayForLoops");
        boolean checkLoopTypeClash = false;
        if (options.getOption(OptionsImpl.ARRAY_ITERATOR, classFileVersion).booleanValue()) {
            IterLoopRewriter.rewriteArrayForLoops(op03SimpleParseNodes);
            checkLoopTypeClash = true;
        }
        logger.info("rewriteIteratorWhileLoops");
        if (options.getOption(OptionsImpl.COLLECTION_ITERATOR, classFileVersion).booleanValue()) {
            IterLoopRewriter.rewriteIteratorWhileLoops(op03SimpleParseNodes);
            checkLoopTypeClash = true;
        }
        logger.info("findSynchronizedBlocks");
        SynchronizedBlocks.findSynchronizedBlocks(op03SimpleParseNodes);
        logger.info("removePointlessSwitchDefaults");
        Op03SimpleStatement.removePointlessSwitchDefaults(op03SimpleParseNodes);
        logger.info("removeUselessNops");
        op03SimpleParseNodes = Op03SimpleStatement.removeUselessNops(op03SimpleParseNodes);
        Op03SimpleStatement.rewriteWith(op03SimpleParseNodes, new StringBuilderRewriter(options, classFileVersion));
        Op03SimpleStatement.rewriteWith(op03SimpleParseNodes, new XorRewriter());
        op03SimpleParseNodes = Cleaner.removeUnreachableCode(op03SimpleParseNodes, true);
        if (((Boolean)options.getOption(OptionsImpl.LABELLED_BLOCKS)).booleanValue()) {
            Op03SimpleStatement.labelAnonymousBlocks(op03SimpleParseNodes, blockIdentifierFactory);
        }
        Op03SimpleStatement.simplifyConditionals(op03SimpleParseNodes, true);
        Op03SimpleStatement.extractExceptionMiddle(op03SimpleParseNodes);
        Op03SimpleStatement.removePointlessJumps(op03SimpleParseNodes);
        Op03SimpleStatement.replaceStackVarsWithLocals(op03SimpleParseNodes);
        Op03SimpleStatement.narrowAssignmentTypes(this.method, op03SimpleParseNodes);
        if (options.getOption(OptionsImpl.SHOW_INFERRABLE, classFileVersion).booleanValue()) {
            Op03SimpleStatement.rewriteWith(op03SimpleParseNodes, new ExplicitTypeCallRewriter());
        }
        if (passIdx == 0 && checkLoopTypeClash) {
            if (LoopLivenessClash.detect(op03SimpleParseNodes, bytecodeMeta)) {
                comments.addComment(DecompilerComment.TYPE_CLASHES);
            }
            if (bytecodeMeta.has(BytecodeMeta.CodeInfoFlag.ITERATED_TYPE_HINTS)) {
                comments.addComment(DecompilerComment.ITERATED_TYPE_HINTS);
            }
        }
        if (((Boolean)options.getOption(OptionsImpl.LABELLED_BLOCKS)).booleanValue()) {
            Op03SimpleStatement.classifyAnonymousBlockGotos(op03SimpleParseNodes, true);
            Op03SimpleStatement.labelAnonymousBlocks(op03SimpleParseNodes, blockIdentifierFactory);
        }
        Op03SimpleStatement.rewriteWith(op03SimpleParseNodes, new BadNarrowingArgRewriter());
        Cleaner.reindexInPlace(op03SimpleParseNodes);
        Op04StructuredStatement block = Op03SimpleStatement.createInitialStructuredBlock(op03SimpleParseNodes);
        Op04StructuredStatement.tidyEmptyCatch(block);
        Op04StructuredStatement.tidyTryCatch(block);
        Op04StructuredStatement.convertUnstructuredIf(block);
        Op04StructuredStatement.inlinePossibles(block);
        Op04StructuredStatement.removeStructuredGotos(block);
        Op04StructuredStatement.removePointlessBlocks(block);
        Op04StructuredStatement.removePointlessReturn(block);
        Op04StructuredStatement.removePointlessControlFlow(block);
        Op04StructuredStatement.removePrimitiveDeconversion(options, this.method, block);
        if (((Boolean)options.getOption(OptionsImpl.LABELLED_BLOCKS)).booleanValue()) {
            Op04StructuredStatement.insertLabelledBlocks(block);
        }
        Op04StructuredStatement.removeUnnecessaryLabelledBreaks(block);
        if (!block.isFullyStructured()) {
            comments.addComment(DecompilerComment.UNABLE_TO_STRUCTURE);
        } else {
            Op04StructuredStatement.tidyTypedBooleans(block);
            Op04StructuredStatement.prettifyBadLoops(block);
            new SwitchStringRewriter(options, classFileVersion, bytecodeMeta).rewrite(block);
            new SwitchEnumRewriter(dcCommonState, classFileVersion, blockIdentifierFactory).rewrite(block);
            Op04StructuredStatement.rewriteExplicitTypeUsages(this.method, block, anonymousClassUsage, classFile);
            Op04StructuredStatement.discoverVariableScopes(this.method, block, variableFactory);
            if (options.getOption(OptionsImpl.REWRITE_TRY_RESOURCES, classFileVersion).booleanValue()) {
                Op04StructuredStatement.removeEndResource(this.method.getClassFile(), block);
            }
            Op04StructuredStatement.rewriteLambdas(dcCommonState, this.method, block);
            Op04StructuredStatement.discoverLocalClassScopes(this.method, block, variableFactory);
            if (((Boolean)options.getOption(OptionsImpl.REMOVE_BOILERPLATE)).booleanValue() && this.method.isConstructor()) {
                Op04StructuredStatement.removeConstructorBoilerplate(block);
            }
            Op04StructuredStatement.removeUnnecessaryVarargArrays(options, this.method, block);
            Op04StructuredStatement.removePrimitiveDeconversion(options, this.method, block);
            Op04StructuredStatement.rewriteBadCastChains(options, this.method, block);
            Op04StructuredStatement.rewriteNarrowingAssignments(options, this.method, block);
            Op04StructuredStatement.tidyVariableNames(this.method, block, bytecodeMeta, comments, this.cp.getClassCache());
            Op04StructuredStatement.miscKeyholeTransforms(block);
            Op04StructuredStatement.applyChecker(new LooseCatchChecker(), block, comments);
            Op04StructuredStatement.applyTypeAnnotations(this.originalCodeAttribute, block, lutByOffset, comments);
        }
        if (passIdx == 0 && Op04StructuredStatement.checkTypeClashes(block, bytecodeMeta)) {
            comments.addComment(DecompilerComment.TYPE_CLASHES);
        }
        return new AnalysisResultSuccessful(comments, block, anonymousClassUsage);
    }

    public void dump(Dumper d) {
        d.newln();
        this.analysed.dump(d);
    }
}

