/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.benf.cfr.reader.bytecode.BytecodeMeta;
import org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Cleaner;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.TypeFilter;
import org.benf.cfr.reader.bytecode.analysis.parse.Expression;
import org.benf.cfr.reader.bytecode.analysis.parse.Statement;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.CompOp;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.ComparisonOperation;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.LValueExpression;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.Literal;
import org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral;
import org.benf.cfr.reader.bytecode.analysis.parse.lvalue.LocalVariable;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.Nop;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.RawSwitchStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.wildcard.WildcardMatch;
import org.benf.cfr.reader.bytecode.analysis.types.RawJavaType;
import org.benf.cfr.reader.bytecode.analysis.types.TypeConstants;
import org.benf.cfr.reader.bytecode.analysis.types.discovery.InferredJavaType;
import org.benf.cfr.reader.bytecode.opcode.DecodedSwitch;
import org.benf.cfr.reader.bytecode.opcode.DecodedSwitchEntry;
import org.benf.cfr.reader.entities.Method;
import org.benf.cfr.reader.util.Functional;
import org.benf.cfr.reader.util.ListFactory;
import org.benf.cfr.reader.util.MapFactory;
import org.benf.cfr.reader.util.functors.UnaryFunction;

public class KotlinSwitchHandler {
    public static List<Op03SimpleStatement> extractStringSwitches(Method method, List<Op03SimpleStatement> in, BytecodeMeta bytecodeMeta) {
        List<Op03SimpleStatement> switchStatements = Functional.filter(in, new TypeFilter<RawSwitchStatement>(RawSwitchStatement.class));
        boolean action = false;
        for (Op03SimpleStatement swatch : switchStatements) {
            action |= KotlinSwitchHandler.extractStringSwitch(swatch, in, bytecodeMeta);
        }
        if (!action) {
            return in;
        }
        return Cleaner.sortAndRenumber(in);
    }

    private static boolean extractStringSwitch(Op03SimpleStatement swatch, List<Op03SimpleStatement> in, BytecodeMeta bytecodeMeta) {
        RawSwitchStatement rawSwitchStatement = (RawSwitchStatement)swatch.getStatement();
        Expression switchOn = rawSwitchStatement.getSwitchOn();
        WildcardMatch wcm = new WildcardMatch();
        WildcardMatch.ExpressionWildcard testObj = wcm.getExpressionWildCard("obj");
        WildcardMatch.MemberFunctionInvokationWildcard test = wcm.getMemberFunction("test", "hashCode", (Expression)testObj);
        if (!test.equals(switchOn)) {
            return false;
        }
        Expression obj = testObj.getMatch();
        DecodedSwitch switchData = rawSwitchStatement.getSwitchData();
        List<DecodedSwitchEntry> jumpTargets = switchData.getJumpTargets();
        List<Op03SimpleStatement> targets = swatch.getTargets();
        if (jumpTargets.size() != targets.size()) {
            return false;
        }
        int defaultBranchIdx = -1;
        for (int x = 0; x < jumpTargets.size(); ++x) {
            if (!jumpTargets.get(x).hasDefault()) continue;
            defaultBranchIdx = x;
            break;
        }
        if (defaultBranchIdx == -1) {
            return false;
        }
        Op03SimpleStatement defaultTarget = targets.get(defaultBranchIdx);
        IfStatement testIf = new IfStatement(new ComparisonOperation(wcm.getMemberFunction("equals", "equals", obj, new CastExpression(new InferredJavaType(TypeConstants.OBJECT, InferredJavaType.Source.UNKNOWN), wcm.getExpressionWildCard("value"))), Literal.FALSE, CompOp.EQ));
        final Map reTargetSet = MapFactory.newIdentityMap();
        Map<Op03SimpleStatement, DistinctSwitchTarget> reTargets = MapFactory.newIdentityLazyMap(new UnaryFunction<Op03SimpleStatement, DistinctSwitchTarget>(){

            @Override
            public DistinctSwitchTarget invoke(Op03SimpleStatement arg) {
                reTargetSet.put(arg, arg);
                return new DistinctSwitchTarget(reTargetSet.size());
            }
        });
        List matchesFound = ListFactory.newList();
        List<Op03SimpleStatement> defaultSources = ListFactory.newList();
        for (int x = 0; x < jumpTargets.size(); ++x) {
            Op03SimpleStatement caseStart = targets.get(x);
            DecodedSwitchEntry switchEntry = jumpTargets.get(x);
            if (switchEntry.hasDefault()) continue;
            Op03SimpleStatement currentCaseLoc = caseStart;
            List found = ListFactory.newList();
            while (true) {
                TypedLiteral literal;
                Expression value;
                Op03SimpleStatement nextCaseLoc = null;
                Statement maybeIf = currentCaseLoc.getStatement();
                if (maybeIf.getClass() == GotoStatement.class) {
                    if (currentCaseLoc.getTargets().get(0) == defaultTarget) break;
                    return false;
                }
                wcm.reset();
                if (testIf.equals(maybeIf) && (value = wcm.getExpressionWildCard("value").getMatch()) instanceof Literal && (literal = ((Literal)value).getValue()).getType() == TypedLiteral.LiteralType.String) {
                    List<Op03SimpleStatement> nextStatements = currentCaseLoc.getTargets();
                    Op03SimpleStatement nextTest = nextStatements.get(1);
                    Op03SimpleStatement stringMatchJump = nextStatements.get(0);
                    if (stringMatchJump.getStatement().getClass() == GotoStatement.class) {
                        Op03SimpleStatement stringMatch = stringMatchJump.getTargets().get(0);
                        OriginalSwitchLookupInfo match = new OriginalSwitchLookupInfo(currentCaseLoc, stringMatchJump, literal, stringMatch);
                        found.add(match);
                        reTargets.get(stringMatch).add(match);
                        nextCaseLoc = nextTest;
                        if (nextCaseLoc == defaultTarget) {
                            defaultSources.add(currentCaseLoc);
                        }
                    }
                }
                if (nextCaseLoc == null) {
                    return false;
                }
                if (nextCaseLoc == defaultTarget) break;
                currentCaseLoc = nextCaseLoc;
            }
            matchesFound.add(found);
        }
        LocalVariable lValue = new LocalVariable("tmp", new InferredJavaType(RawJavaType.INT, InferredJavaType.Source.UNKNOWN));
        LValueExpression lValueExpr = new LValueExpression(lValue);
        List<Op03SimpleStatement> secondSwitchTargets = ListFactory.newList(reTargets.keySet());
        Collections.sort(secondSwitchTargets, new CompareByIndex());
        Op03SimpleStatement firstCase2 = secondSwitchTargets.get(0);
        List switchTargets = ListFactory.newList();
        for (Op03SimpleStatement target : secondSwitchTargets) {
            DistinctSwitchTarget distinctSwitchTarget = reTargets.get(target);
            List<Integer> tmp2 = ListFactory.newList();
            tmp2.add(distinctSwitchTarget.idx);
            DecodedSwitchEntry entry = new DecodedSwitchEntry(tmp2, -1);
            switchTargets.add(entry);
            for (OriginalSwitchLookupInfo originalSwitchLookupInfo : distinctSwitchTarget.entries) {
                Op03SimpleStatement from = originalSwitchLookupInfo.stringMatchJump;
                target.removeSource(from);
                from.removeGotoTarget(target);
            }
        }
        for (Op03SimpleStatement defaultSource : defaultSources) {
            defaultTarget.removeSource(defaultSource);
            defaultSource.removeGotoTarget(defaultTarget);
        }
        List<Integer> defaultSecondary = ListFactory.newList();
        defaultSecondary.add(null);
        switchTargets.add(new DecodedSwitchEntry(defaultSecondary, -1));
        FakeSwitch info = new FakeSwitch(switchTargets);
        RawSwitchStatement secondarySwitch = new RawSwitchStatement(lValueExpr, info);
        Op03SimpleStatement secondarySwitchStm = new Op03SimpleStatement(firstCase2.getBlockIdentifiers(), secondarySwitch, firstCase2.getIndex().justBefore());
        for (Op03SimpleStatement target : secondSwitchTargets) {
            secondarySwitchStm.addTarget(target);
            target.addSource(secondarySwitchStm);
        }
        secondarySwitchStm.addTarget(defaultTarget);
        defaultTarget.addSource(secondarySwitchStm);
        in.add(secondarySwitchStm);
        Op03SimpleStatement nopHolder = new Op03SimpleStatement(firstCase2.getBlockIdentifiers(), new Nop(), secondarySwitchStm.getIndex().justBefore());
        for (Op03SimpleStatement defaultSource : defaultSources) {
            defaultSource.addTarget(nopHolder);
            nopHolder.addSource(defaultSource);
        }
        for (Op03SimpleStatement target : secondSwitchTargets) {
            DistinctSwitchTarget distinctSwitchTarget = reTargets.get(target);
            for (OriginalSwitchLookupInfo originalSwitchLookupInfo : distinctSwitchTarget.entries) {
                Op03SimpleStatement from = originalSwitchLookupInfo.stringMatchJump;
                AssignmentSimple assign = new AssignmentSimple(lValue, new Literal(TypedLiteral.getInt(distinctSwitchTarget.idx)));
                from.replaceStatement(assign);
                Op03SimpleStatement newJmp = new Op03SimpleStatement(from.getBlockIdentifiers(), new GotoStatement(), from.getIndex().justAfter());
                from.addTarget(newJmp);
                newJmp.addSource(from);
                newJmp.addTarget(nopHolder);
                in.add(newJmp);
                nopHolder.addSource(newJmp);
            }
        }
        in.add(nopHolder);
        nopHolder.addTarget(secondarySwitchStm);
        secondarySwitchStm.addSource(nopHolder);
        defaultTarget.removeSource(swatch);
        swatch.replaceTarget(defaultTarget, nopHolder);
        nopHolder.addSource(swatch);
        Op03SimpleStatement init = new Op03SimpleStatement(swatch.getBlockIdentifiers(), new AssignmentSimple(lValue, new Literal(TypedLiteral.getInt(-1))), swatch.getIndex().justBefore());
        List<Op03SimpleStatement> swatchFrom = swatch.getSources();
        for (Op03SimpleStatement from : swatchFrom) {
            from.replaceTarget(swatch, init);
            init.addSource(from);
        }
        init.addTarget(swatch);
        swatch.getSources().clear();
        swatch.addSource(init);
        in.add(init);
        bytecodeMeta.set(BytecodeMeta.CodeInfoFlag.STRING_SWITCHES);
        return true;
    }

    private static class FakeSwitch
    implements DecodedSwitch {
        private final List<DecodedSwitchEntry> entry;

        private FakeSwitch(List<DecodedSwitchEntry> entry) {
            this.entry = entry;
        }

        @Override
        public List<DecodedSwitchEntry> getJumpTargets() {
            return this.entry;
        }
    }

    private static class OriginalSwitchLookupInfo {
        Op03SimpleStatement ifTest;
        Op03SimpleStatement stringMatchJump;
        public TypedLiteral literal;
        public Op03SimpleStatement target;

        OriginalSwitchLookupInfo(Op03SimpleStatement ifTest, Op03SimpleStatement stringMatchJump, TypedLiteral literal, Op03SimpleStatement target) {
            this.ifTest = ifTest;
            this.stringMatchJump = stringMatchJump;
            this.literal = literal;
            this.target = target;
        }
    }

    private static class DistinctSwitchTarget {
        List<OriginalSwitchLookupInfo> entries = ListFactory.newList();
        final int idx;

        private DistinctSwitchTarget(int idx) {
            this.idx = idx;
        }

        void add(OriginalSwitchLookupInfo item) {
            this.entries.add(item);
        }
    }
}

