/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.scheduling;

import java.util.Collection;
import org.bedework.base.exc.BedeworkException;
import org.bedework.base.response.Response;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.ScheduleResult;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.scheduling.OutboundSchedulingHandler;
import org.bedework.convert.Icalendar;
import org.bedework.util.misc.Util;

public abstract class OrganizerSchedulingHandler
extends OutboundSchedulingHandler {
    OrganizerSchedulingHandler(CalSvc svci) {
        super(svci);
    }

    public ScheduleResult schedule(EventInfo ei, String recipient, String fromAttUri, boolean iSchedule, ScheduleResult res) {
        ScheduleResult sr = res == null ? new ScheduleResult() : res;
        BwEvent ev = ei.getEvent();
        try {
            Response addResp;
            if (!Icalendar.itipRequestMethodType((int)ev.getScheduleMethod())) {
                return (ScheduleResult)Response.error((Response)sr, (Throwable)new BedeworkException("org.bedework.error.scheduling.badmethod"));
            }
            boolean freeBusyRequest = ev.getEntityType() == 4;
            int outAccess = freeBusyRequest ? 13 : 11;
            if (!this.initScheduleEvent(ei, false, iSchedule)) {
                return (ScheduleResult)Response.notFound((Response)sr, (String)"Unable to initialise schedule");
            }
            BwCalendar outBox = null;
            BwPrincipal currentUser = this.getPrincipal();
            if (!currentUser.getUnauthenticated()) {
                outBox = this.getSpecialCalendar(this.getPrincipal(), 6, true, outAccess);
            }
            this.sendSchedule(sr, ei, recipient, fromAttUri, true);
            if (!sr.isOk() || sr.ignored) {
                return sr;
            }
            if (freeBusyRequest) {
                return sr;
            }
            if (!(iSchedule || outBox == null || Util.isEmpty((Collection)sr.externalRcs) || (addResp = this.addToOutBox(ei, outBox, sr.externalRcs)).isOk())) {
                return (ScheduleResult)Response.fromResponse((Response)sr, (Response)addResp);
            }
            return sr;
        }
        catch (Throwable t) {
            this.getSvc().rollbackTransaction();
            return (ScheduleResult)Response.error((Response)sr, (Throwable)t);
        }
    }

    public ScheduleResult declineCounter(EventInfo ei, String comment, BwAttendee fromAtt) {
        EventInfo outEi = this.copyEventInfo(ei, this.getPrincipal());
        BwEvent ev = outEi.getEvent();
        ev.setScheduleMethod(8);
        if (comment != null) {
            ev.addComment(null, comment);
        }
        return this.schedule(outEi, fromAtt.getAttendeeUri(), null, false, null);
    }
}

